// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQosWorkloadGetParams creates a new QosWorkloadGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQosWorkloadGetParams() *QosWorkloadGetParams {
	return &QosWorkloadGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQosWorkloadGetParamsWithTimeout creates a new QosWorkloadGetParams object
// with the ability to set a timeout on a request.
func NewQosWorkloadGetParamsWithTimeout(timeout time.Duration) *QosWorkloadGetParams {
	return &QosWorkloadGetParams{
		timeout: timeout,
	}
}

// NewQosWorkloadGetParamsWithContext creates a new QosWorkloadGetParams object
// with the ability to set a context for a request.
func NewQosWorkloadGetParamsWithContext(ctx context.Context) *QosWorkloadGetParams {
	return &QosWorkloadGetParams{
		Context: ctx,
	}
}

// NewQosWorkloadGetParamsWithHTTPClient creates a new QosWorkloadGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQosWorkloadGetParamsWithHTTPClient(client *http.Client) *QosWorkloadGetParams {
	return &QosWorkloadGetParams{
		HTTPClient: client,
	}
}

/*
QosWorkloadGetParams contains all the parameters to send to the API endpoint

	for the qos workload get operation.

	Typically these are written to a http.Request.
*/
type QosWorkloadGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// UUID.
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qos workload get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosWorkloadGetParams) WithDefaults() *QosWorkloadGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qos workload get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosWorkloadGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the qos workload get params
func (o *QosWorkloadGetParams) WithTimeout(timeout time.Duration) *QosWorkloadGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qos workload get params
func (o *QosWorkloadGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qos workload get params
func (o *QosWorkloadGetParams) WithContext(ctx context.Context) *QosWorkloadGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qos workload get params
func (o *QosWorkloadGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qos workload get params
func (o *QosWorkloadGetParams) WithHTTPClient(client *http.Client) *QosWorkloadGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qos workload get params
func (o *QosWorkloadGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the qos workload get params
func (o *QosWorkloadGetParams) WithFields(fields []string) *QosWorkloadGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qos workload get params
func (o *QosWorkloadGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the qos workload get params
func (o *QosWorkloadGetParams) WithUUID(uuid string) *QosWorkloadGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the qos workload get params
func (o *QosWorkloadGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *QosWorkloadGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQosWorkloadGet binds the parameter fields
func (o *QosWorkloadGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
