// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQtreeCollectionGetParams creates a new QtreeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQtreeCollectionGetParams() *QtreeCollectionGetParams {
	return &QtreeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQtreeCollectionGetParamsWithTimeout creates a new QtreeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewQtreeCollectionGetParamsWithTimeout(timeout time.Duration) *QtreeCollectionGetParams {
	return &QtreeCollectionGetParams{
		timeout: timeout,
	}
}

// NewQtreeCollectionGetParamsWithContext creates a new QtreeCollectionGetParams object
// with the ability to set a context for a request.
func NewQtreeCollectionGetParamsWithContext(ctx context.Context) *QtreeCollectionGetParams {
	return &QtreeCollectionGetParams{
		Context: ctx,
	}
}

// NewQtreeCollectionGetParamsWithHTTPClient creates a new QtreeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQtreeCollectionGetParamsWithHTTPClient(client *http.Client) *QtreeCollectionGetParams {
	return &QtreeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
QtreeCollectionGetParams contains all the parameters to send to the API endpoint

	for the qtree collection get operation.

	Typically these are written to a http.Request.
*/
type QtreeCollectionGetParams struct {

	/* Tags.

	   Filter by _tags
	*/
	Tags *string

	/* ExportPolicyID.

	   Filter by export_policy.id
	*/
	ExportPolicyID *int64

	/* ExportPolicyName.

	   Filter by export_policy.name
	*/
	ExportPolicyName *string

	/* ExtPerformanceMonitoringEnabled.

	   Filter by ext_performance_monitoring.enabled
	*/
	ExtPerformanceMonitoringEnabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GroupID.

	   Filter by group.id
	*/
	GroupID *string

	/* GroupName.

	   Filter by group.name
	*/
	GroupName *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputOther.

	   Filter by metric.throughput.other
	*/
	MetricThroughputOther *int64

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NasPath.

	   Filter by nas.path
	*/
	NasPath *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Path.

	   Filter by path
	*/
	Path *string

	/* QosPolicyMaxThroughput.

	   Filter by qos_policy.max_throughput
	*/
	QosPolicyMaxThroughput *string

	/* QosPolicyMaxThroughputIops.

	   Filter by qos_policy.max_throughput_iops
	*/
	QosPolicyMaxThroughputIops *int64

	/* QosPolicyMaxThroughputMbps.

	   Filter by qos_policy.max_throughput_mbps
	*/
	QosPolicyMaxThroughputMbps *int64

	/* QosPolicyMinThroughput.

	   Filter by qos_policy.min_throughput
	*/
	QosPolicyMinThroughput *string

	/* QosPolicyMinThroughputIops.

	   Filter by qos_policy.min_throughput_iops
	*/
	QosPolicyMinThroughputIops *int64

	/* QosPolicyMinThroughputMbps.

	   Filter by qos_policy.min_throughput_mbps
	*/
	QosPolicyMinThroughputMbps *int64

	/* QosPolicyName.

	   Filter by qos_policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter by qos_policy.uuid
	*/
	QosPolicyUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityStyle.

	   Filter by security_style
	*/
	SecurityStyle *string

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawOther.

	   Filter by statistics.throughput_raw.other
	*/
	StatisticsThroughputRawOther *int64

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UnixPermissions.

	   Filter by unix_permissions
	*/
	UnixPermissions *int64

	/* UserID.

	   Filter by user.id
	*/
	UserID *string

	/* UserName.

	   Filter by user.name
	*/
	UserName *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qtree collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QtreeCollectionGetParams) WithDefaults() *QtreeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qtree collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QtreeCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := QtreeCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the qtree collection get params
func (o *QtreeCollectionGetParams) WithTimeout(timeout time.Duration) *QtreeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qtree collection get params
func (o *QtreeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qtree collection get params
func (o *QtreeCollectionGetParams) WithContext(ctx context.Context) *QtreeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qtree collection get params
func (o *QtreeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qtree collection get params
func (o *QtreeCollectionGetParams) WithHTTPClient(client *http.Client) *QtreeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qtree collection get params
func (o *QtreeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTags adds the tags to the qtree collection get params
func (o *QtreeCollectionGetParams) WithTags(tags *string) *QtreeCollectionGetParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the qtree collection get params
func (o *QtreeCollectionGetParams) SetTags(tags *string) {
	o.Tags = tags
}

// WithExportPolicyID adds the exportPolicyID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithExportPolicyID(exportPolicyID *int64) *QtreeCollectionGetParams {
	o.SetExportPolicyID(exportPolicyID)
	return o
}

// SetExportPolicyID adds the exportPolicyId to the qtree collection get params
func (o *QtreeCollectionGetParams) SetExportPolicyID(exportPolicyID *int64) {
	o.ExportPolicyID = exportPolicyID
}

// WithExportPolicyName adds the exportPolicyName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithExportPolicyName(exportPolicyName *string) *QtreeCollectionGetParams {
	o.SetExportPolicyName(exportPolicyName)
	return o
}

// SetExportPolicyName adds the exportPolicyName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetExportPolicyName(exportPolicyName *string) {
	o.ExportPolicyName = exportPolicyName
}

// WithExtPerformanceMonitoringEnabled adds the extPerformanceMonitoringEnabled to the qtree collection get params
func (o *QtreeCollectionGetParams) WithExtPerformanceMonitoringEnabled(extPerformanceMonitoringEnabled *bool) *QtreeCollectionGetParams {
	o.SetExtPerformanceMonitoringEnabled(extPerformanceMonitoringEnabled)
	return o
}

// SetExtPerformanceMonitoringEnabled adds the extPerformanceMonitoringEnabled to the qtree collection get params
func (o *QtreeCollectionGetParams) SetExtPerformanceMonitoringEnabled(extPerformanceMonitoringEnabled *bool) {
	o.ExtPerformanceMonitoringEnabled = extPerformanceMonitoringEnabled
}

// WithFields adds the fields to the qtree collection get params
func (o *QtreeCollectionGetParams) WithFields(fields []string) *QtreeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qtree collection get params
func (o *QtreeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGroupID adds the groupID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithGroupID(groupID *string) *QtreeCollectionGetParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the qtree collection get params
func (o *QtreeCollectionGetParams) SetGroupID(groupID *string) {
	o.GroupID = groupID
}

// WithGroupName adds the groupName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithGroupName(groupName *string) *QtreeCollectionGetParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetGroupName(groupName *string) {
	o.GroupName = groupName
}

// WithID adds the id to the qtree collection get params
func (o *QtreeCollectionGetParams) WithID(id *int64) *QtreeCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the qtree collection get params
func (o *QtreeCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMaxRecords(maxRecords *int64) *QtreeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetricDuration adds the metricDuration to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricDuration(metricDuration *string) *QtreeCollectionGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricIopsOther(metricIopsOther *int64) *QtreeCollectionGetParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricIopsRead(metricIopsRead *int64) *QtreeCollectionGetParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricIopsTotal(metricIopsTotal *int64) *QtreeCollectionGetParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricIopsWrite(metricIopsWrite *int64) *QtreeCollectionGetParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricLatencyOther(metricLatencyOther *int64) *QtreeCollectionGetParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricLatencyRead(metricLatencyRead *int64) *QtreeCollectionGetParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *QtreeCollectionGetParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *QtreeCollectionGetParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricStatus(metricStatus *string) *QtreeCollectionGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputOther adds the metricThroughputOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricThroughputOther(metricThroughputOther *int64) *QtreeCollectionGetParams {
	o.SetMetricThroughputOther(metricThroughputOther)
	return o
}

// SetMetricThroughputOther adds the metricThroughputOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricThroughputOther(metricThroughputOther *int64) {
	o.MetricThroughputOther = metricThroughputOther
}

// WithMetricThroughputRead adds the metricThroughputRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricThroughputRead(metricThroughputRead *int64) *QtreeCollectionGetParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *QtreeCollectionGetParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *QtreeCollectionGetParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the qtree collection get params
func (o *QtreeCollectionGetParams) WithMetricTimestamp(metricTimestamp *string) *QtreeCollectionGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the qtree collection get params
func (o *QtreeCollectionGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithName adds the name to the qtree collection get params
func (o *QtreeCollectionGetParams) WithName(name *string) *QtreeCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the qtree collection get params
func (o *QtreeCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNasPath adds the nasPath to the qtree collection get params
func (o *QtreeCollectionGetParams) WithNasPath(nasPath *string) *QtreeCollectionGetParams {
	o.SetNasPath(nasPath)
	return o
}

// SetNasPath adds the nasPath to the qtree collection get params
func (o *QtreeCollectionGetParams) SetNasPath(nasPath *string) {
	o.NasPath = nasPath
}

// WithOrderBy adds the orderBy to the qtree collection get params
func (o *QtreeCollectionGetParams) WithOrderBy(orderBy []string) *QtreeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the qtree collection get params
func (o *QtreeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPath adds the path to the qtree collection get params
func (o *QtreeCollectionGetParams) WithPath(path *string) *QtreeCollectionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the qtree collection get params
func (o *QtreeCollectionGetParams) SetPath(path *string) {
	o.Path = path
}

// WithQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) *QtreeCollectionGetParams {
	o.SetQosPolicyMaxThroughput(qosPolicyMaxThroughput)
	return o
}

// SetQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) {
	o.QosPolicyMaxThroughput = qosPolicyMaxThroughput
}

// WithQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) *QtreeCollectionGetParams {
	o.SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops)
	return o
}

// SetQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) {
	o.QosPolicyMaxThroughputIops = qosPolicyMaxThroughputIops
}

// WithQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) *QtreeCollectionGetParams {
	o.SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps)
	return o
}

// SetQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) {
	o.QosPolicyMaxThroughputMbps = qosPolicyMaxThroughputMbps
}

// WithQosPolicyMinThroughput adds the qosPolicyMinThroughput to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMinThroughput(qosPolicyMinThroughput *string) *QtreeCollectionGetParams {
	o.SetQosPolicyMinThroughput(qosPolicyMinThroughput)
	return o
}

// SetQosPolicyMinThroughput adds the qosPolicyMinThroughput to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMinThroughput(qosPolicyMinThroughput *string) {
	o.QosPolicyMinThroughput = qosPolicyMinThroughput
}

// WithQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) *QtreeCollectionGetParams {
	o.SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops)
	return o
}

// SetQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) {
	o.QosPolicyMinThroughputIops = qosPolicyMinThroughputIops
}

// WithQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) *QtreeCollectionGetParams {
	o.SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps)
	return o
}

// SetQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) {
	o.QosPolicyMinThroughputMbps = qosPolicyMinThroughputMbps
}

// WithQosPolicyName adds the qosPolicyName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyName(qosPolicyName *string) *QtreeCollectionGetParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithQosPolicyUUID(qosPolicyUUID *string) *QtreeCollectionGetParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the qtree collection get params
func (o *QtreeCollectionGetParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithReturnRecords adds the returnRecords to the qtree collection get params
func (o *QtreeCollectionGetParams) WithReturnRecords(returnRecords *bool) *QtreeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the qtree collection get params
func (o *QtreeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the qtree collection get params
func (o *QtreeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *QtreeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the qtree collection get params
func (o *QtreeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityStyle adds the securityStyle to the qtree collection get params
func (o *QtreeCollectionGetParams) WithSecurityStyle(securityStyle *string) *QtreeCollectionGetParams {
	o.SetSecurityStyle(securityStyle)
	return o
}

// SetSecurityStyle adds the securityStyle to the qtree collection get params
func (o *QtreeCollectionGetParams) SetSecurityStyle(securityStyle *string) {
	o.SecurityStyle = securityStyle
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *QtreeCollectionGetParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *QtreeCollectionGetParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *QtreeCollectionGetParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *QtreeCollectionGetParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *QtreeCollectionGetParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *QtreeCollectionGetParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *QtreeCollectionGetParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *QtreeCollectionGetParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsStatus(statisticsStatus *string) *QtreeCollectionGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) *QtreeCollectionGetParams {
	o.SetStatisticsThroughputRawOther(statisticsThroughputRawOther)
	return o
}

// SetStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) {
	o.StatisticsThroughputRawOther = statisticsThroughputRawOther
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *QtreeCollectionGetParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *QtreeCollectionGetParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *QtreeCollectionGetParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the qtree collection get params
func (o *QtreeCollectionGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *QtreeCollectionGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the qtree collection get params
func (o *QtreeCollectionGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithSvmName(svmName *string) *QtreeCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithSvmUUID(svmUUID *string) *QtreeCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the qtree collection get params
func (o *QtreeCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUnixPermissions adds the unixPermissions to the qtree collection get params
func (o *QtreeCollectionGetParams) WithUnixPermissions(unixPermissions *int64) *QtreeCollectionGetParams {
	o.SetUnixPermissions(unixPermissions)
	return o
}

// SetUnixPermissions adds the unixPermissions to the qtree collection get params
func (o *QtreeCollectionGetParams) SetUnixPermissions(unixPermissions *int64) {
	o.UnixPermissions = unixPermissions
}

// WithUserID adds the userID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithUserID(userID *string) *QtreeCollectionGetParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the qtree collection get params
func (o *QtreeCollectionGetParams) SetUserID(userID *string) {
	o.UserID = userID
}

// WithUserName adds the userName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithUserName(userName *string) *QtreeCollectionGetParams {
	o.SetUserName(userName)
	return o
}

// SetUserName adds the userName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetUserName(userName *string) {
	o.UserName = userName
}

// WithVolumeName adds the volumeName to the qtree collection get params
func (o *QtreeCollectionGetParams) WithVolumeName(volumeName *string) *QtreeCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the qtree collection get params
func (o *QtreeCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the qtree collection get params
func (o *QtreeCollectionGetParams) WithVolumeUUID(volumeUUID *string) *QtreeCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the qtree collection get params
func (o *QtreeCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QtreeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Tags != nil {

		// query param _tags
		var qrTags string

		if o.Tags != nil {
			qrTags = *o.Tags
		}
		qTags := qrTags
		if qTags != "" {

			if err := r.SetQueryParam("_tags", qTags); err != nil {
				return err
			}
		}
	}

	if o.ExportPolicyID != nil {

		// query param export_policy.id
		var qrExportPolicyID int64

		if o.ExportPolicyID != nil {
			qrExportPolicyID = *o.ExportPolicyID
		}
		qExportPolicyID := swag.FormatInt64(qrExportPolicyID)
		if qExportPolicyID != "" {

			if err := r.SetQueryParam("export_policy.id", qExportPolicyID); err != nil {
				return err
			}
		}
	}

	if o.ExportPolicyName != nil {

		// query param export_policy.name
		var qrExportPolicyName string

		if o.ExportPolicyName != nil {
			qrExportPolicyName = *o.ExportPolicyName
		}
		qExportPolicyName := qrExportPolicyName
		if qExportPolicyName != "" {

			if err := r.SetQueryParam("export_policy.name", qExportPolicyName); err != nil {
				return err
			}
		}
	}

	if o.ExtPerformanceMonitoringEnabled != nil {

		// query param ext_performance_monitoring.enabled
		var qrExtPerformanceMonitoringEnabled bool

		if o.ExtPerformanceMonitoringEnabled != nil {
			qrExtPerformanceMonitoringEnabled = *o.ExtPerformanceMonitoringEnabled
		}
		qExtPerformanceMonitoringEnabled := swag.FormatBool(qrExtPerformanceMonitoringEnabled)
		if qExtPerformanceMonitoringEnabled != "" {

			if err := r.SetQueryParam("ext_performance_monitoring.enabled", qExtPerformanceMonitoringEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.GroupID != nil {

		// query param group.id
		var qrGroupID string

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := qrGroupID
		if qGroupID != "" {

			if err := r.SetQueryParam("group.id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.GroupName != nil {

		// query param group.name
		var qrGroupName string

		if o.GroupName != nil {
			qrGroupName = *o.GroupName
		}
		qGroupName := qrGroupName
		if qGroupName != "" {

			if err := r.SetQueryParam("group.name", qGroupName); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputOther != nil {

		// query param metric.throughput.other
		var qrMetricThroughputOther int64

		if o.MetricThroughputOther != nil {
			qrMetricThroughputOther = *o.MetricThroughputOther
		}
		qMetricThroughputOther := swag.FormatInt64(qrMetricThroughputOther)
		if qMetricThroughputOther != "" {

			if err := r.SetQueryParam("metric.throughput.other", qMetricThroughputOther); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NasPath != nil {

		// query param nas.path
		var qrNasPath string

		if o.NasPath != nil {
			qrNasPath = *o.NasPath
		}
		qNasPath := qrNasPath
		if qNasPath != "" {

			if err := r.SetQueryParam("nas.path", qNasPath); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughput != nil {

		// query param qos_policy.max_throughput
		var qrQosPolicyMaxThroughput string

		if o.QosPolicyMaxThroughput != nil {
			qrQosPolicyMaxThroughput = *o.QosPolicyMaxThroughput
		}
		qQosPolicyMaxThroughput := qrQosPolicyMaxThroughput
		if qQosPolicyMaxThroughput != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput", qQosPolicyMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputIops != nil {

		// query param qos_policy.max_throughput_iops
		var qrQosPolicyMaxThroughputIops int64

		if o.QosPolicyMaxThroughputIops != nil {
			qrQosPolicyMaxThroughputIops = *o.QosPolicyMaxThroughputIops
		}
		qQosPolicyMaxThroughputIops := swag.FormatInt64(qrQosPolicyMaxThroughputIops)
		if qQosPolicyMaxThroughputIops != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput_iops", qQosPolicyMaxThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputMbps != nil {

		// query param qos_policy.max_throughput_mbps
		var qrQosPolicyMaxThroughputMbps int64

		if o.QosPolicyMaxThroughputMbps != nil {
			qrQosPolicyMaxThroughputMbps = *o.QosPolicyMaxThroughputMbps
		}
		qQosPolicyMaxThroughputMbps := swag.FormatInt64(qrQosPolicyMaxThroughputMbps)
		if qQosPolicyMaxThroughputMbps != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput_mbps", qQosPolicyMaxThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughput != nil {

		// query param qos_policy.min_throughput
		var qrQosPolicyMinThroughput string

		if o.QosPolicyMinThroughput != nil {
			qrQosPolicyMinThroughput = *o.QosPolicyMinThroughput
		}
		qQosPolicyMinThroughput := qrQosPolicyMinThroughput
		if qQosPolicyMinThroughput != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput", qQosPolicyMinThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputIops != nil {

		// query param qos_policy.min_throughput_iops
		var qrQosPolicyMinThroughputIops int64

		if o.QosPolicyMinThroughputIops != nil {
			qrQosPolicyMinThroughputIops = *o.QosPolicyMinThroughputIops
		}
		qQosPolicyMinThroughputIops := swag.FormatInt64(qrQosPolicyMinThroughputIops)
		if qQosPolicyMinThroughputIops != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput_iops", qQosPolicyMinThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputMbps != nil {

		// query param qos_policy.min_throughput_mbps
		var qrQosPolicyMinThroughputMbps int64

		if o.QosPolicyMinThroughputMbps != nil {
			qrQosPolicyMinThroughputMbps = *o.QosPolicyMinThroughputMbps
		}
		qQosPolicyMinThroughputMbps := swag.FormatInt64(qrQosPolicyMinThroughputMbps)
		if qQosPolicyMinThroughputMbps != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput_mbps", qQosPolicyMinThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyName != nil {

		// query param qos_policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos_policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos_policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos_policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecurityStyle != nil {

		// query param security_style
		var qrSecurityStyle string

		if o.SecurityStyle != nil {
			qrSecurityStyle = *o.SecurityStyle
		}
		qSecurityStyle := qrSecurityStyle
		if qSecurityStyle != "" {

			if err := r.SetQueryParam("security_style", qSecurityStyle); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawOther != nil {

		// query param statistics.throughput_raw.other
		var qrStatisticsThroughputRawOther int64

		if o.StatisticsThroughputRawOther != nil {
			qrStatisticsThroughputRawOther = *o.StatisticsThroughputRawOther
		}
		qStatisticsThroughputRawOther := swag.FormatInt64(qrStatisticsThroughputRawOther)
		if qStatisticsThroughputRawOther != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.other", qStatisticsThroughputRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UnixPermissions != nil {

		// query param unix_permissions
		var qrUnixPermissions int64

		if o.UnixPermissions != nil {
			qrUnixPermissions = *o.UnixPermissions
		}
		qUnixPermissions := swag.FormatInt64(qrUnixPermissions)
		if qUnixPermissions != "" {

			if err := r.SetQueryParam("unix_permissions", qUnixPermissions); err != nil {
				return err
			}
		}
	}

	if o.UserID != nil {

		// query param user.id
		var qrUserID string

		if o.UserID != nil {
			qrUserID = *o.UserID
		}
		qUserID := qrUserID
		if qUserID != "" {

			if err := r.SetQueryParam("user.id", qUserID); err != nil {
				return err
			}
		}
	}

	if o.UserName != nil {

		// query param user.name
		var qrUserName string

		if o.UserName != nil {
			qrUserName = *o.UserName
		}
		qUserName := qrUserName
		if qUserName != "" {

			if err := r.SetQueryParam("user.name", qUserName); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQtreeCollectionGet binds the parameter fields
func (o *QtreeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamQtreeCollectionGet binds the parameter order_by
func (o *QtreeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
