// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QtreeDeleteCollectionReader is a Reader for the QtreeDeleteCollection structure.
type QtreeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QtreeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQtreeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewQtreeDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQtreeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQtreeDeleteCollectionOK creates a QtreeDeleteCollectionOK with default headers values
func NewQtreeDeleteCollectionOK() *QtreeDeleteCollectionOK {
	return &QtreeDeleteCollectionOK{}
}

/*
QtreeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type QtreeDeleteCollectionOK struct {
	Payload *models.QtreeJobLinkResponse
}

// IsSuccess returns true when this qtree delete collection o k response has a 2xx status code
func (o *QtreeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qtree delete collection o k response has a 3xx status code
func (o *QtreeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qtree delete collection o k response has a 4xx status code
func (o *QtreeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qtree delete collection o k response has a 5xx status code
func (o *QtreeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qtree delete collection o k response a status code equal to that given
func (o *QtreeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qtree delete collection o k response
func (o *QtreeDeleteCollectionOK) Code() int {
	return 200
}

func (o *QtreeDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtreeDeleteCollectionOK %s", 200, payload)
}

func (o *QtreeDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtreeDeleteCollectionOK %s", 200, payload)
}

func (o *QtreeDeleteCollectionOK) GetPayload() *models.QtreeJobLinkResponse {
	return o.Payload
}

func (o *QtreeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QtreeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQtreeDeleteCollectionAccepted creates a QtreeDeleteCollectionAccepted with default headers values
func NewQtreeDeleteCollectionAccepted() *QtreeDeleteCollectionAccepted {
	return &QtreeDeleteCollectionAccepted{}
}

/*
QtreeDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type QtreeDeleteCollectionAccepted struct {
	Payload *models.QtreeJobLinkResponse
}

// IsSuccess returns true when this qtree delete collection accepted response has a 2xx status code
func (o *QtreeDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qtree delete collection accepted response has a 3xx status code
func (o *QtreeDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qtree delete collection accepted response has a 4xx status code
func (o *QtreeDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this qtree delete collection accepted response has a 5xx status code
func (o *QtreeDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this qtree delete collection accepted response a status code equal to that given
func (o *QtreeDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the qtree delete collection accepted response
func (o *QtreeDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *QtreeDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtreeDeleteCollectionAccepted %s", 202, payload)
}

func (o *QtreeDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtreeDeleteCollectionAccepted %s", 202, payload)
}

func (o *QtreeDeleteCollectionAccepted) GetPayload() *models.QtreeJobLinkResponse {
	return o.Payload
}

func (o *QtreeDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QtreeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQtreeDeleteCollectionDefault creates a QtreeDeleteCollectionDefault with default headers values
func NewQtreeDeleteCollectionDefault(code int) *QtreeDeleteCollectionDefault {
	return &QtreeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	QtreeDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917505 | Vserver not found. |
| 917506 | Volume not found. |
| 917525 | The specified volume does not exist in Vserver. |
| 918235 | A volume with UUID was not found. |
| 5242894 | The default qtree cannot be deleted. |
| 5242895 | Failed to delete the qtree. |
| 5242897 | This operation is not permitted on read-only volume. |
| 5242898 | This operation is only permitted on a data Vserver. |
| 5242916 | Cannot delete qtree because the volume contains one or more LUNs. |
| 5242925 | The limit for the number of concurrent delete jobs has been reached. |
| 5242927 | Unable to find qtree. |
| 5242955 | The UUID of the volume is required. |
| 5242957 | Failed to delete qtree with ID in the volume and SVM. |
| 5242965 | Invalid qtree path. The volume name component of the qtree path, must be the same as the volume specified with the parameter. |
| 10485796 | Cannot delete qtree because it contains a Storage Level Access Guard (SLAG). |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QtreeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qtree delete collection default response has a 2xx status code
func (o *QtreeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qtree delete collection default response has a 3xx status code
func (o *QtreeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qtree delete collection default response has a 4xx status code
func (o *QtreeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qtree delete collection default response has a 5xx status code
func (o *QtreeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qtree delete collection default response a status code equal to that given
func (o *QtreeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qtree delete collection default response
func (o *QtreeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *QtreeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtree_delete_collection default %s", o._statusCode, payload)
}

func (o *QtreeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qtrees][%d] qtree_delete_collection default %s", o._statusCode, payload)
}

func (o *QtreeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QtreeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QtreeDeleteCollectionBody qtree delete collection body
swagger:model QtreeDeleteCollectionBody
*/
type QtreeDeleteCollectionBody struct {

	// qtree response inline records
	QtreeResponseInlineRecords []*models.Qtree `json:"records,omitempty"`
}

// Validate validates this qtree delete collection body
func (o *QtreeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateQtreeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeDeleteCollectionBody) validateQtreeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.QtreeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.QtreeResponseInlineRecords); i++ {
		if swag.IsZero(o.QtreeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.QtreeResponseInlineRecords[i] != nil {
			if err := o.QtreeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this qtree delete collection body based on the context it is used
func (o *QtreeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateQtreeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeDeleteCollectionBody) contextValidateQtreeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QtreeResponseInlineRecords); i++ {

		if o.QtreeResponseInlineRecords[i] != nil {
			if err := o.QtreeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res QtreeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
