// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQtreeGetParams creates a new QtreeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQtreeGetParams() *QtreeGetParams {
	return &QtreeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQtreeGetParamsWithTimeout creates a new QtreeGetParams object
// with the ability to set a timeout on a request.
func NewQtreeGetParamsWithTimeout(timeout time.Duration) *QtreeGetParams {
	return &QtreeGetParams{
		timeout: timeout,
	}
}

// NewQtreeGetParamsWithContext creates a new QtreeGetParams object
// with the ability to set a context for a request.
func NewQtreeGetParamsWithContext(ctx context.Context) *QtreeGetParams {
	return &QtreeGetParams{
		Context: ctx,
	}
}

// NewQtreeGetParamsWithHTTPClient creates a new QtreeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQtreeGetParamsWithHTTPClient(client *http.Client) *QtreeGetParams {
	return &QtreeGetParams{
		HTTPClient: client,
	}
}

/*
QtreeGetParams contains all the parameters to send to the API endpoint

	for the qtree get operation.

	Typically these are written to a http.Request.
*/
type QtreeGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Qtree ID
	*/
	ID string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qtree get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QtreeGetParams) WithDefaults() *QtreeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qtree get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QtreeGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the qtree get params
func (o *QtreeGetParams) WithTimeout(timeout time.Duration) *QtreeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qtree get params
func (o *QtreeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qtree get params
func (o *QtreeGetParams) WithContext(ctx context.Context) *QtreeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qtree get params
func (o *QtreeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qtree get params
func (o *QtreeGetParams) WithHTTPClient(client *http.Client) *QtreeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qtree get params
func (o *QtreeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the qtree get params
func (o *QtreeGetParams) WithFields(fields []string) *QtreeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qtree get params
func (o *QtreeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the qtree get params
func (o *QtreeGetParams) WithID(id string) *QtreeGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the qtree get params
func (o *QtreeGetParams) SetID(id string) {
	o.ID = id
}

// WithVolumeUUID adds the volumeUUID to the qtree get params
func (o *QtreeGetParams) WithVolumeUUID(volumeUUID string) *QtreeGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the qtree get params
func (o *QtreeGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QtreeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQtreeGet binds the parameter fields
func (o *QtreeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
