// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QtreeModifyCollectionReader is a Reader for the QtreeModifyCollection structure.
type QtreeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QtreeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQtreeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewQtreeModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQtreeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQtreeModifyCollectionOK creates a QtreeModifyCollectionOK with default headers values
func NewQtreeModifyCollectionOK() *QtreeModifyCollectionOK {
	return &QtreeModifyCollectionOK{}
}

/*
QtreeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type QtreeModifyCollectionOK struct {
	Payload *models.QtreeJobLinkResponse
}

// IsSuccess returns true when this qtree modify collection o k response has a 2xx status code
func (o *QtreeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qtree modify collection o k response has a 3xx status code
func (o *QtreeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qtree modify collection o k response has a 4xx status code
func (o *QtreeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qtree modify collection o k response has a 5xx status code
func (o *QtreeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qtree modify collection o k response a status code equal to that given
func (o *QtreeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qtree modify collection o k response
func (o *QtreeModifyCollectionOK) Code() int {
	return 200
}

func (o *QtreeModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtreeModifyCollectionOK %s", 200, payload)
}

func (o *QtreeModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtreeModifyCollectionOK %s", 200, payload)
}

func (o *QtreeModifyCollectionOK) GetPayload() *models.QtreeJobLinkResponse {
	return o.Payload
}

func (o *QtreeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QtreeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQtreeModifyCollectionAccepted creates a QtreeModifyCollectionAccepted with default headers values
func NewQtreeModifyCollectionAccepted() *QtreeModifyCollectionAccepted {
	return &QtreeModifyCollectionAccepted{}
}

/*
QtreeModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type QtreeModifyCollectionAccepted struct {
	Payload *models.QtreeJobLinkResponse
}

// IsSuccess returns true when this qtree modify collection accepted response has a 2xx status code
func (o *QtreeModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qtree modify collection accepted response has a 3xx status code
func (o *QtreeModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qtree modify collection accepted response has a 4xx status code
func (o *QtreeModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this qtree modify collection accepted response has a 5xx status code
func (o *QtreeModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this qtree modify collection accepted response a status code equal to that given
func (o *QtreeModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the qtree modify collection accepted response
func (o *QtreeModifyCollectionAccepted) Code() int {
	return 202
}

func (o *QtreeModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtreeModifyCollectionAccepted %s", 202, payload)
}

func (o *QtreeModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtreeModifyCollectionAccepted %s", 202, payload)
}

func (o *QtreeModifyCollectionAccepted) GetPayload() *models.QtreeJobLinkResponse {
	return o.Payload
}

func (o *QtreeModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QtreeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQtreeModifyCollectionDefault creates a QtreeModifyCollectionDefault with default headers values
func NewQtreeModifyCollectionDefault(code int) *QtreeModifyCollectionDefault {
	return &QtreeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	QtreeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196 | The request contains a field which cannot be set in this operation. |
| 262278 | Required field is missing in the request. |
| 917505 | Vserver not found. |
| 917525 | The specified volume does not exist in Vserver. |
| 918235 | A volume with UUID was not found. |
| 5242887 | Failed to modify qtree. |
| 5242897 | This operation is not permitted on read-only volume. |
| 5242898 | This operation is only permitted on a data Vserver. |
| 5242902 | Missing inputs. |
| 5242915 | Failed to assign qtree export policy to qtree. |
| 5242927 | Unable to find qtree. |
| 5242945 | Failed to modify qtree. |
| 5242951 | Export policy supplied does not belong to the specified export policy ID. |
| 5242954 | Failed to get the qtree from volume. |
| 5242955 | The UUID of the volume is required. |
| 5242956 | Failed to obtain a qtree with ID. |
| 5242957 | Failed to delete the qtree. |
| 5242958 | Failed to rename the qtree with ID in the volume and SVM. |
| 5242959 | Successfully renamed qtree but the modify operation failed. |
| 5242965 | Invalid qtree path. The volume name component of the qtree path, must be the same as the volume specified with the parameter. |
| 5242967 | UNIX user or group ID must be 32-bit unsigned integer. |
| 5242971 | Qtree was renamed. However, the path modification failed. |
| 5242972 | Cannot rename qtree as that name already exists on a volume in the Vserver. |
| 5242973 | Cannot rename qtree to name with path concurrently on volume in Vserver, unless non-root qtrees in enabled on the volume. |
| 5242974 | Moved qtree. However, other properties were not modified. |
| 5242975 | Renamed qtree and moved the qtree. However, other properties were not modified. |
| 6622064 | Security-style NTFS is not supported on a SnapMirror active sync relationship volume. |
| 8454348 | QoS on qtrees is not supported because not all nodes in the cluster can support it. |
| 9437324 | The security style unified is not supported. |
| 23724050 | Failed to resolve user or group name. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QtreeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qtree modify collection default response has a 2xx status code
func (o *QtreeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qtree modify collection default response has a 3xx status code
func (o *QtreeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qtree modify collection default response has a 4xx status code
func (o *QtreeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qtree modify collection default response has a 5xx status code
func (o *QtreeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qtree modify collection default response a status code equal to that given
func (o *QtreeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qtree modify collection default response
func (o *QtreeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *QtreeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtree_modify_collection default %s", o._statusCode, payload)
}

func (o *QtreeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qtrees][%d] qtree_modify_collection default %s", o._statusCode, payload)
}

func (o *QtreeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QtreeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QtreeModifyCollectionBody qtree modify collection body
swagger:model QtreeModifyCollectionBody
*/
type QtreeModifyCollectionBody struct {

	// links
	Links *models.QtreeInlineLinks `json:"_links,omitempty"`

	// export policy
	ExportPolicy *models.QtreeInlineExportPolicy `json:"export_policy,omitempty"`

	// ext performance monitoring
	ExtPerformanceMonitoring *models.QtreeInlineExtPerformanceMonitoring `json:"ext_performance_monitoring,omitempty"`

	// group
	Group *models.QtreeInlineGroup `json:"group,omitempty"`

	// The identifier for the qtree, unique within the qtree's volume.
	//
	// Example: 1
	// Read Only: true
	// Maximum: 4994
	// Minimum: 0
	ID *int64 `json:"id,omitempty"`

	// metric
	Metric *models.QtreeInlineMetric `json:"metric,omitempty"`

	// The name of the qtree. Required in POST; optional in PATCH.
	Name *string `json:"name,omitempty"`

	// nas
	Nas *models.QtreeInlineNas `json:"nas,omitempty"`

	// Client visible path to the qtree. This field is not available if the volume does not have a junction-path configured. Not valid in POST or PATCH. This field is to be deprecated and replaced with nas.path.
	// Example: /volume3/qtree1
	// Read Only: true
	Path *string `json:"path,omitempty"`

	// qos policy
	QosPolicy *models.QtreeInlineQosPolicy `json:"qos_policy,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	QtreeInlineTags []*string `json:"_tags,omitempty"`

	// qtree response inline records
	QtreeResponseInlineRecords []*models.Qtree `json:"records,omitempty"`

	// security style
	SecurityStyle *models.SecurityStyle `json:"security_style,omitempty"`

	// statistics
	Statistics *models.QtreeInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.QtreeInlineSvm `json:"svm,omitempty"`

	// The UNIX permissions for the qtree. Valid in POST or PATCH.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`

	// user
	User *models.QtreeInlineUser `json:"user,omitempty"`

	// volume
	Volume *models.QtreeInlineVolume `json:"volume,omitempty"`
}

// Validate validates this qtree modify collection body
func (o *QtreeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExtPerformanceMonitoring(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQtreeInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQtreeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateExtPerformanceMonitoring(formats strfmt.Registry) error {
	if swag.IsZero(o.ExtPerformanceMonitoring) { // not required
		return nil
	}

	if o.ExtPerformanceMonitoring != nil {
		if err := o.ExtPerformanceMonitoring.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ext_performance_monitoring")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Group) { // not required
		return nil
	}

	if o.Group != nil {
		if err := o.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "group")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateID(formats strfmt.Registry) error {
	if swag.IsZero(o.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"id", "body", *o.ID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"id", "body", *o.ID, 4994, false); err != nil {
		return err
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateQtreeInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(o.QtreeInlineTags) { // not required
		return nil
	}

	iQtreeInlineTagsSize := int64(len(o.QtreeInlineTags))

	if err := validate.MaxItems("info"+"."+"_tags", "body", iQtreeInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateQtreeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.QtreeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.QtreeResponseInlineRecords); i++ {
		if swag.IsZero(o.QtreeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.QtreeResponseInlineRecords[i] != nil {
			if err := o.QtreeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	if o.SecurityStyle != nil {
		if err := o.SecurityStyle.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security_style")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateUser(formats strfmt.Registry) error {
	if swag.IsZero(o.User) { // not required
		return nil
	}

	if o.User != nil {
		if err := o.User.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "user")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree modify collection body based on the context it is used
func (o *QtreeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExtPerformanceMonitoring(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQtreeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUser(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateExtPerformanceMonitoring(ctx context.Context, formats strfmt.Registry) error {

	if o.ExtPerformanceMonitoring != nil {
		if err := o.ExtPerformanceMonitoring.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ext_performance_monitoring")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Group != nil {
		if err := o.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "group")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"path", "body", o.Path); err != nil {
		return err
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateQtreeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QtreeResponseInlineRecords); i++ {

		if o.QtreeResponseInlineRecords[i] != nil {
			if err := o.QtreeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateSecurityStyle(ctx context.Context, formats strfmt.Registry) error {

	if o.SecurityStyle != nil {
		if err := o.SecurityStyle.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security_style")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateUser(ctx context.Context, formats strfmt.Registry) error {

	if o.User != nil {
		if err := o.User.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "user")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res QtreeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineLinks qtree inline links
swagger:model qtree_inline__links
*/
type QtreeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline links
func (o *QtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline links based on the context it is used
func (o *QtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineExportPolicy Export Policy
swagger:model qtree_inline_export_policy
*/
type QtreeInlineExportPolicy struct {

	// links
	Links *models.QtreeInlineExportPolicyInlineLinks `json:"_links,omitempty"`

	// id
	// Example: 100
	ID *int64 `json:"id,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline export policy
func (o *QtreeInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline export policy based on the context it is used
func (o *QtreeInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineExportPolicyInlineLinks qtree inline export policy inline links
swagger:model qtree_inline_export_policy_inline__links
*/
type QtreeInlineExportPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline export policy inline links
func (o *QtreeInlineExportPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineExportPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline export policy inline links based on the context it is used
func (o *QtreeInlineExportPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineExportPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineExportPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineExportPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExportPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineExtPerformanceMonitoring qtree inline ext performance monitoring
swagger:model qtree_inline_ext_performance_monitoring
*/
type QtreeInlineExtPerformanceMonitoring struct {

	// Specifies whether extended performance monitoring is enabled for the qtree.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this qtree inline ext performance monitoring
func (o *QtreeInlineExtPerformanceMonitoring) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline ext performance monitoring based on context it is used
func (o *QtreeInlineExtPerformanceMonitoring) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineExtPerformanceMonitoring) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineExtPerformanceMonitoring) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExtPerformanceMonitoring
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineGroup The user set as owner of the qtree.
swagger:model qtree_inline_group
*/
type QtreeInlineGroup struct {

	// The numeric ID of the group that owns the qtree. Valid in POST or PATCH.
	// Example: 20001
	ID *string `json:"id,omitempty"`

	// Alphanumeric group name of group that owns the qtree. Valid in POST or PATCH.
	// Example: unix_group1
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline group
func (o *QtreeInlineGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline group based on context it is used
func (o *QtreeInlineGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineGroup) UnmarshalBinary(b []byte) error {
	var res QtreeInlineGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineMetric Performance numbers, such as IOPS latency and throughput.
swagger:model qtree_inline_metric
*/
type QtreeInlineMetric struct {

	// links
	Links *models.QtreeInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT5M
	// Enum: ["PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.QtreeInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.QtreeInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.QtreeInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this qtree inline metric
func (o *QtreeInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineMetricTypeDurationPropEnum = append(qtreeInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT4M captures enum value "PT4M"
	QtreeInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT30M captures enum value "PT30M"
	QtreeInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// QtreeInlineMetricDurationPT2H captures enum value "PT2H"
	QtreeInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// QtreeInlineMetricDurationP1D captures enum value "P1D"
	QtreeInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT5M captures enum value "PT5M"
	QtreeInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *QtreeInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QtreeInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineMetricTypeStatusPropEnum = append(qtreeInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// QtreeInlineMetricStatusOk captures enum value "ok"
	QtreeInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// QtreeInlineMetricStatusError captures enum value "error"
	QtreeInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	QtreeInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	QtreeInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	QtreeInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// QtreeInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	QtreeInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// QtreeInlineMetricStatusNotFound captures enum value "not_found"
	QtreeInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// QtreeInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	QtreeInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// QtreeInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	QtreeInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// QtreeInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	QtreeInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	QtreeInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *QtreeInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QtreeInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline metric based on the context it is used
func (o *QtreeInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineMetric) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineMetricInlineLinks qtree inline metric inline links
swagger:model qtree_inline_metric_inline__links
*/
type QtreeInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline metric inline links
func (o *QtreeInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline metric inline links based on the context it is used
func (o *QtreeInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model qtree_inline_metric_inline_iops
*/
type QtreeInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline iops
func (o *QtreeInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline iops based on the context it is used
func (o *QtreeInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model qtree_inline_metric_inline_latency
*/
type QtreeInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline latency
func (o *QtreeInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline latency based on the context it is used
func (o *QtreeInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model qtree_inline_metric_inline_throughput
*/
type QtreeInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline throughput
func (o *QtreeInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline throughput based on the context it is used
func (o *QtreeInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineNas qtree inline nas
swagger:model qtree_inline_nas
*/
type QtreeInlineNas struct {

	// Client visible path to the qtree. This field is not available if the volume does not have a junction-path configured. Not valid in POST or PATCH.
	// Example: /volume3/qtree1
	// Read Only: true
	Path *string `json:"path,omitempty"`
}

// Validate validates this qtree inline nas
func (o *QtreeInlineNas) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline nas based on the context it is used
func (o *QtreeInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineNas) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"nas"+"."+"path", "body", o.Path); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineNas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineNas) UnmarshalBinary(b []byte) error {
	var res QtreeInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineQosPolicy When "min_throughput_iops", "min_throughput_mbps", "min_throughput", "max_throughput_iops", "max_throughput_mbps" or "max_throughput" attributes are specified, the storage object is assigned to an auto-generated QoS policy group. If the attributes are later modified, the auto-generated QoS policy-group attributes are modified. Attributes can be removed by specifying "0" and policy group by specifying "none". Upon deletion of the storage object or if the attributes are removed, then the QoS policy-group is also removed.
swagger:model qtree_inline_qos_policy
*/
type QtreeInlineQosPolicy struct {

	// links
	Links *models.QtreeInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline qos policy
func (o *QtreeInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline qos policy based on the context it is used
func (o *QtreeInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res QtreeInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineQosPolicyInlineLinks qtree inline qos policy inline links
swagger:model qtree_inline_qos_policy_inline__links
*/
type QtreeInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline qos policy inline links
func (o *QtreeInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline qos policy inline links based on the context it is used
func (o *QtreeInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineStatistics These are raw IOPS and throughput performance numbers. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model qtree_inline_statistics
*/
type QtreeInlineStatistics struct {

	// iops raw
	IopsRaw *models.QtreeInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.QtreeInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled with the next closest collection and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes does not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.QtreeInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this qtree inline statistics
func (o *QtreeInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineStatisticsTypeStatusPropEnum = append(qtreeInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// QtreeInlineStatisticsStatusOk captures enum value "ok"
	QtreeInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// QtreeInlineStatisticsStatusError captures enum value "error"
	QtreeInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	QtreeInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	QtreeInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	QtreeInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	QtreeInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// QtreeInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	QtreeInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	QtreeInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// QtreeInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	QtreeInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	QtreeInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *QtreeInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QtreeInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline statistics based on the context it is used
func (o *QtreeInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *QtreeInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *QtreeInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineStatistics) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model qtree_inline_statistics_inline_iops_raw
*/
type QtreeInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline iops raw
func (o *QtreeInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline iops raw based on the context it is used
func (o *QtreeInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineStatisticsInlineLatencyRaw The raw latency observed at the storage object, in microseconds. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model qtree_inline_statistics_inline_latency_raw
*/
type QtreeInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline latency raw
func (o *QtreeInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline latency raw based on the context it is used
func (o *QtreeInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model qtree_inline_statistics_inline_throughput_raw
*/
type QtreeInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline throughput raw
func (o *QtreeInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline throughput raw based on the context it is used
func (o *QtreeInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineSvm Required in POST
swagger:model qtree_inline_svm
*/
type QtreeInlineSvm struct {

	// links
	Links *models.QtreeInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline svm
func (o *QtreeInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline svm based on the context it is used
func (o *QtreeInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineSvm) UnmarshalBinary(b []byte) error {
	var res QtreeInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineSvmInlineLinks qtree inline svm inline links
swagger:model qtree_inline_svm_inline__links
*/
type QtreeInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline svm inline links
func (o *QtreeInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline svm inline links based on the context it is used
func (o *QtreeInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineUser The user set as owner of the qtree.
swagger:model qtree_inline_user
*/
type QtreeInlineUser struct {

	// The numeric ID of the user who owns the qtree. Valid in POST or PATCH.
	// Example: 10001
	ID *string `json:"id,omitempty"`

	// Alphanumeric username of user who owns the qtree. Valid in POST or PATCH.
	// Example: unix_user1
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline user
func (o *QtreeInlineUser) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline user based on context it is used
func (o *QtreeInlineUser) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineUser) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineUser) UnmarshalBinary(b []byte) error {
	var res QtreeInlineUser
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineVolume Required in POST
swagger:model qtree_inline_volume
*/
type QtreeInlineVolume struct {

	// links
	Links *models.QtreeInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline volume
func (o *QtreeInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline volume based on the context it is used
func (o *QtreeInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineVolume) UnmarshalBinary(b []byte) error {
	var res QtreeInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QtreeInlineVolumeInlineLinks qtree inline volume inline links
swagger:model qtree_inline_volume_inline__links
*/
type QtreeInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qtree inline volume inline links
func (o *QtreeInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline volume inline links based on the context it is used
func (o *QtreeInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QtreeInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QtreeInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QtreeInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
