// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQuotaReportCollectionGetParams creates a new QuotaReportCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQuotaReportCollectionGetParams() *QuotaReportCollectionGetParams {
	return &QuotaReportCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQuotaReportCollectionGetParamsWithTimeout creates a new QuotaReportCollectionGetParams object
// with the ability to set a timeout on a request.
func NewQuotaReportCollectionGetParamsWithTimeout(timeout time.Duration) *QuotaReportCollectionGetParams {
	return &QuotaReportCollectionGetParams{
		timeout: timeout,
	}
}

// NewQuotaReportCollectionGetParamsWithContext creates a new QuotaReportCollectionGetParams object
// with the ability to set a context for a request.
func NewQuotaReportCollectionGetParamsWithContext(ctx context.Context) *QuotaReportCollectionGetParams {
	return &QuotaReportCollectionGetParams{
		Context: ctx,
	}
}

// NewQuotaReportCollectionGetParamsWithHTTPClient creates a new QuotaReportCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQuotaReportCollectionGetParamsWithHTTPClient(client *http.Client) *QuotaReportCollectionGetParams {
	return &QuotaReportCollectionGetParams{
		HTTPClient: client,
	}
}

/*
QuotaReportCollectionGetParams contains all the parameters to send to the API endpoint

	for the quota report collection get operation.

	Typically these are written to a http.Request.
*/
type QuotaReportCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FilesHardLimit.

	   Filter by files.hard_limit
	*/
	FilesHardLimit *int64

	/* FilesSoftLimit.

	   Filter by files.soft_limit
	*/
	FilesSoftLimit *int64

	/* FilesUsedHardLimitPercent.

	   Filter by files.used.hard_limit_percent
	*/
	FilesUsedHardLimitPercent *int64

	/* FilesUsedSoftLimitPercent.

	   Filter by files.used.soft_limit_percent
	*/
	FilesUsedSoftLimitPercent *int64

	/* FilesUsedTotal.

	   Filter by files.used.total
	*/
	FilesUsedTotal *int64

	/* GroupID.

	   Filter by group.id
	*/
	GroupID *string

	/* GroupName.

	   Filter by group.name
	*/
	GroupName *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* QtreeID.

	   Filter by qtree.id
	*/
	QtreeID *int64

	/* QtreeName.

	   Filter by qtree.name
	*/
	QtreeName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ShowDefaultRecords.

	   The default is true for GET calls. When set to false, the default records are not reported.

	   Default: true
	*/
	ShowDefaultRecords *bool

	/* SpaceHardLimit.

	   Filter by space.hard_limit
	*/
	SpaceHardLimit *int64

	/* SpaceSoftLimit.

	   Filter by space.soft_limit
	*/
	SpaceSoftLimit *int64

	/* SpaceUsedHardLimitPercent.

	   Filter by space.used.hard_limit_percent
	*/
	SpaceUsedHardLimitPercent *int64

	/* SpaceUsedSoftLimitPercent.

	   Filter by space.used.soft_limit_percent
	*/
	SpaceUsedSoftLimitPercent *int64

	/* SpaceUsedTotal.

	   Filter by space.used.total
	*/
	SpaceUsedTotal *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UsersID.

	   Filter by users.id
	*/
	UsersID *string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the quota report collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaReportCollectionGetParams) WithDefaults() *QuotaReportCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the quota report collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaReportCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		showDefaultRecordsDefault = bool(true)
	)

	val := QuotaReportCollectionGetParams{
		ReturnRecords:      &returnRecordsDefault,
		ReturnTimeout:      &returnTimeoutDefault,
		ShowDefaultRecords: &showDefaultRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithTimeout(timeout time.Duration) *QuotaReportCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithContext(ctx context.Context) *QuotaReportCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithHTTPClient(client *http.Client) *QuotaReportCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFields(fields []string) *QuotaReportCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFilesHardLimit adds the filesHardLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFilesHardLimit(filesHardLimit *int64) *QuotaReportCollectionGetParams {
	o.SetFilesHardLimit(filesHardLimit)
	return o
}

// SetFilesHardLimit adds the filesHardLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFilesHardLimit(filesHardLimit *int64) {
	o.FilesHardLimit = filesHardLimit
}

// WithFilesSoftLimit adds the filesSoftLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFilesSoftLimit(filesSoftLimit *int64) *QuotaReportCollectionGetParams {
	o.SetFilesSoftLimit(filesSoftLimit)
	return o
}

// SetFilesSoftLimit adds the filesSoftLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFilesSoftLimit(filesSoftLimit *int64) {
	o.FilesSoftLimit = filesSoftLimit
}

// WithFilesUsedHardLimitPercent adds the filesUsedHardLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFilesUsedHardLimitPercent(filesUsedHardLimitPercent *int64) *QuotaReportCollectionGetParams {
	o.SetFilesUsedHardLimitPercent(filesUsedHardLimitPercent)
	return o
}

// SetFilesUsedHardLimitPercent adds the filesUsedHardLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFilesUsedHardLimitPercent(filesUsedHardLimitPercent *int64) {
	o.FilesUsedHardLimitPercent = filesUsedHardLimitPercent
}

// WithFilesUsedSoftLimitPercent adds the filesUsedSoftLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFilesUsedSoftLimitPercent(filesUsedSoftLimitPercent *int64) *QuotaReportCollectionGetParams {
	o.SetFilesUsedSoftLimitPercent(filesUsedSoftLimitPercent)
	return o
}

// SetFilesUsedSoftLimitPercent adds the filesUsedSoftLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFilesUsedSoftLimitPercent(filesUsedSoftLimitPercent *int64) {
	o.FilesUsedSoftLimitPercent = filesUsedSoftLimitPercent
}

// WithFilesUsedTotal adds the filesUsedTotal to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithFilesUsedTotal(filesUsedTotal *int64) *QuotaReportCollectionGetParams {
	o.SetFilesUsedTotal(filesUsedTotal)
	return o
}

// SetFilesUsedTotal adds the filesUsedTotal to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetFilesUsedTotal(filesUsedTotal *int64) {
	o.FilesUsedTotal = filesUsedTotal
}

// WithGroupID adds the groupID to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithGroupID(groupID *string) *QuotaReportCollectionGetParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetGroupID(groupID *string) {
	o.GroupID = groupID
}

// WithGroupName adds the groupName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithGroupName(groupName *string) *QuotaReportCollectionGetParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetGroupName(groupName *string) {
	o.GroupName = groupName
}

// WithIndex adds the index to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithIndex(index *int64) *QuotaReportCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithMaxRecords(maxRecords *int64) *QuotaReportCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithOrderBy(orderBy []string) *QuotaReportCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithQtreeID adds the qtreeID to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithQtreeID(qtreeID *int64) *QuotaReportCollectionGetParams {
	o.SetQtreeID(qtreeID)
	return o
}

// SetQtreeID adds the qtreeId to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetQtreeID(qtreeID *int64) {
	o.QtreeID = qtreeID
}

// WithQtreeName adds the qtreeName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithQtreeName(qtreeName *string) *QuotaReportCollectionGetParams {
	o.SetQtreeName(qtreeName)
	return o
}

// SetQtreeName adds the qtreeName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetQtreeName(qtreeName *string) {
	o.QtreeName = qtreeName
}

// WithReturnRecords adds the returnRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithReturnRecords(returnRecords *bool) *QuotaReportCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *QuotaReportCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithShowDefaultRecords adds the showDefaultRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithShowDefaultRecords(showDefaultRecords *bool) *QuotaReportCollectionGetParams {
	o.SetShowDefaultRecords(showDefaultRecords)
	return o
}

// SetShowDefaultRecords adds the showDefaultRecords to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetShowDefaultRecords(showDefaultRecords *bool) {
	o.ShowDefaultRecords = showDefaultRecords
}

// WithSpaceHardLimit adds the spaceHardLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSpaceHardLimit(spaceHardLimit *int64) *QuotaReportCollectionGetParams {
	o.SetSpaceHardLimit(spaceHardLimit)
	return o
}

// SetSpaceHardLimit adds the spaceHardLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSpaceHardLimit(spaceHardLimit *int64) {
	o.SpaceHardLimit = spaceHardLimit
}

// WithSpaceSoftLimit adds the spaceSoftLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSpaceSoftLimit(spaceSoftLimit *int64) *QuotaReportCollectionGetParams {
	o.SetSpaceSoftLimit(spaceSoftLimit)
	return o
}

// SetSpaceSoftLimit adds the spaceSoftLimit to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSpaceSoftLimit(spaceSoftLimit *int64) {
	o.SpaceSoftLimit = spaceSoftLimit
}

// WithSpaceUsedHardLimitPercent adds the spaceUsedHardLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSpaceUsedHardLimitPercent(spaceUsedHardLimitPercent *int64) *QuotaReportCollectionGetParams {
	o.SetSpaceUsedHardLimitPercent(spaceUsedHardLimitPercent)
	return o
}

// SetSpaceUsedHardLimitPercent adds the spaceUsedHardLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSpaceUsedHardLimitPercent(spaceUsedHardLimitPercent *int64) {
	o.SpaceUsedHardLimitPercent = spaceUsedHardLimitPercent
}

// WithSpaceUsedSoftLimitPercent adds the spaceUsedSoftLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSpaceUsedSoftLimitPercent(spaceUsedSoftLimitPercent *int64) *QuotaReportCollectionGetParams {
	o.SetSpaceUsedSoftLimitPercent(spaceUsedSoftLimitPercent)
	return o
}

// SetSpaceUsedSoftLimitPercent adds the spaceUsedSoftLimitPercent to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSpaceUsedSoftLimitPercent(spaceUsedSoftLimitPercent *int64) {
	o.SpaceUsedSoftLimitPercent = spaceUsedSoftLimitPercent
}

// WithSpaceUsedTotal adds the spaceUsedTotal to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSpaceUsedTotal(spaceUsedTotal *int64) *QuotaReportCollectionGetParams {
	o.SetSpaceUsedTotal(spaceUsedTotal)
	return o
}

// SetSpaceUsedTotal adds the spaceUsedTotal to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSpaceUsedTotal(spaceUsedTotal *int64) {
	o.SpaceUsedTotal = spaceUsedTotal
}

// WithSvmName adds the svmName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSvmName(svmName *string) *QuotaReportCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithSvmUUID(svmUUID *string) *QuotaReportCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithType(typeVar *string) *QuotaReportCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUsersID adds the usersID to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithUsersID(usersID *string) *QuotaReportCollectionGetParams {
	o.SetUsersID(usersID)
	return o
}

// SetUsersID adds the usersId to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetUsersID(usersID *string) {
	o.UsersID = usersID
}

// WithUsersName adds the usersName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithUsersName(usersName *string) *QuotaReportCollectionGetParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WithVolumeName adds the volumeName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithVolumeName(volumeName *string) *QuotaReportCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the quota report collection get params
func (o *QuotaReportCollectionGetParams) WithVolumeUUID(volumeUUID *string) *QuotaReportCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the quota report collection get params
func (o *QuotaReportCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QuotaReportCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FilesHardLimit != nil {

		// query param files.hard_limit
		var qrFilesHardLimit int64

		if o.FilesHardLimit != nil {
			qrFilesHardLimit = *o.FilesHardLimit
		}
		qFilesHardLimit := swag.FormatInt64(qrFilesHardLimit)
		if qFilesHardLimit != "" {

			if err := r.SetQueryParam("files.hard_limit", qFilesHardLimit); err != nil {
				return err
			}
		}
	}

	if o.FilesSoftLimit != nil {

		// query param files.soft_limit
		var qrFilesSoftLimit int64

		if o.FilesSoftLimit != nil {
			qrFilesSoftLimit = *o.FilesSoftLimit
		}
		qFilesSoftLimit := swag.FormatInt64(qrFilesSoftLimit)
		if qFilesSoftLimit != "" {

			if err := r.SetQueryParam("files.soft_limit", qFilesSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.FilesUsedHardLimitPercent != nil {

		// query param files.used.hard_limit_percent
		var qrFilesUsedHardLimitPercent int64

		if o.FilesUsedHardLimitPercent != nil {
			qrFilesUsedHardLimitPercent = *o.FilesUsedHardLimitPercent
		}
		qFilesUsedHardLimitPercent := swag.FormatInt64(qrFilesUsedHardLimitPercent)
		if qFilesUsedHardLimitPercent != "" {

			if err := r.SetQueryParam("files.used.hard_limit_percent", qFilesUsedHardLimitPercent); err != nil {
				return err
			}
		}
	}

	if o.FilesUsedSoftLimitPercent != nil {

		// query param files.used.soft_limit_percent
		var qrFilesUsedSoftLimitPercent int64

		if o.FilesUsedSoftLimitPercent != nil {
			qrFilesUsedSoftLimitPercent = *o.FilesUsedSoftLimitPercent
		}
		qFilesUsedSoftLimitPercent := swag.FormatInt64(qrFilesUsedSoftLimitPercent)
		if qFilesUsedSoftLimitPercent != "" {

			if err := r.SetQueryParam("files.used.soft_limit_percent", qFilesUsedSoftLimitPercent); err != nil {
				return err
			}
		}
	}

	if o.FilesUsedTotal != nil {

		// query param files.used.total
		var qrFilesUsedTotal int64

		if o.FilesUsedTotal != nil {
			qrFilesUsedTotal = *o.FilesUsedTotal
		}
		qFilesUsedTotal := swag.FormatInt64(qrFilesUsedTotal)
		if qFilesUsedTotal != "" {

			if err := r.SetQueryParam("files.used.total", qFilesUsedTotal); err != nil {
				return err
			}
		}
	}

	if o.GroupID != nil {

		// query param group.id
		var qrGroupID string

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := qrGroupID
		if qGroupID != "" {

			if err := r.SetQueryParam("group.id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.GroupName != nil {

		// query param group.name
		var qrGroupName string

		if o.GroupName != nil {
			qrGroupName = *o.GroupName
		}
		qGroupName := qrGroupName
		if qGroupName != "" {

			if err := r.SetQueryParam("group.name", qGroupName); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.QtreeID != nil {

		// query param qtree.id
		var qrQtreeID int64

		if o.QtreeID != nil {
			qrQtreeID = *o.QtreeID
		}
		qQtreeID := swag.FormatInt64(qrQtreeID)
		if qQtreeID != "" {

			if err := r.SetQueryParam("qtree.id", qQtreeID); err != nil {
				return err
			}
		}
	}

	if o.QtreeName != nil {

		// query param qtree.name
		var qrQtreeName string

		if o.QtreeName != nil {
			qrQtreeName = *o.QtreeName
		}
		qQtreeName := qrQtreeName
		if qQtreeName != "" {

			if err := r.SetQueryParam("qtree.name", qQtreeName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ShowDefaultRecords != nil {

		// query param show_default_records
		var qrShowDefaultRecords bool

		if o.ShowDefaultRecords != nil {
			qrShowDefaultRecords = *o.ShowDefaultRecords
		}
		qShowDefaultRecords := swag.FormatBool(qrShowDefaultRecords)
		if qShowDefaultRecords != "" {

			if err := r.SetQueryParam("show_default_records", qShowDefaultRecords); err != nil {
				return err
			}
		}
	}

	if o.SpaceHardLimit != nil {

		// query param space.hard_limit
		var qrSpaceHardLimit int64

		if o.SpaceHardLimit != nil {
			qrSpaceHardLimit = *o.SpaceHardLimit
		}
		qSpaceHardLimit := swag.FormatInt64(qrSpaceHardLimit)
		if qSpaceHardLimit != "" {

			if err := r.SetQueryParam("space.hard_limit", qSpaceHardLimit); err != nil {
				return err
			}
		}
	}

	if o.SpaceSoftLimit != nil {

		// query param space.soft_limit
		var qrSpaceSoftLimit int64

		if o.SpaceSoftLimit != nil {
			qrSpaceSoftLimit = *o.SpaceSoftLimit
		}
		qSpaceSoftLimit := swag.FormatInt64(qrSpaceSoftLimit)
		if qSpaceSoftLimit != "" {

			if err := r.SetQueryParam("space.soft_limit", qSpaceSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsedHardLimitPercent != nil {

		// query param space.used.hard_limit_percent
		var qrSpaceUsedHardLimitPercent int64

		if o.SpaceUsedHardLimitPercent != nil {
			qrSpaceUsedHardLimitPercent = *o.SpaceUsedHardLimitPercent
		}
		qSpaceUsedHardLimitPercent := swag.FormatInt64(qrSpaceUsedHardLimitPercent)
		if qSpaceUsedHardLimitPercent != "" {

			if err := r.SetQueryParam("space.used.hard_limit_percent", qSpaceUsedHardLimitPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsedSoftLimitPercent != nil {

		// query param space.used.soft_limit_percent
		var qrSpaceUsedSoftLimitPercent int64

		if o.SpaceUsedSoftLimitPercent != nil {
			qrSpaceUsedSoftLimitPercent = *o.SpaceUsedSoftLimitPercent
		}
		qSpaceUsedSoftLimitPercent := swag.FormatInt64(qrSpaceUsedSoftLimitPercent)
		if qSpaceUsedSoftLimitPercent != "" {

			if err := r.SetQueryParam("space.used.soft_limit_percent", qSpaceUsedSoftLimitPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsedTotal != nil {

		// query param space.used.total
		var qrSpaceUsedTotal int64

		if o.SpaceUsedTotal != nil {
			qrSpaceUsedTotal = *o.SpaceUsedTotal
		}
		qSpaceUsedTotal := swag.FormatInt64(qrSpaceUsedTotal)
		if qSpaceUsedTotal != "" {

			if err := r.SetQueryParam("space.used.total", qSpaceUsedTotal); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UsersID != nil {

		// query param users.id
		var qrUsersID string

		if o.UsersID != nil {
			qrUsersID = *o.UsersID
		}
		qUsersID := qrUsersID
		if qUsersID != "" {

			if err := r.SetQueryParam("users.id", qUsersID); err != nil {
				return err
			}
		}
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQuotaReportCollectionGet binds the parameter fields
func (o *QuotaReportCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamQuotaReportCollectionGet binds the parameter order_by
func (o *QuotaReportCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
