// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQuotaRuleCollectionGetParams creates a new QuotaRuleCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQuotaRuleCollectionGetParams() *QuotaRuleCollectionGetParams {
	return &QuotaRuleCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQuotaRuleCollectionGetParamsWithTimeout creates a new QuotaRuleCollectionGetParams object
// with the ability to set a timeout on a request.
func NewQuotaRuleCollectionGetParamsWithTimeout(timeout time.Duration) *QuotaRuleCollectionGetParams {
	return &QuotaRuleCollectionGetParams{
		timeout: timeout,
	}
}

// NewQuotaRuleCollectionGetParamsWithContext creates a new QuotaRuleCollectionGetParams object
// with the ability to set a context for a request.
func NewQuotaRuleCollectionGetParamsWithContext(ctx context.Context) *QuotaRuleCollectionGetParams {
	return &QuotaRuleCollectionGetParams{
		Context: ctx,
	}
}

// NewQuotaRuleCollectionGetParamsWithHTTPClient creates a new QuotaRuleCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQuotaRuleCollectionGetParamsWithHTTPClient(client *http.Client) *QuotaRuleCollectionGetParams {
	return &QuotaRuleCollectionGetParams{
		HTTPClient: client,
	}
}

/*
QuotaRuleCollectionGetParams contains all the parameters to send to the API endpoint

	for the quota rule collection get operation.

	Typically these are written to a http.Request.
*/
type QuotaRuleCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FilesHardLimit.

	   Filter by files.hard_limit
	*/
	FilesHardLimit *int64

	/* FilesSoftLimit.

	   Filter by files.soft_limit
	*/
	FilesSoftLimit *int64

	/* GroupID.

	   Filter by group.id
	*/
	GroupID *string

	/* GroupName.

	   Filter by group.name
	*/
	GroupName *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* QtreeID.

	   Filter by qtree.id
	*/
	QtreeID *int64

	/* QtreeName.

	   Filter by qtree.name
	*/
	QtreeName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SpaceHardLimit.

	   Filter by space.hard_limit
	*/
	SpaceHardLimit *int64

	/* SpaceSoftLimit.

	   Filter by space.soft_limit
	*/
	SpaceSoftLimit *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UserMapping.

	   Filter by user_mapping
	*/
	UserMapping *bool

	/* UsersID.

	   Filter by users.id
	*/
	UsersID *string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the quota rule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleCollectionGetParams) WithDefaults() *QuotaRuleCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the quota rule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := QuotaRuleCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithTimeout(timeout time.Duration) *QuotaRuleCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithContext(ctx context.Context) *QuotaRuleCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithHTTPClient(client *http.Client) *QuotaRuleCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithFields(fields []string) *QuotaRuleCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFilesHardLimit adds the filesHardLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithFilesHardLimit(filesHardLimit *int64) *QuotaRuleCollectionGetParams {
	o.SetFilesHardLimit(filesHardLimit)
	return o
}

// SetFilesHardLimit adds the filesHardLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetFilesHardLimit(filesHardLimit *int64) {
	o.FilesHardLimit = filesHardLimit
}

// WithFilesSoftLimit adds the filesSoftLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithFilesSoftLimit(filesSoftLimit *int64) *QuotaRuleCollectionGetParams {
	o.SetFilesSoftLimit(filesSoftLimit)
	return o
}

// SetFilesSoftLimit adds the filesSoftLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetFilesSoftLimit(filesSoftLimit *int64) {
	o.FilesSoftLimit = filesSoftLimit
}

// WithGroupID adds the groupID to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithGroupID(groupID *string) *QuotaRuleCollectionGetParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetGroupID(groupID *string) {
	o.GroupID = groupID
}

// WithGroupName adds the groupName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithGroupName(groupName *string) *QuotaRuleCollectionGetParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetGroupName(groupName *string) {
	o.GroupName = groupName
}

// WithMaxRecords adds the maxRecords to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithMaxRecords(maxRecords *int64) *QuotaRuleCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithOrderBy(orderBy []string) *QuotaRuleCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithQtreeID adds the qtreeID to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithQtreeID(qtreeID *int64) *QuotaRuleCollectionGetParams {
	o.SetQtreeID(qtreeID)
	return o
}

// SetQtreeID adds the qtreeId to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetQtreeID(qtreeID *int64) {
	o.QtreeID = qtreeID
}

// WithQtreeName adds the qtreeName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithQtreeName(qtreeName *string) *QuotaRuleCollectionGetParams {
	o.SetQtreeName(qtreeName)
	return o
}

// SetQtreeName adds the qtreeName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetQtreeName(qtreeName *string) {
	o.QtreeName = qtreeName
}

// WithReturnRecords adds the returnRecords to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithReturnRecords(returnRecords *bool) *QuotaRuleCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *QuotaRuleCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSpaceHardLimit adds the spaceHardLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithSpaceHardLimit(spaceHardLimit *int64) *QuotaRuleCollectionGetParams {
	o.SetSpaceHardLimit(spaceHardLimit)
	return o
}

// SetSpaceHardLimit adds the spaceHardLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetSpaceHardLimit(spaceHardLimit *int64) {
	o.SpaceHardLimit = spaceHardLimit
}

// WithSpaceSoftLimit adds the spaceSoftLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithSpaceSoftLimit(spaceSoftLimit *int64) *QuotaRuleCollectionGetParams {
	o.SetSpaceSoftLimit(spaceSoftLimit)
	return o
}

// SetSpaceSoftLimit adds the spaceSoftLimit to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetSpaceSoftLimit(spaceSoftLimit *int64) {
	o.SpaceSoftLimit = spaceSoftLimit
}

// WithSvmName adds the svmName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithSvmName(svmName *string) *QuotaRuleCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithSvmUUID(svmUUID *string) *QuotaRuleCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithType(typeVar *string) *QuotaRuleCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUserMapping adds the userMapping to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithUserMapping(userMapping *bool) *QuotaRuleCollectionGetParams {
	o.SetUserMapping(userMapping)
	return o
}

// SetUserMapping adds the userMapping to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetUserMapping(userMapping *bool) {
	o.UserMapping = userMapping
}

// WithUsersID adds the usersID to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithUsersID(usersID *string) *QuotaRuleCollectionGetParams {
	o.SetUsersID(usersID)
	return o
}

// SetUsersID adds the usersId to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetUsersID(usersID *string) {
	o.UsersID = usersID
}

// WithUsersName adds the usersName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithUsersName(usersName *string) *QuotaRuleCollectionGetParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WithUUID adds the uuid to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithUUID(uuid *string) *QuotaRuleCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVolumeName adds the volumeName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithVolumeName(volumeName *string) *QuotaRuleCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) WithVolumeUUID(volumeUUID *string) *QuotaRuleCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the quota rule collection get params
func (o *QuotaRuleCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QuotaRuleCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FilesHardLimit != nil {

		// query param files.hard_limit
		var qrFilesHardLimit int64

		if o.FilesHardLimit != nil {
			qrFilesHardLimit = *o.FilesHardLimit
		}
		qFilesHardLimit := swag.FormatInt64(qrFilesHardLimit)
		if qFilesHardLimit != "" {

			if err := r.SetQueryParam("files.hard_limit", qFilesHardLimit); err != nil {
				return err
			}
		}
	}

	if o.FilesSoftLimit != nil {

		// query param files.soft_limit
		var qrFilesSoftLimit int64

		if o.FilesSoftLimit != nil {
			qrFilesSoftLimit = *o.FilesSoftLimit
		}
		qFilesSoftLimit := swag.FormatInt64(qrFilesSoftLimit)
		if qFilesSoftLimit != "" {

			if err := r.SetQueryParam("files.soft_limit", qFilesSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.GroupID != nil {

		// query param group.id
		var qrGroupID string

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := qrGroupID
		if qGroupID != "" {

			if err := r.SetQueryParam("group.id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.GroupName != nil {

		// query param group.name
		var qrGroupName string

		if o.GroupName != nil {
			qrGroupName = *o.GroupName
		}
		qGroupName := qrGroupName
		if qGroupName != "" {

			if err := r.SetQueryParam("group.name", qGroupName); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.QtreeID != nil {

		// query param qtree.id
		var qrQtreeID int64

		if o.QtreeID != nil {
			qrQtreeID = *o.QtreeID
		}
		qQtreeID := swag.FormatInt64(qrQtreeID)
		if qQtreeID != "" {

			if err := r.SetQueryParam("qtree.id", qQtreeID); err != nil {
				return err
			}
		}
	}

	if o.QtreeName != nil {

		// query param qtree.name
		var qrQtreeName string

		if o.QtreeName != nil {
			qrQtreeName = *o.QtreeName
		}
		qQtreeName := qrQtreeName
		if qQtreeName != "" {

			if err := r.SetQueryParam("qtree.name", qQtreeName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SpaceHardLimit != nil {

		// query param space.hard_limit
		var qrSpaceHardLimit int64

		if o.SpaceHardLimit != nil {
			qrSpaceHardLimit = *o.SpaceHardLimit
		}
		qSpaceHardLimit := swag.FormatInt64(qrSpaceHardLimit)
		if qSpaceHardLimit != "" {

			if err := r.SetQueryParam("space.hard_limit", qSpaceHardLimit); err != nil {
				return err
			}
		}
	}

	if o.SpaceSoftLimit != nil {

		// query param space.soft_limit
		var qrSpaceSoftLimit int64

		if o.SpaceSoftLimit != nil {
			qrSpaceSoftLimit = *o.SpaceSoftLimit
		}
		qSpaceSoftLimit := swag.FormatInt64(qrSpaceSoftLimit)
		if qSpaceSoftLimit != "" {

			if err := r.SetQueryParam("space.soft_limit", qSpaceSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UserMapping != nil {

		// query param user_mapping
		var qrUserMapping bool

		if o.UserMapping != nil {
			qrUserMapping = *o.UserMapping
		}
		qUserMapping := swag.FormatBool(qrUserMapping)
		if qUserMapping != "" {

			if err := r.SetQueryParam("user_mapping", qUserMapping); err != nil {
				return err
			}
		}
	}

	if o.UsersID != nil {

		// query param users.id
		var qrUsersID string

		if o.UsersID != nil {
			qrUsersID = *o.UsersID
		}
		qUsersID := qrUsersID
		if qUsersID != "" {

			if err := r.SetQueryParam("users.id", qUsersID); err != nil {
				return err
			}
		}
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQuotaRuleCollectionGet binds the parameter fields
func (o *QuotaRuleCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamQuotaRuleCollectionGet binds the parameter order_by
func (o *QuotaRuleCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
