// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QuotaRuleCollectionGetReader is a Reader for the QuotaRuleCollectionGet structure.
type QuotaRuleCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QuotaRuleCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQuotaRuleCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQuotaRuleCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQuotaRuleCollectionGetOK creates a QuotaRuleCollectionGetOK with default headers values
func NewQuotaRuleCollectionGetOK() *QuotaRuleCollectionGetOK {
	return &QuotaRuleCollectionGetOK{}
}

/*
QuotaRuleCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type QuotaRuleCollectionGetOK struct {
	Payload *models.QuotaRuleResponse
}

// IsSuccess returns true when this quota rule collection get o k response has a 2xx status code
func (o *QuotaRuleCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule collection get o k response has a 3xx status code
func (o *QuotaRuleCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule collection get o k response has a 4xx status code
func (o *QuotaRuleCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule collection get o k response has a 5xx status code
func (o *QuotaRuleCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule collection get o k response a status code equal to that given
func (o *QuotaRuleCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the quota rule collection get o k response
func (o *QuotaRuleCollectionGetOK) Code() int {
	return 200
}

func (o *QuotaRuleCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules][%d] quotaRuleCollectionGetOK %s", 200, payload)
}

func (o *QuotaRuleCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules][%d] quotaRuleCollectionGetOK %s", 200, payload)
}

func (o *QuotaRuleCollectionGetOK) GetPayload() *models.QuotaRuleResponse {
	return o.Payload
}

func (o *QuotaRuleCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRuleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleCollectionGetDefault creates a QuotaRuleCollectionGetDefault with default headers values
func NewQuotaRuleCollectionGetDefault(code int) *QuotaRuleCollectionGetDefault {
	return &QuotaRuleCollectionGetDefault{
		_statusCode: code,
	}
}

/*
QuotaRuleCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type QuotaRuleCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this quota rule collection get default response has a 2xx status code
func (o *QuotaRuleCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this quota rule collection get default response has a 3xx status code
func (o *QuotaRuleCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this quota rule collection get default response has a 4xx status code
func (o *QuotaRuleCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this quota rule collection get default response has a 5xx status code
func (o *QuotaRuleCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this quota rule collection get default response a status code equal to that given
func (o *QuotaRuleCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the quota rule collection get default response
func (o *QuotaRuleCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *QuotaRuleCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules][%d] quota_rule_collection_get default %s", o._statusCode, payload)
}

func (o *QuotaRuleCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules][%d] quota_rule_collection_get default %s", o._statusCode, payload)
}

func (o *QuotaRuleCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QuotaRuleCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
