// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QuotaRuleDeleteCollectionReader is a Reader for the QuotaRuleDeleteCollection structure.
type QuotaRuleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QuotaRuleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQuotaRuleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewQuotaRuleDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQuotaRuleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQuotaRuleDeleteCollectionOK creates a QuotaRuleDeleteCollectionOK with default headers values
func NewQuotaRuleDeleteCollectionOK() *QuotaRuleDeleteCollectionOK {
	return &QuotaRuleDeleteCollectionOK{}
}

/*
QuotaRuleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type QuotaRuleDeleteCollectionOK struct {
	Payload *models.QuotaRuleJobLinkResponse
}

// IsSuccess returns true when this quota rule delete collection o k response has a 2xx status code
func (o *QuotaRuleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule delete collection o k response has a 3xx status code
func (o *QuotaRuleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule delete collection o k response has a 4xx status code
func (o *QuotaRuleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule delete collection o k response has a 5xx status code
func (o *QuotaRuleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule delete collection o k response a status code equal to that given
func (o *QuotaRuleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the quota rule delete collection o k response
func (o *QuotaRuleDeleteCollectionOK) Code() int {
	return 200
}

func (o *QuotaRuleDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quotaRuleDeleteCollectionOK %s", 200, payload)
}

func (o *QuotaRuleDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quotaRuleDeleteCollectionOK %s", 200, payload)
}

func (o *QuotaRuleDeleteCollectionOK) GetPayload() *models.QuotaRuleJobLinkResponse {
	return o.Payload
}

func (o *QuotaRuleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRuleJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleDeleteCollectionAccepted creates a QuotaRuleDeleteCollectionAccepted with default headers values
func NewQuotaRuleDeleteCollectionAccepted() *QuotaRuleDeleteCollectionAccepted {
	return &QuotaRuleDeleteCollectionAccepted{}
}

/*
QuotaRuleDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type QuotaRuleDeleteCollectionAccepted struct {
	Payload *models.QuotaRuleJobLinkResponse
}

// IsSuccess returns true when this quota rule delete collection accepted response has a 2xx status code
func (o *QuotaRuleDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule delete collection accepted response has a 3xx status code
func (o *QuotaRuleDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule delete collection accepted response has a 4xx status code
func (o *QuotaRuleDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule delete collection accepted response has a 5xx status code
func (o *QuotaRuleDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule delete collection accepted response a status code equal to that given
func (o *QuotaRuleDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the quota rule delete collection accepted response
func (o *QuotaRuleDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *QuotaRuleDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quotaRuleDeleteCollectionAccepted %s", 202, payload)
}

func (o *QuotaRuleDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quotaRuleDeleteCollectionAccepted %s", 202, payload)
}

func (o *QuotaRuleDeleteCollectionAccepted) GetPayload() *models.QuotaRuleJobLinkResponse {
	return o.Payload
}

func (o *QuotaRuleDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRuleJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleDeleteCollectionDefault creates a QuotaRuleDeleteCollectionDefault with default headers values
func NewQuotaRuleDeleteCollectionDefault(code int) *QuotaRuleDeleteCollectionDefault {
	return &QuotaRuleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	QuotaRuleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5308545 | The specified quota rule UUID is invalid. |
| 5308561 | Failed to obtain volume quota state or invalid quota state obtained for volume. |
| 5308569 | Quota policy rule delete operation succeeded, but quota resize failed due to internal error. |
| 5308572 | Quota policy rule delete operation succeeded, however the rule is still being enforced. To stop enforcing the rule, disable quotas and enable them again for this volume. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QuotaRuleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this quota rule delete collection default response has a 2xx status code
func (o *QuotaRuleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this quota rule delete collection default response has a 3xx status code
func (o *QuotaRuleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this quota rule delete collection default response has a 4xx status code
func (o *QuotaRuleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this quota rule delete collection default response has a 5xx status code
func (o *QuotaRuleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this quota rule delete collection default response a status code equal to that given
func (o *QuotaRuleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the quota rule delete collection default response
func (o *QuotaRuleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *QuotaRuleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quota_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *QuotaRuleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/quota/rules][%d] quota_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *QuotaRuleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QuotaRuleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QuotaRuleDeleteCollectionBody quota rule delete collection body
swagger:model QuotaRuleDeleteCollectionBody
*/
type QuotaRuleDeleteCollectionBody struct {

	// quota rule response inline records
	QuotaRuleResponseInlineRecords []*models.QuotaRule `json:"records,omitempty"`
}

// Validate validates this quota rule delete collection body
func (o *QuotaRuleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateQuotaRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleDeleteCollectionBody) validateQuotaRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.QuotaRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.QuotaRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.QuotaRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.QuotaRuleResponseInlineRecords[i] != nil {
			if err := o.QuotaRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this quota rule delete collection body based on the context it is used
func (o *QuotaRuleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateQuotaRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleDeleteCollectionBody) contextValidateQuotaRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QuotaRuleResponseInlineRecords); i++ {

		if o.QuotaRuleResponseInlineRecords[i] != nil {
			if err := o.QuotaRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res QuotaRuleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
