// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQuotaRuleGetParams creates a new QuotaRuleGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQuotaRuleGetParams() *QuotaRuleGetParams {
	return &QuotaRuleGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQuotaRuleGetParamsWithTimeout creates a new QuotaRuleGetParams object
// with the ability to set a timeout on a request.
func NewQuotaRuleGetParamsWithTimeout(timeout time.Duration) *QuotaRuleGetParams {
	return &QuotaRuleGetParams{
		timeout: timeout,
	}
}

// NewQuotaRuleGetParamsWithContext creates a new QuotaRuleGetParams object
// with the ability to set a context for a request.
func NewQuotaRuleGetParamsWithContext(ctx context.Context) *QuotaRuleGetParams {
	return &QuotaRuleGetParams{
		Context: ctx,
	}
}

// NewQuotaRuleGetParamsWithHTTPClient creates a new QuotaRuleGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQuotaRuleGetParamsWithHTTPClient(client *http.Client) *QuotaRuleGetParams {
	return &QuotaRuleGetParams{
		HTTPClient: client,
	}
}

/*
QuotaRuleGetParams contains all the parameters to send to the API endpoint

	for the quota rule get operation.

	Typically these are written to a http.Request.
*/
type QuotaRuleGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Rule UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the quota rule get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleGetParams) WithDefaults() *QuotaRuleGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the quota rule get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the quota rule get params
func (o *QuotaRuleGetParams) WithTimeout(timeout time.Duration) *QuotaRuleGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the quota rule get params
func (o *QuotaRuleGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the quota rule get params
func (o *QuotaRuleGetParams) WithContext(ctx context.Context) *QuotaRuleGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the quota rule get params
func (o *QuotaRuleGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the quota rule get params
func (o *QuotaRuleGetParams) WithHTTPClient(client *http.Client) *QuotaRuleGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the quota rule get params
func (o *QuotaRuleGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the quota rule get params
func (o *QuotaRuleGetParams) WithFields(fields []string) *QuotaRuleGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the quota rule get params
func (o *QuotaRuleGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the quota rule get params
func (o *QuotaRuleGetParams) WithUUID(uuid string) *QuotaRuleGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the quota rule get params
func (o *QuotaRuleGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *QuotaRuleGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQuotaRuleGet binds the parameter fields
func (o *QuotaRuleGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
