// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QuotaRuleGetReader is a Reader for the QuotaRuleGet structure.
type QuotaRuleGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QuotaRuleGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQuotaRuleGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQuotaRuleGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQuotaRuleGetOK creates a QuotaRuleGetOK with default headers values
func NewQuotaRuleGetOK() *QuotaRuleGetOK {
	return &QuotaRuleGetOK{}
}

/*
QuotaRuleGetOK describes a response with status code 200, with default header values.

OK
*/
type QuotaRuleGetOK struct {
	Payload *models.QuotaRule
}

// IsSuccess returns true when this quota rule get o k response has a 2xx status code
func (o *QuotaRuleGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule get o k response has a 3xx status code
func (o *QuotaRuleGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule get o k response has a 4xx status code
func (o *QuotaRuleGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule get o k response has a 5xx status code
func (o *QuotaRuleGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule get o k response a status code equal to that given
func (o *QuotaRuleGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the quota rule get o k response
func (o *QuotaRuleGetOK) Code() int {
	return 200
}

func (o *QuotaRuleGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules/{uuid}][%d] quotaRuleGetOK %s", 200, payload)
}

func (o *QuotaRuleGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules/{uuid}][%d] quotaRuleGetOK %s", 200, payload)
}

func (o *QuotaRuleGetOK) GetPayload() *models.QuotaRule {
	return o.Payload
}

func (o *QuotaRuleGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleGetDefault creates a QuotaRuleGetDefault with default headers values
func NewQuotaRuleGetDefault(code int) *QuotaRuleGetDefault {
	return &QuotaRuleGetDefault{
		_statusCode: code,
	}
}

/*
	QuotaRuleGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5308544 | The specified quota rule UUID is invalid. |
| 5308545 | Unable to retrieve rule for the specified quota rule UUID. |
| 5308576 | Parameter `show_default_records` only allowed for GET collection. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QuotaRuleGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this quota rule get default response has a 2xx status code
func (o *QuotaRuleGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this quota rule get default response has a 3xx status code
func (o *QuotaRuleGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this quota rule get default response has a 4xx status code
func (o *QuotaRuleGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this quota rule get default response has a 5xx status code
func (o *QuotaRuleGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this quota rule get default response a status code equal to that given
func (o *QuotaRuleGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the quota rule get default response
func (o *QuotaRuleGetDefault) Code() int {
	return o._statusCode
}

func (o *QuotaRuleGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules/{uuid}][%d] quota_rule_get default %s", o._statusCode, payload)
}

func (o *QuotaRuleGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/quota/rules/{uuid}][%d] quota_rule_get default %s", o._statusCode, payload)
}

func (o *QuotaRuleGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QuotaRuleGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
