// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQuotaRuleModifyCollectionParams creates a new QuotaRuleModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQuotaRuleModifyCollectionParams() *QuotaRuleModifyCollectionParams {
	return &QuotaRuleModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQuotaRuleModifyCollectionParamsWithTimeout creates a new QuotaRuleModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewQuotaRuleModifyCollectionParamsWithTimeout(timeout time.Duration) *QuotaRuleModifyCollectionParams {
	return &QuotaRuleModifyCollectionParams{
		timeout: timeout,
	}
}

// NewQuotaRuleModifyCollectionParamsWithContext creates a new QuotaRuleModifyCollectionParams object
// with the ability to set a context for a request.
func NewQuotaRuleModifyCollectionParamsWithContext(ctx context.Context) *QuotaRuleModifyCollectionParams {
	return &QuotaRuleModifyCollectionParams{
		Context: ctx,
	}
}

// NewQuotaRuleModifyCollectionParamsWithHTTPClient creates a new QuotaRuleModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewQuotaRuleModifyCollectionParamsWithHTTPClient(client *http.Client) *QuotaRuleModifyCollectionParams {
	return &QuotaRuleModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
QuotaRuleModifyCollectionParams contains all the parameters to send to the API endpoint

	for the quota rule modify collection operation.

	Typically these are written to a http.Request.
*/
type QuotaRuleModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* FilesHardLimit.

	   Filter by files.hard_limit
	*/
	FilesHardLimit *int64

	/* FilesSoftLimit.

	   Filter by files.soft_limit
	*/
	FilesSoftLimit *int64

	/* GroupID.

	   Filter by group.id
	*/
	GroupID *string

	/* GroupName.

	   Filter by group.name
	*/
	GroupName *string

	/* Info.

	   Info specification
	*/
	Info QuotaRuleModifyCollectionBody

	/* QtreeID.

	   Filter by qtree.id
	*/
	QtreeID *int64

	/* QtreeName.

	   Filter by qtree.name
	*/
	QtreeName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SpaceHardLimit.

	   Filter by space.hard_limit
	*/
	SpaceHardLimit *int64

	/* SpaceSoftLimit.

	   Filter by space.soft_limit
	*/
	SpaceSoftLimit *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UserMapping.

	   Filter by user_mapping
	*/
	UserMapping *bool

	/* UsersID.

	   Filter by users.id
	*/
	UsersID *string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the quota rule modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleModifyCollectionParams) WithDefaults() *QuotaRuleModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the quota rule modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QuotaRuleModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := QuotaRuleModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithTimeout(timeout time.Duration) *QuotaRuleModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithContext(ctx context.Context) *QuotaRuleModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithHTTPClient(client *http.Client) *QuotaRuleModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *QuotaRuleModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFilesHardLimit adds the filesHardLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithFilesHardLimit(filesHardLimit *int64) *QuotaRuleModifyCollectionParams {
	o.SetFilesHardLimit(filesHardLimit)
	return o
}

// SetFilesHardLimit adds the filesHardLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetFilesHardLimit(filesHardLimit *int64) {
	o.FilesHardLimit = filesHardLimit
}

// WithFilesSoftLimit adds the filesSoftLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithFilesSoftLimit(filesSoftLimit *int64) *QuotaRuleModifyCollectionParams {
	o.SetFilesSoftLimit(filesSoftLimit)
	return o
}

// SetFilesSoftLimit adds the filesSoftLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetFilesSoftLimit(filesSoftLimit *int64) {
	o.FilesSoftLimit = filesSoftLimit
}

// WithGroupID adds the groupID to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithGroupID(groupID *string) *QuotaRuleModifyCollectionParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetGroupID(groupID *string) {
	o.GroupID = groupID
}

// WithGroupName adds the groupName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithGroupName(groupName *string) *QuotaRuleModifyCollectionParams {
	o.SetGroupName(groupName)
	return o
}

// SetGroupName adds the groupName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetGroupName(groupName *string) {
	o.GroupName = groupName
}

// WithInfo adds the info to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithInfo(info QuotaRuleModifyCollectionBody) *QuotaRuleModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetInfo(info QuotaRuleModifyCollectionBody) {
	o.Info = info
}

// WithQtreeID adds the qtreeID to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithQtreeID(qtreeID *int64) *QuotaRuleModifyCollectionParams {
	o.SetQtreeID(qtreeID)
	return o
}

// SetQtreeID adds the qtreeId to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetQtreeID(qtreeID *int64) {
	o.QtreeID = qtreeID
}

// WithQtreeName adds the qtreeName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithQtreeName(qtreeName *string) *QuotaRuleModifyCollectionParams {
	o.SetQtreeName(qtreeName)
	return o
}

// SetQtreeName adds the qtreeName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetQtreeName(qtreeName *string) {
	o.QtreeName = qtreeName
}

// WithReturnRecords adds the returnRecords to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithReturnRecords(returnRecords *bool) *QuotaRuleModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *QuotaRuleModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithSerialRecords(serialRecords *bool) *QuotaRuleModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpaceHardLimit adds the spaceHardLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithSpaceHardLimit(spaceHardLimit *int64) *QuotaRuleModifyCollectionParams {
	o.SetSpaceHardLimit(spaceHardLimit)
	return o
}

// SetSpaceHardLimit adds the spaceHardLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetSpaceHardLimit(spaceHardLimit *int64) {
	o.SpaceHardLimit = spaceHardLimit
}

// WithSpaceSoftLimit adds the spaceSoftLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithSpaceSoftLimit(spaceSoftLimit *int64) *QuotaRuleModifyCollectionParams {
	o.SetSpaceSoftLimit(spaceSoftLimit)
	return o
}

// SetSpaceSoftLimit adds the spaceSoftLimit to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetSpaceSoftLimit(spaceSoftLimit *int64) {
	o.SpaceSoftLimit = spaceSoftLimit
}

// WithSvmName adds the svmName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithSvmName(svmName *string) *QuotaRuleModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithSvmUUID(svmUUID *string) *QuotaRuleModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithType(typeVar *string) *QuotaRuleModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUserMapping adds the userMapping to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithUserMapping(userMapping *bool) *QuotaRuleModifyCollectionParams {
	o.SetUserMapping(userMapping)
	return o
}

// SetUserMapping adds the userMapping to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetUserMapping(userMapping *bool) {
	o.UserMapping = userMapping
}

// WithUsersID adds the usersID to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithUsersID(usersID *string) *QuotaRuleModifyCollectionParams {
	o.SetUsersID(usersID)
	return o
}

// SetUsersID adds the usersId to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetUsersID(usersID *string) {
	o.UsersID = usersID
}

// WithUsersName adds the usersName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithUsersName(usersName *string) *QuotaRuleModifyCollectionParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WithUUID adds the uuid to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithUUID(uuid *string) *QuotaRuleModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVolumeName adds the volumeName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithVolumeName(volumeName *string) *QuotaRuleModifyCollectionParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) WithVolumeUUID(volumeUUID *string) *QuotaRuleModifyCollectionParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the quota rule modify collection params
func (o *QuotaRuleModifyCollectionParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QuotaRuleModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.FilesHardLimit != nil {

		// query param files.hard_limit
		var qrFilesHardLimit int64

		if o.FilesHardLimit != nil {
			qrFilesHardLimit = *o.FilesHardLimit
		}
		qFilesHardLimit := swag.FormatInt64(qrFilesHardLimit)
		if qFilesHardLimit != "" {

			if err := r.SetQueryParam("files.hard_limit", qFilesHardLimit); err != nil {
				return err
			}
		}
	}

	if o.FilesSoftLimit != nil {

		// query param files.soft_limit
		var qrFilesSoftLimit int64

		if o.FilesSoftLimit != nil {
			qrFilesSoftLimit = *o.FilesSoftLimit
		}
		qFilesSoftLimit := swag.FormatInt64(qrFilesSoftLimit)
		if qFilesSoftLimit != "" {

			if err := r.SetQueryParam("files.soft_limit", qFilesSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.GroupID != nil {

		// query param group.id
		var qrGroupID string

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := qrGroupID
		if qGroupID != "" {

			if err := r.SetQueryParam("group.id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.GroupName != nil {

		// query param group.name
		var qrGroupName string

		if o.GroupName != nil {
			qrGroupName = *o.GroupName
		}
		qGroupName := qrGroupName
		if qGroupName != "" {

			if err := r.SetQueryParam("group.name", qGroupName); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.QtreeID != nil {

		// query param qtree.id
		var qrQtreeID int64

		if o.QtreeID != nil {
			qrQtreeID = *o.QtreeID
		}
		qQtreeID := swag.FormatInt64(qrQtreeID)
		if qQtreeID != "" {

			if err := r.SetQueryParam("qtree.id", qQtreeID); err != nil {
				return err
			}
		}
	}

	if o.QtreeName != nil {

		// query param qtree.name
		var qrQtreeName string

		if o.QtreeName != nil {
			qrQtreeName = *o.QtreeName
		}
		qQtreeName := qrQtreeName
		if qQtreeName != "" {

			if err := r.SetQueryParam("qtree.name", qQtreeName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SpaceHardLimit != nil {

		// query param space.hard_limit
		var qrSpaceHardLimit int64

		if o.SpaceHardLimit != nil {
			qrSpaceHardLimit = *o.SpaceHardLimit
		}
		qSpaceHardLimit := swag.FormatInt64(qrSpaceHardLimit)
		if qSpaceHardLimit != "" {

			if err := r.SetQueryParam("space.hard_limit", qSpaceHardLimit); err != nil {
				return err
			}
		}
	}

	if o.SpaceSoftLimit != nil {

		// query param space.soft_limit
		var qrSpaceSoftLimit int64

		if o.SpaceSoftLimit != nil {
			qrSpaceSoftLimit = *o.SpaceSoftLimit
		}
		qSpaceSoftLimit := swag.FormatInt64(qrSpaceSoftLimit)
		if qSpaceSoftLimit != "" {

			if err := r.SetQueryParam("space.soft_limit", qSpaceSoftLimit); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UserMapping != nil {

		// query param user_mapping
		var qrUserMapping bool

		if o.UserMapping != nil {
			qrUserMapping = *o.UserMapping
		}
		qUserMapping := swag.FormatBool(qrUserMapping)
		if qUserMapping != "" {

			if err := r.SetQueryParam("user_mapping", qUserMapping); err != nil {
				return err
			}
		}
	}

	if o.UsersID != nil {

		// query param users.id
		var qrUsersID string

		if o.UsersID != nil {
			qrUsersID = *o.UsersID
		}
		qUsersID := qrUsersID
		if qUsersID != "" {

			if err := r.SetQueryParam("users.id", qUsersID); err != nil {
				return err
			}
		}
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
