// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QuotaRuleModifyCollectionReader is a Reader for the QuotaRuleModifyCollection structure.
type QuotaRuleModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QuotaRuleModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQuotaRuleModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewQuotaRuleModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQuotaRuleModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQuotaRuleModifyCollectionOK creates a QuotaRuleModifyCollectionOK with default headers values
func NewQuotaRuleModifyCollectionOK() *QuotaRuleModifyCollectionOK {
	return &QuotaRuleModifyCollectionOK{}
}

/*
QuotaRuleModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type QuotaRuleModifyCollectionOK struct {
	Payload *models.QuotaRuleJobLinkResponse
}

// IsSuccess returns true when this quota rule modify collection o k response has a 2xx status code
func (o *QuotaRuleModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule modify collection o k response has a 3xx status code
func (o *QuotaRuleModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule modify collection o k response has a 4xx status code
func (o *QuotaRuleModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule modify collection o k response has a 5xx status code
func (o *QuotaRuleModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule modify collection o k response a status code equal to that given
func (o *QuotaRuleModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the quota rule modify collection o k response
func (o *QuotaRuleModifyCollectionOK) Code() int {
	return 200
}

func (o *QuotaRuleModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quotaRuleModifyCollectionOK %s", 200, payload)
}

func (o *QuotaRuleModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quotaRuleModifyCollectionOK %s", 200, payload)
}

func (o *QuotaRuleModifyCollectionOK) GetPayload() *models.QuotaRuleJobLinkResponse {
	return o.Payload
}

func (o *QuotaRuleModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRuleJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleModifyCollectionAccepted creates a QuotaRuleModifyCollectionAccepted with default headers values
func NewQuotaRuleModifyCollectionAccepted() *QuotaRuleModifyCollectionAccepted {
	return &QuotaRuleModifyCollectionAccepted{}
}

/*
QuotaRuleModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type QuotaRuleModifyCollectionAccepted struct {
	Payload *models.QuotaRuleJobLinkResponse
}

// IsSuccess returns true when this quota rule modify collection accepted response has a 2xx status code
func (o *QuotaRuleModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this quota rule modify collection accepted response has a 3xx status code
func (o *QuotaRuleModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this quota rule modify collection accepted response has a 4xx status code
func (o *QuotaRuleModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this quota rule modify collection accepted response has a 5xx status code
func (o *QuotaRuleModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this quota rule modify collection accepted response a status code equal to that given
func (o *QuotaRuleModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the quota rule modify collection accepted response
func (o *QuotaRuleModifyCollectionAccepted) Code() int {
	return 202
}

func (o *QuotaRuleModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quotaRuleModifyCollectionAccepted %s", 202, payload)
}

func (o *QuotaRuleModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quotaRuleModifyCollectionAccepted %s", 202, payload)
}

func (o *QuotaRuleModifyCollectionAccepted) GetPayload() *models.QuotaRuleJobLinkResponse {
	return o.Payload
}

func (o *QuotaRuleModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QuotaRuleJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuotaRuleModifyCollectionDefault creates a QuotaRuleModifyCollectionDefault with default headers values
func NewQuotaRuleModifyCollectionDefault(code int) *QuotaRuleModifyCollectionDefault {
	return &QuotaRuleModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	QuotaRuleModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5308478 | User mapping can only be turned on for UNIX usernames or Windows account names. |
| 5308501 | Mapping from Windows user to UNIX user for user rule was unsuccessful. |
| 5308502 | Mapping from UNIX user to Windows user for user rule was unsuccessful. |
| 5308545 | The specified quota rule UUID is invalid. |
| 5308561 | Failed to obtain volume quota state or invalid quota state obtained for volume. |
| 5308567 | Quota policy rule modify operation succeeded, but quota resize failed due to internal error. |
| 5308573 | Input value is greater than limit for field. |
| 5308574 | Input value is out of range for field. |
| 5308575 | Input value is incorrectly larger than listed field. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QuotaRuleModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this quota rule modify collection default response has a 2xx status code
func (o *QuotaRuleModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this quota rule modify collection default response has a 3xx status code
func (o *QuotaRuleModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this quota rule modify collection default response has a 4xx status code
func (o *QuotaRuleModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this quota rule modify collection default response has a 5xx status code
func (o *QuotaRuleModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this quota rule modify collection default response a status code equal to that given
func (o *QuotaRuleModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the quota rule modify collection default response
func (o *QuotaRuleModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *QuotaRuleModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quota_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *QuotaRuleModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/quota/rules][%d] quota_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *QuotaRuleModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QuotaRuleModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QuotaRuleModifyCollectionBody quota rule modify collection body
swagger:model QuotaRuleModifyCollectionBody
*/
type QuotaRuleModifyCollectionBody struct {

	// links
	Links *models.QuotaRuleInlineLinks `json:"_links,omitempty"`

	// files
	Files *models.QuotaRuleInlineFiles `json:"files,omitempty"`

	// group
	Group *models.QuotaRuleInlineGroup `json:"group,omitempty"`

	// qtree
	Qtree *models.QuotaRuleInlineQtree `json:"qtree,omitempty"`

	// This parameter specifies the target user to which the user quota policy rule applies. This parameter takes single or multiple user names or identifiers. This parameter is valid only for the POST operation of a user quota policy rule. If this parameter is used as an input to create a group or a tree quota policy rule, the POST operation will fail with an appropriate error. For POST, this input parameter takes either a user name or a user identifier, not both. For default quota rules, the user name must be chosen and specified as "". For explicit user quota rules, this parameter can indicate either a user name or user identifier. The user name can be a UNIX user name or a Windows user name. If a name contains a space, enclose the entire value in quotes. A UNIX user name cannot include a backslash (\) or an @ sign; user names with these characters are treated as Windows names. The user identifier can be a UNIX user identifier or a Windows security identifier. For multi-user quota, this parameter can contain multiple user targets separated by a comma.
	QuotaRuleInlineUsers []*models.QuotaRuleInlineUsersInlineArrayItem `json:"users,omitempty"`

	// quota rule response inline records
	QuotaRuleResponseInlineRecords []*models.QuotaRule `json:"records,omitempty"`

	// space
	Space *models.QuotaRuleInlineSpace `json:"space,omitempty"`

	// svm
	Svm *models.QuotaRuleInlineSvm `json:"svm,omitempty"`

	// This parameter specifies the quota policy rule type. This is required in POST only and can take either one of the \"user\", \"group\" or \"tree\" values.
	// Enum: ["tree","user","group"]
	Type *string `json:"type,omitempty"`

	// This parameter enables user mapping for user quota policy rules. This is valid in POST or PATCH for user quota policy rules only.
	UserMapping *bool `json:"user_mapping,omitempty"`

	// Unique identifier for the quota policy rule. This field is generated when the quota policy rule is created.
	// Example: 5f1d13a7-f401-11e8-ac1a-005056a7c3b9
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume
	Volume *models.QuotaRuleInlineVolume `json:"volume,omitempty"`
}

// Validate validates this quota rule modify collection body
func (o *QuotaRuleModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuotaRuleInlineUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuotaRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateFiles(formats strfmt.Registry) error {
	if swag.IsZero(o.Files) { // not required
		return nil
	}

	if o.Files != nil {
		if err := o.Files.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "files")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Group) { // not required
		return nil
	}

	if o.Group != nil {
		if err := o.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "group")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(o.Qtree) { // not required
		return nil
	}

	if o.Qtree != nil {
		if err := o.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateQuotaRuleInlineUsers(formats strfmt.Registry) error {
	if swag.IsZero(o.QuotaRuleInlineUsers) { // not required
		return nil
	}

	for i := 0; i < len(o.QuotaRuleInlineUsers); i++ {
		if swag.IsZero(o.QuotaRuleInlineUsers[i]) { // not required
			continue
		}

		if o.QuotaRuleInlineUsers[i] != nil {
			if err := o.QuotaRuleInlineUsers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateQuotaRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.QuotaRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.QuotaRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.QuotaRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.QuotaRuleResponseInlineRecords[i] != nil {
			if err := o.QuotaRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var quotaRuleModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tree","user","group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		quotaRuleModifyCollectionBodyTypeTypePropEnum = append(quotaRuleModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// QuotaRuleModifyCollectionBody
	// QuotaRuleModifyCollectionBody
	// type
	// Type
	// tree
	// END DEBUGGING
	// QuotaRuleModifyCollectionBodyTypeTree captures enum value "tree"
	QuotaRuleModifyCollectionBodyTypeTree string = "tree"

	// BEGIN DEBUGGING
	// QuotaRuleModifyCollectionBody
	// QuotaRuleModifyCollectionBody
	// type
	// Type
	// user
	// END DEBUGGING
	// QuotaRuleModifyCollectionBodyTypeUser captures enum value "user"
	QuotaRuleModifyCollectionBodyTypeUser string = "user"

	// BEGIN DEBUGGING
	// QuotaRuleModifyCollectionBody
	// QuotaRuleModifyCollectionBody
	// type
	// Type
	// group
	// END DEBUGGING
	// QuotaRuleModifyCollectionBodyTypeGroup captures enum value "group"
	QuotaRuleModifyCollectionBodyTypeGroup string = "group"
)

// prop value enum
func (o *QuotaRuleModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, quotaRuleModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule modify collection body based on the context it is used
func (o *QuotaRuleModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQuotaRuleInlineUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQuotaRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateFiles(ctx context.Context, formats strfmt.Registry) error {

	if o.Files != nil {
		if err := o.Files.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "files")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Group != nil {
		if err := o.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "group")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if o.Qtree != nil {
		if err := o.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateQuotaRuleInlineUsers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QuotaRuleInlineUsers); i++ {

		if o.QuotaRuleInlineUsers[i] != nil {
			if err := o.QuotaRuleInlineUsers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateQuotaRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QuotaRuleResponseInlineRecords); i++ {

		if o.QuotaRuleResponseInlineRecords[i] != nil {
			if err := o.QuotaRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *QuotaRuleModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res QuotaRuleModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineLinks quota rule inline links
swagger:model quota_rule_inline__links
*/
type QuotaRuleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this quota rule inline links
func (o *QuotaRuleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline links based on the context it is used
func (o *QuotaRuleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineFiles quota rule inline files
swagger:model quota_rule_inline_files
*/
type QuotaRuleInlineFiles struct {

	// This parameter specifies the hard limit for files. This is valid in POST or PATCH.
	HardLimit *int64 `json:"hard_limit,omitempty"`

	// This parameter specifies the soft limit for files. This is valid in POST or PATCH.
	SoftLimit *int64 `json:"soft_limit,omitempty"`
}

// Validate validates this quota rule inline files
func (o *QuotaRuleInlineFiles) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this quota rule inline files based on context it is used
func (o *QuotaRuleInlineFiles) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineFiles) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineFiles) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineFiles
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineGroup This parameter specifies the target group to which the group quota policy rule applies. This parameter takes a group name or identifier. This parameter is only valid for the POST operation of a group quota policy rule. The POST operation will fail with an appropriate error if this parameter is used as an input to create a user or a tree quota policy rule. This input parameter for POST takes either a group name or a group identifier, but not both. For default quota rules, the group name must be chosen and should be specified as "". For explicit group quota rules, this parameter can contain a UNIX group name or a UNIX group identifier.
swagger:model quota_rule_inline_group
*/
type QuotaRuleInlineGroup struct {

	// Quota target group ID
	ID *string `json:"id,omitempty"`

	// Quota target group name
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota rule inline group
func (o *QuotaRuleInlineGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this quota rule inline group based on context it is used
func (o *QuotaRuleInlineGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineGroup) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineQtree This parameter specifies the target qtree to which the user/group/tree quota policy rule applies. For a user/group quota policy rule at qtree level, this parameter takes a qtree name and is valid in GET or POST. For a user/group quota policy rule at volume level, this parameter is not valid in GET or POST. For a tree quota policy rule, this parameter is mandatory and is valid in both POST and GET. For a default tree quota policy rule, this parameter needs to be specified as "". For a tree quota policy rule at qtree level, this parameter takes a qtree name and is valid in GET or POST.
swagger:model quota_rule_inline_qtree
*/
type QuotaRuleInlineQtree struct {

	// links
	Links *models.QuotaRuleInlineQtreeInlineLinks `json:"_links,omitempty"`

	// The unique identifier for a qtree.
	// Example: 1
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// The name of the qtree.
	// Example: qt1
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota rule inline qtree
func (o *QuotaRuleInlineQtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineQtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline qtree based on the context it is used
func (o *QuotaRuleInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineQtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QuotaRuleInlineQtree) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"qtree"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineQtree) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineQtree) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineQtreeInlineLinks quota rule inline qtree inline links
swagger:model quota_rule_inline_qtree_inline__links
*/
type QuotaRuleInlineQtreeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this quota rule inline qtree inline links
func (o *QuotaRuleInlineQtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineQtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline qtree inline links based on the context it is used
func (o *QuotaRuleInlineQtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineQtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineQtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineQtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineQtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineSpace quota rule inline space
swagger:model quota_rule_inline_space
*/
type QuotaRuleInlineSpace struct {

	// This parameter specifies the space hard limit, in bytes. If less than 1024 bytes, the value is rounded up to 1024 bytes. Valid in POST or PATCH. For a POST operation where the parameter is either empty or set to -1, no limit is applied. For a PATCH operation where a limit is configured, use a value of -1 to clear the limit.
	HardLimit *int64 `json:"hard_limit,omitempty"`

	// This parameter specifies the space soft limit, in bytes. If less than 1024 bytes, the value is rounded up to 1024 bytes. Valid in POST or PATCH. For a POST operation where the parameter is either empty or set to -1, no limit is applied. For a PATCH operation where a limit is configured, use a value of -1 to clear the limit.
	SoftLimit *int64 `json:"soft_limit,omitempty"`
}

// Validate validates this quota rule inline space
func (o *QuotaRuleInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this quota rule inline space based on context it is used
func (o *QuotaRuleInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineSpace) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model quota_rule_inline_svm
*/
type QuotaRuleInlineSvm struct {

	// links
	Links *models.QuotaRuleInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this quota rule inline svm
func (o *QuotaRuleInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline svm based on the context it is used
func (o *QuotaRuleInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineSvm) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineSvmInlineLinks quota rule inline svm inline links
swagger:model quota_rule_inline_svm_inline__links
*/
type QuotaRuleInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this quota rule inline svm inline links
func (o *QuotaRuleInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline svm inline links based on the context it is used
func (o *QuotaRuleInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineUsersInlineArrayItem quota rule inline users inline array item
swagger:model quota_rule_inline_users_inline_array_item
*/
type QuotaRuleInlineUsersInlineArrayItem struct {

	// Quota target user ID
	ID *string `json:"id,omitempty"`

	// Quota target user name
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota rule inline users inline array item
func (o *QuotaRuleInlineUsersInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this quota rule inline users inline array item based on context it is used
func (o *QuotaRuleInlineUsersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineUsersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineUsersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineUsersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineVolume quota rule inline volume
swagger:model quota_rule_inline_volume
*/
type QuotaRuleInlineVolume struct {

	// links
	Links *models.QuotaRuleInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this quota rule inline volume
func (o *QuotaRuleInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline volume based on the context it is used
func (o *QuotaRuleInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineVolume) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QuotaRuleInlineVolumeInlineLinks quota rule inline volume inline links
swagger:model quota_rule_inline_volume_inline__links
*/
type QuotaRuleInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this quota rule inline volume inline links
func (o *QuotaRuleInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota rule inline volume inline links based on the context it is used
func (o *QuotaRuleInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QuotaRuleInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QuotaRuleInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QuotaRuleInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaRuleInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
