// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewShelfCollectionGetParams creates a new ShelfCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewShelfCollectionGetParams() *ShelfCollectionGetParams {
	return &ShelfCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewShelfCollectionGetParamsWithTimeout creates a new ShelfCollectionGetParams object
// with the ability to set a timeout on a request.
func NewShelfCollectionGetParamsWithTimeout(timeout time.Duration) *ShelfCollectionGetParams {
	return &ShelfCollectionGetParams{
		timeout: timeout,
	}
}

// NewShelfCollectionGetParamsWithContext creates a new ShelfCollectionGetParams object
// with the ability to set a context for a request.
func NewShelfCollectionGetParamsWithContext(ctx context.Context) *ShelfCollectionGetParams {
	return &ShelfCollectionGetParams{
		Context: ctx,
	}
}

// NewShelfCollectionGetParamsWithHTTPClient creates a new ShelfCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewShelfCollectionGetParamsWithHTTPClient(client *http.Client) *ShelfCollectionGetParams {
	return &ShelfCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ShelfCollectionGetParams contains all the parameters to send to the API endpoint

	for the shelf collection get operation.

	Typically these are written to a http.Request.
*/
type ShelfCollectionGetParams struct {

	/* AcpsAddress.

	   Filter by acps.address
	*/
	AcpsAddress *string

	/* AcpsChannel.

	   Filter by acps.channel
	*/
	AcpsChannel *string

	/* AcpsConnectionState.

	   Filter by acps.connection_state
	*/
	AcpsConnectionState *string

	/* AcpsEnabled.

	   Filter by acps.enabled
	*/
	AcpsEnabled *bool

	/* AcpsErrorReasonArgumentsCode.

	   Filter by acps.error.reason.arguments.code
	*/
	AcpsErrorReasonArgumentsCode *string

	/* AcpsErrorReasonArgumentsMessage.

	   Filter by acps.error.reason.arguments.message
	*/
	AcpsErrorReasonArgumentsMessage *string

	/* AcpsErrorReasonCode.

	   Filter by acps.error.reason.code
	*/
	AcpsErrorReasonCode *string

	/* AcpsErrorReasonMessage.

	   Filter by acps.error.reason.message
	*/
	AcpsErrorReasonMessage *string

	/* AcpsErrorSeverity.

	   Filter by acps.error.severity
	*/
	AcpsErrorSeverity *string

	/* AcpsErrorType.

	   Filter by acps.error.type
	*/
	AcpsErrorType *string

	/* AcpsNetmask.

	   Filter by acps.netmask
	*/
	AcpsNetmask *string

	/* AcpsNodeName.

	   Filter by acps.node.name
	*/
	AcpsNodeName *string

	/* AcpsNodeUUID.

	   Filter by acps.node.uuid
	*/
	AcpsNodeUUID *string

	/* AcpsPort.

	   Filter by acps.port
	*/
	AcpsPort *string

	/* AcpsSubnet.

	   Filter by acps.subnet
	*/
	AcpsSubnet *string

	/* BaysDrawerID.

	   Filter by bays.drawer.id
	*/
	BaysDrawerID *int64

	/* BaysDrawerSlot.

	   Filter by bays.drawer.slot
	*/
	BaysDrawerSlot *int64

	/* BaysHasDisk.

	   Filter by bays.has_disk
	*/
	BaysHasDisk *bool

	/* BaysID.

	   Filter by bays.id
	*/
	BaysID *int64

	/* BaysState.

	   Filter by bays.state
	*/
	BaysState *string

	/* BaysType.

	   Filter by bays.type
	*/
	BaysType *string

	/* ConnectionType.

	   Filter by connection_type
	*/
	ConnectionType *string

	/* CurrentSensorsCurrent.

	   Filter by current_sensors.current
	*/
	CurrentSensorsCurrent *int64

	/* CurrentSensorsID.

	   Filter by current_sensors.id
	*/
	CurrentSensorsID *int64

	/* CurrentSensorsInstalled.

	   Filter by current_sensors.installed
	*/
	CurrentSensorsInstalled *bool

	/* CurrentSensorsLocation.

	   Filter by current_sensors.location
	*/
	CurrentSensorsLocation *string

	/* CurrentSensorsState.

	   Filter by current_sensors.state
	*/
	CurrentSensorsState *string

	/* DiskCount.

	   Filter by disk_count
	*/
	DiskCount *int64

	/* DrawersClosed.

	   Filter by drawers.closed
	*/
	DrawersClosed *bool

	/* DrawersDiskCount.

	   Filter by drawers.disk_count
	*/
	DrawersDiskCount *int64

	/* DrawersError.

	   Filter by drawers.error
	*/
	DrawersError *string

	/* DrawersID.

	   Filter by drawers.id
	*/
	DrawersID *int64

	/* DrawersPartNumber.

	   Filter by drawers.part_number
	*/
	DrawersPartNumber *string

	/* DrawersSerialNumber.

	   Filter by drawers.serial_number
	*/
	DrawersSerialNumber *string

	/* DrawersState.

	   Filter by drawers.state
	*/
	DrawersState *string

	/* ErrorsReasonArgumentsCode.

	   Filter by errors.reason.arguments.code
	*/
	ErrorsReasonArgumentsCode *string

	/* ErrorsReasonArgumentsMessage.

	   Filter by errors.reason.arguments.message
	*/
	ErrorsReasonArgumentsMessage *string

	/* ErrorsReasonCode.

	   Filter by errors.reason.code
	*/
	ErrorsReasonCode *string

	/* ErrorsReasonMessage.

	   Filter by errors.reason.message
	*/
	ErrorsReasonMessage *string

	/* FansID.

	   Filter by fans.id
	*/
	FansID *int64

	/* FansInstalled.

	   Filter by fans.installed
	*/
	FansInstalled *bool

	/* FansLocation.

	   Filter by fans.location
	*/
	FansLocation *string

	/* FansRpm.

	   Filter by fans.rpm
	*/
	FansRpm *int64

	/* FansState.

	   Filter by fans.state
	*/
	FansState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FrusFirmwareVersion.

	   Filter by frus.firmware_version
	*/
	FrusFirmwareVersion *string

	/* FrusID.

	   Filter by frus.id
	*/
	FrusID *int64

	/* FrusInstalled.

	   Filter by frus.installed
	*/
	FrusInstalled *bool

	/* FrusPartNumber.

	   Filter by frus.part_number
	*/
	FrusPartNumber *string

	/* FrusPsuCrestFactor.

	   Filter by frus.psu.crest_factor
	*/
	FrusPsuCrestFactor *int64

	/* FrusPsuModel.

	   Filter by frus.psu.model
	*/
	FrusPsuModel *string

	/* FrusPsuPowerDrawn.

	   Filter by frus.psu.power_drawn
	*/
	FrusPsuPowerDrawn *int64

	/* FrusPsuPowerRating.

	   Filter by frus.psu.power_rating
	*/
	FrusPsuPowerRating *int64

	/* FrusSerialNumber.

	   Filter by frus.serial_number
	*/
	FrusSerialNumber *string

	/* FrusState.

	   Filter by frus.state
	*/
	FrusState *string

	/* FrusType.

	   Filter by frus.type
	*/
	FrusType *string

	/* ID.

	   Filter by id
	*/
	ID *string

	/* Internal.

	   Filter by internal
	*/
	Internal *bool

	/* Local.

	   Filter by local
	*/
	Local *bool

	/* LocationLed.

	   Filter by location_led
	*/
	LocationLed *string

	/* ManufacturerName.

	   Filter by manufacturer.name
	*/
	ManufacturerName *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Model.

	   Filter by model
	*/
	Model *string

	/* ModuleType.

	   Filter by module_type
	*/
	ModuleType *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PathsName.

	   Filter by paths.name
	*/
	PathsName *string

	/* PathsNodeName.

	   Filter by paths.node.name
	*/
	PathsNodeName *string

	/* PathsNodeUUID.

	   Filter by paths.node.uuid
	*/
	PathsNodeUUID *string

	/* PortsCableIdentifier.

	   Filter by ports.cable.identifier
	*/
	PortsCableIdentifier *string

	/* PortsCableLength.

	   Filter by ports.cable.length
	*/
	PortsCableLength *string

	/* PortsCablePartNumber.

	   Filter by ports.cable.part_number
	*/
	PortsCablePartNumber *string

	/* PortsCableSerialNumber.

	   Filter by ports.cable.serial_number
	*/
	PortsCableSerialNumber *string

	/* PortsDesignator.

	   Filter by ports.designator
	*/
	PortsDesignator *string

	/* PortsID.

	   Filter by ports.id
	*/
	PortsID *int64

	/* PortsInternal.

	   Filter by ports.internal
	*/
	PortsInternal *bool

	/* PortsMacAddress.

	   Filter by ports.mac_address
	*/
	PortsMacAddress *string

	/* PortsModuleID.

	   Filter by ports.module_id
	*/
	PortsModuleID *string

	/* PortsRemoteChassis.

	   Filter by ports.remote.chassis
	*/
	PortsRemoteChassis *string

	/* PortsRemoteDevice.

	   Filter by ports.remote.device
	*/
	PortsRemoteDevice *string

	/* PortsRemoteMacAddress.

	   Filter by ports.remote.mac_address
	*/
	PortsRemoteMacAddress *string

	/* PortsRemotePhy.

	   Filter by ports.remote.phy
	*/
	PortsRemotePhy *string

	/* PortsRemotePort.

	   Filter by ports.remote.port
	*/
	PortsRemotePort *string

	/* PortsRemoteWwn.

	   Filter by ports.remote.wwn
	*/
	PortsRemoteWwn *string

	/* PortsSpeed.

	   Filter by ports.speed
	*/
	PortsSpeed *int64

	/* PortsState.

	   Filter by ports.state
	*/
	PortsState *string

	/* PortsWwn.

	   Filter by ports.wwn
	*/
	PortsWwn *string

	/* RawCapacity.

	   Filter by raw_capacity
	*/
	RawCapacity *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* State.

	   Filter by state
	*/
	State *string

	/* TemperatureSensorsAmbient.

	   Filter by temperature_sensors.ambient
	*/
	TemperatureSensorsAmbient *bool

	/* TemperatureSensorsID.

	   Filter by temperature_sensors.id
	*/
	TemperatureSensorsID *int64

	/* TemperatureSensorsInstalled.

	   Filter by temperature_sensors.installed
	*/
	TemperatureSensorsInstalled *bool

	/* TemperatureSensorsLocation.

	   Filter by temperature_sensors.location
	*/
	TemperatureSensorsLocation *string

	/* TemperatureSensorsState.

	   Filter by temperature_sensors.state
	*/
	TemperatureSensorsState *string

	/* TemperatureSensorsTemperature.

	   Filter by temperature_sensors.temperature
	*/
	TemperatureSensorsTemperature *int64

	/* TemperatureSensorsThresholdHighCritical.

	   Filter by temperature_sensors.threshold.high.critical
	*/
	TemperatureSensorsThresholdHighCritical *int64

	/* TemperatureSensorsThresholdHighWarning.

	   Filter by temperature_sensors.threshold.high.warning
	*/
	TemperatureSensorsThresholdHighWarning *int64

	/* TemperatureSensorsThresholdLowCritical.

	   Filter by temperature_sensors.threshold.low.critical
	*/
	TemperatureSensorsThresholdLowCritical *int64

	/* TemperatureSensorsThresholdLowWarning.

	   Filter by temperature_sensors.threshold.low.warning
	*/
	TemperatureSensorsThresholdLowWarning *int64

	/* UID.

	   Filter by uid
	*/
	UID *string

	/* VendorManufacturer.

	   Filter by vendor.manufacturer
	*/
	VendorManufacturer *string

	/* VendorName.

	   Filter by vendor.name
	*/
	VendorName *string

	/* VendorPartNumber.

	   Filter by vendor.part_number
	*/
	VendorPartNumber *string

	/* VendorProduct.

	   Filter by vendor.product
	*/
	VendorProduct *string

	/* VendorSerialNumber.

	   Filter by vendor.serial_number
	*/
	VendorSerialNumber *string

	/* VoltageSensorsID.

	   Filter by voltage_sensors.id
	*/
	VoltageSensorsID *int64

	/* VoltageSensorsInstalled.

	   Filter by voltage_sensors.installed
	*/
	VoltageSensorsInstalled *bool

	/* VoltageSensorsLocation.

	   Filter by voltage_sensors.location
	*/
	VoltageSensorsLocation *string

	/* VoltageSensorsState.

	   Filter by voltage_sensors.state
	*/
	VoltageSensorsState *string

	/* VoltageSensorsVoltage.

	   Filter by voltage_sensors.voltage
	*/
	VoltageSensorsVoltage *float64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the shelf collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ShelfCollectionGetParams) WithDefaults() *ShelfCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the shelf collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ShelfCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ShelfCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTimeout(timeout time.Duration) *ShelfCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the shelf collection get params
func (o *ShelfCollectionGetParams) WithContext(ctx context.Context) *ShelfCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the shelf collection get params
func (o *ShelfCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the shelf collection get params
func (o *ShelfCollectionGetParams) WithHTTPClient(client *http.Client) *ShelfCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the shelf collection get params
func (o *ShelfCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAcpsAddress adds the acpsAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsAddress(acpsAddress *string) *ShelfCollectionGetParams {
	o.SetAcpsAddress(acpsAddress)
	return o
}

// SetAcpsAddress adds the acpsAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsAddress(acpsAddress *string) {
	o.AcpsAddress = acpsAddress
}

// WithAcpsChannel adds the acpsChannel to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsChannel(acpsChannel *string) *ShelfCollectionGetParams {
	o.SetAcpsChannel(acpsChannel)
	return o
}

// SetAcpsChannel adds the acpsChannel to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsChannel(acpsChannel *string) {
	o.AcpsChannel = acpsChannel
}

// WithAcpsConnectionState adds the acpsConnectionState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsConnectionState(acpsConnectionState *string) *ShelfCollectionGetParams {
	o.SetAcpsConnectionState(acpsConnectionState)
	return o
}

// SetAcpsConnectionState adds the acpsConnectionState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsConnectionState(acpsConnectionState *string) {
	o.AcpsConnectionState = acpsConnectionState
}

// WithAcpsEnabled adds the acpsEnabled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsEnabled(acpsEnabled *bool) *ShelfCollectionGetParams {
	o.SetAcpsEnabled(acpsEnabled)
	return o
}

// SetAcpsEnabled adds the acpsEnabled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsEnabled(acpsEnabled *bool) {
	o.AcpsEnabled = acpsEnabled
}

// WithAcpsErrorReasonArgumentsCode adds the acpsErrorReasonArgumentsCode to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorReasonArgumentsCode(acpsErrorReasonArgumentsCode *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorReasonArgumentsCode(acpsErrorReasonArgumentsCode)
	return o
}

// SetAcpsErrorReasonArgumentsCode adds the acpsErrorReasonArgumentsCode to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorReasonArgumentsCode(acpsErrorReasonArgumentsCode *string) {
	o.AcpsErrorReasonArgumentsCode = acpsErrorReasonArgumentsCode
}

// WithAcpsErrorReasonArgumentsMessage adds the acpsErrorReasonArgumentsMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorReasonArgumentsMessage(acpsErrorReasonArgumentsMessage *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorReasonArgumentsMessage(acpsErrorReasonArgumentsMessage)
	return o
}

// SetAcpsErrorReasonArgumentsMessage adds the acpsErrorReasonArgumentsMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorReasonArgumentsMessage(acpsErrorReasonArgumentsMessage *string) {
	o.AcpsErrorReasonArgumentsMessage = acpsErrorReasonArgumentsMessage
}

// WithAcpsErrorReasonCode adds the acpsErrorReasonCode to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorReasonCode(acpsErrorReasonCode *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorReasonCode(acpsErrorReasonCode)
	return o
}

// SetAcpsErrorReasonCode adds the acpsErrorReasonCode to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorReasonCode(acpsErrorReasonCode *string) {
	o.AcpsErrorReasonCode = acpsErrorReasonCode
}

// WithAcpsErrorReasonMessage adds the acpsErrorReasonMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorReasonMessage(acpsErrorReasonMessage *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorReasonMessage(acpsErrorReasonMessage)
	return o
}

// SetAcpsErrorReasonMessage adds the acpsErrorReasonMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorReasonMessage(acpsErrorReasonMessage *string) {
	o.AcpsErrorReasonMessage = acpsErrorReasonMessage
}

// WithAcpsErrorSeverity adds the acpsErrorSeverity to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorSeverity(acpsErrorSeverity *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorSeverity(acpsErrorSeverity)
	return o
}

// SetAcpsErrorSeverity adds the acpsErrorSeverity to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorSeverity(acpsErrorSeverity *string) {
	o.AcpsErrorSeverity = acpsErrorSeverity
}

// WithAcpsErrorType adds the acpsErrorType to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsErrorType(acpsErrorType *string) *ShelfCollectionGetParams {
	o.SetAcpsErrorType(acpsErrorType)
	return o
}

// SetAcpsErrorType adds the acpsErrorType to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsErrorType(acpsErrorType *string) {
	o.AcpsErrorType = acpsErrorType
}

// WithAcpsNetmask adds the acpsNetmask to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsNetmask(acpsNetmask *string) *ShelfCollectionGetParams {
	o.SetAcpsNetmask(acpsNetmask)
	return o
}

// SetAcpsNetmask adds the acpsNetmask to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsNetmask(acpsNetmask *string) {
	o.AcpsNetmask = acpsNetmask
}

// WithAcpsNodeName adds the acpsNodeName to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsNodeName(acpsNodeName *string) *ShelfCollectionGetParams {
	o.SetAcpsNodeName(acpsNodeName)
	return o
}

// SetAcpsNodeName adds the acpsNodeName to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsNodeName(acpsNodeName *string) {
	o.AcpsNodeName = acpsNodeName
}

// WithAcpsNodeUUID adds the acpsNodeUUID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsNodeUUID(acpsNodeUUID *string) *ShelfCollectionGetParams {
	o.SetAcpsNodeUUID(acpsNodeUUID)
	return o
}

// SetAcpsNodeUUID adds the acpsNodeUuid to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsNodeUUID(acpsNodeUUID *string) {
	o.AcpsNodeUUID = acpsNodeUUID
}

// WithAcpsPort adds the acpsPort to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsPort(acpsPort *string) *ShelfCollectionGetParams {
	o.SetAcpsPort(acpsPort)
	return o
}

// SetAcpsPort adds the acpsPort to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsPort(acpsPort *string) {
	o.AcpsPort = acpsPort
}

// WithAcpsSubnet adds the acpsSubnet to the shelf collection get params
func (o *ShelfCollectionGetParams) WithAcpsSubnet(acpsSubnet *string) *ShelfCollectionGetParams {
	o.SetAcpsSubnet(acpsSubnet)
	return o
}

// SetAcpsSubnet adds the acpsSubnet to the shelf collection get params
func (o *ShelfCollectionGetParams) SetAcpsSubnet(acpsSubnet *string) {
	o.AcpsSubnet = acpsSubnet
}

// WithBaysDrawerID adds the baysDrawerID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysDrawerID(baysDrawerID *int64) *ShelfCollectionGetParams {
	o.SetBaysDrawerID(baysDrawerID)
	return o
}

// SetBaysDrawerID adds the baysDrawerId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysDrawerID(baysDrawerID *int64) {
	o.BaysDrawerID = baysDrawerID
}

// WithBaysDrawerSlot adds the baysDrawerSlot to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysDrawerSlot(baysDrawerSlot *int64) *ShelfCollectionGetParams {
	o.SetBaysDrawerSlot(baysDrawerSlot)
	return o
}

// SetBaysDrawerSlot adds the baysDrawerSlot to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysDrawerSlot(baysDrawerSlot *int64) {
	o.BaysDrawerSlot = baysDrawerSlot
}

// WithBaysHasDisk adds the baysHasDisk to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysHasDisk(baysHasDisk *bool) *ShelfCollectionGetParams {
	o.SetBaysHasDisk(baysHasDisk)
	return o
}

// SetBaysHasDisk adds the baysHasDisk to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysHasDisk(baysHasDisk *bool) {
	o.BaysHasDisk = baysHasDisk
}

// WithBaysID adds the baysID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysID(baysID *int64) *ShelfCollectionGetParams {
	o.SetBaysID(baysID)
	return o
}

// SetBaysID adds the baysId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysID(baysID *int64) {
	o.BaysID = baysID
}

// WithBaysState adds the baysState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysState(baysState *string) *ShelfCollectionGetParams {
	o.SetBaysState(baysState)
	return o
}

// SetBaysState adds the baysState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysState(baysState *string) {
	o.BaysState = baysState
}

// WithBaysType adds the baysType to the shelf collection get params
func (o *ShelfCollectionGetParams) WithBaysType(baysType *string) *ShelfCollectionGetParams {
	o.SetBaysType(baysType)
	return o
}

// SetBaysType adds the baysType to the shelf collection get params
func (o *ShelfCollectionGetParams) SetBaysType(baysType *string) {
	o.BaysType = baysType
}

// WithConnectionType adds the connectionType to the shelf collection get params
func (o *ShelfCollectionGetParams) WithConnectionType(connectionType *string) *ShelfCollectionGetParams {
	o.SetConnectionType(connectionType)
	return o
}

// SetConnectionType adds the connectionType to the shelf collection get params
func (o *ShelfCollectionGetParams) SetConnectionType(connectionType *string) {
	o.ConnectionType = connectionType
}

// WithCurrentSensorsCurrent adds the currentSensorsCurrent to the shelf collection get params
func (o *ShelfCollectionGetParams) WithCurrentSensorsCurrent(currentSensorsCurrent *int64) *ShelfCollectionGetParams {
	o.SetCurrentSensorsCurrent(currentSensorsCurrent)
	return o
}

// SetCurrentSensorsCurrent adds the currentSensorsCurrent to the shelf collection get params
func (o *ShelfCollectionGetParams) SetCurrentSensorsCurrent(currentSensorsCurrent *int64) {
	o.CurrentSensorsCurrent = currentSensorsCurrent
}

// WithCurrentSensorsID adds the currentSensorsID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithCurrentSensorsID(currentSensorsID *int64) *ShelfCollectionGetParams {
	o.SetCurrentSensorsID(currentSensorsID)
	return o
}

// SetCurrentSensorsID adds the currentSensorsId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetCurrentSensorsID(currentSensorsID *int64) {
	o.CurrentSensorsID = currentSensorsID
}

// WithCurrentSensorsInstalled adds the currentSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithCurrentSensorsInstalled(currentSensorsInstalled *bool) *ShelfCollectionGetParams {
	o.SetCurrentSensorsInstalled(currentSensorsInstalled)
	return o
}

// SetCurrentSensorsInstalled adds the currentSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetCurrentSensorsInstalled(currentSensorsInstalled *bool) {
	o.CurrentSensorsInstalled = currentSensorsInstalled
}

// WithCurrentSensorsLocation adds the currentSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) WithCurrentSensorsLocation(currentSensorsLocation *string) *ShelfCollectionGetParams {
	o.SetCurrentSensorsLocation(currentSensorsLocation)
	return o
}

// SetCurrentSensorsLocation adds the currentSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) SetCurrentSensorsLocation(currentSensorsLocation *string) {
	o.CurrentSensorsLocation = currentSensorsLocation
}

// WithCurrentSensorsState adds the currentSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithCurrentSensorsState(currentSensorsState *string) *ShelfCollectionGetParams {
	o.SetCurrentSensorsState(currentSensorsState)
	return o
}

// SetCurrentSensorsState adds the currentSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetCurrentSensorsState(currentSensorsState *string) {
	o.CurrentSensorsState = currentSensorsState
}

// WithDiskCount adds the diskCount to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDiskCount(diskCount *int64) *ShelfCollectionGetParams {
	o.SetDiskCount(diskCount)
	return o
}

// SetDiskCount adds the diskCount to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDiskCount(diskCount *int64) {
	o.DiskCount = diskCount
}

// WithDrawersClosed adds the drawersClosed to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersClosed(drawersClosed *bool) *ShelfCollectionGetParams {
	o.SetDrawersClosed(drawersClosed)
	return o
}

// SetDrawersClosed adds the drawersClosed to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersClosed(drawersClosed *bool) {
	o.DrawersClosed = drawersClosed
}

// WithDrawersDiskCount adds the drawersDiskCount to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersDiskCount(drawersDiskCount *int64) *ShelfCollectionGetParams {
	o.SetDrawersDiskCount(drawersDiskCount)
	return o
}

// SetDrawersDiskCount adds the drawersDiskCount to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersDiskCount(drawersDiskCount *int64) {
	o.DrawersDiskCount = drawersDiskCount
}

// WithDrawersError adds the drawersError to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersError(drawersError *string) *ShelfCollectionGetParams {
	o.SetDrawersError(drawersError)
	return o
}

// SetDrawersError adds the drawersError to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersError(drawersError *string) {
	o.DrawersError = drawersError
}

// WithDrawersID adds the drawersID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersID(drawersID *int64) *ShelfCollectionGetParams {
	o.SetDrawersID(drawersID)
	return o
}

// SetDrawersID adds the drawersId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersID(drawersID *int64) {
	o.DrawersID = drawersID
}

// WithDrawersPartNumber adds the drawersPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersPartNumber(drawersPartNumber *string) *ShelfCollectionGetParams {
	o.SetDrawersPartNumber(drawersPartNumber)
	return o
}

// SetDrawersPartNumber adds the drawersPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersPartNumber(drawersPartNumber *string) {
	o.DrawersPartNumber = drawersPartNumber
}

// WithDrawersSerialNumber adds the drawersSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersSerialNumber(drawersSerialNumber *string) *ShelfCollectionGetParams {
	o.SetDrawersSerialNumber(drawersSerialNumber)
	return o
}

// SetDrawersSerialNumber adds the drawersSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersSerialNumber(drawersSerialNumber *string) {
	o.DrawersSerialNumber = drawersSerialNumber
}

// WithDrawersState adds the drawersState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithDrawersState(drawersState *string) *ShelfCollectionGetParams {
	o.SetDrawersState(drawersState)
	return o
}

// SetDrawersState adds the drawersState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetDrawersState(drawersState *string) {
	o.DrawersState = drawersState
}

// WithErrorsReasonArgumentsCode adds the errorsReasonArgumentsCode to the shelf collection get params
func (o *ShelfCollectionGetParams) WithErrorsReasonArgumentsCode(errorsReasonArgumentsCode *string) *ShelfCollectionGetParams {
	o.SetErrorsReasonArgumentsCode(errorsReasonArgumentsCode)
	return o
}

// SetErrorsReasonArgumentsCode adds the errorsReasonArgumentsCode to the shelf collection get params
func (o *ShelfCollectionGetParams) SetErrorsReasonArgumentsCode(errorsReasonArgumentsCode *string) {
	o.ErrorsReasonArgumentsCode = errorsReasonArgumentsCode
}

// WithErrorsReasonArgumentsMessage adds the errorsReasonArgumentsMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) WithErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage *string) *ShelfCollectionGetParams {
	o.SetErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage)
	return o
}

// SetErrorsReasonArgumentsMessage adds the errorsReasonArgumentsMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) SetErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage *string) {
	o.ErrorsReasonArgumentsMessage = errorsReasonArgumentsMessage
}

// WithErrorsReasonCode adds the errorsReasonCode to the shelf collection get params
func (o *ShelfCollectionGetParams) WithErrorsReasonCode(errorsReasonCode *string) *ShelfCollectionGetParams {
	o.SetErrorsReasonCode(errorsReasonCode)
	return o
}

// SetErrorsReasonCode adds the errorsReasonCode to the shelf collection get params
func (o *ShelfCollectionGetParams) SetErrorsReasonCode(errorsReasonCode *string) {
	o.ErrorsReasonCode = errorsReasonCode
}

// WithErrorsReasonMessage adds the errorsReasonMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) WithErrorsReasonMessage(errorsReasonMessage *string) *ShelfCollectionGetParams {
	o.SetErrorsReasonMessage(errorsReasonMessage)
	return o
}

// SetErrorsReasonMessage adds the errorsReasonMessage to the shelf collection get params
func (o *ShelfCollectionGetParams) SetErrorsReasonMessage(errorsReasonMessage *string) {
	o.ErrorsReasonMessage = errorsReasonMessage
}

// WithFansID adds the fansID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFansID(fansID *int64) *ShelfCollectionGetParams {
	o.SetFansID(fansID)
	return o
}

// SetFansID adds the fansId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFansID(fansID *int64) {
	o.FansID = fansID
}

// WithFansInstalled adds the fansInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFansInstalled(fansInstalled *bool) *ShelfCollectionGetParams {
	o.SetFansInstalled(fansInstalled)
	return o
}

// SetFansInstalled adds the fansInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFansInstalled(fansInstalled *bool) {
	o.FansInstalled = fansInstalled
}

// WithFansLocation adds the fansLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFansLocation(fansLocation *string) *ShelfCollectionGetParams {
	o.SetFansLocation(fansLocation)
	return o
}

// SetFansLocation adds the fansLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFansLocation(fansLocation *string) {
	o.FansLocation = fansLocation
}

// WithFansRpm adds the fansRpm to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFansRpm(fansRpm *int64) *ShelfCollectionGetParams {
	o.SetFansRpm(fansRpm)
	return o
}

// SetFansRpm adds the fansRpm to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFansRpm(fansRpm *int64) {
	o.FansRpm = fansRpm
}

// WithFansState adds the fansState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFansState(fansState *string) *ShelfCollectionGetParams {
	o.SetFansState(fansState)
	return o
}

// SetFansState adds the fansState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFansState(fansState *string) {
	o.FansState = fansState
}

// WithFields adds the fields to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFields(fields []string) *ShelfCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFrusFirmwareVersion adds the frusFirmwareVersion to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusFirmwareVersion(frusFirmwareVersion *string) *ShelfCollectionGetParams {
	o.SetFrusFirmwareVersion(frusFirmwareVersion)
	return o
}

// SetFrusFirmwareVersion adds the frusFirmwareVersion to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusFirmwareVersion(frusFirmwareVersion *string) {
	o.FrusFirmwareVersion = frusFirmwareVersion
}

// WithFrusID adds the frusID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusID(frusID *int64) *ShelfCollectionGetParams {
	o.SetFrusID(frusID)
	return o
}

// SetFrusID adds the frusId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusID(frusID *int64) {
	o.FrusID = frusID
}

// WithFrusInstalled adds the frusInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusInstalled(frusInstalled *bool) *ShelfCollectionGetParams {
	o.SetFrusInstalled(frusInstalled)
	return o
}

// SetFrusInstalled adds the frusInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusInstalled(frusInstalled *bool) {
	o.FrusInstalled = frusInstalled
}

// WithFrusPartNumber adds the frusPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusPartNumber(frusPartNumber *string) *ShelfCollectionGetParams {
	o.SetFrusPartNumber(frusPartNumber)
	return o
}

// SetFrusPartNumber adds the frusPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusPartNumber(frusPartNumber *string) {
	o.FrusPartNumber = frusPartNumber
}

// WithFrusPsuCrestFactor adds the frusPsuCrestFactor to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusPsuCrestFactor(frusPsuCrestFactor *int64) *ShelfCollectionGetParams {
	o.SetFrusPsuCrestFactor(frusPsuCrestFactor)
	return o
}

// SetFrusPsuCrestFactor adds the frusPsuCrestFactor to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusPsuCrestFactor(frusPsuCrestFactor *int64) {
	o.FrusPsuCrestFactor = frusPsuCrestFactor
}

// WithFrusPsuModel adds the frusPsuModel to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusPsuModel(frusPsuModel *string) *ShelfCollectionGetParams {
	o.SetFrusPsuModel(frusPsuModel)
	return o
}

// SetFrusPsuModel adds the frusPsuModel to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusPsuModel(frusPsuModel *string) {
	o.FrusPsuModel = frusPsuModel
}

// WithFrusPsuPowerDrawn adds the frusPsuPowerDrawn to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusPsuPowerDrawn(frusPsuPowerDrawn *int64) *ShelfCollectionGetParams {
	o.SetFrusPsuPowerDrawn(frusPsuPowerDrawn)
	return o
}

// SetFrusPsuPowerDrawn adds the frusPsuPowerDrawn to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusPsuPowerDrawn(frusPsuPowerDrawn *int64) {
	o.FrusPsuPowerDrawn = frusPsuPowerDrawn
}

// WithFrusPsuPowerRating adds the frusPsuPowerRating to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusPsuPowerRating(frusPsuPowerRating *int64) *ShelfCollectionGetParams {
	o.SetFrusPsuPowerRating(frusPsuPowerRating)
	return o
}

// SetFrusPsuPowerRating adds the frusPsuPowerRating to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusPsuPowerRating(frusPsuPowerRating *int64) {
	o.FrusPsuPowerRating = frusPsuPowerRating
}

// WithFrusSerialNumber adds the frusSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusSerialNumber(frusSerialNumber *string) *ShelfCollectionGetParams {
	o.SetFrusSerialNumber(frusSerialNumber)
	return o
}

// SetFrusSerialNumber adds the frusSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusSerialNumber(frusSerialNumber *string) {
	o.FrusSerialNumber = frusSerialNumber
}

// WithFrusState adds the frusState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusState(frusState *string) *ShelfCollectionGetParams {
	o.SetFrusState(frusState)
	return o
}

// SetFrusState adds the frusState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusState(frusState *string) {
	o.FrusState = frusState
}

// WithFrusType adds the frusType to the shelf collection get params
func (o *ShelfCollectionGetParams) WithFrusType(frusType *string) *ShelfCollectionGetParams {
	o.SetFrusType(frusType)
	return o
}

// SetFrusType adds the frusType to the shelf collection get params
func (o *ShelfCollectionGetParams) SetFrusType(frusType *string) {
	o.FrusType = frusType
}

// WithID adds the id to the shelf collection get params
func (o *ShelfCollectionGetParams) WithID(id *string) *ShelfCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the shelf collection get params
func (o *ShelfCollectionGetParams) SetID(id *string) {
	o.ID = id
}

// WithInternal adds the internal to the shelf collection get params
func (o *ShelfCollectionGetParams) WithInternal(internal *bool) *ShelfCollectionGetParams {
	o.SetInternal(internal)
	return o
}

// SetInternal adds the internal to the shelf collection get params
func (o *ShelfCollectionGetParams) SetInternal(internal *bool) {
	o.Internal = internal
}

// WithLocal adds the local to the shelf collection get params
func (o *ShelfCollectionGetParams) WithLocal(local *bool) *ShelfCollectionGetParams {
	o.SetLocal(local)
	return o
}

// SetLocal adds the local to the shelf collection get params
func (o *ShelfCollectionGetParams) SetLocal(local *bool) {
	o.Local = local
}

// WithLocationLed adds the locationLed to the shelf collection get params
func (o *ShelfCollectionGetParams) WithLocationLed(locationLed *string) *ShelfCollectionGetParams {
	o.SetLocationLed(locationLed)
	return o
}

// SetLocationLed adds the locationLed to the shelf collection get params
func (o *ShelfCollectionGetParams) SetLocationLed(locationLed *string) {
	o.LocationLed = locationLed
}

// WithManufacturerName adds the manufacturerName to the shelf collection get params
func (o *ShelfCollectionGetParams) WithManufacturerName(manufacturerName *string) *ShelfCollectionGetParams {
	o.SetManufacturerName(manufacturerName)
	return o
}

// SetManufacturerName adds the manufacturerName to the shelf collection get params
func (o *ShelfCollectionGetParams) SetManufacturerName(manufacturerName *string) {
	o.ManufacturerName = manufacturerName
}

// WithMaxRecords adds the maxRecords to the shelf collection get params
func (o *ShelfCollectionGetParams) WithMaxRecords(maxRecords *int64) *ShelfCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the shelf collection get params
func (o *ShelfCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithModel adds the model to the shelf collection get params
func (o *ShelfCollectionGetParams) WithModel(model *string) *ShelfCollectionGetParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the shelf collection get params
func (o *ShelfCollectionGetParams) SetModel(model *string) {
	o.Model = model
}

// WithModuleType adds the moduleType to the shelf collection get params
func (o *ShelfCollectionGetParams) WithModuleType(moduleType *string) *ShelfCollectionGetParams {
	o.SetModuleType(moduleType)
	return o
}

// SetModuleType adds the moduleType to the shelf collection get params
func (o *ShelfCollectionGetParams) SetModuleType(moduleType *string) {
	o.ModuleType = moduleType
}

// WithName adds the name to the shelf collection get params
func (o *ShelfCollectionGetParams) WithName(name *string) *ShelfCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the shelf collection get params
func (o *ShelfCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the shelf collection get params
func (o *ShelfCollectionGetParams) WithOrderBy(orderBy []string) *ShelfCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the shelf collection get params
func (o *ShelfCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPathsName adds the pathsName to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPathsName(pathsName *string) *ShelfCollectionGetParams {
	o.SetPathsName(pathsName)
	return o
}

// SetPathsName adds the pathsName to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPathsName(pathsName *string) {
	o.PathsName = pathsName
}

// WithPathsNodeName adds the pathsNodeName to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPathsNodeName(pathsNodeName *string) *ShelfCollectionGetParams {
	o.SetPathsNodeName(pathsNodeName)
	return o
}

// SetPathsNodeName adds the pathsNodeName to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPathsNodeName(pathsNodeName *string) {
	o.PathsNodeName = pathsNodeName
}

// WithPathsNodeUUID adds the pathsNodeUUID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPathsNodeUUID(pathsNodeUUID *string) *ShelfCollectionGetParams {
	o.SetPathsNodeUUID(pathsNodeUUID)
	return o
}

// SetPathsNodeUUID adds the pathsNodeUuid to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPathsNodeUUID(pathsNodeUUID *string) {
	o.PathsNodeUUID = pathsNodeUUID
}

// WithPortsCableIdentifier adds the portsCableIdentifier to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsCableIdentifier(portsCableIdentifier *string) *ShelfCollectionGetParams {
	o.SetPortsCableIdentifier(portsCableIdentifier)
	return o
}

// SetPortsCableIdentifier adds the portsCableIdentifier to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsCableIdentifier(portsCableIdentifier *string) {
	o.PortsCableIdentifier = portsCableIdentifier
}

// WithPortsCableLength adds the portsCableLength to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsCableLength(portsCableLength *string) *ShelfCollectionGetParams {
	o.SetPortsCableLength(portsCableLength)
	return o
}

// SetPortsCableLength adds the portsCableLength to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsCableLength(portsCableLength *string) {
	o.PortsCableLength = portsCableLength
}

// WithPortsCablePartNumber adds the portsCablePartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsCablePartNumber(portsCablePartNumber *string) *ShelfCollectionGetParams {
	o.SetPortsCablePartNumber(portsCablePartNumber)
	return o
}

// SetPortsCablePartNumber adds the portsCablePartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsCablePartNumber(portsCablePartNumber *string) {
	o.PortsCablePartNumber = portsCablePartNumber
}

// WithPortsCableSerialNumber adds the portsCableSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsCableSerialNumber(portsCableSerialNumber *string) *ShelfCollectionGetParams {
	o.SetPortsCableSerialNumber(portsCableSerialNumber)
	return o
}

// SetPortsCableSerialNumber adds the portsCableSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsCableSerialNumber(portsCableSerialNumber *string) {
	o.PortsCableSerialNumber = portsCableSerialNumber
}

// WithPortsDesignator adds the portsDesignator to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsDesignator(portsDesignator *string) *ShelfCollectionGetParams {
	o.SetPortsDesignator(portsDesignator)
	return o
}

// SetPortsDesignator adds the portsDesignator to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsDesignator(portsDesignator *string) {
	o.PortsDesignator = portsDesignator
}

// WithPortsID adds the portsID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsID(portsID *int64) *ShelfCollectionGetParams {
	o.SetPortsID(portsID)
	return o
}

// SetPortsID adds the portsId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsID(portsID *int64) {
	o.PortsID = portsID
}

// WithPortsInternal adds the portsInternal to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsInternal(portsInternal *bool) *ShelfCollectionGetParams {
	o.SetPortsInternal(portsInternal)
	return o
}

// SetPortsInternal adds the portsInternal to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsInternal(portsInternal *bool) {
	o.PortsInternal = portsInternal
}

// WithPortsMacAddress adds the portsMacAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsMacAddress(portsMacAddress *string) *ShelfCollectionGetParams {
	o.SetPortsMacAddress(portsMacAddress)
	return o
}

// SetPortsMacAddress adds the portsMacAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsMacAddress(portsMacAddress *string) {
	o.PortsMacAddress = portsMacAddress
}

// WithPortsModuleID adds the portsModuleID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsModuleID(portsModuleID *string) *ShelfCollectionGetParams {
	o.SetPortsModuleID(portsModuleID)
	return o
}

// SetPortsModuleID adds the portsModuleId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsModuleID(portsModuleID *string) {
	o.PortsModuleID = portsModuleID
}

// WithPortsRemoteChassis adds the portsRemoteChassis to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemoteChassis(portsRemoteChassis *string) *ShelfCollectionGetParams {
	o.SetPortsRemoteChassis(portsRemoteChassis)
	return o
}

// SetPortsRemoteChassis adds the portsRemoteChassis to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemoteChassis(portsRemoteChassis *string) {
	o.PortsRemoteChassis = portsRemoteChassis
}

// WithPortsRemoteDevice adds the portsRemoteDevice to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemoteDevice(portsRemoteDevice *string) *ShelfCollectionGetParams {
	o.SetPortsRemoteDevice(portsRemoteDevice)
	return o
}

// SetPortsRemoteDevice adds the portsRemoteDevice to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemoteDevice(portsRemoteDevice *string) {
	o.PortsRemoteDevice = portsRemoteDevice
}

// WithPortsRemoteMacAddress adds the portsRemoteMacAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemoteMacAddress(portsRemoteMacAddress *string) *ShelfCollectionGetParams {
	o.SetPortsRemoteMacAddress(portsRemoteMacAddress)
	return o
}

// SetPortsRemoteMacAddress adds the portsRemoteMacAddress to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemoteMacAddress(portsRemoteMacAddress *string) {
	o.PortsRemoteMacAddress = portsRemoteMacAddress
}

// WithPortsRemotePhy adds the portsRemotePhy to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemotePhy(portsRemotePhy *string) *ShelfCollectionGetParams {
	o.SetPortsRemotePhy(portsRemotePhy)
	return o
}

// SetPortsRemotePhy adds the portsRemotePhy to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemotePhy(portsRemotePhy *string) {
	o.PortsRemotePhy = portsRemotePhy
}

// WithPortsRemotePort adds the portsRemotePort to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemotePort(portsRemotePort *string) *ShelfCollectionGetParams {
	o.SetPortsRemotePort(portsRemotePort)
	return o
}

// SetPortsRemotePort adds the portsRemotePort to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemotePort(portsRemotePort *string) {
	o.PortsRemotePort = portsRemotePort
}

// WithPortsRemoteWwn adds the portsRemoteWwn to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsRemoteWwn(portsRemoteWwn *string) *ShelfCollectionGetParams {
	o.SetPortsRemoteWwn(portsRemoteWwn)
	return o
}

// SetPortsRemoteWwn adds the portsRemoteWwn to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsRemoteWwn(portsRemoteWwn *string) {
	o.PortsRemoteWwn = portsRemoteWwn
}

// WithPortsSpeed adds the portsSpeed to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsSpeed(portsSpeed *int64) *ShelfCollectionGetParams {
	o.SetPortsSpeed(portsSpeed)
	return o
}

// SetPortsSpeed adds the portsSpeed to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsSpeed(portsSpeed *int64) {
	o.PortsSpeed = portsSpeed
}

// WithPortsState adds the portsState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsState(portsState *string) *ShelfCollectionGetParams {
	o.SetPortsState(portsState)
	return o
}

// SetPortsState adds the portsState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsState(portsState *string) {
	o.PortsState = portsState
}

// WithPortsWwn adds the portsWwn to the shelf collection get params
func (o *ShelfCollectionGetParams) WithPortsWwn(portsWwn *string) *ShelfCollectionGetParams {
	o.SetPortsWwn(portsWwn)
	return o
}

// SetPortsWwn adds the portsWwn to the shelf collection get params
func (o *ShelfCollectionGetParams) SetPortsWwn(portsWwn *string) {
	o.PortsWwn = portsWwn
}

// WithRawCapacity adds the rawCapacity to the shelf collection get params
func (o *ShelfCollectionGetParams) WithRawCapacity(rawCapacity *int64) *ShelfCollectionGetParams {
	o.SetRawCapacity(rawCapacity)
	return o
}

// SetRawCapacity adds the rawCapacity to the shelf collection get params
func (o *ShelfCollectionGetParams) SetRawCapacity(rawCapacity *int64) {
	o.RawCapacity = rawCapacity
}

// WithReturnRecords adds the returnRecords to the shelf collection get params
func (o *ShelfCollectionGetParams) WithReturnRecords(returnRecords *bool) *ShelfCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the shelf collection get params
func (o *ShelfCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the shelf collection get params
func (o *ShelfCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ShelfCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the shelf collection get params
func (o *ShelfCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithSerialNumber(serialNumber *string) *ShelfCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithState adds the state to the shelf collection get params
func (o *ShelfCollectionGetParams) WithState(state *string) *ShelfCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the shelf collection get params
func (o *ShelfCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithTemperatureSensorsAmbient adds the temperatureSensorsAmbient to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsAmbient(temperatureSensorsAmbient *bool) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsAmbient(temperatureSensorsAmbient)
	return o
}

// SetTemperatureSensorsAmbient adds the temperatureSensorsAmbient to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsAmbient(temperatureSensorsAmbient *bool) {
	o.TemperatureSensorsAmbient = temperatureSensorsAmbient
}

// WithTemperatureSensorsID adds the temperatureSensorsID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsID(temperatureSensorsID *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsID(temperatureSensorsID)
	return o
}

// SetTemperatureSensorsID adds the temperatureSensorsId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsID(temperatureSensorsID *int64) {
	o.TemperatureSensorsID = temperatureSensorsID
}

// WithTemperatureSensorsInstalled adds the temperatureSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsInstalled(temperatureSensorsInstalled *bool) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsInstalled(temperatureSensorsInstalled)
	return o
}

// SetTemperatureSensorsInstalled adds the temperatureSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsInstalled(temperatureSensorsInstalled *bool) {
	o.TemperatureSensorsInstalled = temperatureSensorsInstalled
}

// WithTemperatureSensorsLocation adds the temperatureSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsLocation(temperatureSensorsLocation *string) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsLocation(temperatureSensorsLocation)
	return o
}

// SetTemperatureSensorsLocation adds the temperatureSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsLocation(temperatureSensorsLocation *string) {
	o.TemperatureSensorsLocation = temperatureSensorsLocation
}

// WithTemperatureSensorsState adds the temperatureSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsState(temperatureSensorsState *string) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsState(temperatureSensorsState)
	return o
}

// SetTemperatureSensorsState adds the temperatureSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsState(temperatureSensorsState *string) {
	o.TemperatureSensorsState = temperatureSensorsState
}

// WithTemperatureSensorsTemperature adds the temperatureSensorsTemperature to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsTemperature(temperatureSensorsTemperature *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsTemperature(temperatureSensorsTemperature)
	return o
}

// SetTemperatureSensorsTemperature adds the temperatureSensorsTemperature to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsTemperature(temperatureSensorsTemperature *int64) {
	o.TemperatureSensorsTemperature = temperatureSensorsTemperature
}

// WithTemperatureSensorsThresholdHighCritical adds the temperatureSensorsThresholdHighCritical to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsThresholdHighCritical(temperatureSensorsThresholdHighCritical *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsThresholdHighCritical(temperatureSensorsThresholdHighCritical)
	return o
}

// SetTemperatureSensorsThresholdHighCritical adds the temperatureSensorsThresholdHighCritical to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsThresholdHighCritical(temperatureSensorsThresholdHighCritical *int64) {
	o.TemperatureSensorsThresholdHighCritical = temperatureSensorsThresholdHighCritical
}

// WithTemperatureSensorsThresholdHighWarning adds the temperatureSensorsThresholdHighWarning to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsThresholdHighWarning(temperatureSensorsThresholdHighWarning *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsThresholdHighWarning(temperatureSensorsThresholdHighWarning)
	return o
}

// SetTemperatureSensorsThresholdHighWarning adds the temperatureSensorsThresholdHighWarning to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsThresholdHighWarning(temperatureSensorsThresholdHighWarning *int64) {
	o.TemperatureSensorsThresholdHighWarning = temperatureSensorsThresholdHighWarning
}

// WithTemperatureSensorsThresholdLowCritical adds the temperatureSensorsThresholdLowCritical to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsThresholdLowCritical(temperatureSensorsThresholdLowCritical *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsThresholdLowCritical(temperatureSensorsThresholdLowCritical)
	return o
}

// SetTemperatureSensorsThresholdLowCritical adds the temperatureSensorsThresholdLowCritical to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsThresholdLowCritical(temperatureSensorsThresholdLowCritical *int64) {
	o.TemperatureSensorsThresholdLowCritical = temperatureSensorsThresholdLowCritical
}

// WithTemperatureSensorsThresholdLowWarning adds the temperatureSensorsThresholdLowWarning to the shelf collection get params
func (o *ShelfCollectionGetParams) WithTemperatureSensorsThresholdLowWarning(temperatureSensorsThresholdLowWarning *int64) *ShelfCollectionGetParams {
	o.SetTemperatureSensorsThresholdLowWarning(temperatureSensorsThresholdLowWarning)
	return o
}

// SetTemperatureSensorsThresholdLowWarning adds the temperatureSensorsThresholdLowWarning to the shelf collection get params
func (o *ShelfCollectionGetParams) SetTemperatureSensorsThresholdLowWarning(temperatureSensorsThresholdLowWarning *int64) {
	o.TemperatureSensorsThresholdLowWarning = temperatureSensorsThresholdLowWarning
}

// WithUID adds the uid to the shelf collection get params
func (o *ShelfCollectionGetParams) WithUID(uid *string) *ShelfCollectionGetParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the shelf collection get params
func (o *ShelfCollectionGetParams) SetUID(uid *string) {
	o.UID = uid
}

// WithVendorManufacturer adds the vendorManufacturer to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVendorManufacturer(vendorManufacturer *string) *ShelfCollectionGetParams {
	o.SetVendorManufacturer(vendorManufacturer)
	return o
}

// SetVendorManufacturer adds the vendorManufacturer to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVendorManufacturer(vendorManufacturer *string) {
	o.VendorManufacturer = vendorManufacturer
}

// WithVendorName adds the vendorName to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVendorName(vendorName *string) *ShelfCollectionGetParams {
	o.SetVendorName(vendorName)
	return o
}

// SetVendorName adds the vendorName to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVendorName(vendorName *string) {
	o.VendorName = vendorName
}

// WithVendorPartNumber adds the vendorPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVendorPartNumber(vendorPartNumber *string) *ShelfCollectionGetParams {
	o.SetVendorPartNumber(vendorPartNumber)
	return o
}

// SetVendorPartNumber adds the vendorPartNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVendorPartNumber(vendorPartNumber *string) {
	o.VendorPartNumber = vendorPartNumber
}

// WithVendorProduct adds the vendorProduct to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVendorProduct(vendorProduct *string) *ShelfCollectionGetParams {
	o.SetVendorProduct(vendorProduct)
	return o
}

// SetVendorProduct adds the vendorProduct to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVendorProduct(vendorProduct *string) {
	o.VendorProduct = vendorProduct
}

// WithVendorSerialNumber adds the vendorSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVendorSerialNumber(vendorSerialNumber *string) *ShelfCollectionGetParams {
	o.SetVendorSerialNumber(vendorSerialNumber)
	return o
}

// SetVendorSerialNumber adds the vendorSerialNumber to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVendorSerialNumber(vendorSerialNumber *string) {
	o.VendorSerialNumber = vendorSerialNumber
}

// WithVoltageSensorsID adds the voltageSensorsID to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVoltageSensorsID(voltageSensorsID *int64) *ShelfCollectionGetParams {
	o.SetVoltageSensorsID(voltageSensorsID)
	return o
}

// SetVoltageSensorsID adds the voltageSensorsId to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVoltageSensorsID(voltageSensorsID *int64) {
	o.VoltageSensorsID = voltageSensorsID
}

// WithVoltageSensorsInstalled adds the voltageSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVoltageSensorsInstalled(voltageSensorsInstalled *bool) *ShelfCollectionGetParams {
	o.SetVoltageSensorsInstalled(voltageSensorsInstalled)
	return o
}

// SetVoltageSensorsInstalled adds the voltageSensorsInstalled to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVoltageSensorsInstalled(voltageSensorsInstalled *bool) {
	o.VoltageSensorsInstalled = voltageSensorsInstalled
}

// WithVoltageSensorsLocation adds the voltageSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVoltageSensorsLocation(voltageSensorsLocation *string) *ShelfCollectionGetParams {
	o.SetVoltageSensorsLocation(voltageSensorsLocation)
	return o
}

// SetVoltageSensorsLocation adds the voltageSensorsLocation to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVoltageSensorsLocation(voltageSensorsLocation *string) {
	o.VoltageSensorsLocation = voltageSensorsLocation
}

// WithVoltageSensorsState adds the voltageSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVoltageSensorsState(voltageSensorsState *string) *ShelfCollectionGetParams {
	o.SetVoltageSensorsState(voltageSensorsState)
	return o
}

// SetVoltageSensorsState adds the voltageSensorsState to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVoltageSensorsState(voltageSensorsState *string) {
	o.VoltageSensorsState = voltageSensorsState
}

// WithVoltageSensorsVoltage adds the voltageSensorsVoltage to the shelf collection get params
func (o *ShelfCollectionGetParams) WithVoltageSensorsVoltage(voltageSensorsVoltage *float64) *ShelfCollectionGetParams {
	o.SetVoltageSensorsVoltage(voltageSensorsVoltage)
	return o
}

// SetVoltageSensorsVoltage adds the voltageSensorsVoltage to the shelf collection get params
func (o *ShelfCollectionGetParams) SetVoltageSensorsVoltage(voltageSensorsVoltage *float64) {
	o.VoltageSensorsVoltage = voltageSensorsVoltage
}

// WriteToRequest writes these params to a swagger request
func (o *ShelfCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AcpsAddress != nil {

		// query param acps.address
		var qrAcpsAddress string

		if o.AcpsAddress != nil {
			qrAcpsAddress = *o.AcpsAddress
		}
		qAcpsAddress := qrAcpsAddress
		if qAcpsAddress != "" {

			if err := r.SetQueryParam("acps.address", qAcpsAddress); err != nil {
				return err
			}
		}
	}

	if o.AcpsChannel != nil {

		// query param acps.channel
		var qrAcpsChannel string

		if o.AcpsChannel != nil {
			qrAcpsChannel = *o.AcpsChannel
		}
		qAcpsChannel := qrAcpsChannel
		if qAcpsChannel != "" {

			if err := r.SetQueryParam("acps.channel", qAcpsChannel); err != nil {
				return err
			}
		}
	}

	if o.AcpsConnectionState != nil {

		// query param acps.connection_state
		var qrAcpsConnectionState string

		if o.AcpsConnectionState != nil {
			qrAcpsConnectionState = *o.AcpsConnectionState
		}
		qAcpsConnectionState := qrAcpsConnectionState
		if qAcpsConnectionState != "" {

			if err := r.SetQueryParam("acps.connection_state", qAcpsConnectionState); err != nil {
				return err
			}
		}
	}

	if o.AcpsEnabled != nil {

		// query param acps.enabled
		var qrAcpsEnabled bool

		if o.AcpsEnabled != nil {
			qrAcpsEnabled = *o.AcpsEnabled
		}
		qAcpsEnabled := swag.FormatBool(qrAcpsEnabled)
		if qAcpsEnabled != "" {

			if err := r.SetQueryParam("acps.enabled", qAcpsEnabled); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorReasonArgumentsCode != nil {

		// query param acps.error.reason.arguments.code
		var qrAcpsErrorReasonArgumentsCode string

		if o.AcpsErrorReasonArgumentsCode != nil {
			qrAcpsErrorReasonArgumentsCode = *o.AcpsErrorReasonArgumentsCode
		}
		qAcpsErrorReasonArgumentsCode := qrAcpsErrorReasonArgumentsCode
		if qAcpsErrorReasonArgumentsCode != "" {

			if err := r.SetQueryParam("acps.error.reason.arguments.code", qAcpsErrorReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorReasonArgumentsMessage != nil {

		// query param acps.error.reason.arguments.message
		var qrAcpsErrorReasonArgumentsMessage string

		if o.AcpsErrorReasonArgumentsMessage != nil {
			qrAcpsErrorReasonArgumentsMessage = *o.AcpsErrorReasonArgumentsMessage
		}
		qAcpsErrorReasonArgumentsMessage := qrAcpsErrorReasonArgumentsMessage
		if qAcpsErrorReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("acps.error.reason.arguments.message", qAcpsErrorReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorReasonCode != nil {

		// query param acps.error.reason.code
		var qrAcpsErrorReasonCode string

		if o.AcpsErrorReasonCode != nil {
			qrAcpsErrorReasonCode = *o.AcpsErrorReasonCode
		}
		qAcpsErrorReasonCode := qrAcpsErrorReasonCode
		if qAcpsErrorReasonCode != "" {

			if err := r.SetQueryParam("acps.error.reason.code", qAcpsErrorReasonCode); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorReasonMessage != nil {

		// query param acps.error.reason.message
		var qrAcpsErrorReasonMessage string

		if o.AcpsErrorReasonMessage != nil {
			qrAcpsErrorReasonMessage = *o.AcpsErrorReasonMessage
		}
		qAcpsErrorReasonMessage := qrAcpsErrorReasonMessage
		if qAcpsErrorReasonMessage != "" {

			if err := r.SetQueryParam("acps.error.reason.message", qAcpsErrorReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorSeverity != nil {

		// query param acps.error.severity
		var qrAcpsErrorSeverity string

		if o.AcpsErrorSeverity != nil {
			qrAcpsErrorSeverity = *o.AcpsErrorSeverity
		}
		qAcpsErrorSeverity := qrAcpsErrorSeverity
		if qAcpsErrorSeverity != "" {

			if err := r.SetQueryParam("acps.error.severity", qAcpsErrorSeverity); err != nil {
				return err
			}
		}
	}

	if o.AcpsErrorType != nil {

		// query param acps.error.type
		var qrAcpsErrorType string

		if o.AcpsErrorType != nil {
			qrAcpsErrorType = *o.AcpsErrorType
		}
		qAcpsErrorType := qrAcpsErrorType
		if qAcpsErrorType != "" {

			if err := r.SetQueryParam("acps.error.type", qAcpsErrorType); err != nil {
				return err
			}
		}
	}

	if o.AcpsNetmask != nil {

		// query param acps.netmask
		var qrAcpsNetmask string

		if o.AcpsNetmask != nil {
			qrAcpsNetmask = *o.AcpsNetmask
		}
		qAcpsNetmask := qrAcpsNetmask
		if qAcpsNetmask != "" {

			if err := r.SetQueryParam("acps.netmask", qAcpsNetmask); err != nil {
				return err
			}
		}
	}

	if o.AcpsNodeName != nil {

		// query param acps.node.name
		var qrAcpsNodeName string

		if o.AcpsNodeName != nil {
			qrAcpsNodeName = *o.AcpsNodeName
		}
		qAcpsNodeName := qrAcpsNodeName
		if qAcpsNodeName != "" {

			if err := r.SetQueryParam("acps.node.name", qAcpsNodeName); err != nil {
				return err
			}
		}
	}

	if o.AcpsNodeUUID != nil {

		// query param acps.node.uuid
		var qrAcpsNodeUUID string

		if o.AcpsNodeUUID != nil {
			qrAcpsNodeUUID = *o.AcpsNodeUUID
		}
		qAcpsNodeUUID := qrAcpsNodeUUID
		if qAcpsNodeUUID != "" {

			if err := r.SetQueryParam("acps.node.uuid", qAcpsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.AcpsPort != nil {

		// query param acps.port
		var qrAcpsPort string

		if o.AcpsPort != nil {
			qrAcpsPort = *o.AcpsPort
		}
		qAcpsPort := qrAcpsPort
		if qAcpsPort != "" {

			if err := r.SetQueryParam("acps.port", qAcpsPort); err != nil {
				return err
			}
		}
	}

	if o.AcpsSubnet != nil {

		// query param acps.subnet
		var qrAcpsSubnet string

		if o.AcpsSubnet != nil {
			qrAcpsSubnet = *o.AcpsSubnet
		}
		qAcpsSubnet := qrAcpsSubnet
		if qAcpsSubnet != "" {

			if err := r.SetQueryParam("acps.subnet", qAcpsSubnet); err != nil {
				return err
			}
		}
	}

	if o.BaysDrawerID != nil {

		// query param bays.drawer.id
		var qrBaysDrawerID int64

		if o.BaysDrawerID != nil {
			qrBaysDrawerID = *o.BaysDrawerID
		}
		qBaysDrawerID := swag.FormatInt64(qrBaysDrawerID)
		if qBaysDrawerID != "" {

			if err := r.SetQueryParam("bays.drawer.id", qBaysDrawerID); err != nil {
				return err
			}
		}
	}

	if o.BaysDrawerSlot != nil {

		// query param bays.drawer.slot
		var qrBaysDrawerSlot int64

		if o.BaysDrawerSlot != nil {
			qrBaysDrawerSlot = *o.BaysDrawerSlot
		}
		qBaysDrawerSlot := swag.FormatInt64(qrBaysDrawerSlot)
		if qBaysDrawerSlot != "" {

			if err := r.SetQueryParam("bays.drawer.slot", qBaysDrawerSlot); err != nil {
				return err
			}
		}
	}

	if o.BaysHasDisk != nil {

		// query param bays.has_disk
		var qrBaysHasDisk bool

		if o.BaysHasDisk != nil {
			qrBaysHasDisk = *o.BaysHasDisk
		}
		qBaysHasDisk := swag.FormatBool(qrBaysHasDisk)
		if qBaysHasDisk != "" {

			if err := r.SetQueryParam("bays.has_disk", qBaysHasDisk); err != nil {
				return err
			}
		}
	}

	if o.BaysID != nil {

		// query param bays.id
		var qrBaysID int64

		if o.BaysID != nil {
			qrBaysID = *o.BaysID
		}
		qBaysID := swag.FormatInt64(qrBaysID)
		if qBaysID != "" {

			if err := r.SetQueryParam("bays.id", qBaysID); err != nil {
				return err
			}
		}
	}

	if o.BaysState != nil {

		// query param bays.state
		var qrBaysState string

		if o.BaysState != nil {
			qrBaysState = *o.BaysState
		}
		qBaysState := qrBaysState
		if qBaysState != "" {

			if err := r.SetQueryParam("bays.state", qBaysState); err != nil {
				return err
			}
		}
	}

	if o.BaysType != nil {

		// query param bays.type
		var qrBaysType string

		if o.BaysType != nil {
			qrBaysType = *o.BaysType
		}
		qBaysType := qrBaysType
		if qBaysType != "" {

			if err := r.SetQueryParam("bays.type", qBaysType); err != nil {
				return err
			}
		}
	}

	if o.ConnectionType != nil {

		// query param connection_type
		var qrConnectionType string

		if o.ConnectionType != nil {
			qrConnectionType = *o.ConnectionType
		}
		qConnectionType := qrConnectionType
		if qConnectionType != "" {

			if err := r.SetQueryParam("connection_type", qConnectionType); err != nil {
				return err
			}
		}
	}

	if o.CurrentSensorsCurrent != nil {

		// query param current_sensors.current
		var qrCurrentSensorsCurrent int64

		if o.CurrentSensorsCurrent != nil {
			qrCurrentSensorsCurrent = *o.CurrentSensorsCurrent
		}
		qCurrentSensorsCurrent := swag.FormatInt64(qrCurrentSensorsCurrent)
		if qCurrentSensorsCurrent != "" {

			if err := r.SetQueryParam("current_sensors.current", qCurrentSensorsCurrent); err != nil {
				return err
			}
		}
	}

	if o.CurrentSensorsID != nil {

		// query param current_sensors.id
		var qrCurrentSensorsID int64

		if o.CurrentSensorsID != nil {
			qrCurrentSensorsID = *o.CurrentSensorsID
		}
		qCurrentSensorsID := swag.FormatInt64(qrCurrentSensorsID)
		if qCurrentSensorsID != "" {

			if err := r.SetQueryParam("current_sensors.id", qCurrentSensorsID); err != nil {
				return err
			}
		}
	}

	if o.CurrentSensorsInstalled != nil {

		// query param current_sensors.installed
		var qrCurrentSensorsInstalled bool

		if o.CurrentSensorsInstalled != nil {
			qrCurrentSensorsInstalled = *o.CurrentSensorsInstalled
		}
		qCurrentSensorsInstalled := swag.FormatBool(qrCurrentSensorsInstalled)
		if qCurrentSensorsInstalled != "" {

			if err := r.SetQueryParam("current_sensors.installed", qCurrentSensorsInstalled); err != nil {
				return err
			}
		}
	}

	if o.CurrentSensorsLocation != nil {

		// query param current_sensors.location
		var qrCurrentSensorsLocation string

		if o.CurrentSensorsLocation != nil {
			qrCurrentSensorsLocation = *o.CurrentSensorsLocation
		}
		qCurrentSensorsLocation := qrCurrentSensorsLocation
		if qCurrentSensorsLocation != "" {

			if err := r.SetQueryParam("current_sensors.location", qCurrentSensorsLocation); err != nil {
				return err
			}
		}
	}

	if o.CurrentSensorsState != nil {

		// query param current_sensors.state
		var qrCurrentSensorsState string

		if o.CurrentSensorsState != nil {
			qrCurrentSensorsState = *o.CurrentSensorsState
		}
		qCurrentSensorsState := qrCurrentSensorsState
		if qCurrentSensorsState != "" {

			if err := r.SetQueryParam("current_sensors.state", qCurrentSensorsState); err != nil {
				return err
			}
		}
	}

	if o.DiskCount != nil {

		// query param disk_count
		var qrDiskCount int64

		if o.DiskCount != nil {
			qrDiskCount = *o.DiskCount
		}
		qDiskCount := swag.FormatInt64(qrDiskCount)
		if qDiskCount != "" {

			if err := r.SetQueryParam("disk_count", qDiskCount); err != nil {
				return err
			}
		}
	}

	if o.DrawersClosed != nil {

		// query param drawers.closed
		var qrDrawersClosed bool

		if o.DrawersClosed != nil {
			qrDrawersClosed = *o.DrawersClosed
		}
		qDrawersClosed := swag.FormatBool(qrDrawersClosed)
		if qDrawersClosed != "" {

			if err := r.SetQueryParam("drawers.closed", qDrawersClosed); err != nil {
				return err
			}
		}
	}

	if o.DrawersDiskCount != nil {

		// query param drawers.disk_count
		var qrDrawersDiskCount int64

		if o.DrawersDiskCount != nil {
			qrDrawersDiskCount = *o.DrawersDiskCount
		}
		qDrawersDiskCount := swag.FormatInt64(qrDrawersDiskCount)
		if qDrawersDiskCount != "" {

			if err := r.SetQueryParam("drawers.disk_count", qDrawersDiskCount); err != nil {
				return err
			}
		}
	}

	if o.DrawersError != nil {

		// query param drawers.error
		var qrDrawersError string

		if o.DrawersError != nil {
			qrDrawersError = *o.DrawersError
		}
		qDrawersError := qrDrawersError
		if qDrawersError != "" {

			if err := r.SetQueryParam("drawers.error", qDrawersError); err != nil {
				return err
			}
		}
	}

	if o.DrawersID != nil {

		// query param drawers.id
		var qrDrawersID int64

		if o.DrawersID != nil {
			qrDrawersID = *o.DrawersID
		}
		qDrawersID := swag.FormatInt64(qrDrawersID)
		if qDrawersID != "" {

			if err := r.SetQueryParam("drawers.id", qDrawersID); err != nil {
				return err
			}
		}
	}

	if o.DrawersPartNumber != nil {

		// query param drawers.part_number
		var qrDrawersPartNumber string

		if o.DrawersPartNumber != nil {
			qrDrawersPartNumber = *o.DrawersPartNumber
		}
		qDrawersPartNumber := qrDrawersPartNumber
		if qDrawersPartNumber != "" {

			if err := r.SetQueryParam("drawers.part_number", qDrawersPartNumber); err != nil {
				return err
			}
		}
	}

	if o.DrawersSerialNumber != nil {

		// query param drawers.serial_number
		var qrDrawersSerialNumber string

		if o.DrawersSerialNumber != nil {
			qrDrawersSerialNumber = *o.DrawersSerialNumber
		}
		qDrawersSerialNumber := qrDrawersSerialNumber
		if qDrawersSerialNumber != "" {

			if err := r.SetQueryParam("drawers.serial_number", qDrawersSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.DrawersState != nil {

		// query param drawers.state
		var qrDrawersState string

		if o.DrawersState != nil {
			qrDrawersState = *o.DrawersState
		}
		qDrawersState := qrDrawersState
		if qDrawersState != "" {

			if err := r.SetQueryParam("drawers.state", qDrawersState); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonArgumentsCode != nil {

		// query param errors.reason.arguments.code
		var qrErrorsReasonArgumentsCode string

		if o.ErrorsReasonArgumentsCode != nil {
			qrErrorsReasonArgumentsCode = *o.ErrorsReasonArgumentsCode
		}
		qErrorsReasonArgumentsCode := qrErrorsReasonArgumentsCode
		if qErrorsReasonArgumentsCode != "" {

			if err := r.SetQueryParam("errors.reason.arguments.code", qErrorsReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonArgumentsMessage != nil {

		// query param errors.reason.arguments.message
		var qrErrorsReasonArgumentsMessage string

		if o.ErrorsReasonArgumentsMessage != nil {
			qrErrorsReasonArgumentsMessage = *o.ErrorsReasonArgumentsMessage
		}
		qErrorsReasonArgumentsMessage := qrErrorsReasonArgumentsMessage
		if qErrorsReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("errors.reason.arguments.message", qErrorsReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonCode != nil {

		// query param errors.reason.code
		var qrErrorsReasonCode string

		if o.ErrorsReasonCode != nil {
			qrErrorsReasonCode = *o.ErrorsReasonCode
		}
		qErrorsReasonCode := qrErrorsReasonCode
		if qErrorsReasonCode != "" {

			if err := r.SetQueryParam("errors.reason.code", qErrorsReasonCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonMessage != nil {

		// query param errors.reason.message
		var qrErrorsReasonMessage string

		if o.ErrorsReasonMessage != nil {
			qrErrorsReasonMessage = *o.ErrorsReasonMessage
		}
		qErrorsReasonMessage := qrErrorsReasonMessage
		if qErrorsReasonMessage != "" {

			if err := r.SetQueryParam("errors.reason.message", qErrorsReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.FansID != nil {

		// query param fans.id
		var qrFansID int64

		if o.FansID != nil {
			qrFansID = *o.FansID
		}
		qFansID := swag.FormatInt64(qrFansID)
		if qFansID != "" {

			if err := r.SetQueryParam("fans.id", qFansID); err != nil {
				return err
			}
		}
	}

	if o.FansInstalled != nil {

		// query param fans.installed
		var qrFansInstalled bool

		if o.FansInstalled != nil {
			qrFansInstalled = *o.FansInstalled
		}
		qFansInstalled := swag.FormatBool(qrFansInstalled)
		if qFansInstalled != "" {

			if err := r.SetQueryParam("fans.installed", qFansInstalled); err != nil {
				return err
			}
		}
	}

	if o.FansLocation != nil {

		// query param fans.location
		var qrFansLocation string

		if o.FansLocation != nil {
			qrFansLocation = *o.FansLocation
		}
		qFansLocation := qrFansLocation
		if qFansLocation != "" {

			if err := r.SetQueryParam("fans.location", qFansLocation); err != nil {
				return err
			}
		}
	}

	if o.FansRpm != nil {

		// query param fans.rpm
		var qrFansRpm int64

		if o.FansRpm != nil {
			qrFansRpm = *o.FansRpm
		}
		qFansRpm := swag.FormatInt64(qrFansRpm)
		if qFansRpm != "" {

			if err := r.SetQueryParam("fans.rpm", qFansRpm); err != nil {
				return err
			}
		}
	}

	if o.FansState != nil {

		// query param fans.state
		var qrFansState string

		if o.FansState != nil {
			qrFansState = *o.FansState
		}
		qFansState := qrFansState
		if qFansState != "" {

			if err := r.SetQueryParam("fans.state", qFansState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FrusFirmwareVersion != nil {

		// query param frus.firmware_version
		var qrFrusFirmwareVersion string

		if o.FrusFirmwareVersion != nil {
			qrFrusFirmwareVersion = *o.FrusFirmwareVersion
		}
		qFrusFirmwareVersion := qrFrusFirmwareVersion
		if qFrusFirmwareVersion != "" {

			if err := r.SetQueryParam("frus.firmware_version", qFrusFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.FrusID != nil {

		// query param frus.id
		var qrFrusID int64

		if o.FrusID != nil {
			qrFrusID = *o.FrusID
		}
		qFrusID := swag.FormatInt64(qrFrusID)
		if qFrusID != "" {

			if err := r.SetQueryParam("frus.id", qFrusID); err != nil {
				return err
			}
		}
	}

	if o.FrusInstalled != nil {

		// query param frus.installed
		var qrFrusInstalled bool

		if o.FrusInstalled != nil {
			qrFrusInstalled = *o.FrusInstalled
		}
		qFrusInstalled := swag.FormatBool(qrFrusInstalled)
		if qFrusInstalled != "" {

			if err := r.SetQueryParam("frus.installed", qFrusInstalled); err != nil {
				return err
			}
		}
	}

	if o.FrusPartNumber != nil {

		// query param frus.part_number
		var qrFrusPartNumber string

		if o.FrusPartNumber != nil {
			qrFrusPartNumber = *o.FrusPartNumber
		}
		qFrusPartNumber := qrFrusPartNumber
		if qFrusPartNumber != "" {

			if err := r.SetQueryParam("frus.part_number", qFrusPartNumber); err != nil {
				return err
			}
		}
	}

	if o.FrusPsuCrestFactor != nil {

		// query param frus.psu.crest_factor
		var qrFrusPsuCrestFactor int64

		if o.FrusPsuCrestFactor != nil {
			qrFrusPsuCrestFactor = *o.FrusPsuCrestFactor
		}
		qFrusPsuCrestFactor := swag.FormatInt64(qrFrusPsuCrestFactor)
		if qFrusPsuCrestFactor != "" {

			if err := r.SetQueryParam("frus.psu.crest_factor", qFrusPsuCrestFactor); err != nil {
				return err
			}
		}
	}

	if o.FrusPsuModel != nil {

		// query param frus.psu.model
		var qrFrusPsuModel string

		if o.FrusPsuModel != nil {
			qrFrusPsuModel = *o.FrusPsuModel
		}
		qFrusPsuModel := qrFrusPsuModel
		if qFrusPsuModel != "" {

			if err := r.SetQueryParam("frus.psu.model", qFrusPsuModel); err != nil {
				return err
			}
		}
	}

	if o.FrusPsuPowerDrawn != nil {

		// query param frus.psu.power_drawn
		var qrFrusPsuPowerDrawn int64

		if o.FrusPsuPowerDrawn != nil {
			qrFrusPsuPowerDrawn = *o.FrusPsuPowerDrawn
		}
		qFrusPsuPowerDrawn := swag.FormatInt64(qrFrusPsuPowerDrawn)
		if qFrusPsuPowerDrawn != "" {

			if err := r.SetQueryParam("frus.psu.power_drawn", qFrusPsuPowerDrawn); err != nil {
				return err
			}
		}
	}

	if o.FrusPsuPowerRating != nil {

		// query param frus.psu.power_rating
		var qrFrusPsuPowerRating int64

		if o.FrusPsuPowerRating != nil {
			qrFrusPsuPowerRating = *o.FrusPsuPowerRating
		}
		qFrusPsuPowerRating := swag.FormatInt64(qrFrusPsuPowerRating)
		if qFrusPsuPowerRating != "" {

			if err := r.SetQueryParam("frus.psu.power_rating", qFrusPsuPowerRating); err != nil {
				return err
			}
		}
	}

	if o.FrusSerialNumber != nil {

		// query param frus.serial_number
		var qrFrusSerialNumber string

		if o.FrusSerialNumber != nil {
			qrFrusSerialNumber = *o.FrusSerialNumber
		}
		qFrusSerialNumber := qrFrusSerialNumber
		if qFrusSerialNumber != "" {

			if err := r.SetQueryParam("frus.serial_number", qFrusSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.FrusState != nil {

		// query param frus.state
		var qrFrusState string

		if o.FrusState != nil {
			qrFrusState = *o.FrusState
		}
		qFrusState := qrFrusState
		if qFrusState != "" {

			if err := r.SetQueryParam("frus.state", qFrusState); err != nil {
				return err
			}
		}
	}

	if o.FrusType != nil {

		// query param frus.type
		var qrFrusType string

		if o.FrusType != nil {
			qrFrusType = *o.FrusType
		}
		qFrusType := qrFrusType
		if qFrusType != "" {

			if err := r.SetQueryParam("frus.type", qFrusType); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.Internal != nil {

		// query param internal
		var qrInternal bool

		if o.Internal != nil {
			qrInternal = *o.Internal
		}
		qInternal := swag.FormatBool(qrInternal)
		if qInternal != "" {

			if err := r.SetQueryParam("internal", qInternal); err != nil {
				return err
			}
		}
	}

	if o.Local != nil {

		// query param local
		var qrLocal bool

		if o.Local != nil {
			qrLocal = *o.Local
		}
		qLocal := swag.FormatBool(qrLocal)
		if qLocal != "" {

			if err := r.SetQueryParam("local", qLocal); err != nil {
				return err
			}
		}
	}

	if o.LocationLed != nil {

		// query param location_led
		var qrLocationLed string

		if o.LocationLed != nil {
			qrLocationLed = *o.LocationLed
		}
		qLocationLed := qrLocationLed
		if qLocationLed != "" {

			if err := r.SetQueryParam("location_led", qLocationLed); err != nil {
				return err
			}
		}
	}

	if o.ManufacturerName != nil {

		// query param manufacturer.name
		var qrManufacturerName string

		if o.ManufacturerName != nil {
			qrManufacturerName = *o.ManufacturerName
		}
		qManufacturerName := qrManufacturerName
		if qManufacturerName != "" {

			if err := r.SetQueryParam("manufacturer.name", qManufacturerName); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.ModuleType != nil {

		// query param module_type
		var qrModuleType string

		if o.ModuleType != nil {
			qrModuleType = *o.ModuleType
		}
		qModuleType := qrModuleType
		if qModuleType != "" {

			if err := r.SetQueryParam("module_type", qModuleType); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PathsName != nil {

		// query param paths.name
		var qrPathsName string

		if o.PathsName != nil {
			qrPathsName = *o.PathsName
		}
		qPathsName := qrPathsName
		if qPathsName != "" {

			if err := r.SetQueryParam("paths.name", qPathsName); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeName != nil {

		// query param paths.node.name
		var qrPathsNodeName string

		if o.PathsNodeName != nil {
			qrPathsNodeName = *o.PathsNodeName
		}
		qPathsNodeName := qrPathsNodeName
		if qPathsNodeName != "" {

			if err := r.SetQueryParam("paths.node.name", qPathsNodeName); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeUUID != nil {

		// query param paths.node.uuid
		var qrPathsNodeUUID string

		if o.PathsNodeUUID != nil {
			qrPathsNodeUUID = *o.PathsNodeUUID
		}
		qPathsNodeUUID := qrPathsNodeUUID
		if qPathsNodeUUID != "" {

			if err := r.SetQueryParam("paths.node.uuid", qPathsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PortsCableIdentifier != nil {

		// query param ports.cable.identifier
		var qrPortsCableIdentifier string

		if o.PortsCableIdentifier != nil {
			qrPortsCableIdentifier = *o.PortsCableIdentifier
		}
		qPortsCableIdentifier := qrPortsCableIdentifier
		if qPortsCableIdentifier != "" {

			if err := r.SetQueryParam("ports.cable.identifier", qPortsCableIdentifier); err != nil {
				return err
			}
		}
	}

	if o.PortsCableLength != nil {

		// query param ports.cable.length
		var qrPortsCableLength string

		if o.PortsCableLength != nil {
			qrPortsCableLength = *o.PortsCableLength
		}
		qPortsCableLength := qrPortsCableLength
		if qPortsCableLength != "" {

			if err := r.SetQueryParam("ports.cable.length", qPortsCableLength); err != nil {
				return err
			}
		}
	}

	if o.PortsCablePartNumber != nil {

		// query param ports.cable.part_number
		var qrPortsCablePartNumber string

		if o.PortsCablePartNumber != nil {
			qrPortsCablePartNumber = *o.PortsCablePartNumber
		}
		qPortsCablePartNumber := qrPortsCablePartNumber
		if qPortsCablePartNumber != "" {

			if err := r.SetQueryParam("ports.cable.part_number", qPortsCablePartNumber); err != nil {
				return err
			}
		}
	}

	if o.PortsCableSerialNumber != nil {

		// query param ports.cable.serial_number
		var qrPortsCableSerialNumber string

		if o.PortsCableSerialNumber != nil {
			qrPortsCableSerialNumber = *o.PortsCableSerialNumber
		}
		qPortsCableSerialNumber := qrPortsCableSerialNumber
		if qPortsCableSerialNumber != "" {

			if err := r.SetQueryParam("ports.cable.serial_number", qPortsCableSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.PortsDesignator != nil {

		// query param ports.designator
		var qrPortsDesignator string

		if o.PortsDesignator != nil {
			qrPortsDesignator = *o.PortsDesignator
		}
		qPortsDesignator := qrPortsDesignator
		if qPortsDesignator != "" {

			if err := r.SetQueryParam("ports.designator", qPortsDesignator); err != nil {
				return err
			}
		}
	}

	if o.PortsID != nil {

		// query param ports.id
		var qrPortsID int64

		if o.PortsID != nil {
			qrPortsID = *o.PortsID
		}
		qPortsID := swag.FormatInt64(qrPortsID)
		if qPortsID != "" {

			if err := r.SetQueryParam("ports.id", qPortsID); err != nil {
				return err
			}
		}
	}

	if o.PortsInternal != nil {

		// query param ports.internal
		var qrPortsInternal bool

		if o.PortsInternal != nil {
			qrPortsInternal = *o.PortsInternal
		}
		qPortsInternal := swag.FormatBool(qrPortsInternal)
		if qPortsInternal != "" {

			if err := r.SetQueryParam("ports.internal", qPortsInternal); err != nil {
				return err
			}
		}
	}

	if o.PortsMacAddress != nil {

		// query param ports.mac_address
		var qrPortsMacAddress string

		if o.PortsMacAddress != nil {
			qrPortsMacAddress = *o.PortsMacAddress
		}
		qPortsMacAddress := qrPortsMacAddress
		if qPortsMacAddress != "" {

			if err := r.SetQueryParam("ports.mac_address", qPortsMacAddress); err != nil {
				return err
			}
		}
	}

	if o.PortsModuleID != nil {

		// query param ports.module_id
		var qrPortsModuleID string

		if o.PortsModuleID != nil {
			qrPortsModuleID = *o.PortsModuleID
		}
		qPortsModuleID := qrPortsModuleID
		if qPortsModuleID != "" {

			if err := r.SetQueryParam("ports.module_id", qPortsModuleID); err != nil {
				return err
			}
		}
	}

	if o.PortsRemoteChassis != nil {

		// query param ports.remote.chassis
		var qrPortsRemoteChassis string

		if o.PortsRemoteChassis != nil {
			qrPortsRemoteChassis = *o.PortsRemoteChassis
		}
		qPortsRemoteChassis := qrPortsRemoteChassis
		if qPortsRemoteChassis != "" {

			if err := r.SetQueryParam("ports.remote.chassis", qPortsRemoteChassis); err != nil {
				return err
			}
		}
	}

	if o.PortsRemoteDevice != nil {

		// query param ports.remote.device
		var qrPortsRemoteDevice string

		if o.PortsRemoteDevice != nil {
			qrPortsRemoteDevice = *o.PortsRemoteDevice
		}
		qPortsRemoteDevice := qrPortsRemoteDevice
		if qPortsRemoteDevice != "" {

			if err := r.SetQueryParam("ports.remote.device", qPortsRemoteDevice); err != nil {
				return err
			}
		}
	}

	if o.PortsRemoteMacAddress != nil {

		// query param ports.remote.mac_address
		var qrPortsRemoteMacAddress string

		if o.PortsRemoteMacAddress != nil {
			qrPortsRemoteMacAddress = *o.PortsRemoteMacAddress
		}
		qPortsRemoteMacAddress := qrPortsRemoteMacAddress
		if qPortsRemoteMacAddress != "" {

			if err := r.SetQueryParam("ports.remote.mac_address", qPortsRemoteMacAddress); err != nil {
				return err
			}
		}
	}

	if o.PortsRemotePhy != nil {

		// query param ports.remote.phy
		var qrPortsRemotePhy string

		if o.PortsRemotePhy != nil {
			qrPortsRemotePhy = *o.PortsRemotePhy
		}
		qPortsRemotePhy := qrPortsRemotePhy
		if qPortsRemotePhy != "" {

			if err := r.SetQueryParam("ports.remote.phy", qPortsRemotePhy); err != nil {
				return err
			}
		}
	}

	if o.PortsRemotePort != nil {

		// query param ports.remote.port
		var qrPortsRemotePort string

		if o.PortsRemotePort != nil {
			qrPortsRemotePort = *o.PortsRemotePort
		}
		qPortsRemotePort := qrPortsRemotePort
		if qPortsRemotePort != "" {

			if err := r.SetQueryParam("ports.remote.port", qPortsRemotePort); err != nil {
				return err
			}
		}
	}

	if o.PortsRemoteWwn != nil {

		// query param ports.remote.wwn
		var qrPortsRemoteWwn string

		if o.PortsRemoteWwn != nil {
			qrPortsRemoteWwn = *o.PortsRemoteWwn
		}
		qPortsRemoteWwn := qrPortsRemoteWwn
		if qPortsRemoteWwn != "" {

			if err := r.SetQueryParam("ports.remote.wwn", qPortsRemoteWwn); err != nil {
				return err
			}
		}
	}

	if o.PortsSpeed != nil {

		// query param ports.speed
		var qrPortsSpeed int64

		if o.PortsSpeed != nil {
			qrPortsSpeed = *o.PortsSpeed
		}
		qPortsSpeed := swag.FormatInt64(qrPortsSpeed)
		if qPortsSpeed != "" {

			if err := r.SetQueryParam("ports.speed", qPortsSpeed); err != nil {
				return err
			}
		}
	}

	if o.PortsState != nil {

		// query param ports.state
		var qrPortsState string

		if o.PortsState != nil {
			qrPortsState = *o.PortsState
		}
		qPortsState := qrPortsState
		if qPortsState != "" {

			if err := r.SetQueryParam("ports.state", qPortsState); err != nil {
				return err
			}
		}
	}

	if o.PortsWwn != nil {

		// query param ports.wwn
		var qrPortsWwn string

		if o.PortsWwn != nil {
			qrPortsWwn = *o.PortsWwn
		}
		qPortsWwn := qrPortsWwn
		if qPortsWwn != "" {

			if err := r.SetQueryParam("ports.wwn", qPortsWwn); err != nil {
				return err
			}
		}
	}

	if o.RawCapacity != nil {

		// query param raw_capacity
		var qrRawCapacity int64

		if o.RawCapacity != nil {
			qrRawCapacity = *o.RawCapacity
		}
		qRawCapacity := swag.FormatInt64(qrRawCapacity)
		if qRawCapacity != "" {

			if err := r.SetQueryParam("raw_capacity", qRawCapacity); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsAmbient != nil {

		// query param temperature_sensors.ambient
		var qrTemperatureSensorsAmbient bool

		if o.TemperatureSensorsAmbient != nil {
			qrTemperatureSensorsAmbient = *o.TemperatureSensorsAmbient
		}
		qTemperatureSensorsAmbient := swag.FormatBool(qrTemperatureSensorsAmbient)
		if qTemperatureSensorsAmbient != "" {

			if err := r.SetQueryParam("temperature_sensors.ambient", qTemperatureSensorsAmbient); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsID != nil {

		// query param temperature_sensors.id
		var qrTemperatureSensorsID int64

		if o.TemperatureSensorsID != nil {
			qrTemperatureSensorsID = *o.TemperatureSensorsID
		}
		qTemperatureSensorsID := swag.FormatInt64(qrTemperatureSensorsID)
		if qTemperatureSensorsID != "" {

			if err := r.SetQueryParam("temperature_sensors.id", qTemperatureSensorsID); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsInstalled != nil {

		// query param temperature_sensors.installed
		var qrTemperatureSensorsInstalled bool

		if o.TemperatureSensorsInstalled != nil {
			qrTemperatureSensorsInstalled = *o.TemperatureSensorsInstalled
		}
		qTemperatureSensorsInstalled := swag.FormatBool(qrTemperatureSensorsInstalled)
		if qTemperatureSensorsInstalled != "" {

			if err := r.SetQueryParam("temperature_sensors.installed", qTemperatureSensorsInstalled); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsLocation != nil {

		// query param temperature_sensors.location
		var qrTemperatureSensorsLocation string

		if o.TemperatureSensorsLocation != nil {
			qrTemperatureSensorsLocation = *o.TemperatureSensorsLocation
		}
		qTemperatureSensorsLocation := qrTemperatureSensorsLocation
		if qTemperatureSensorsLocation != "" {

			if err := r.SetQueryParam("temperature_sensors.location", qTemperatureSensorsLocation); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsState != nil {

		// query param temperature_sensors.state
		var qrTemperatureSensorsState string

		if o.TemperatureSensorsState != nil {
			qrTemperatureSensorsState = *o.TemperatureSensorsState
		}
		qTemperatureSensorsState := qrTemperatureSensorsState
		if qTemperatureSensorsState != "" {

			if err := r.SetQueryParam("temperature_sensors.state", qTemperatureSensorsState); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsTemperature != nil {

		// query param temperature_sensors.temperature
		var qrTemperatureSensorsTemperature int64

		if o.TemperatureSensorsTemperature != nil {
			qrTemperatureSensorsTemperature = *o.TemperatureSensorsTemperature
		}
		qTemperatureSensorsTemperature := swag.FormatInt64(qrTemperatureSensorsTemperature)
		if qTemperatureSensorsTemperature != "" {

			if err := r.SetQueryParam("temperature_sensors.temperature", qTemperatureSensorsTemperature); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsThresholdHighCritical != nil {

		// query param temperature_sensors.threshold.high.critical
		var qrTemperatureSensorsThresholdHighCritical int64

		if o.TemperatureSensorsThresholdHighCritical != nil {
			qrTemperatureSensorsThresholdHighCritical = *o.TemperatureSensorsThresholdHighCritical
		}
		qTemperatureSensorsThresholdHighCritical := swag.FormatInt64(qrTemperatureSensorsThresholdHighCritical)
		if qTemperatureSensorsThresholdHighCritical != "" {

			if err := r.SetQueryParam("temperature_sensors.threshold.high.critical", qTemperatureSensorsThresholdHighCritical); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsThresholdHighWarning != nil {

		// query param temperature_sensors.threshold.high.warning
		var qrTemperatureSensorsThresholdHighWarning int64

		if o.TemperatureSensorsThresholdHighWarning != nil {
			qrTemperatureSensorsThresholdHighWarning = *o.TemperatureSensorsThresholdHighWarning
		}
		qTemperatureSensorsThresholdHighWarning := swag.FormatInt64(qrTemperatureSensorsThresholdHighWarning)
		if qTemperatureSensorsThresholdHighWarning != "" {

			if err := r.SetQueryParam("temperature_sensors.threshold.high.warning", qTemperatureSensorsThresholdHighWarning); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsThresholdLowCritical != nil {

		// query param temperature_sensors.threshold.low.critical
		var qrTemperatureSensorsThresholdLowCritical int64

		if o.TemperatureSensorsThresholdLowCritical != nil {
			qrTemperatureSensorsThresholdLowCritical = *o.TemperatureSensorsThresholdLowCritical
		}
		qTemperatureSensorsThresholdLowCritical := swag.FormatInt64(qrTemperatureSensorsThresholdLowCritical)
		if qTemperatureSensorsThresholdLowCritical != "" {

			if err := r.SetQueryParam("temperature_sensors.threshold.low.critical", qTemperatureSensorsThresholdLowCritical); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorsThresholdLowWarning != nil {

		// query param temperature_sensors.threshold.low.warning
		var qrTemperatureSensorsThresholdLowWarning int64

		if o.TemperatureSensorsThresholdLowWarning != nil {
			qrTemperatureSensorsThresholdLowWarning = *o.TemperatureSensorsThresholdLowWarning
		}
		qTemperatureSensorsThresholdLowWarning := swag.FormatInt64(qrTemperatureSensorsThresholdLowWarning)
		if qTemperatureSensorsThresholdLowWarning != "" {

			if err := r.SetQueryParam("temperature_sensors.threshold.low.warning", qTemperatureSensorsThresholdLowWarning); err != nil {
				return err
			}
		}
	}

	if o.UID != nil {

		// query param uid
		var qrUID string

		if o.UID != nil {
			qrUID = *o.UID
		}
		qUID := qrUID
		if qUID != "" {

			if err := r.SetQueryParam("uid", qUID); err != nil {
				return err
			}
		}
	}

	if o.VendorManufacturer != nil {

		// query param vendor.manufacturer
		var qrVendorManufacturer string

		if o.VendorManufacturer != nil {
			qrVendorManufacturer = *o.VendorManufacturer
		}
		qVendorManufacturer := qrVendorManufacturer
		if qVendorManufacturer != "" {

			if err := r.SetQueryParam("vendor.manufacturer", qVendorManufacturer); err != nil {
				return err
			}
		}
	}

	if o.VendorName != nil {

		// query param vendor.name
		var qrVendorName string

		if o.VendorName != nil {
			qrVendorName = *o.VendorName
		}
		qVendorName := qrVendorName
		if qVendorName != "" {

			if err := r.SetQueryParam("vendor.name", qVendorName); err != nil {
				return err
			}
		}
	}

	if o.VendorPartNumber != nil {

		// query param vendor.part_number
		var qrVendorPartNumber string

		if o.VendorPartNumber != nil {
			qrVendorPartNumber = *o.VendorPartNumber
		}
		qVendorPartNumber := qrVendorPartNumber
		if qVendorPartNumber != "" {

			if err := r.SetQueryParam("vendor.part_number", qVendorPartNumber); err != nil {
				return err
			}
		}
	}

	if o.VendorProduct != nil {

		// query param vendor.product
		var qrVendorProduct string

		if o.VendorProduct != nil {
			qrVendorProduct = *o.VendorProduct
		}
		qVendorProduct := qrVendorProduct
		if qVendorProduct != "" {

			if err := r.SetQueryParam("vendor.product", qVendorProduct); err != nil {
				return err
			}
		}
	}

	if o.VendorSerialNumber != nil {

		// query param vendor.serial_number
		var qrVendorSerialNumber string

		if o.VendorSerialNumber != nil {
			qrVendorSerialNumber = *o.VendorSerialNumber
		}
		qVendorSerialNumber := qrVendorSerialNumber
		if qVendorSerialNumber != "" {

			if err := r.SetQueryParam("vendor.serial_number", qVendorSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.VoltageSensorsID != nil {

		// query param voltage_sensors.id
		var qrVoltageSensorsID int64

		if o.VoltageSensorsID != nil {
			qrVoltageSensorsID = *o.VoltageSensorsID
		}
		qVoltageSensorsID := swag.FormatInt64(qrVoltageSensorsID)
		if qVoltageSensorsID != "" {

			if err := r.SetQueryParam("voltage_sensors.id", qVoltageSensorsID); err != nil {
				return err
			}
		}
	}

	if o.VoltageSensorsInstalled != nil {

		// query param voltage_sensors.installed
		var qrVoltageSensorsInstalled bool

		if o.VoltageSensorsInstalled != nil {
			qrVoltageSensorsInstalled = *o.VoltageSensorsInstalled
		}
		qVoltageSensorsInstalled := swag.FormatBool(qrVoltageSensorsInstalled)
		if qVoltageSensorsInstalled != "" {

			if err := r.SetQueryParam("voltage_sensors.installed", qVoltageSensorsInstalled); err != nil {
				return err
			}
		}
	}

	if o.VoltageSensorsLocation != nil {

		// query param voltage_sensors.location
		var qrVoltageSensorsLocation string

		if o.VoltageSensorsLocation != nil {
			qrVoltageSensorsLocation = *o.VoltageSensorsLocation
		}
		qVoltageSensorsLocation := qrVoltageSensorsLocation
		if qVoltageSensorsLocation != "" {

			if err := r.SetQueryParam("voltage_sensors.location", qVoltageSensorsLocation); err != nil {
				return err
			}
		}
	}

	if o.VoltageSensorsState != nil {

		// query param voltage_sensors.state
		var qrVoltageSensorsState string

		if o.VoltageSensorsState != nil {
			qrVoltageSensorsState = *o.VoltageSensorsState
		}
		qVoltageSensorsState := qrVoltageSensorsState
		if qVoltageSensorsState != "" {

			if err := r.SetQueryParam("voltage_sensors.state", qVoltageSensorsState); err != nil {
				return err
			}
		}
	}

	if o.VoltageSensorsVoltage != nil {

		// query param voltage_sensors.voltage
		var qrVoltageSensorsVoltage float64

		if o.VoltageSensorsVoltage != nil {
			qrVoltageSensorsVoltage = *o.VoltageSensorsVoltage
		}
		qVoltageSensorsVoltage := swag.FormatFloat64(qrVoltageSensorsVoltage)
		if qVoltageSensorsVoltage != "" {

			if err := r.SetQueryParam("voltage_sensors.voltage", qVoltageSensorsVoltage); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamShelfCollectionGet binds the parameter fields
func (o *ShelfCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamShelfCollectionGet binds the parameter order_by
func (o *ShelfCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
