// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ShelfModifyCollectionReader is a Reader for the ShelfModifyCollection structure.
type ShelfModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ShelfModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewShelfModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewShelfModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewShelfModifyCollectionOK creates a ShelfModifyCollectionOK with default headers values
func NewShelfModifyCollectionOK() *ShelfModifyCollectionOK {
	return &ShelfModifyCollectionOK{}
}

/*
ShelfModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ShelfModifyCollectionOK struct {
}

// IsSuccess returns true when this shelf modify collection o k response has a 2xx status code
func (o *ShelfModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this shelf modify collection o k response has a 3xx status code
func (o *ShelfModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this shelf modify collection o k response has a 4xx status code
func (o *ShelfModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this shelf modify collection o k response has a 5xx status code
func (o *ShelfModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this shelf modify collection o k response a status code equal to that given
func (o *ShelfModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the shelf modify collection o k response
func (o *ShelfModifyCollectionOK) Code() int {
	return 200
}

func (o *ShelfModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/shelves][%d] shelfModifyCollectionOK", 200)
}

func (o *ShelfModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/shelves][%d] shelfModifyCollectionOK", 200)
}

func (o *ShelfModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewShelfModifyCollectionDefault creates a ShelfModifyCollectionDefault with default headers values
func NewShelfModifyCollectionDefault(code int) *ShelfModifyCollectionDefault {
	return &ShelfModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ShelfModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 17825872 | Shelf locate request failed because shelf \"<name>\" was not found. |
| 17825873 | Shelf locate request failed because shelf \"<name>\" does not support this command. |
| 17825874 | Shelf locate request failed for shelf \"<name>\" with an unknown error. |
| 17825875 | Shelf locate request failed for shelf \"<name>\" because shelf modules are unreachable. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ShelfModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this shelf modify collection default response has a 2xx status code
func (o *ShelfModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this shelf modify collection default response has a 3xx status code
func (o *ShelfModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this shelf modify collection default response has a 4xx status code
func (o *ShelfModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this shelf modify collection default response has a 5xx status code
func (o *ShelfModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this shelf modify collection default response a status code equal to that given
func (o *ShelfModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the shelf modify collection default response
func (o *ShelfModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ShelfModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/shelves][%d] shelf_modify_collection default %s", o._statusCode, payload)
}

func (o *ShelfModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/shelves][%d] shelf_modify_collection default %s", o._statusCode, payload)
}

func (o *ShelfModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ShelfModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ShelfModifyCollectionBody shelf modify collection body
swagger:model ShelfModifyCollectionBody
*/
type ShelfModifyCollectionBody struct {

	// connection type
	// Example: sas
	// Read Only: true
	// Enum: ["unknown","fc","sas","nvme"]
	ConnectionType *string `json:"connection_type,omitempty"`

	// disk count
	// Example: 12
	// Read Only: true
	DiskCount *int64 `json:"disk_count,omitempty"`

	// id
	// Example: 1
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// internal
	// Read Only: true
	Internal *bool `json:"internal,omitempty"`

	// local
	// Read Only: true
	Local *bool `json:"local,omitempty"`

	// location led
	// Example: off
	// Enum: ["off","on","unsupported"]
	LocationLed *string `json:"location_led,omitempty"`

	// manufacturer
	Manufacturer *models.ShelfInlineManufacturer `json:"manufacturer,omitempty"`

	// model
	// Example: DS2246
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// module type
	// Example: iom6
	// Read Only: true
	// Enum: ["unknown","iom6","iom6e","iom12","iom12b","iom12c","iom12e","iom12f","iom12g","nsm100","nsm8e","nsm16e","psm3e","nsm100b","nsm140"]
	ModuleType *string `json:"module_type,omitempty"`

	// name
	// Example: 1.1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Raw capacity of drives in shelf in 4k blocks
	// Example: 5157308772
	// Read Only: true
	RawCapacity *int64 `json:"raw_capacity,omitempty"`

	// serial number
	// Example: SHFMS1514000895
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// Alternate Control Paths to ACP processors/functions in shelf modules and expanders
	// Read Only: true
	ShelfInlineAcps []*models.ShelfInlineAcpsInlineArrayItem `json:"acps,omitempty"`

	// shelf inline bays
	ShelfInlineBays []*models.ShelfInlineBaysInlineArrayItem `json:"bays,omitempty"`

	// shelf inline current sensors
	// Read Only: true
	ShelfInlineCurrentSensors []*models.ShelfInlineCurrentSensorsInlineArrayItem `json:"current_sensors,omitempty"`

	// shelf inline drawers
	// Read Only: true
	ShelfInlineDrawers []*models.ShelfInlineDrawersInlineArrayItem `json:"drawers,omitempty"`

	// shelf inline errors
	ShelfInlineErrors []*models.ShelfInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// shelf inline fans
	// Read Only: true
	ShelfInlineFans []*models.ShelfInlineFansInlineArrayItem `json:"fans,omitempty"`

	// shelf inline frus
	// Read Only: true
	ShelfInlineFrus []*models.ShelfInlineFrusInlineArrayItem `json:"frus,omitempty"`

	// shelf inline paths
	// Read Only: true
	ShelfInlinePaths []*models.ShelfInlinePathsInlineArrayItem `json:"paths,omitempty"`

	// shelf inline ports
	ShelfInlinePorts []*models.ShelfInlinePortsInlineArrayItem `json:"ports,omitempty"`

	// shelf inline temperature sensors
	// Read Only: true
	ShelfInlineTemperatureSensors []*models.ShelfInlineTemperatureSensorsInlineArrayItem `json:"temperature_sensors,omitempty"`

	// shelf inline voltage sensors
	// Read Only: true
	ShelfInlineVoltageSensors []*models.ShelfInlineVoltageSensorsInlineArrayItem `json:"voltage_sensors,omitempty"`

	// shelf response inline records
	ShelfResponseInlineRecords []*models.Shelf `json:"records,omitempty"`

	// state
	// Example: ok
	// Read Only: true
	// Enum: ["unknown","ok","error"]
	State *string `json:"state,omitempty"`

	// uid
	// Example: 7777841915827391056
	// Read Only: true
	UID *string `json:"uid,omitempty"`

	// vendor
	Vendor *models.ShelfInlineVendor `json:"vendor,omitempty"`
}

// Validate validates this shelf modify collection body
func (o *ShelfModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConnectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocationLed(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateManufacturer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateModuleType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineAcps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineBays(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineCurrentSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineDrawers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineFans(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlinePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlinePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineTemperatureSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfInlineVoltageSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShelfResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfModifyCollectionBodyTypeConnectionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","fc","sas","nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfModifyCollectionBodyTypeConnectionTypePropEnum = append(shelfModifyCollectionBodyTypeConnectionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// connection_type
	// ConnectionType
	// unknown
	// END DEBUGGING
	// ShelfModifyCollectionBodyConnectionTypeUnknown captures enum value "unknown"
	ShelfModifyCollectionBodyConnectionTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// connection_type
	// ConnectionType
	// fc
	// END DEBUGGING
	// ShelfModifyCollectionBodyConnectionTypeFc captures enum value "fc"
	ShelfModifyCollectionBodyConnectionTypeFc string = "fc"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// connection_type
	// ConnectionType
	// sas
	// END DEBUGGING
	// ShelfModifyCollectionBodyConnectionTypeSas captures enum value "sas"
	ShelfModifyCollectionBodyConnectionTypeSas string = "sas"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// connection_type
	// ConnectionType
	// nvme
	// END DEBUGGING
	// ShelfModifyCollectionBodyConnectionTypeNvme captures enum value "nvme"
	ShelfModifyCollectionBodyConnectionTypeNvme string = "nvme"
)

// prop value enum
func (o *ShelfModifyCollectionBody) validateConnectionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfModifyCollectionBodyTypeConnectionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfModifyCollectionBody) validateConnectionType(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectionType) { // not required
		return nil
	}

	// value enum
	if err := o.validateConnectionTypeEnum("info"+"."+"connection_type", "body", *o.ConnectionType); err != nil {
		return err
	}

	return nil
}

var shelfModifyCollectionBodyTypeLocationLedPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","on","unsupported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfModifyCollectionBodyTypeLocationLedPropEnum = append(shelfModifyCollectionBodyTypeLocationLedPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// location_led
	// LocationLed
	// off
	// END DEBUGGING
	// ShelfModifyCollectionBodyLocationLedOff captures enum value "off"
	ShelfModifyCollectionBodyLocationLedOff string = "off"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// location_led
	// LocationLed
	// on
	// END DEBUGGING
	// ShelfModifyCollectionBodyLocationLedOn captures enum value "on"
	ShelfModifyCollectionBodyLocationLedOn string = "on"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// location_led
	// LocationLed
	// unsupported
	// END DEBUGGING
	// ShelfModifyCollectionBodyLocationLedUnsupported captures enum value "unsupported"
	ShelfModifyCollectionBodyLocationLedUnsupported string = "unsupported"
)

// prop value enum
func (o *ShelfModifyCollectionBody) validateLocationLedEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfModifyCollectionBodyTypeLocationLedPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfModifyCollectionBody) validateLocationLed(formats strfmt.Registry) error {
	if swag.IsZero(o.LocationLed) { // not required
		return nil
	}

	// value enum
	if err := o.validateLocationLedEnum("info"+"."+"location_led", "body", *o.LocationLed); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateManufacturer(formats strfmt.Registry) error {
	if swag.IsZero(o.Manufacturer) { // not required
		return nil
	}

	if o.Manufacturer != nil {
		if err := o.Manufacturer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "manufacturer")
			}
			return err
		}
	}

	return nil
}

var shelfModifyCollectionBodyTypeModuleTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","iom6","iom6e","iom12","iom12b","iom12c","iom12e","iom12f","iom12g","nsm100","nsm8e","nsm16e","psm3e","nsm100b","nsm140"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfModifyCollectionBodyTypeModuleTypePropEnum = append(shelfModifyCollectionBodyTypeModuleTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// unknown
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeUnknown captures enum value "unknown"
	ShelfModifyCollectionBodyModuleTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom6
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom6 captures enum value "iom6"
	ShelfModifyCollectionBodyModuleTypeIom6 string = "iom6"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom6e
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom6e captures enum value "iom6e"
	ShelfModifyCollectionBodyModuleTypeIom6e string = "iom6e"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12 captures enum value "iom12"
	ShelfModifyCollectionBodyModuleTypeIom12 string = "iom12"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12b
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12b captures enum value "iom12b"
	ShelfModifyCollectionBodyModuleTypeIom12b string = "iom12b"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12c
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12c captures enum value "iom12c"
	ShelfModifyCollectionBodyModuleTypeIom12c string = "iom12c"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12e
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12e captures enum value "iom12e"
	ShelfModifyCollectionBodyModuleTypeIom12e string = "iom12e"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12f
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12f captures enum value "iom12f"
	ShelfModifyCollectionBodyModuleTypeIom12f string = "iom12f"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// iom12g
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeIom12g captures enum value "iom12g"
	ShelfModifyCollectionBodyModuleTypeIom12g string = "iom12g"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// nsm100
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeNsm100 captures enum value "nsm100"
	ShelfModifyCollectionBodyModuleTypeNsm100 string = "nsm100"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// nsm8e
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeNsm8e captures enum value "nsm8e"
	ShelfModifyCollectionBodyModuleTypeNsm8e string = "nsm8e"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// nsm16e
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeNsm16e captures enum value "nsm16e"
	ShelfModifyCollectionBodyModuleTypeNsm16e string = "nsm16e"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// psm3e
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypePsm3e captures enum value "psm3e"
	ShelfModifyCollectionBodyModuleTypePsm3e string = "psm3e"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// nsm100b
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeNsm100b captures enum value "nsm100b"
	ShelfModifyCollectionBodyModuleTypeNsm100b string = "nsm100b"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// module_type
	// ModuleType
	// nsm140
	// END DEBUGGING
	// ShelfModifyCollectionBodyModuleTypeNsm140 captures enum value "nsm140"
	ShelfModifyCollectionBodyModuleTypeNsm140 string = "nsm140"
)

// prop value enum
func (o *ShelfModifyCollectionBody) validateModuleTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfModifyCollectionBodyTypeModuleTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfModifyCollectionBody) validateModuleType(formats strfmt.Registry) error {
	if swag.IsZero(o.ModuleType) { // not required
		return nil
	}

	// value enum
	if err := o.validateModuleTypeEnum("info"+"."+"module_type", "body", *o.ModuleType); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineAcps(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineAcps) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineAcps); i++ {
		if swag.IsZero(o.ShelfInlineAcps[i]) { // not required
			continue
		}

		if o.ShelfInlineAcps[i] != nil {
			if err := o.ShelfInlineAcps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineBays(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineBays) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineBays); i++ {
		if swag.IsZero(o.ShelfInlineBays[i]) { // not required
			continue
		}

		if o.ShelfInlineBays[i] != nil {
			if err := o.ShelfInlineBays[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "bays" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineCurrentSensors(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineCurrentSensors) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineCurrentSensors); i++ {
		if swag.IsZero(o.ShelfInlineCurrentSensors[i]) { // not required
			continue
		}

		if o.ShelfInlineCurrentSensors[i] != nil {
			if err := o.ShelfInlineCurrentSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "current_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineDrawers(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineDrawers) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineDrawers); i++ {
		if swag.IsZero(o.ShelfInlineDrawers[i]) { // not required
			continue
		}

		if o.ShelfInlineDrawers[i] != nil {
			if err := o.ShelfInlineDrawers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "drawers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineErrors); i++ {
		if swag.IsZero(o.ShelfInlineErrors[i]) { // not required
			continue
		}

		if o.ShelfInlineErrors[i] != nil {
			if err := o.ShelfInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineFans(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineFans) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineFans); i++ {
		if swag.IsZero(o.ShelfInlineFans[i]) { // not required
			continue
		}

		if o.ShelfInlineFans[i] != nil {
			if err := o.ShelfInlineFans[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineFrus(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineFrus) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineFrus); i++ {
		if swag.IsZero(o.ShelfInlineFrus[i]) { // not required
			continue
		}

		if o.ShelfInlineFrus[i] != nil {
			if err := o.ShelfInlineFrus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlinePaths(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlinePaths) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlinePaths); i++ {
		if swag.IsZero(o.ShelfInlinePaths[i]) { // not required
			continue
		}

		if o.ShelfInlinePaths[i] != nil {
			if err := o.ShelfInlinePaths[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlinePorts(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlinePorts) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlinePorts); i++ {
		if swag.IsZero(o.ShelfInlinePorts[i]) { // not required
			continue
		}

		if o.ShelfInlinePorts[i] != nil {
			if err := o.ShelfInlinePorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineTemperatureSensors(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineTemperatureSensors) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineTemperatureSensors); i++ {
		if swag.IsZero(o.ShelfInlineTemperatureSensors[i]) { // not required
			continue
		}

		if o.ShelfInlineTemperatureSensors[i] != nil {
			if err := o.ShelfInlineTemperatureSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfInlineVoltageSensors(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfInlineVoltageSensors) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfInlineVoltageSensors); i++ {
		if swag.IsZero(o.ShelfInlineVoltageSensors[i]) { // not required
			continue
		}

		if o.ShelfInlineVoltageSensors[i] != nil {
			if err := o.ShelfInlineVoltageSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "voltage_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateShelfResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ShelfResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ShelfResponseInlineRecords); i++ {
		if swag.IsZero(o.ShelfResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ShelfResponseInlineRecords[i] != nil {
			if err := o.ShelfResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var shelfModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfModifyCollectionBodyTypeStatePropEnum = append(shelfModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// ShelfModifyCollectionBodyStateUnknown captures enum value "unknown"
	ShelfModifyCollectionBodyStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfModifyCollectionBodyStateOk captures enum value "ok"
	ShelfModifyCollectionBodyStateOk string = "ok"

	// BEGIN DEBUGGING
	// ShelfModifyCollectionBody
	// ShelfModifyCollectionBody
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfModifyCollectionBodyStateError captures enum value "error"
	ShelfModifyCollectionBodyStateError string = "error"
)

// prop value enum
func (o *ShelfModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) validateVendor(formats strfmt.Registry) error {
	if swag.IsZero(o.Vendor) { // not required
		return nil
	}

	if o.Vendor != nil {
		if err := o.Vendor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vendor")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf modify collection body based on the context it is used
func (o *ShelfModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConnectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDiskCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInternal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateManufacturer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModuleType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRawCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineAcps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineBays(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineCurrentSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineDrawers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineFans(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlinePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlinePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineTemperatureSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfInlineVoltageSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShelfResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVendor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateConnectionType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connection_type", "body", o.ConnectionType); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateDiskCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"disk_count", "body", o.DiskCount); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateInternal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"internal", "body", o.Internal); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"local", "body", o.Local); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateManufacturer(ctx context.Context, formats strfmt.Registry) error {

	if o.Manufacturer != nil {
		if err := o.Manufacturer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "manufacturer")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"model", "body", o.Model); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateModuleType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"module_type", "body", o.ModuleType); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateRawCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"raw_capacity", "body", o.RawCapacity); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineAcps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"acps", "body", []*models.ShelfInlineAcpsInlineArrayItem(o.ShelfInlineAcps)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineAcps); i++ {

		if o.ShelfInlineAcps[i] != nil {
			if err := o.ShelfInlineAcps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineBays(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShelfInlineBays); i++ {

		if o.ShelfInlineBays[i] != nil {
			if err := o.ShelfInlineBays[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "bays" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineCurrentSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"current_sensors", "body", []*models.ShelfInlineCurrentSensorsInlineArrayItem(o.ShelfInlineCurrentSensors)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineCurrentSensors); i++ {

		if o.ShelfInlineCurrentSensors[i] != nil {
			if err := o.ShelfInlineCurrentSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "current_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineDrawers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"drawers", "body", []*models.ShelfInlineDrawersInlineArrayItem(o.ShelfInlineDrawers)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineDrawers); i++ {

		if o.ShelfInlineDrawers[i] != nil {
			if err := o.ShelfInlineDrawers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "drawers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShelfInlineErrors); i++ {

		if o.ShelfInlineErrors[i] != nil {
			if err := o.ShelfInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineFans(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fans", "body", []*models.ShelfInlineFansInlineArrayItem(o.ShelfInlineFans)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineFans); i++ {

		if o.ShelfInlineFans[i] != nil {
			if err := o.ShelfInlineFans[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineFrus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"frus", "body", []*models.ShelfInlineFrusInlineArrayItem(o.ShelfInlineFrus)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineFrus); i++ {

		if o.ShelfInlineFrus[i] != nil {
			if err := o.ShelfInlineFrus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlinePaths(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"paths", "body", []*models.ShelfInlinePathsInlineArrayItem(o.ShelfInlinePaths)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlinePaths); i++ {

		if o.ShelfInlinePaths[i] != nil {
			if err := o.ShelfInlinePaths[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlinePorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShelfInlinePorts); i++ {

		if o.ShelfInlinePorts[i] != nil {
			if err := o.ShelfInlinePorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineTemperatureSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"temperature_sensors", "body", []*models.ShelfInlineTemperatureSensorsInlineArrayItem(o.ShelfInlineTemperatureSensors)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineTemperatureSensors); i++ {

		if o.ShelfInlineTemperatureSensors[i] != nil {
			if err := o.ShelfInlineTemperatureSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfInlineVoltageSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"voltage_sensors", "body", []*models.ShelfInlineVoltageSensorsInlineArrayItem(o.ShelfInlineVoltageSensors)); err != nil {
		return err
	}

	for i := 0; i < len(o.ShelfInlineVoltageSensors); i++ {

		if o.ShelfInlineVoltageSensors[i] != nil {
			if err := o.ShelfInlineVoltageSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "voltage_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateShelfResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShelfResponseInlineRecords); i++ {

		if o.ShelfResponseInlineRecords[i] != nil {
			if err := o.ShelfResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uid", "body", o.UID); err != nil {
		return err
	}

	return nil
}

func (o *ShelfModifyCollectionBody) contextValidateVendor(ctx context.Context, formats strfmt.Registry) error {

	if o.Vendor != nil {
		if err := o.Vendor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vendor")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ShelfModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineAcpsInlineArrayItem shelf inline acps inline array item
swagger:model shelf_inline_acps_inline_array_item
*/
type ShelfInlineAcpsInlineArrayItem struct {

	// address
	// Example: 192.168.1.104
	Address *string `json:"address,omitempty"`

	// channel
	// Example: out_of_band
	// Enum: ["unknown","out_of_band","in_band"]
	Channel *string `json:"channel,omitempty"`

	// connection state
	// Example: full_connectivity
	// Enum: ["no_connectivity","partial_connectivity","full_connectivity","additional_connectivity","unknown_connectivity","not_available","active","disabled"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// enabled
	Enabled *bool `json:"enabled,omitempty"`

	// error
	Error *models.ShelfInlineAcpsInlineArrayItemInlineError `json:"error,omitempty"`

	// netmask
	// Example: 255.255.252.0
	Netmask *string `json:"netmask,omitempty"`

	// node
	Node *models.ShelfInlineAcpsInlineArrayItemInlineNode `json:"node,omitempty"`

	// port
	// Example: e0P
	Port *string `json:"port,omitempty"`

	// subnet
	// Example: 192.168.0.1
	Subnet *string `json:"subnet,omitempty"`
}

// Validate validates this shelf inline acps inline array item
func (o *ShelfInlineAcpsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateChannel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineAcpsInlineArrayItemTypeChannelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","out_of_band","in_band"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemTypeChannelPropEnum = append(shelfInlineAcpsInlineArrayItemTypeChannelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// unknown
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelUnknown captures enum value "unknown"
	ShelfInlineAcpsInlineArrayItemChannelUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// out_of_band
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelOutOfBand captures enum value "out_of_band"
	ShelfInlineAcpsInlineArrayItemChannelOutOfBand string = "out_of_band"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// in_band
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelInBand captures enum value "in_band"
	ShelfInlineAcpsInlineArrayItemChannelInBand string = "in_band"
)

// prop value enum
func (o *ShelfInlineAcpsInlineArrayItem) validateChannelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemTypeChannelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) validateChannel(formats strfmt.Registry) error {
	if swag.IsZero(o.Channel) { // not required
		return nil
	}

	// value enum
	if err := o.validateChannelEnum("channel", "body", *o.Channel); err != nil {
		return err
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_connectivity","partial_connectivity","full_connectivity","additional_connectivity","unknown_connectivity","not_available","active","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum = append(shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// no_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateNoConnectivity captures enum value "no_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateNoConnectivity string = "no_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// partial_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStatePartialConnectivity captures enum value "partial_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStatePartialConnectivity string = "partial_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// full_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateFullConnectivity captures enum value "full_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateFullConnectivity string = "full_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// additional_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateAdditionalConnectivity captures enum value "additional_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateAdditionalConnectivity string = "additional_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// unknown_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateUnknownConnectivity captures enum value "unknown_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateUnknownConnectivity string = "unknown_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// not_available
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateNotAvailable captures enum value "not_available"
	ShelfInlineAcpsInlineArrayItemConnectionStateNotAvailable string = "not_available"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// active
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateActive captures enum value "active"
	ShelfInlineAcpsInlineArrayItemConnectionStateActive string = "active"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// disabled
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateDisabled captures enum value "disabled"
	ShelfInlineAcpsInlineArrayItemConnectionStateDisabled string = "disabled"
)

// prop value enum
func (o *ShelfInlineAcpsInlineArrayItem) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := o.validateConnectionStateEnum("connection_state", "body", *o.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item based on the context it is used
func (o *ShelfInlineAcpsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlineAcpsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineAcpsInlineArrayItemInlineError Error object is populated when connection_state becomes non-optimal
swagger:model shelf_inline_acps_inline_array_item_inline_error
*/
type ShelfInlineAcpsInlineArrayItemInlineError struct {

	// reason
	Reason *models.Error `json:"reason,omitempty"`

	// severity
	// Enum: ["unknown","notice","warning","error","critical"]
	Severity *string `json:"severity,omitempty"`

	// type
	// Enum: ["not_applicable","connection_issue","connection_activity","module_error","shelf_error"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline error
func (o *ShelfInlineAcpsInlineArrayItemInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineError) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(o.Reason) { // not required
		return nil
	}

	if o.Reason != nil {
		if err := o.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","notice","warning","error","critical"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum = append(shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// unknown
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityUnknown captures enum value "unknown"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityNotice captures enum value "notice"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// warning
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityWarning captures enum value "warning"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityWarning string = "warning"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityError captures enum value "error"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityError string = "error"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// critical
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityCritical captures enum value "critical"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityCritical string = "critical"
)

// prop value enum
func (o *ShelfInlineAcpsInlineArrayItemInlineError) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineError) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(o.Severity) { // not required
		return nil
	}

	// value enum
	if err := o.validateSeverityEnum("error"+"."+"severity", "body", *o.Severity); err != nil {
		return err
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_applicable","connection_issue","connection_activity","module_error","shelf_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum = append(shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// not_applicable
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeNotApplicable captures enum value "not_applicable"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeNotApplicable string = "not_applicable"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// connection_issue
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionIssue captures enum value "connection_issue"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionIssue string = "connection_issue"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// connection_activity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionActivity captures enum value "connection_activity"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionActivity string = "connection_activity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// module_error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeModuleError captures enum value "module_error"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeModuleError string = "module_error"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// shelf_error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeShelfError captures enum value "shelf_error"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeShelfError string = "shelf_error"
)

// prop value enum
func (o *ShelfInlineAcpsInlineArrayItemInlineError) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineError) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("error"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline error based on the context it is used
func (o *ShelfInlineAcpsInlineArrayItemInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineError) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if o.Reason != nil {
		if err := o.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineError) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineAcpsInlineArrayItemInlineNode shelf inline acps inline array item inline node
swagger:model shelf_inline_acps_inline_array_item_inline_node
*/
type ShelfInlineAcpsInlineArrayItemInlineNode struct {

	// links
	Links *models.ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline node
func (o *ShelfInlineAcpsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline node based on the context it is used
func (o *ShelfInlineAcpsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks shelf inline acps inline array item inline node inline links
swagger:model shelf_inline_acps_inline_array_item_inline_node_inline__links
*/
type ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline node inline links
func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline node inline links based on the context it is used
func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineBaysInlineArrayItem shelf inline bays inline array item
swagger:model shelf_inline_bays_inline_array_item
*/
type ShelfInlineBaysInlineArrayItem struct {

	// drawer
	Drawer *models.ShelfInlineBaysInlineArrayItemInlineDrawer `json:"drawer,omitempty"`

	// has disk
	HasDisk *bool `json:"has_disk,omitempty"`

	// id
	// Example: 0
	ID *int64 `json:"id,omitempty"`

	// state
	// Example: ok
	// Enum: ["unknown","ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Example: single_disk
	// Enum: ["unknown","single_disk","multi_lun"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline bays inline array item
func (o *ShelfInlineBaysInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDrawer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineBaysInlineArrayItem) validateDrawer(formats strfmt.Registry) error {
	if swag.IsZero(o.Drawer) { // not required
		return nil
	}

	if o.Drawer != nil {
		if err := o.Drawer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

var shelfInlineBaysInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineBaysInlineArrayItemTypeStatePropEnum = append(shelfInlineBaysInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateUnknown captures enum value "unknown"
	ShelfInlineBaysInlineArrayItemStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineBaysInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateError captures enum value "error"
	ShelfInlineBaysInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineBaysInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineBaysInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineBaysInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var shelfInlineBaysInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_disk","multi_lun"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineBaysInlineArrayItemTypeTypePropEnum = append(shelfInlineBaysInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// unknown
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeUnknown captures enum value "unknown"
	ShelfInlineBaysInlineArrayItemTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// single_disk
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeSingleDisk captures enum value "single_disk"
	ShelfInlineBaysInlineArrayItemTypeSingleDisk string = "single_disk"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// multi_lun
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeMultiLun captures enum value "multi_lun"
	ShelfInlineBaysInlineArrayItemTypeMultiLun string = "multi_lun"
)

// prop value enum
func (o *ShelfInlineBaysInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineBaysInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineBaysInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline bays inline array item based on the context it is used
func (o *ShelfInlineBaysInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDrawer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineBaysInlineArrayItem) contextValidateDrawer(ctx context.Context, formats strfmt.Registry) error {

	if o.Drawer != nil {
		if err := o.Drawer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineBaysInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineBaysInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineBaysInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineBaysInlineArrayItemInlineDrawer shelf inline bays inline array item inline drawer
swagger:model shelf_inline_bays_inline_array_item_inline_drawer
*/
type ShelfInlineBaysInlineArrayItemInlineDrawer struct {

	// The drawer containing this bay
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// The drawer slot for this bay
	// Example: 0
	Slot *int64 `json:"slot,omitempty"`
}

// Validate validates this shelf inline bays inline array item inline drawer
func (o *ShelfInlineBaysInlineArrayItemInlineDrawer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline bays inline array item inline drawer based on context it is used
func (o *ShelfInlineBaysInlineArrayItemInlineDrawer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineBaysInlineArrayItemInlineDrawer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineBaysInlineArrayItemInlineDrawer) UnmarshalBinary(b []byte) error {
	var res ShelfInlineBaysInlineArrayItemInlineDrawer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineCurrentSensorsInlineArrayItem shelf inline current sensors inline array item
swagger:model shelf_inline_current_sensors_inline_array_item
*/
type ShelfInlineCurrentSensorsInlineArrayItem struct {

	// Current, in milliamps
	// Example: 14410
	Current *int64 `json:"current,omitempty"`

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline current sensors inline array item
func (o *ShelfInlineCurrentSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_current_sensors_inline_array_item
	// ShelfInlineCurrentSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineCurrentSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineCurrentSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_current_sensors_inline_array_item
	// ShelfInlineCurrentSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineCurrentSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineCurrentSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineCurrentSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineCurrentSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline current sensors inline array item based on context it is used
func (o *ShelfInlineCurrentSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineCurrentSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineCurrentSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineCurrentSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineDrawersInlineArrayItem shelf inline drawers inline array item
swagger:model shelf_inline_drawers_inline_array_item
*/
type ShelfInlineDrawersInlineArrayItem struct {

	// closed
	Closed *bool `json:"closed,omitempty"`

	// disk count
	// Example: 12
	DiskCount *int64 `json:"disk_count,omitempty"`

	// error
	Error *string `json:"error,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// part number
	// Example: 111-03071
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: 21604008263
	SerialNumber *string `json:"serial_number,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline drawers inline array item
func (o *ShelfInlineDrawersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineDrawersInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineDrawersInlineArrayItemTypeStatePropEnum = append(shelfInlineDrawersInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_drawers_inline_array_item
	// ShelfInlineDrawersInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineDrawersInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineDrawersInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_drawers_inline_array_item
	// ShelfInlineDrawersInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineDrawersInlineArrayItemStateError captures enum value "error"
	ShelfInlineDrawersInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineDrawersInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineDrawersInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineDrawersInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline drawers inline array item based on context it is used
func (o *ShelfInlineDrawersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineDrawersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineDrawersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineDrawersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineErrorsInlineArrayItem shelf inline errors inline array item
swagger:model shelf_inline_errors_inline_array_item
*/
type ShelfInlineErrorsInlineArrayItem struct {

	// reason
	Reason *models.Error `json:"reason,omitempty"`
}

// Validate validates this shelf inline errors inline array item
func (o *ShelfInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineErrorsInlineArrayItem) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(o.Reason) { // not required
		return nil
	}

	if o.Reason != nil {
		if err := o.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline errors inline array item based on the context it is used
func (o *ShelfInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineErrorsInlineArrayItem) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if o.Reason != nil {
		if err := o.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineFansInlineArrayItem shelf inline fans inline array item
swagger:model shelf_inline_fans_inline_array_item
*/
type ShelfInlineFansInlineArrayItem struct {

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// rpm
	// Example: 3020
	Rpm *int64 `json:"rpm,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline fans inline array item
func (o *ShelfInlineFansInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineFansInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFansInlineArrayItemTypeStatePropEnum = append(shelfInlineFansInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_fans_inline_array_item
	// ShelfInlineFansInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineFansInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineFansInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_fans_inline_array_item
	// ShelfInlineFansInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineFansInlineArrayItemStateError captures enum value "error"
	ShelfInlineFansInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineFansInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFansInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineFansInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline fans inline array item based on context it is used
func (o *ShelfInlineFansInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineFansInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineFansInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFansInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineFrusInlineArrayItem shelf inline frus inline array item
swagger:model shelf_inline_frus_inline_array_item
*/
type ShelfInlineFrusInlineArrayItem struct {

	// firmware version
	// Example: 191
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// part number
	// Example: 111-00690+A2
	PartNumber *string `json:"part_number,omitempty"`

	// psu
	Psu *models.ShelfInlineFrusInlineArrayItemInlinePsu `json:"psu,omitempty"`

	// serial number
	// Example: 8000166294
	SerialNumber *string `json:"serial_number,omitempty"`

	// state
	// Example: error
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Example: module
	// Enum: ["module","psu"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline frus inline array item
func (o *ShelfInlineFrusInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePsu(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineFrusInlineArrayItem) validatePsu(formats strfmt.Registry) error {
	if swag.IsZero(o.Psu) { // not required
		return nil
	}

	if o.Psu != nil {
		if err := o.Psu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("psu")
			}
			return err
		}
	}

	return nil
}

var shelfInlineFrusInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFrusInlineArrayItemTypeStatePropEnum = append(shelfInlineFrusInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineFrusInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemStateError captures enum value "error"
	ShelfInlineFrusInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineFrusInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFrusInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineFrusInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var shelfInlineFrusInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["module","psu"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFrusInlineArrayItemTypeTypePropEnum = append(shelfInlineFrusInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// type
	// Type
	// module
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemTypeModule captures enum value "module"
	ShelfInlineFrusInlineArrayItemTypeModule string = "module"

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// type
	// Type
	// psu
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemTypePsu captures enum value "psu"
	ShelfInlineFrusInlineArrayItemTypePsu string = "psu"
)

// prop value enum
func (o *ShelfInlineFrusInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFrusInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineFrusInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline frus inline array item based on the context it is used
func (o *ShelfInlineFrusInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePsu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineFrusInlineArrayItem) contextValidatePsu(ctx context.Context, formats strfmt.Registry) error {

	if o.Psu != nil {
		if err := o.Psu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("psu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineFrusInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineFrusInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFrusInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineFrusInlineArrayItemInlinePsu shelf inline frus inline array item inline psu
swagger:model shelf_inline_frus_inline_array_item_inline_psu
*/
type ShelfInlineFrusInlineArrayItemInlinePsu struct {

	// The ratio of the peak voltage to the root-mean-square voltage
	// Example: 92
	CrestFactor *int64 `json:"crest_factor,omitempty"`

	// model
	// Example: 00
	Model *string `json:"model,omitempty"`

	// Power drawn, in watts
	// Example: 210
	PowerDrawn *int64 `json:"power_drawn,omitempty"`

	// Power rating, in watts
	// Example: 1600
	PowerRating *int64 `json:"power_rating,omitempty"`
}

// Validate validates this shelf inline frus inline array item inline psu
func (o *ShelfInlineFrusInlineArrayItemInlinePsu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline frus inline array item inline psu based on context it is used
func (o *ShelfInlineFrusInlineArrayItemInlinePsu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineFrusInlineArrayItemInlinePsu) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineFrusInlineArrayItemInlinePsu) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFrusInlineArrayItemInlinePsu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineManufacturer shelf inline manufacturer
swagger:model shelf_inline_manufacturer
*/
type ShelfInlineManufacturer struct {

	// name
	// Example: NETAPP
	Name *string `json:"name,omitempty"`
}

// Validate validates this shelf inline manufacturer
func (o *ShelfInlineManufacturer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this shelf inline manufacturer based on the context it is used
func (o *ShelfInlineManufacturer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineManufacturer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineManufacturer) UnmarshalBinary(b []byte) error {
	var res ShelfInlineManufacturer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePathsInlineArrayItem Storage port
swagger:model shelf_inline_paths_inline_array_item
*/
type ShelfInlinePathsInlineArrayItem struct {

	// links
	Links *models.ShelfInlinePathsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: 2a
	Name *string `json:"name,omitempty"`

	// node
	Node *models.ShelfInlinePathsInlineArrayItemInlineNode `json:"node,omitempty"`
}

// Validate validates this shelf inline paths inline array item
func (o *ShelfInlinePathsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlinePathsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item based on the context it is used
func (o *ShelfInlinePathsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlinePathsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePathsInlineArrayItemInlineLinks shelf inline paths inline array item inline links
swagger:model shelf_inline_paths_inline_array_item_inline__links
*/
type ShelfInlinePathsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline links
func (o *ShelfInlinePathsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline links based on the context it is used
func (o *ShelfInlinePathsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePathsInlineArrayItemInlineNode shelf inline paths inline array item inline node
swagger:model shelf_inline_paths_inline_array_item_inline_node
*/
type ShelfInlinePathsInlineArrayItemInlineNode struct {

	// links
	Links *models.ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline node
func (o *ShelfInlinePathsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline node based on the context it is used
func (o *ShelfInlinePathsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks shelf inline paths inline array item inline node inline links
swagger:model shelf_inline_paths_inline_array_item_inline_node_inline__links
*/
type ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline node inline links
func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline node inline links based on the context it is used
func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePortsInlineArrayItem shelf inline ports inline array item
swagger:model shelf_inline_ports_inline_array_item
*/
type ShelfInlinePortsInlineArrayItem struct {

	// cable
	Cable *models.ShelfInlinePortsInlineArrayItemInlineCable `json:"cable,omitempty"`

	// designator
	// Example: square
	// Enum: ["circle","square","1","2","3","4"]
	Designator *string `json:"designator,omitempty"`

	// id
	// Example: 0
	ID *int64 `json:"id,omitempty"`

	// internal
	Internal *bool `json:"internal,omitempty"`

	// mac address
	MacAddress *string `json:"mac_address,omitempty"`

	// module id
	// Example: a
	// Enum: ["a","b"]
	ModuleID *string `json:"module_id,omitempty"`

	// remote
	Remote *models.ShelfInlinePortsInlineArrayItemInlineRemote `json:"remote,omitempty"`

	// speed
	// Example: 100
	Speed *int64 `json:"speed,omitempty"`

	// state
	// Example: connected
	// Enum: ["connected","disconnected","error"]
	State *string `json:"state,omitempty"`

	// wwn
	// Example: 500A0980000B6C3F
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this shelf inline ports inline array item
func (o *ShelfInlinePortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCable(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDesignator(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateModuleID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) validateCable(formats strfmt.Registry) error {
	if swag.IsZero(o.Cable) { // not required
		return nil
	}

	if o.Cable != nil {
		if err := o.Cable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["circle","square","1","2","3","4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum = append(shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// circle
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorCircle captures enum value "circle"
	ShelfInlinePortsInlineArrayItemDesignatorCircle string = "circle"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// square
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorSquare captures enum value "square"
	ShelfInlinePortsInlineArrayItemDesignatorSquare string = "square"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 1
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr1 captures enum value "1"
	ShelfInlinePortsInlineArrayItemDesignatorNr1 string = "1"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 2
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr2 captures enum value "2"
	ShelfInlinePortsInlineArrayItemDesignatorNr2 string = "2"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 3
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr3 captures enum value "3"
	ShelfInlinePortsInlineArrayItemDesignatorNr3 string = "3"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 4
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr4 captures enum value "4"
	ShelfInlinePortsInlineArrayItemDesignatorNr4 string = "4"
)

// prop value enum
func (o *ShelfInlinePortsInlineArrayItem) validateDesignatorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) validateDesignator(formats strfmt.Registry) error {
	if swag.IsZero(o.Designator) { // not required
		return nil
	}

	// value enum
	if err := o.validateDesignatorEnum("designator", "body", *o.Designator); err != nil {
		return err
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["a","b"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum = append(shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// module_id
	// ModuleID
	// a
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemModuleIDA captures enum value "a"
	ShelfInlinePortsInlineArrayItemModuleIDA string = "a"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// module_id
	// ModuleID
	// b
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemModuleIDB captures enum value "b"
	ShelfInlinePortsInlineArrayItemModuleIDB string = "b"
)

// prop value enum
func (o *ShelfInlinePortsInlineArrayItem) validateModuleIDEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) validateModuleID(formats strfmt.Registry) error {
	if swag.IsZero(o.ModuleID) { // not required
		return nil
	}

	// value enum
	if err := o.validateModuleIDEnum("module_id", "body", *o.ModuleID); err != nil {
		return err
	}

	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(o.Remote) { // not required
		return nil
	}

	if o.Remote != nil {
		if err := o.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connected","disconnected","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeStatePropEnum = append(shelfInlinePortsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// connected
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateConnected captures enum value "connected"
	ShelfInlinePortsInlineArrayItemStateConnected string = "connected"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// disconnected
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateDisconnected captures enum value "disconnected"
	ShelfInlinePortsInlineArrayItemStateDisconnected string = "disconnected"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateError captures enum value "error"
	ShelfInlinePortsInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlinePortsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline ports inline array item based on the context it is used
func (o *ShelfInlinePortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) contextValidateCable(ctx context.Context, formats strfmt.Registry) error {

	if o.Cable != nil {
		if err := o.Cable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlinePortsInlineArrayItem) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if o.Remote != nil {
		if err := o.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePortsInlineArrayItemInlineCable shelf inline ports inline array item inline cable
swagger:model shelf_inline_ports_inline_array_item_inline_cable
*/
type ShelfInlinePortsInlineArrayItemInlineCable struct {

	// identifier
	// Example: 500a0980000b6c3f-50000d1703544b80
	Identifier *string `json:"identifier,omitempty"`

	// length
	// Example: 2m
	Length *string `json:"length,omitempty"`

	// part number
	// Example: 112-00431+A0
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: 616930439
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this shelf inline ports inline array item inline cable
func (o *ShelfInlinePortsInlineArrayItemInlineCable) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline ports inline array item inline cable based on context it is used
func (o *ShelfInlinePortsInlineArrayItemInlineCable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItemInlineCable) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItemInlineCable) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItemInlineCable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlinePortsInlineArrayItemInlineRemote shelf inline ports inline array item inline remote
swagger:model shelf_inline_ports_inline_array_item_inline_remote
*/
type ShelfInlinePortsInlineArrayItemInlineRemote struct {

	// chassis
	Chassis *string `json:"chassis,omitempty"`

	// device
	Device *string `json:"device,omitempty"`

	// mac address
	MacAddress *string `json:"mac_address,omitempty"`

	// phy
	// Example: 12
	Phy *string `json:"phy,omitempty"`

	// port
	Port *string `json:"port,omitempty"`

	// wwn
	// Example: 50000D1703544B80
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this shelf inline ports inline array item inline remote
func (o *ShelfInlinePortsInlineArrayItemInlineRemote) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline ports inline array item inline remote based on context it is used
func (o *ShelfInlinePortsInlineArrayItemInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItemInlineRemote) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlinePortsInlineArrayItemInlineRemote) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItemInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineTemperatureSensorsInlineArrayItem shelf inline temperature sensors inline array item
swagger:model shelf_inline_temperature_sensors_inline_array_item
*/
type ShelfInlineTemperatureSensorsInlineArrayItem struct {

	// Sensor that measures the ambient temperature
	// Example: false
	Ambient *bool `json:"ambient,omitempty"`

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: temp sensor on midplane left
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// Temperature, in degrees Celsius
	// Example: 32
	Temperature *int64 `json:"temperature,omitempty"`

	// threshold
	Threshold *models.ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold `json:"threshold,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item
func (o *ShelfInlineTemperatureSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThreshold(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_temperature_sensors_inline_array_item
	// ShelfInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineTemperatureSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineTemperatureSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_temperature_sensors_inline_array_item
	// ShelfInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineTemperatureSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineTemperatureSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineTemperatureSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItem) validateThreshold(formats strfmt.Registry) error {
	if swag.IsZero(o.Threshold) { // not required
		return nil
	}

	if o.Threshold != nil {
		if err := o.Threshold.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline temperature sensors inline array item based on the context it is used
func (o *ShelfInlineTemperatureSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateThreshold(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItem) contextValidateThreshold(ctx context.Context, formats strfmt.Registry) error {

	if o.Threshold != nil {
		if err := o.Threshold.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold shelf inline temperature sensors inline array item inline threshold
swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold
*/
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold struct {

	// high
	High *models.ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh `json:"high,omitempty"`

	// low
	Low *models.ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow `json:"low,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHigh(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLow(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) validateHigh(formats strfmt.Registry) error {
	if swag.IsZero(o.High) { // not required
		return nil
	}

	if o.High != nil {
		if err := o.High.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "high")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) validateLow(formats strfmt.Registry) error {
	if swag.IsZero(o.Low) { // not required
		return nil
	}

	if o.Low != nil {
		if err := o.Low.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "low")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline temperature sensors inline array item inline threshold based on the context it is used
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHigh(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) contextValidateHigh(ctx context.Context, formats strfmt.Registry) error {

	if o.High != nil {
		if err := o.High.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "high")
			}
			return err
		}
	}

	return nil
}

func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) contextValidateLow(ctx context.Context, formats strfmt.Registry) error {

	if o.Low != nil {
		if err := o.Low.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "low")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh shelf inline temperature sensors inline array item inline threshold inline high
swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold_inline_high
*/
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh struct {

	// High critical threshold, in degrees Celsius
	// Example: 60
	Critical *int64 `json:"critical,omitempty"`

	// High warning threshold, in degrees Celsius
	// Example: 55
	Warning *int64 `json:"warning,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold inline high
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline temperature sensors inline array item inline threshold inline high based on context it is used
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow shelf inline temperature sensors inline array item inline threshold inline low
swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold_inline_low
*/
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow struct {

	// Low critical threshold, in degrees Celsius
	// Example: 0
	Critical *int64 `json:"critical,omitempty"`

	// Low warning threshold, in degrees Celsius
	// Example: 5
	Warning *int64 `json:"warning,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold inline low
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline temperature sensors inline array item inline threshold inline low based on context it is used
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineVendor shelf inline vendor
swagger:model shelf_inline_vendor
*/
type ShelfInlineVendor struct {

	// Support for this field will be removed in a future release. Please use vendor.name for this field.
	// Example: XYZ
	Manufacturer *string `json:"manufacturer,omitempty"`

	// name
	// Example: XYZ
	Name *string `json:"name,omitempty"`

	// Part number
	// Example: A92831142733
	PartNumber *string `json:"part_number,omitempty"`

	// Product name
	// Example: LS2246
	Product *string `json:"product,omitempty"`

	// Serial number
	// Example: 891234572210221
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this shelf inline vendor
func (o *ShelfInlineVendor) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this shelf inline vendor based on the context it is used
func (o *ShelfInlineVendor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineVendor) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineVendor) UnmarshalBinary(b []byte) error {
	var res ShelfInlineVendor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShelfInlineVoltageSensorsInlineArrayItem shelf inline voltage sensors inline array item
swagger:model shelf_inline_voltage_sensors_inline_array_item
*/
type ShelfInlineVoltageSensorsInlineArrayItem struct {

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// Voltage, in volts
	// Example: 12.18
	Voltage *float64 `json:"voltage,omitempty"`
}

// Validate validates this shelf inline voltage sensors inline array item
func (o *ShelfInlineVoltageSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_voltage_sensors_inline_array_item
	// ShelfInlineVoltageSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineVoltageSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineVoltageSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_voltage_sensors_inline_array_item
	// ShelfInlineVoltageSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineVoltageSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineVoltageSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (o *ShelfInlineVoltageSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ShelfInlineVoltageSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline voltage sensors inline array item based on context it is used
func (o *ShelfInlineVoltageSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ShelfInlineVoltageSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShelfInlineVoltageSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineVoltageSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
