// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapshotDeleteParams creates a new SnapshotDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotDeleteParams() *SnapshotDeleteParams {
	return &SnapshotDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotDeleteParamsWithTimeout creates a new SnapshotDeleteParams object
// with the ability to set a timeout on a request.
func NewSnapshotDeleteParamsWithTimeout(timeout time.Duration) *SnapshotDeleteParams {
	return &SnapshotDeleteParams{
		timeout: timeout,
	}
}

// NewSnapshotDeleteParamsWithContext creates a new SnapshotDeleteParams object
// with the ability to set a context for a request.
func NewSnapshotDeleteParamsWithContext(ctx context.Context) *SnapshotDeleteParams {
	return &SnapshotDeleteParams{
		Context: ctx,
	}
}

// NewSnapshotDeleteParamsWithHTTPClient creates a new SnapshotDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotDeleteParamsWithHTTPClient(client *http.Client) *SnapshotDeleteParams {
	return &SnapshotDeleteParams{
		HTTPClient: client,
	}
}

/*
SnapshotDeleteParams contains all the parameters to send to the API endpoint

	for the snapshot delete operation.

	Typically these are written to a http.Request.
*/
type SnapshotDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Snapshot UUID
	*/
	UUID string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotDeleteParams) WithDefaults() *SnapshotDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SnapshotDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapshot delete params
func (o *SnapshotDeleteParams) WithTimeout(timeout time.Duration) *SnapshotDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot delete params
func (o *SnapshotDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot delete params
func (o *SnapshotDeleteParams) WithContext(ctx context.Context) *SnapshotDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot delete params
func (o *SnapshotDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot delete params
func (o *SnapshotDeleteParams) WithHTTPClient(client *http.Client) *SnapshotDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot delete params
func (o *SnapshotDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the snapshot delete params
func (o *SnapshotDeleteParams) WithReturnTimeout(returnTimeout *int64) *SnapshotDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapshot delete params
func (o *SnapshotDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the snapshot delete params
func (o *SnapshotDeleteParams) WithUUID(uuid string) *SnapshotDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapshot delete params
func (o *SnapshotDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithVolumeUUID adds the volumeUUID to the snapshot delete params
func (o *SnapshotDeleteParams) WithVolumeUUID(volumeUUID string) *SnapshotDeleteParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the snapshot delete params
func (o *SnapshotDeleteParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
