// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotDeleteReader is a Reader for the SnapshotDelete structure.
type SnapshotDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapshotDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotDeleteOK creates a SnapshotDeleteOK with default headers values
func NewSnapshotDeleteOK() *SnapshotDeleteOK {
	return &SnapshotDeleteOK{}
}

/*
SnapshotDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotDeleteOK struct {
	Payload *models.SnapshotJobLinkResponse
}

// IsSuccess returns true when this snapshot delete o k response has a 2xx status code
func (o *SnapshotDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot delete o k response has a 3xx status code
func (o *SnapshotDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot delete o k response has a 4xx status code
func (o *SnapshotDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot delete o k response has a 5xx status code
func (o *SnapshotDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot delete o k response a status code equal to that given
func (o *SnapshotDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot delete o k response
func (o *SnapshotDeleteOK) Code() int {
	return 200
}

func (o *SnapshotDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotDeleteOK %s", 200, payload)
}

func (o *SnapshotDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotDeleteOK %s", 200, payload)
}

func (o *SnapshotDeleteOK) GetPayload() *models.SnapshotJobLinkResponse {
	return o.Payload
}

func (o *SnapshotDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotDeleteAccepted creates a SnapshotDeleteAccepted with default headers values
func NewSnapshotDeleteAccepted() *SnapshotDeleteAccepted {
	return &SnapshotDeleteAccepted{}
}

/*
SnapshotDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapshotDeleteAccepted struct {
	Payload *models.SnapshotJobLinkResponse
}

// IsSuccess returns true when this snapshot delete accepted response has a 2xx status code
func (o *SnapshotDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot delete accepted response has a 3xx status code
func (o *SnapshotDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot delete accepted response has a 4xx status code
func (o *SnapshotDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot delete accepted response has a 5xx status code
func (o *SnapshotDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot delete accepted response a status code equal to that given
func (o *SnapshotDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapshot delete accepted response
func (o *SnapshotDeleteAccepted) Code() int {
	return 202
}

func (o *SnapshotDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotDeleteAccepted %s", 202, payload)
}

func (o *SnapshotDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotDeleteAccepted %s", 202, payload)
}

func (o *SnapshotDeleteAccepted) GetPayload() *models.SnapshotJobLinkResponse {
	return o.Payload
}

func (o *SnapshotDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotDeleteDefault creates a SnapshotDeleteDefault with default headers values
func NewSnapshotDeleteDefault(code int) *SnapshotDeleteDefault {
	return &SnapshotDeleteDefault{
		_statusCode: code,
	}
}

/*
	SnapshotDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 2          | An invalid value was entered for one of the fields. |
| 524481     | Snapshot was not deleted because the associated volume is locked or fenced. |
| 1638521    | Snapshots can only be deleted on read/write (RW) volumes. |
| 1638538    | Cannot determine the status of the snapshot delete operation for the specified volume. |
| 1638543    | Failed to delete snapshot because it has an owner. |
| 1638555    | The specified snapshot has not expired or is locked. |
| 1638600    | The snapshot does not exist. |
| 1638644    | POST, DELETE, and PATCH requests on the snapshot session endpoint are not supported on this platform. |
*/
type SnapshotDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot delete default response has a 2xx status code
func (o *SnapshotDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot delete default response has a 3xx status code
func (o *SnapshotDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot delete default response has a 4xx status code
func (o *SnapshotDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot delete default response has a 5xx status code
func (o *SnapshotDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot delete default response a status code equal to that given
func (o *SnapshotDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot delete default response
func (o *SnapshotDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshot_delete default %s", o._statusCode, payload)
}

func (o *SnapshotDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshot_delete default %s", o._statusCode, payload)
}

func (o *SnapshotDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
