// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotGetReader is a Reader for the SnapshotGet structure.
type SnapshotGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotGetOK creates a SnapshotGetOK with default headers values
func NewSnapshotGetOK() *SnapshotGetOK {
	return &SnapshotGetOK{}
}

/*
SnapshotGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotGetOK struct {
	Payload *models.Snapshot
}

// IsSuccess returns true when this snapshot get o k response has a 2xx status code
func (o *SnapshotGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot get o k response has a 3xx status code
func (o *SnapshotGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot get o k response has a 4xx status code
func (o *SnapshotGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot get o k response has a 5xx status code
func (o *SnapshotGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot get o k response a status code equal to that given
func (o *SnapshotGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot get o k response
func (o *SnapshotGetOK) Code() int {
	return 200
}

func (o *SnapshotGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotGetOK %s", 200, payload)
}

func (o *SnapshotGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshotGetOK %s", 200, payload)
}

func (o *SnapshotGetOK) GetPayload() *models.Snapshot {
	return o.Payload
}

func (o *SnapshotGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Snapshot)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotGetDefault creates a SnapshotGetDefault with default headers values
func NewSnapshotGetDefault(code int) *SnapshotGetDefault {
	return &SnapshotGetDefault{
		_statusCode: code,
	}
}

/*
	SnapshotGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 2          | An invalid value was entered for one of the fields. |
| 262197     | An invalid field was specified in the request. |
| 1638473    | Snapshot tag not found. |
| 1638503    | The snapshot does not exist on the specified volume. |
| 1638600    | The snapshot does not exist. |
| 1638615    | Bulk operations for snapshots are not supported on multiple SVMs. |
*/
type SnapshotGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot get default response has a 2xx status code
func (o *SnapshotGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot get default response has a 3xx status code
func (o *SnapshotGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot get default response has a 4xx status code
func (o *SnapshotGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot get default response has a 5xx status code
func (o *SnapshotGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot get default response a status code equal to that given
func (o *SnapshotGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot get default response
func (o *SnapshotGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshot_get default %s", o._statusCode, payload)
}

func (o *SnapshotGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/volumes/{volume.uuid}/snapshots/{uuid}][%d] snapshot_get default %s", o._statusCode, payload)
}

func (o *SnapshotGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
