// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotModifyCollectionReader is a Reader for the SnapshotModifyCollection structure.
type SnapshotModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapshotModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotModifyCollectionOK creates a SnapshotModifyCollectionOK with default headers values
func NewSnapshotModifyCollectionOK() *SnapshotModifyCollectionOK {
	return &SnapshotModifyCollectionOK{}
}

/*
SnapshotModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotModifyCollectionOK struct {
	Payload *models.SnapshotJobLinkResponse
}

// IsSuccess returns true when this snapshot modify collection o k response has a 2xx status code
func (o *SnapshotModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot modify collection o k response has a 3xx status code
func (o *SnapshotModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot modify collection o k response has a 4xx status code
func (o *SnapshotModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot modify collection o k response has a 5xx status code
func (o *SnapshotModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot modify collection o k response a status code equal to that given
func (o *SnapshotModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot modify collection o k response
func (o *SnapshotModifyCollectionOK) Code() int {
	return 200
}

func (o *SnapshotModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshotModifyCollectionOK %s", 200, payload)
}

func (o *SnapshotModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshotModifyCollectionOK %s", 200, payload)
}

func (o *SnapshotModifyCollectionOK) GetPayload() *models.SnapshotJobLinkResponse {
	return o.Payload
}

func (o *SnapshotModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotModifyCollectionAccepted creates a SnapshotModifyCollectionAccepted with default headers values
func NewSnapshotModifyCollectionAccepted() *SnapshotModifyCollectionAccepted {
	return &SnapshotModifyCollectionAccepted{}
}

/*
SnapshotModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapshotModifyCollectionAccepted struct {
	Payload *models.SnapshotJobLinkResponse
}

// IsSuccess returns true when this snapshot modify collection accepted response has a 2xx status code
func (o *SnapshotModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot modify collection accepted response has a 3xx status code
func (o *SnapshotModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot modify collection accepted response has a 4xx status code
func (o *SnapshotModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot modify collection accepted response has a 5xx status code
func (o *SnapshotModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot modify collection accepted response a status code equal to that given
func (o *SnapshotModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapshot modify collection accepted response
func (o *SnapshotModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SnapshotModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapshotModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapshotModifyCollectionAccepted) GetPayload() *models.SnapshotJobLinkResponse {
	return o.Payload
}

func (o *SnapshotModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotModifyCollectionDefault creates a SnapshotModifyCollectionDefault with default headers values
func NewSnapshotModifyCollectionDefault(code int) *SnapshotModifyCollectionDefault {
	return &SnapshotModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapshotModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 524508     | The snapshot was not renamed because the name entered is not valid. |
| 542797     | The specified file or snapshot does not exist. |
| 1638455    | Failed to set comment for snapshot. |
| 1638476    | You cannot rename a snapshot created for use as a reference snapshot by other jobs. |
| 1638477    | User-created snapshot names cannot begin with the specified prefix. |
| 1638518    | The specified snapshot name is invalid. |
| 1638522    | Snapshots can only be renamed on read/write (RW) volumes. |
| 1638523    | Failed to set the specified SnapMirror label for the snapshot. |
| 1638524    | Adding SnapMirror labels is not allowed in a mixed version cluster. |
| 1638539    | Cannot determine the status of the snapshot rename operation for the specified volume. |
| 1638554    | Failed to set expiry time for the snapshot. |
| 1638600    | The snapshot does not exist. |
| 1638644    | POST, DELETE, and PATCH requests on the snapshot session endpoint are not supported on this platform. |
*/
type SnapshotModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot modify collection default response has a 2xx status code
func (o *SnapshotModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot modify collection default response has a 3xx status code
func (o *SnapshotModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot modify collection default response has a 4xx status code
func (o *SnapshotModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot modify collection default response has a 5xx status code
func (o *SnapshotModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot modify collection default response a status code equal to that given
func (o *SnapshotModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot modify collection default response
func (o *SnapshotModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapshotModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/volumes/{volume.uuid}/snapshots][%d] snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapshotModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapshotModifyCollectionBody snapshot modify collection body
swagger:model SnapshotModifyCollectionBody
*/
type SnapshotModifyCollectionBody struct {

	// links
	Links *models.SnapshotInlineLinks `json:"_links,omitempty"`

	// A comment associated with the snapshot. This is an optional attribute for POST or PATCH.
	Comment *string `json:"comment,omitempty"`

	// Savings due to compression at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	CompressSavings *int64 `json:"compress_savings,omitempty"`

	// Creation time of the snapshot. It is the volume access time when the snapshot was created.
	// Example: 2019-02-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Savings due to dedup at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	DedupSavings *int64 `json:"dedup_savings,omitempty"`

	// delta
	Delta *models.SnapshotDelta `json:"delta,omitempty"`

	// The expiry time for the snapshot. This is an optional attribute for POST or PATCH. Snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Size of the logical used file system at the time the snapshot is captured.
	// Example: 1228800
	// Read Only: true
	LogicalSize *int64 `json:"logical_size,omitempty"`

	// Snapshot. Valid in POST or PATCH.
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// owners
	// Read Only: true
	Owners []*string `json:"owners,omitempty"`

	// provenance volume
	ProvenanceVolume *models.SnapshotInlineProvenanceVolume `json:"provenance_volume,omitempty"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the active file system at the time the snapshot is captured. The actual size of the snapshot also includes those blocks trapped by other snapshots. On a snapshot deletion, the "size" amount of blocks is the maximum number of blocks available. On a snapshot restore, the "afs-used size" value will match the snapshot "size" value.
	// Example: 122880
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// snaplock
	Snaplock *models.SnapshotInlineSnaplock `json:"snaplock,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock volume. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. This field will no longer be supported in a future release. Use snaplock.expiry_time instead.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	SnaplockExpiryTime *strfmt.DateTime `json:"snaplock_expiry_time,omitempty"`

	// Label for SnapMirror operations
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// snapshot response inline records
	SnapshotResponseInlineRecords []*models.Snapshot `json:"records,omitempty"`

	// State of the FlexGroup volume snapshot. In the "pre_conversion" state, the snapshot was created before converting the FlexVol to a FlexGroup volume. A recently created snapshot can be in the "unknown" state while the system is calculating the state. In the "partial" state, the snapshot is consistent but exists only on the subset of the constituents that existed prior to the FlexGroup's expansion. Partial snapshots cannot be used for a snapshot restore operation. A snapshot is in an "invalid" state when it is present in some FlexGroup constituents but not in others. At all other times, a snapshot is valid.
	// Read Only: true
	// Enum: ["valid","invalid","partial","unknown","pre_conversion"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *models.SnapshotInlineSvm `json:"svm,omitempty"`

	// The UUID of the snapshot in the volume that uniquely identifies the snapshot in that volume.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Savings due vbn0 at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	Vbn0Savings *int64 `json:"vbn0_savings,omitempty"`

	// The 128 bit identifier that uniquely identifies a snapshot and its logical data layout.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	VersionUUID *string `json:"version_uuid,omitempty"`

	// volume
	Volume *models.SnapshotInlineVolume `json:"volume,omitempty"`
}

// Validate validates this snapshot modify collection body
func (o *SnapshotModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDelta(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwners(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvenanceVolume(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplockExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateDelta(formats strfmt.Registry) error {
	if swag.IsZero(o.Delta) { // not required
		return nil
	}

	if o.Delta != nil {
		if err := o.Delta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "delta")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapshotModifyCollectionBodyOwnersItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","snapmirror","snapmirror_dependent","sync_mirror","volume_clone","volume_clone_dependent","snap_restore","snap_restore_dependent","dump","cifs_share","volume_copy","ndmp","worm_volume","sis_clone","s2c_iron","lun_clone","backup_dependent","snaplock_dependent","file_clone_dependent","volume_move_dependent","svmdr_dependent","anti_ransomware_backup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapshotModifyCollectionBodyOwnersItemsEnum = append(snapshotModifyCollectionBodyOwnersItemsEnum, v)
	}
}

func (o *SnapshotModifyCollectionBody) validateOwnersItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapshotModifyCollectionBodyOwnersItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapshotModifyCollectionBody) validateOwners(formats strfmt.Registry) error {
	if swag.IsZero(o.Owners) { // not required
		return nil
	}

	for i := 0; i < len(o.Owners); i++ {
		if swag.IsZero(o.Owners[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateOwnersItemsEnum("info"+"."+"owners"+"."+strconv.Itoa(i), "body", *o.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateProvenanceVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvenanceVolume) { // not required
		return nil
	}

	if o.ProvenanceVolume != nil {
		if err := o.ProvenanceVolume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provenance_volume")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateSnaplockExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snaplock_expiry_time", "body", "date-time", o.SnaplockExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapshotResponseInlineRecords[i] != nil {
			if err := o.SnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var snapshotModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["valid","invalid","partial","unknown","pre_conversion"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapshotModifyCollectionBodyTypeStatePropEnum = append(snapshotModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapshotModifyCollectionBody
	// SnapshotModifyCollectionBody
	// state
	// State
	// valid
	// END DEBUGGING
	// SnapshotModifyCollectionBodyStateValid captures enum value "valid"
	SnapshotModifyCollectionBodyStateValid string = "valid"

	// BEGIN DEBUGGING
	// SnapshotModifyCollectionBody
	// SnapshotModifyCollectionBody
	// state
	// State
	// invalid
	// END DEBUGGING
	// SnapshotModifyCollectionBodyStateInvalid captures enum value "invalid"
	SnapshotModifyCollectionBodyStateInvalid string = "invalid"

	// BEGIN DEBUGGING
	// SnapshotModifyCollectionBody
	// SnapshotModifyCollectionBody
	// state
	// State
	// partial
	// END DEBUGGING
	// SnapshotModifyCollectionBodyStatePartial captures enum value "partial"
	SnapshotModifyCollectionBodyStatePartial string = "partial"

	// BEGIN DEBUGGING
	// SnapshotModifyCollectionBody
	// SnapshotModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// SnapshotModifyCollectionBodyStateUnknown captures enum value "unknown"
	SnapshotModifyCollectionBodyStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// SnapshotModifyCollectionBody
	// SnapshotModifyCollectionBody
	// state
	// State
	// pre_conversion
	// END DEBUGGING
	// SnapshotModifyCollectionBodyStatePreConversion captures enum value "pre_conversion"
	SnapshotModifyCollectionBodyStatePreConversion string = "pre_conversion"
)

// prop value enum
func (o *SnapshotModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapshotModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapshotModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot modify collection body based on the context it is used
func (o *SnapshotModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCompressSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDedupSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDelta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvenanceVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVbn0Savings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersionUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateCompressSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"compress_savings", "body", o.CompressSavings); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateDedupSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"dedup_savings", "body", o.DedupSavings); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateDelta(ctx context.Context, formats strfmt.Registry) error {

	if o.Delta != nil {
		if err := o.Delta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "delta")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateLogicalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"logical_size", "body", o.LogicalSize); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateOwners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owners", "body", []*string(o.Owners)); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateProvenanceVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvenanceVolume != nil {
		if err := o.ProvenanceVolume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provenance_volume")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapshotResponseInlineRecords); i++ {

		if o.SnapshotResponseInlineRecords[i] != nil {
			if err := o.SnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateVbn0Savings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"vbn0_savings", "body", o.Vbn0Savings); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateVersionUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version_uuid", "body", o.VersionUUID); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapshotModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineLinks snapshot inline links
swagger:model snapshot_inline__links
*/
type SnapshotInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline links
func (o *SnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline links based on the context it is used
func (o *SnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineProvenanceVolume snapshot inline provenance volume
swagger:model snapshot_inline_provenance_volume
*/
type SnapshotInlineProvenanceVolume struct {

	// UUID for the volume that is used to identify the source volume in a mirroring relationship. When the mirroring relationship is broken, a volume's Instance UUID and Provenance UUID are made identical. An unmirrored volume's Provenance UUID is the same as its Instance UUID. This field is valid for flexible volumes only.
	// Example: 4cd8a442-86d1-11e0-ae1c-125648563413
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline provenance volume
func (o *SnapshotInlineProvenanceVolume) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this snapshot inline provenance volume based on the context it is used
func (o *SnapshotInlineProvenanceVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineProvenanceVolume) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"provenance_volume"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineProvenanceVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineProvenanceVolume) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineProvenanceVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineSnaplock snapshot inline snaplock
swagger:model snapshot_inline_snaplock
*/
type SnapshotInlineSnaplock struct {

	// Indicates whether a SnapLock snapshot has expired.
	// Example: true
	// Read Only: true
	Expired *bool `json:"expired,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock volume. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. It can also be used to extend the expiry time of a locked snapshot on a SnapLock for SnapVault destination consistency-group.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates the remaining SnapLock expiry time of a locked snapshot, in seconds. This field is set only when the remaining time interval is less than 136 years.
	// Example: PT3H27M45S
	// Read Only: true
	TimeUntilExpiry *string `json:"time_until_expiry,omitempty"`
}

// Validate validates this snapshot inline snaplock
func (o *SnapshotInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snaplock"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapshot inline snaplock based on the context it is used
func (o *SnapshotInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimeUntilExpiry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSnaplock) contextValidateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"expired", "body", o.Expired); err != nil {
		return err
	}

	return nil
}

func (o *SnapshotInlineSnaplock) contextValidateTimeUntilExpiry(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"time_until_expiry", "body", o.TimeUntilExpiry); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineSnaplock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model snapshot_inline_svm
*/
type SnapshotInlineSvm struct {

	// links
	Links *models.SnapshotInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline svm
func (o *SnapshotInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline svm based on the context it is used
func (o *SnapshotInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineSvmInlineLinks snapshot inline svm inline links
swagger:model snapshot_inline_svm_inline__links
*/
type SnapshotInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline svm inline links
func (o *SnapshotInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline svm inline links based on the context it is used
func (o *SnapshotInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineVolume snapshot inline volume
swagger:model snapshot_inline_volume
*/
type SnapshotInlineVolume struct {

	// links
	Links *models.SnapshotInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline volume
func (o *SnapshotInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline volume based on the context it is used
func (o *SnapshotInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineVolume) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapshotInlineVolumeInlineLinks snapshot inline volume inline links
swagger:model snapshot_inline_volume_inline__links
*/
type SnapshotInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline volume inline links
func (o *SnapshotInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline volume inline links based on the context it is used
func (o *SnapshotInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
