// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapshotPolicyCollectionGetParams creates a new SnapshotPolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotPolicyCollectionGetParams() *SnapshotPolicyCollectionGetParams {
	return &SnapshotPolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotPolicyCollectionGetParamsWithTimeout creates a new SnapshotPolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSnapshotPolicyCollectionGetParamsWithTimeout(timeout time.Duration) *SnapshotPolicyCollectionGetParams {
	return &SnapshotPolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewSnapshotPolicyCollectionGetParamsWithContext creates a new SnapshotPolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewSnapshotPolicyCollectionGetParamsWithContext(ctx context.Context) *SnapshotPolicyCollectionGetParams {
	return &SnapshotPolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewSnapshotPolicyCollectionGetParamsWithHTTPClient creates a new SnapshotPolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotPolicyCollectionGetParamsWithHTTPClient(client *http.Client) *SnapshotPolicyCollectionGetParams {
	return &SnapshotPolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SnapshotPolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the snapshot policy collection get operation.

	Typically these are written to a http.Request.
*/
type SnapshotPolicyCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* CopiesCount.

	   Filter by copies.count
	*/
	CopiesCount *int64

	/* CopiesPrefix.

	   Filter by copies.prefix
	*/
	CopiesPrefix *string

	/* CopiesRetentionPeriod.

	   Filter by copies.retention_period
	*/
	CopiesRetentionPeriod *string

	/* CopiesScheduleName.

	   Filter by copies.schedule.name
	*/
	CopiesScheduleName *string

	/* CopiesScheduleUUID.

	   Filter by copies.schedule.uuid
	*/
	CopiesScheduleUUID *string

	/* CopiesSnapmirrorLabel.

	   Filter by copies.snapmirror_label
	*/
	CopiesSnapmirrorLabel *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyCollectionGetParams) WithDefaults() *SnapshotPolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnapshotPolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithTimeout(timeout time.Duration) *SnapshotPolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithContext(ctx context.Context) *SnapshotPolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithHTTPClient(client *http.Client) *SnapshotPolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithComment(comment *string) *SnapshotPolicyCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithCopiesCount adds the copiesCount to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesCount(copiesCount *int64) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesCount(copiesCount)
	return o
}

// SetCopiesCount adds the copiesCount to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesCount(copiesCount *int64) {
	o.CopiesCount = copiesCount
}

// WithCopiesPrefix adds the copiesPrefix to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesPrefix(copiesPrefix *string) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesPrefix(copiesPrefix)
	return o
}

// SetCopiesPrefix adds the copiesPrefix to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesPrefix(copiesPrefix *string) {
	o.CopiesPrefix = copiesPrefix
}

// WithCopiesRetentionPeriod adds the copiesRetentionPeriod to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesRetentionPeriod(copiesRetentionPeriod *string) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesRetentionPeriod(copiesRetentionPeriod)
	return o
}

// SetCopiesRetentionPeriod adds the copiesRetentionPeriod to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesRetentionPeriod(copiesRetentionPeriod *string) {
	o.CopiesRetentionPeriod = copiesRetentionPeriod
}

// WithCopiesScheduleName adds the copiesScheduleName to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesScheduleName(copiesScheduleName *string) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesScheduleName(copiesScheduleName)
	return o
}

// SetCopiesScheduleName adds the copiesScheduleName to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesScheduleName(copiesScheduleName *string) {
	o.CopiesScheduleName = copiesScheduleName
}

// WithCopiesScheduleUUID adds the copiesScheduleUUID to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesScheduleUUID(copiesScheduleUUID *string) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesScheduleUUID(copiesScheduleUUID)
	return o
}

// SetCopiesScheduleUUID adds the copiesScheduleUuid to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesScheduleUUID(copiesScheduleUUID *string) {
	o.CopiesScheduleUUID = copiesScheduleUUID
}

// WithCopiesSnapmirrorLabel adds the copiesSnapmirrorLabel to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithCopiesSnapmirrorLabel(copiesSnapmirrorLabel *string) *SnapshotPolicyCollectionGetParams {
	o.SetCopiesSnapmirrorLabel(copiesSnapmirrorLabel)
	return o
}

// SetCopiesSnapmirrorLabel adds the copiesSnapmirrorLabel to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetCopiesSnapmirrorLabel(copiesSnapmirrorLabel *string) {
	o.CopiesSnapmirrorLabel = copiesSnapmirrorLabel
}

// WithEnabled adds the enabled to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithEnabled(enabled *bool) *SnapshotPolicyCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithFields(fields []string) *SnapshotPolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *SnapshotPolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithName(name *string) *SnapshotPolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithOrderBy(orderBy []string) *SnapshotPolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *SnapshotPolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SnapshotPolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithScope(scope *string) *SnapshotPolicyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithSvmName(svmName *string) *SnapshotPolicyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithSvmUUID(svmUUID *string) *SnapshotPolicyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) WithUUID(uuid *string) *SnapshotPolicyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapshot policy collection get params
func (o *SnapshotPolicyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotPolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.CopiesCount != nil {

		// query param copies.count
		var qrCopiesCount int64

		if o.CopiesCount != nil {
			qrCopiesCount = *o.CopiesCount
		}
		qCopiesCount := swag.FormatInt64(qrCopiesCount)
		if qCopiesCount != "" {

			if err := r.SetQueryParam("copies.count", qCopiesCount); err != nil {
				return err
			}
		}
	}

	if o.CopiesPrefix != nil {

		// query param copies.prefix
		var qrCopiesPrefix string

		if o.CopiesPrefix != nil {
			qrCopiesPrefix = *o.CopiesPrefix
		}
		qCopiesPrefix := qrCopiesPrefix
		if qCopiesPrefix != "" {

			if err := r.SetQueryParam("copies.prefix", qCopiesPrefix); err != nil {
				return err
			}
		}
	}

	if o.CopiesRetentionPeriod != nil {

		// query param copies.retention_period
		var qrCopiesRetentionPeriod string

		if o.CopiesRetentionPeriod != nil {
			qrCopiesRetentionPeriod = *o.CopiesRetentionPeriod
		}
		qCopiesRetentionPeriod := qrCopiesRetentionPeriod
		if qCopiesRetentionPeriod != "" {

			if err := r.SetQueryParam("copies.retention_period", qCopiesRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.CopiesScheduleName != nil {

		// query param copies.schedule.name
		var qrCopiesScheduleName string

		if o.CopiesScheduleName != nil {
			qrCopiesScheduleName = *o.CopiesScheduleName
		}
		qCopiesScheduleName := qrCopiesScheduleName
		if qCopiesScheduleName != "" {

			if err := r.SetQueryParam("copies.schedule.name", qCopiesScheduleName); err != nil {
				return err
			}
		}
	}

	if o.CopiesScheduleUUID != nil {

		// query param copies.schedule.uuid
		var qrCopiesScheduleUUID string

		if o.CopiesScheduleUUID != nil {
			qrCopiesScheduleUUID = *o.CopiesScheduleUUID
		}
		qCopiesScheduleUUID := qrCopiesScheduleUUID
		if qCopiesScheduleUUID != "" {

			if err := r.SetQueryParam("copies.schedule.uuid", qCopiesScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.CopiesSnapmirrorLabel != nil {

		// query param copies.snapmirror_label
		var qrCopiesSnapmirrorLabel string

		if o.CopiesSnapmirrorLabel != nil {
			qrCopiesSnapmirrorLabel = *o.CopiesSnapmirrorLabel
		}
		qCopiesSnapmirrorLabel := qrCopiesSnapmirrorLabel
		if qCopiesSnapmirrorLabel != "" {

			if err := r.SetQueryParam("copies.snapmirror_label", qCopiesSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnapshotPolicyCollectionGet binds the parameter fields
func (o *SnapshotPolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnapshotPolicyCollectionGet binds the parameter order_by
func (o *SnapshotPolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
