// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnapshotPolicyCreateParams creates a new SnapshotPolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotPolicyCreateParams() *SnapshotPolicyCreateParams {
	return &SnapshotPolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotPolicyCreateParamsWithTimeout creates a new SnapshotPolicyCreateParams object
// with the ability to set a timeout on a request.
func NewSnapshotPolicyCreateParamsWithTimeout(timeout time.Duration) *SnapshotPolicyCreateParams {
	return &SnapshotPolicyCreateParams{
		timeout: timeout,
	}
}

// NewSnapshotPolicyCreateParamsWithContext creates a new SnapshotPolicyCreateParams object
// with the ability to set a context for a request.
func NewSnapshotPolicyCreateParamsWithContext(ctx context.Context) *SnapshotPolicyCreateParams {
	return &SnapshotPolicyCreateParams{
		Context: ctx,
	}
}

// NewSnapshotPolicyCreateParamsWithHTTPClient creates a new SnapshotPolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotPolicyCreateParamsWithHTTPClient(client *http.Client) *SnapshotPolicyCreateParams {
	return &SnapshotPolicyCreateParams{
		HTTPClient: client,
	}
}

/*
SnapshotPolicyCreateParams contains all the parameters to send to the API endpoint

	for the snapshot policy create operation.

	Typically these are written to a http.Request.
*/
type SnapshotPolicyCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SnapshotPolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyCreateParams) WithDefaults() *SnapshotPolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SnapshotPolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) WithTimeout(timeout time.Duration) *SnapshotPolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) WithContext(ctx context.Context) *SnapshotPolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) WithHTTPClient(client *http.Client) *SnapshotPolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) WithInfo(info *models.SnapshotPolicy) *SnapshotPolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) SetInfo(info *models.SnapshotPolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) WithReturnRecords(returnRecords *bool) *SnapshotPolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapshot policy create params
func (o *SnapshotPolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotPolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
