// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyCreateReader is a Reader for the SnapshotPolicyCreate structure.
type SnapshotPolicyCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSnapshotPolicyCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyCreateCreated creates a SnapshotPolicyCreateCreated with default headers values
func NewSnapshotPolicyCreateCreated() *SnapshotPolicyCreateCreated {
	return &SnapshotPolicyCreateCreated{}
}

/*
SnapshotPolicyCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SnapshotPolicyCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this snapshot policy create created response has a 2xx status code
func (o *SnapshotPolicyCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy create created response has a 3xx status code
func (o *SnapshotPolicyCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy create created response has a 4xx status code
func (o *SnapshotPolicyCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy create created response has a 5xx status code
func (o *SnapshotPolicyCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy create created response a status code equal to that given
func (o *SnapshotPolicyCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the snapshot policy create created response
func (o *SnapshotPolicyCreateCreated) Code() int {
	return 201
}

func (o *SnapshotPolicyCreateCreated) Error() string {
	return fmt.Sprintf("[POST /storage/snapshot-policies][%d] snapshotPolicyCreateCreated", 201)
}

func (o *SnapshotPolicyCreateCreated) String() string {
	return fmt.Sprintf("[POST /storage/snapshot-policies][%d] snapshotPolicyCreateCreated", 201)
}

func (o *SnapshotPolicyCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewSnapshotPolicyCreateDefault creates a SnapshotPolicyCreateDefault with default headers values
func NewSnapshotPolicyCreateDefault(code int) *SnapshotPolicyCreateDefault {
	return &SnapshotPolicyCreateDefault{
		_statusCode: code,
	}
}

/*
	SnapshotPolicyCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1638407    | When adding schedule to a snapshot policy, the count for that schedule must be specified. |
| 1638408    | When adding schedule to a snapshot policy, the schedule name must be specified. |
| 1638413    | Schedule not found. |
| 1638417    | Specified policy name is invalid. |
| 1638451    | This operation would result in total snapshot count for the policy to exceed maximum supported count. |
| 1638506    | Schedule already has a prefix. Cannot associate another prefix to the same schedule. |
| 1638508    | Another schedule has the same prefix within this policy. |
| 1638526    | This operation is not supported on a node Vserver. |
| 1638527    | Policy name already exists. |
| 1638528    | This operation is not supported in a mixed-version cluster. |
| 1638531    | This operation is not supported because specified policy is owned by the cluster admin. |
| 2621706    | The specified SVM UUID and SVM name refer to different SVMs. |
| 918253     | Incorrect format for the retention period, duration must be in the ISO-8601 format. |
*/
type SnapshotPolicyCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy create default response has a 2xx status code
func (o *SnapshotPolicyCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy create default response has a 3xx status code
func (o *SnapshotPolicyCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy create default response has a 4xx status code
func (o *SnapshotPolicyCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy create default response has a 5xx status code
func (o *SnapshotPolicyCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy create default response a status code equal to that given
func (o *SnapshotPolicyCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy create default response
func (o *SnapshotPolicyCreateDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/snapshot-policies][%d] snapshot_policy_create default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/snapshot-policies][%d] snapshot_policy_create default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
