// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapshotPolicyDeleteCollectionParams creates a new SnapshotPolicyDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotPolicyDeleteCollectionParams() *SnapshotPolicyDeleteCollectionParams {
	return &SnapshotPolicyDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotPolicyDeleteCollectionParamsWithTimeout creates a new SnapshotPolicyDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSnapshotPolicyDeleteCollectionParamsWithTimeout(timeout time.Duration) *SnapshotPolicyDeleteCollectionParams {
	return &SnapshotPolicyDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSnapshotPolicyDeleteCollectionParamsWithContext creates a new SnapshotPolicyDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSnapshotPolicyDeleteCollectionParamsWithContext(ctx context.Context) *SnapshotPolicyDeleteCollectionParams {
	return &SnapshotPolicyDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSnapshotPolicyDeleteCollectionParamsWithHTTPClient creates a new SnapshotPolicyDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotPolicyDeleteCollectionParamsWithHTTPClient(client *http.Client) *SnapshotPolicyDeleteCollectionParams {
	return &SnapshotPolicyDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SnapshotPolicyDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the snapshot policy delete collection operation.

	Typically these are written to a http.Request.
*/
type SnapshotPolicyDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CopiesCount.

	   Filter by copies.count
	*/
	CopiesCount *int64

	/* CopiesPrefix.

	   Filter by copies.prefix
	*/
	CopiesPrefix *string

	/* CopiesRetentionPeriod.

	   Filter by copies.retention_period
	*/
	CopiesRetentionPeriod *string

	/* CopiesScheduleName.

	   Filter by copies.schedule.name
	*/
	CopiesScheduleName *string

	/* CopiesScheduleUUID.

	   Filter by copies.schedule.uuid
	*/
	CopiesScheduleUUID *string

	/* CopiesSnapmirrorLabel.

	   Filter by copies.snapmirror_label
	*/
	CopiesSnapmirrorLabel *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info SnapshotPolicyDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot policy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyDeleteCollectionParams) WithDefaults() *SnapshotPolicyDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot policy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SnapshotPolicyDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithTimeout(timeout time.Duration) *SnapshotPolicyDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithContext(ctx context.Context) *SnapshotPolicyDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithHTTPClient(client *http.Client) *SnapshotPolicyDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithComment(comment *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SnapshotPolicyDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCopiesCount adds the copiesCount to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesCount(copiesCount *int64) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesCount(copiesCount)
	return o
}

// SetCopiesCount adds the copiesCount to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesCount(copiesCount *int64) {
	o.CopiesCount = copiesCount
}

// WithCopiesPrefix adds the copiesPrefix to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesPrefix(copiesPrefix *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesPrefix(copiesPrefix)
	return o
}

// SetCopiesPrefix adds the copiesPrefix to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesPrefix(copiesPrefix *string) {
	o.CopiesPrefix = copiesPrefix
}

// WithCopiesRetentionPeriod adds the copiesRetentionPeriod to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesRetentionPeriod(copiesRetentionPeriod *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesRetentionPeriod(copiesRetentionPeriod)
	return o
}

// SetCopiesRetentionPeriod adds the copiesRetentionPeriod to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesRetentionPeriod(copiesRetentionPeriod *string) {
	o.CopiesRetentionPeriod = copiesRetentionPeriod
}

// WithCopiesScheduleName adds the copiesScheduleName to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesScheduleName(copiesScheduleName *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesScheduleName(copiesScheduleName)
	return o
}

// SetCopiesScheduleName adds the copiesScheduleName to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesScheduleName(copiesScheduleName *string) {
	o.CopiesScheduleName = copiesScheduleName
}

// WithCopiesScheduleUUID adds the copiesScheduleUUID to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesScheduleUUID(copiesScheduleUUID *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesScheduleUUID(copiesScheduleUUID)
	return o
}

// SetCopiesScheduleUUID adds the copiesScheduleUuid to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesScheduleUUID(copiesScheduleUUID *string) {
	o.CopiesScheduleUUID = copiesScheduleUUID
}

// WithCopiesSnapmirrorLabel adds the copiesSnapmirrorLabel to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithCopiesSnapmirrorLabel(copiesSnapmirrorLabel *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetCopiesSnapmirrorLabel(copiesSnapmirrorLabel)
	return o
}

// SetCopiesSnapmirrorLabel adds the copiesSnapmirrorLabel to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetCopiesSnapmirrorLabel(copiesSnapmirrorLabel *string) {
	o.CopiesSnapmirrorLabel = copiesSnapmirrorLabel
}

// WithEnabled adds the enabled to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithEnabled(enabled *bool) *SnapshotPolicyDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithInfo(info SnapshotPolicyDeleteCollectionBody) *SnapshotPolicyDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetInfo(info SnapshotPolicyDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithName(name *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SnapshotPolicyDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SnapshotPolicyDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithScope(scope *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SnapshotPolicyDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithSvmName(svmName *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithSvmUUID(svmUUID *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) WithUUID(uuid *string) *SnapshotPolicyDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapshot policy delete collection params
func (o *SnapshotPolicyDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotPolicyDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CopiesCount != nil {

		// query param copies.count
		var qrCopiesCount int64

		if o.CopiesCount != nil {
			qrCopiesCount = *o.CopiesCount
		}
		qCopiesCount := swag.FormatInt64(qrCopiesCount)
		if qCopiesCount != "" {

			if err := r.SetQueryParam("copies.count", qCopiesCount); err != nil {
				return err
			}
		}
	}

	if o.CopiesPrefix != nil {

		// query param copies.prefix
		var qrCopiesPrefix string

		if o.CopiesPrefix != nil {
			qrCopiesPrefix = *o.CopiesPrefix
		}
		qCopiesPrefix := qrCopiesPrefix
		if qCopiesPrefix != "" {

			if err := r.SetQueryParam("copies.prefix", qCopiesPrefix); err != nil {
				return err
			}
		}
	}

	if o.CopiesRetentionPeriod != nil {

		// query param copies.retention_period
		var qrCopiesRetentionPeriod string

		if o.CopiesRetentionPeriod != nil {
			qrCopiesRetentionPeriod = *o.CopiesRetentionPeriod
		}
		qCopiesRetentionPeriod := qrCopiesRetentionPeriod
		if qCopiesRetentionPeriod != "" {

			if err := r.SetQueryParam("copies.retention_period", qCopiesRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.CopiesScheduleName != nil {

		// query param copies.schedule.name
		var qrCopiesScheduleName string

		if o.CopiesScheduleName != nil {
			qrCopiesScheduleName = *o.CopiesScheduleName
		}
		qCopiesScheduleName := qrCopiesScheduleName
		if qCopiesScheduleName != "" {

			if err := r.SetQueryParam("copies.schedule.name", qCopiesScheduleName); err != nil {
				return err
			}
		}
	}

	if o.CopiesScheduleUUID != nil {

		// query param copies.schedule.uuid
		var qrCopiesScheduleUUID string

		if o.CopiesScheduleUUID != nil {
			qrCopiesScheduleUUID = *o.CopiesScheduleUUID
		}
		qCopiesScheduleUUID := qrCopiesScheduleUUID
		if qCopiesScheduleUUID != "" {

			if err := r.SetQueryParam("copies.schedule.uuid", qCopiesScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.CopiesSnapmirrorLabel != nil {

		// query param copies.snapmirror_label
		var qrCopiesSnapmirrorLabel string

		if o.CopiesSnapmirrorLabel != nil {
			qrCopiesSnapmirrorLabel = *o.CopiesSnapmirrorLabel
		}
		qCopiesSnapmirrorLabel := qrCopiesSnapmirrorLabel
		if qCopiesSnapmirrorLabel != "" {

			if err := r.SetQueryParam("copies.snapmirror_label", qCopiesSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
