// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyDeleteCollectionReader is a Reader for the SnapshotPolicyDeleteCollection structure.
type SnapshotPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyDeleteCollectionOK creates a SnapshotPolicyDeleteCollectionOK with default headers values
func NewSnapshotPolicyDeleteCollectionOK() *SnapshotPolicyDeleteCollectionOK {
	return &SnapshotPolicyDeleteCollectionOK{}
}

/*
SnapshotPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this snapshot policy delete collection o k response has a 2xx status code
func (o *SnapshotPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy delete collection o k response has a 3xx status code
func (o *SnapshotPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy delete collection o k response has a 4xx status code
func (o *SnapshotPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy delete collection o k response has a 5xx status code
func (o *SnapshotPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy delete collection o k response a status code equal to that given
func (o *SnapshotPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot policy delete collection o k response
func (o *SnapshotPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnapshotPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies][%d] snapshotPolicyDeleteCollectionOK", 200)
}

func (o *SnapshotPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies][%d] snapshotPolicyDeleteCollectionOK", 200)
}

func (o *SnapshotPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapshotPolicyDeleteCollectionDefault creates a SnapshotPolicyDeleteCollectionDefault with default headers values
func NewSnapshotPolicyDeleteCollectionDefault(code int) *SnapshotPolicyDeleteCollectionDefault {
	return &SnapshotPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapshotPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 1638415    | Cannot delete policy. Reason: Policy is in use by at least one volume. |
| 1638416    | Cannot delete policy. Reason: Cannot verify whether policy is in use. |
| 1638430    | Cannot delete policy. Reason: Policy is in use by at least one Vserver. |
| 1638431    | Cannot delete built-in policy. |
*/
type SnapshotPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy delete collection default response has a 2xx status code
func (o *SnapshotPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy delete collection default response has a 3xx status code
func (o *SnapshotPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy delete collection default response has a 4xx status code
func (o *SnapshotPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy delete collection default response has a 5xx status code
func (o *SnapshotPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy delete collection default response a status code equal to that given
func (o *SnapshotPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy delete collection default response
func (o *SnapshotPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies][%d] snapshot_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies][%d] snapshot_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapshotPolicyDeleteCollectionBody snapshot policy delete collection body
swagger:model SnapshotPolicyDeleteCollectionBody
*/
type SnapshotPolicyDeleteCollectionBody struct {

	// snapshot policy response inline records
	SnapshotPolicyResponseInlineRecords []*models.SnapshotPolicy `json:"records,omitempty"`
}

// Validate validates this snapshot policy delete collection body
func (o *SnapshotPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshotPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotPolicyDeleteCollectionBody) validateSnapshotPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapshotPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapshotPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapshotPolicyResponseInlineRecords[i] != nil {
			if err := o.SnapshotPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snapshot policy delete collection body based on the context it is used
func (o *SnapshotPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshotPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotPolicyDeleteCollectionBody) contextValidateSnapshotPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapshotPolicyResponseInlineRecords); i++ {

		if o.SnapshotPolicyResponseInlineRecords[i] != nil {
			if err := o.SnapshotPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapshotPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
