// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapshotPolicyGetParams creates a new SnapshotPolicyGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotPolicyGetParams() *SnapshotPolicyGetParams {
	return &SnapshotPolicyGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotPolicyGetParamsWithTimeout creates a new SnapshotPolicyGetParams object
// with the ability to set a timeout on a request.
func NewSnapshotPolicyGetParamsWithTimeout(timeout time.Duration) *SnapshotPolicyGetParams {
	return &SnapshotPolicyGetParams{
		timeout: timeout,
	}
}

// NewSnapshotPolicyGetParamsWithContext creates a new SnapshotPolicyGetParams object
// with the ability to set a context for a request.
func NewSnapshotPolicyGetParamsWithContext(ctx context.Context) *SnapshotPolicyGetParams {
	return &SnapshotPolicyGetParams{
		Context: ctx,
	}
}

// NewSnapshotPolicyGetParamsWithHTTPClient creates a new SnapshotPolicyGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotPolicyGetParamsWithHTTPClient(client *http.Client) *SnapshotPolicyGetParams {
	return &SnapshotPolicyGetParams{
		HTTPClient: client,
	}
}

/*
SnapshotPolicyGetParams contains all the parameters to send to the API endpoint

	for the snapshot policy get operation.

	Typically these are written to a http.Request.
*/
type SnapshotPolicyGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Snapshot policy UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyGetParams) WithDefaults() *SnapshotPolicyGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the snapshot policy get params
func (o *SnapshotPolicyGetParams) WithTimeout(timeout time.Duration) *SnapshotPolicyGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot policy get params
func (o *SnapshotPolicyGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot policy get params
func (o *SnapshotPolicyGetParams) WithContext(ctx context.Context) *SnapshotPolicyGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot policy get params
func (o *SnapshotPolicyGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot policy get params
func (o *SnapshotPolicyGetParams) WithHTTPClient(client *http.Client) *SnapshotPolicyGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot policy get params
func (o *SnapshotPolicyGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the snapshot policy get params
func (o *SnapshotPolicyGetParams) WithFields(fields []string) *SnapshotPolicyGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snapshot policy get params
func (o *SnapshotPolicyGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the snapshot policy get params
func (o *SnapshotPolicyGetParams) WithUUID(uuid string) *SnapshotPolicyGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapshot policy get params
func (o *SnapshotPolicyGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotPolicyGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnapshotPolicyGet binds the parameter fields
func (o *SnapshotPolicyGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
