// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyModifyReader is a Reader for the SnapshotPolicyModify structure.
type SnapshotPolicyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotPolicyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyModifyOK creates a SnapshotPolicyModifyOK with default headers values
func NewSnapshotPolicyModifyOK() *SnapshotPolicyModifyOK {
	return &SnapshotPolicyModifyOK{}
}

/*
SnapshotPolicyModifyOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotPolicyModifyOK struct {
}

// IsSuccess returns true when this snapshot policy modify o k response has a 2xx status code
func (o *SnapshotPolicyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy modify o k response has a 3xx status code
func (o *SnapshotPolicyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy modify o k response has a 4xx status code
func (o *SnapshotPolicyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy modify o k response has a 5xx status code
func (o *SnapshotPolicyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy modify o k response a status code equal to that given
func (o *SnapshotPolicyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot policy modify o k response
func (o *SnapshotPolicyModifyOK) Code() int {
	return 200
}

func (o *SnapshotPolicyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/snapshot-policies/{uuid}][%d] snapshotPolicyModifyOK", 200)
}

func (o *SnapshotPolicyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/snapshot-policies/{uuid}][%d] snapshotPolicyModifyOK", 200)
}

func (o *SnapshotPolicyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapshotPolicyModifyDefault creates a SnapshotPolicyModifyDefault with default headers values
func NewSnapshotPolicyModifyDefault(code int) *SnapshotPolicyModifyDefault {
	return &SnapshotPolicyModifyDefault{
		_statusCode: code,
	}
}

/*
	SnapshotPolicyModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 1638414    | Cannot enable policy. Reason: Schedule not found. |
*/
type SnapshotPolicyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy modify default response has a 2xx status code
func (o *SnapshotPolicyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy modify default response has a 3xx status code
func (o *SnapshotPolicyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy modify default response has a 4xx status code
func (o *SnapshotPolicyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy modify default response has a 5xx status code
func (o *SnapshotPolicyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy modify default response a status code equal to that given
func (o *SnapshotPolicyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy modify default response
func (o *SnapshotPolicyModifyDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snapshot-policies/{uuid}][%d] snapshot_policy_modify default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snapshot-policies/{uuid}][%d] snapshot_policy_modify default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
