// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapshotPolicyScheduleCollectionGetParams creates a new SnapshotPolicyScheduleCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapshotPolicyScheduleCollectionGetParams() *SnapshotPolicyScheduleCollectionGetParams {
	return &SnapshotPolicyScheduleCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapshotPolicyScheduleCollectionGetParamsWithTimeout creates a new SnapshotPolicyScheduleCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSnapshotPolicyScheduleCollectionGetParamsWithTimeout(timeout time.Duration) *SnapshotPolicyScheduleCollectionGetParams {
	return &SnapshotPolicyScheduleCollectionGetParams{
		timeout: timeout,
	}
}

// NewSnapshotPolicyScheduleCollectionGetParamsWithContext creates a new SnapshotPolicyScheduleCollectionGetParams object
// with the ability to set a context for a request.
func NewSnapshotPolicyScheduleCollectionGetParamsWithContext(ctx context.Context) *SnapshotPolicyScheduleCollectionGetParams {
	return &SnapshotPolicyScheduleCollectionGetParams{
		Context: ctx,
	}
}

// NewSnapshotPolicyScheduleCollectionGetParamsWithHTTPClient creates a new SnapshotPolicyScheduleCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapshotPolicyScheduleCollectionGetParamsWithHTTPClient(client *http.Client) *SnapshotPolicyScheduleCollectionGetParams {
	return &SnapshotPolicyScheduleCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SnapshotPolicyScheduleCollectionGetParams contains all the parameters to send to the API endpoint

	for the snapshot policy schedule collection get operation.

	Typically these are written to a http.Request.
*/
type SnapshotPolicyScheduleCollectionGetParams struct {

	/* Count.

	   Filter by count
	*/
	Count *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Prefix.

	   Filter by prefix
	*/
	Prefix *string

	/* RetentionPeriod.

	   Filter by retention_period
	*/
	RetentionPeriod *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScheduleName.

	   Filter by schedule.name
	*/
	ScheduleName *string

	/* ScheduleUUID.

	   Filter by schedule.uuid
	*/
	ScheduleUUID *string

	/* SnapmirrorLabel.

	   Filter by snapmirror_label
	*/
	SnapmirrorLabel *string

	/* SnapshotPolicyName.

	   Filter by snapshot_policy.name
	*/
	SnapshotPolicyName *string

	/* SnapshotPolicyUUID.

	   Snapshot policy UUID
	*/
	SnapshotPolicyUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapshot policy schedule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyScheduleCollectionGetParams) WithDefaults() *SnapshotPolicyScheduleCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapshot policy schedule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapshotPolicyScheduleCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnapshotPolicyScheduleCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithTimeout(timeout time.Duration) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithContext(ctx context.Context) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithHTTPClient(client *http.Client) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCount adds the count to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithCount(count *int64) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetCount(count)
	return o
}

// SetCount adds the count to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetCount(count *int64) {
	o.Count = count
}

// WithFields adds the fields to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithFields(fields []string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithMaxRecords(maxRecords *int64) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithOrderBy(orderBy []string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPrefix adds the prefix to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithPrefix(prefix *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetPrefix(prefix)
	return o
}

// SetPrefix adds the prefix to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetPrefix(prefix *string) {
	o.Prefix = prefix
}

// WithRetentionPeriod adds the retentionPeriod to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithRetentionPeriod(retentionPeriod *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetRetentionPeriod(retentionPeriod)
	return o
}

// SetRetentionPeriod adds the retentionPeriod to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetRetentionPeriod(retentionPeriod *string) {
	o.RetentionPeriod = retentionPeriod
}

// WithReturnRecords adds the returnRecords to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithReturnRecords(returnRecords *bool) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScheduleName adds the scheduleName to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithScheduleName(scheduleName *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetScheduleName(scheduleName)
	return o
}

// SetScheduleName adds the scheduleName to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetScheduleName(scheduleName *string) {
	o.ScheduleName = scheduleName
}

// WithScheduleUUID adds the scheduleUUID to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithScheduleUUID(scheduleUUID *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetScheduleUUID(scheduleUUID)
	return o
}

// SetScheduleUUID adds the scheduleUuid to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetScheduleUUID(scheduleUUID *string) {
	o.ScheduleUUID = scheduleUUID
}

// WithSnapmirrorLabel adds the snapmirrorLabel to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithSnapmirrorLabel(snapmirrorLabel *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetSnapmirrorLabel(snapmirrorLabel)
	return o
}

// SetSnapmirrorLabel adds the snapmirrorLabel to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetSnapmirrorLabel(snapmirrorLabel *string) {
	o.SnapmirrorLabel = snapmirrorLabel
}

// WithSnapshotPolicyName adds the snapshotPolicyName to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithSnapshotPolicyName(snapshotPolicyName *string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetSnapshotPolicyName(snapshotPolicyName)
	return o
}

// SetSnapshotPolicyName adds the snapshotPolicyName to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetSnapshotPolicyName(snapshotPolicyName *string) {
	o.SnapshotPolicyName = snapshotPolicyName
}

// WithSnapshotPolicyUUID adds the snapshotPolicyUUID to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) WithSnapshotPolicyUUID(snapshotPolicyUUID string) *SnapshotPolicyScheduleCollectionGetParams {
	o.SetSnapshotPolicyUUID(snapshotPolicyUUID)
	return o
}

// SetSnapshotPolicyUUID adds the snapshotPolicyUuid to the snapshot policy schedule collection get params
func (o *SnapshotPolicyScheduleCollectionGetParams) SetSnapshotPolicyUUID(snapshotPolicyUUID string) {
	o.SnapshotPolicyUUID = snapshotPolicyUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnapshotPolicyScheduleCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Count != nil {

		// query param count
		var qrCount int64

		if o.Count != nil {
			qrCount = *o.Count
		}
		qCount := swag.FormatInt64(qrCount)
		if qCount != "" {

			if err := r.SetQueryParam("count", qCount); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Prefix != nil {

		// query param prefix
		var qrPrefix string

		if o.Prefix != nil {
			qrPrefix = *o.Prefix
		}
		qPrefix := qrPrefix
		if qPrefix != "" {

			if err := r.SetQueryParam("prefix", qPrefix); err != nil {
				return err
			}
		}
	}

	if o.RetentionPeriod != nil {

		// query param retention_period
		var qrRetentionPeriod string

		if o.RetentionPeriod != nil {
			qrRetentionPeriod = *o.RetentionPeriod
		}
		qRetentionPeriod := qrRetentionPeriod
		if qRetentionPeriod != "" {

			if err := r.SetQueryParam("retention_period", qRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScheduleName != nil {

		// query param schedule.name
		var qrScheduleName string

		if o.ScheduleName != nil {
			qrScheduleName = *o.ScheduleName
		}
		qScheduleName := qrScheduleName
		if qScheduleName != "" {

			if err := r.SetQueryParam("schedule.name", qScheduleName); err != nil {
				return err
			}
		}
	}

	if o.ScheduleUUID != nil {

		// query param schedule.uuid
		var qrScheduleUUID string

		if o.ScheduleUUID != nil {
			qrScheduleUUID = *o.ScheduleUUID
		}
		qScheduleUUID := qrScheduleUUID
		if qScheduleUUID != "" {

			if err := r.SetQueryParam("schedule.uuid", qScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorLabel != nil {

		// query param snapmirror_label
		var qrSnapmirrorLabel string

		if o.SnapmirrorLabel != nil {
			qrSnapmirrorLabel = *o.SnapmirrorLabel
		}
		qSnapmirrorLabel := qrSnapmirrorLabel
		if qSnapmirrorLabel != "" {

			if err := r.SetQueryParam("snapmirror_label", qSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyName != nil {

		// query param snapshot_policy.name
		var qrSnapshotPolicyName string

		if o.SnapshotPolicyName != nil {
			qrSnapshotPolicyName = *o.SnapshotPolicyName
		}
		qSnapshotPolicyName := qrSnapshotPolicyName
		if qSnapshotPolicyName != "" {

			if err := r.SetQueryParam("snapshot_policy.name", qSnapshotPolicyName); err != nil {
				return err
			}
		}
	}

	// path param snapshot_policy.uuid
	if err := r.SetPathParam("snapshot_policy.uuid", o.SnapshotPolicyUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnapshotPolicyScheduleCollectionGet binds the parameter fields
func (o *SnapshotPolicyScheduleCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnapshotPolicyScheduleCollectionGet binds the parameter order_by
func (o *SnapshotPolicyScheduleCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
