// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyScheduleDeleteCollectionReader is a Reader for the SnapshotPolicyScheduleDeleteCollection structure.
type SnapshotPolicyScheduleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyScheduleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotPolicyScheduleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyScheduleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyScheduleDeleteCollectionOK creates a SnapshotPolicyScheduleDeleteCollectionOK with default headers values
func NewSnapshotPolicyScheduleDeleteCollectionOK() *SnapshotPolicyScheduleDeleteCollectionOK {
	return &SnapshotPolicyScheduleDeleteCollectionOK{}
}

/*
SnapshotPolicyScheduleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotPolicyScheduleDeleteCollectionOK struct {
}

// IsSuccess returns true when this snapshot policy schedule delete collection o k response has a 2xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy schedule delete collection o k response has a 3xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy schedule delete collection o k response has a 4xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy schedule delete collection o k response has a 5xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy schedule delete collection o k response a status code equal to that given
func (o *SnapshotPolicyScheduleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot policy schedule delete collection o k response
func (o *SnapshotPolicyScheduleDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnapshotPolicyScheduleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules][%d] snapshotPolicyScheduleDeleteCollectionOK", 200)
}

func (o *SnapshotPolicyScheduleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules][%d] snapshotPolicyScheduleDeleteCollectionOK", 200)
}

func (o *SnapshotPolicyScheduleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapshotPolicyScheduleDeleteCollectionDefault creates a SnapshotPolicyScheduleDeleteCollectionDefault with default headers values
func NewSnapshotPolicyScheduleDeleteCollectionDefault(code int) *SnapshotPolicyScheduleDeleteCollectionDefault {
	return &SnapshotPolicyScheduleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapshotPolicyScheduleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 1638411    | At least minimum number of schedule must be specified for the policy. |
| 1638412    | Schedule does not exist in snapshot policy. |
*/
type SnapshotPolicyScheduleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy schedule delete collection default response has a 2xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy schedule delete collection default response has a 3xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy schedule delete collection default response has a 4xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy schedule delete collection default response has a 5xx status code
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy schedule delete collection default response a status code equal to that given
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy schedule delete collection default response
func (o *SnapshotPolicyScheduleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyScheduleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules][%d] snapshot_policy_schedule_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules][%d] snapshot_policy_schedule_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyScheduleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapshotPolicyScheduleDeleteCollectionBody snapshot policy schedule delete collection body
swagger:model SnapshotPolicyScheduleDeleteCollectionBody
*/
type SnapshotPolicyScheduleDeleteCollectionBody struct {

	// snapshot policy schedule response inline records
	SnapshotPolicyScheduleResponseInlineRecords []*models.SnapshotPolicySchedule `json:"records,omitempty"`
}

// Validate validates this snapshot policy schedule delete collection body
func (o *SnapshotPolicyScheduleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshotPolicyScheduleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotPolicyScheduleDeleteCollectionBody) validateSnapshotPolicyScheduleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicyScheduleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapshotPolicyScheduleResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapshotPolicyScheduleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapshotPolicyScheduleResponseInlineRecords[i] != nil {
			if err := o.SnapshotPolicyScheduleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snapshot policy schedule delete collection body based on the context it is used
func (o *SnapshotPolicyScheduleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshotPolicyScheduleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapshotPolicyScheduleDeleteCollectionBody) contextValidateSnapshotPolicyScheduleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapshotPolicyScheduleResponseInlineRecords); i++ {

		if o.SnapshotPolicyScheduleResponseInlineRecords[i] != nil {
			if err := o.SnapshotPolicyScheduleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapshotPolicyScheduleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapshotPolicyScheduleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapshotPolicyScheduleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
