// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyScheduleDeleteReader is a Reader for the SnapshotPolicyScheduleDelete structure.
type SnapshotPolicyScheduleDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyScheduleDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotPolicyScheduleDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyScheduleDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyScheduleDeleteOK creates a SnapshotPolicyScheduleDeleteOK with default headers values
func NewSnapshotPolicyScheduleDeleteOK() *SnapshotPolicyScheduleDeleteOK {
	return &SnapshotPolicyScheduleDeleteOK{}
}

/*
SnapshotPolicyScheduleDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotPolicyScheduleDeleteOK struct {
}

// IsSuccess returns true when this snapshot policy schedule delete o k response has a 2xx status code
func (o *SnapshotPolicyScheduleDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy schedule delete o k response has a 3xx status code
func (o *SnapshotPolicyScheduleDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy schedule delete o k response has a 4xx status code
func (o *SnapshotPolicyScheduleDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy schedule delete o k response has a 5xx status code
func (o *SnapshotPolicyScheduleDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy schedule delete o k response a status code equal to that given
func (o *SnapshotPolicyScheduleDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot policy schedule delete o k response
func (o *SnapshotPolicyScheduleDeleteOK) Code() int {
	return 200
}

func (o *SnapshotPolicyScheduleDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshotPolicyScheduleDeleteOK", 200)
}

func (o *SnapshotPolicyScheduleDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshotPolicyScheduleDeleteOK", 200)
}

func (o *SnapshotPolicyScheduleDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapshotPolicyScheduleDeleteDefault creates a SnapshotPolicyScheduleDeleteDefault with default headers values
func NewSnapshotPolicyScheduleDeleteDefault(code int) *SnapshotPolicyScheduleDeleteDefault {
	return &SnapshotPolicyScheduleDeleteDefault{
		_statusCode: code,
	}
}

/*
	SnapshotPolicyScheduleDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Code

| Error Code | Description |
| ---------- | ----------- |
| 1638411    | At least minimum number of schedule must be specified for the policy. |
| 1638412    | Schedule does not exist in snapshot policy. |
*/
type SnapshotPolicyScheduleDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy schedule delete default response has a 2xx status code
func (o *SnapshotPolicyScheduleDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy schedule delete default response has a 3xx status code
func (o *SnapshotPolicyScheduleDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy schedule delete default response has a 4xx status code
func (o *SnapshotPolicyScheduleDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy schedule delete default response has a 5xx status code
func (o *SnapshotPolicyScheduleDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy schedule delete default response a status code equal to that given
func (o *SnapshotPolicyScheduleDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy schedule delete default response
func (o *SnapshotPolicyScheduleDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyScheduleDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshot_policy_schedule_delete default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshot_policy_schedule_delete default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyScheduleDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
