// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapshotPolicyScheduleGetReader is a Reader for the SnapshotPolicyScheduleGet structure.
type SnapshotPolicyScheduleGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapshotPolicyScheduleGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapshotPolicyScheduleGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapshotPolicyScheduleGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapshotPolicyScheduleGetOK creates a SnapshotPolicyScheduleGetOK with default headers values
func NewSnapshotPolicyScheduleGetOK() *SnapshotPolicyScheduleGetOK {
	return &SnapshotPolicyScheduleGetOK{}
}

/*
SnapshotPolicyScheduleGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapshotPolicyScheduleGetOK struct {
	Payload *models.SnapshotPolicySchedule
}

// IsSuccess returns true when this snapshot policy schedule get o k response has a 2xx status code
func (o *SnapshotPolicyScheduleGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapshot policy schedule get o k response has a 3xx status code
func (o *SnapshotPolicyScheduleGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapshot policy schedule get o k response has a 4xx status code
func (o *SnapshotPolicyScheduleGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapshot policy schedule get o k response has a 5xx status code
func (o *SnapshotPolicyScheduleGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapshot policy schedule get o k response a status code equal to that given
func (o *SnapshotPolicyScheduleGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapshot policy schedule get o k response
func (o *SnapshotPolicyScheduleGetOK) Code() int {
	return 200
}

func (o *SnapshotPolicyScheduleGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshotPolicyScheduleGetOK %s", 200, payload)
}

func (o *SnapshotPolicyScheduleGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshotPolicyScheduleGetOK %s", 200, payload)
}

func (o *SnapshotPolicyScheduleGetOK) GetPayload() *models.SnapshotPolicySchedule {
	return o.Payload
}

func (o *SnapshotPolicyScheduleGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotPolicySchedule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapshotPolicyScheduleGetDefault creates a SnapshotPolicyScheduleGetDefault with default headers values
func NewSnapshotPolicyScheduleGetDefault(code int) *SnapshotPolicyScheduleGetDefault {
	return &SnapshotPolicyScheduleGetDefault{
		_statusCode: code,
	}
}

/*
SnapshotPolicyScheduleGetDefault describes a response with status code -1, with default header values.

Error
*/
type SnapshotPolicyScheduleGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapshot policy schedule get default response has a 2xx status code
func (o *SnapshotPolicyScheduleGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapshot policy schedule get default response has a 3xx status code
func (o *SnapshotPolicyScheduleGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapshot policy schedule get default response has a 4xx status code
func (o *SnapshotPolicyScheduleGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapshot policy schedule get default response has a 5xx status code
func (o *SnapshotPolicyScheduleGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapshot policy schedule get default response a status code equal to that given
func (o *SnapshotPolicyScheduleGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapshot policy schedule get default response
func (o *SnapshotPolicyScheduleGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapshotPolicyScheduleGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshot_policy_schedule_get default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}][%d] snapshot_policy_schedule_get default %s", o._statusCode, payload)
}

func (o *SnapshotPolicyScheduleGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapshotPolicyScheduleGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
