// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSplitLoadCollectionGetParams creates a new SplitLoadCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSplitLoadCollectionGetParams() *SplitLoadCollectionGetParams {
	return &SplitLoadCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSplitLoadCollectionGetParamsWithTimeout creates a new SplitLoadCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSplitLoadCollectionGetParamsWithTimeout(timeout time.Duration) *SplitLoadCollectionGetParams {
	return &SplitLoadCollectionGetParams{
		timeout: timeout,
	}
}

// NewSplitLoadCollectionGetParamsWithContext creates a new SplitLoadCollectionGetParams object
// with the ability to set a context for a request.
func NewSplitLoadCollectionGetParamsWithContext(ctx context.Context) *SplitLoadCollectionGetParams {
	return &SplitLoadCollectionGetParams{
		Context: ctx,
	}
}

// NewSplitLoadCollectionGetParamsWithHTTPClient creates a new SplitLoadCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSplitLoadCollectionGetParamsWithHTTPClient(client *http.Client) *SplitLoadCollectionGetParams {
	return &SplitLoadCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SplitLoadCollectionGetParams contains all the parameters to send to the API endpoint

	for the split load collection get operation.

	Typically these are written to a http.Request.
*/
type SplitLoadCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LoadAllowable.

	   Filter by load.allowable
	*/
	LoadAllowable *int64

	/* LoadCurrent.

	   Filter by load.current
	*/
	LoadCurrent *int64

	/* LoadMaximum.

	   Filter by load.maximum
	*/
	LoadMaximum *int64

	/* LoadTokenReserved.

	   Filter by load.token_reserved
	*/
	LoadTokenReserved *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the split load collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitLoadCollectionGetParams) WithDefaults() *SplitLoadCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the split load collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitLoadCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SplitLoadCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithTimeout(timeout time.Duration) *SplitLoadCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithContext(ctx context.Context) *SplitLoadCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithHTTPClient(client *http.Client) *SplitLoadCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithFields(fields []string) *SplitLoadCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLoadAllowable adds the loadAllowable to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithLoadAllowable(loadAllowable *int64) *SplitLoadCollectionGetParams {
	o.SetLoadAllowable(loadAllowable)
	return o
}

// SetLoadAllowable adds the loadAllowable to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetLoadAllowable(loadAllowable *int64) {
	o.LoadAllowable = loadAllowable
}

// WithLoadCurrent adds the loadCurrent to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithLoadCurrent(loadCurrent *int64) *SplitLoadCollectionGetParams {
	o.SetLoadCurrent(loadCurrent)
	return o
}

// SetLoadCurrent adds the loadCurrent to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetLoadCurrent(loadCurrent *int64) {
	o.LoadCurrent = loadCurrent
}

// WithLoadMaximum adds the loadMaximum to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithLoadMaximum(loadMaximum *int64) *SplitLoadCollectionGetParams {
	o.SetLoadMaximum(loadMaximum)
	return o
}

// SetLoadMaximum adds the loadMaximum to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetLoadMaximum(loadMaximum *int64) {
	o.LoadMaximum = loadMaximum
}

// WithLoadTokenReserved adds the loadTokenReserved to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithLoadTokenReserved(loadTokenReserved *int64) *SplitLoadCollectionGetParams {
	o.SetLoadTokenReserved(loadTokenReserved)
	return o
}

// SetLoadTokenReserved adds the loadTokenReserved to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetLoadTokenReserved(loadTokenReserved *int64) {
	o.LoadTokenReserved = loadTokenReserved
}

// WithMaxRecords adds the maxRecords to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithMaxRecords(maxRecords *int64) *SplitLoadCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithNodeName(nodeName *string) *SplitLoadCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithNodeUUID(nodeUUID *string) *SplitLoadCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithOrderBy(orderBy []string) *SplitLoadCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithReturnRecords(returnRecords *bool) *SplitLoadCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the split load collection get params
func (o *SplitLoadCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SplitLoadCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the split load collection get params
func (o *SplitLoadCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SplitLoadCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LoadAllowable != nil {

		// query param load.allowable
		var qrLoadAllowable int64

		if o.LoadAllowable != nil {
			qrLoadAllowable = *o.LoadAllowable
		}
		qLoadAllowable := swag.FormatInt64(qrLoadAllowable)
		if qLoadAllowable != "" {

			if err := r.SetQueryParam("load.allowable", qLoadAllowable); err != nil {
				return err
			}
		}
	}

	if o.LoadCurrent != nil {

		// query param load.current
		var qrLoadCurrent int64

		if o.LoadCurrent != nil {
			qrLoadCurrent = *o.LoadCurrent
		}
		qLoadCurrent := swag.FormatInt64(qrLoadCurrent)
		if qLoadCurrent != "" {

			if err := r.SetQueryParam("load.current", qLoadCurrent); err != nil {
				return err
			}
		}
	}

	if o.LoadMaximum != nil {

		// query param load.maximum
		var qrLoadMaximum int64

		if o.LoadMaximum != nil {
			qrLoadMaximum = *o.LoadMaximum
		}
		qLoadMaximum := swag.FormatInt64(qrLoadMaximum)
		if qLoadMaximum != "" {

			if err := r.SetQueryParam("load.maximum", qLoadMaximum); err != nil {
				return err
			}
		}
	}

	if o.LoadTokenReserved != nil {

		// query param load.token_reserved
		var qrLoadTokenReserved int64

		if o.LoadTokenReserved != nil {
			qrLoadTokenReserved = *o.LoadTokenReserved
		}
		qLoadTokenReserved := swag.FormatInt64(qrLoadTokenReserved)
		if qLoadTokenReserved != "" {

			if err := r.SetQueryParam("load.token_reserved", qLoadTokenReserved); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSplitLoadCollectionGet binds the parameter fields
func (o *SplitLoadCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSplitLoadCollectionGet binds the parameter order_by
func (o *SplitLoadCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
