// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SplitLoadModifyCollectionReader is a Reader for the SplitLoadModifyCollection structure.
type SplitLoadModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SplitLoadModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSplitLoadModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSplitLoadModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSplitLoadModifyCollectionOK creates a SplitLoadModifyCollectionOK with default headers values
func NewSplitLoadModifyCollectionOK() *SplitLoadModifyCollectionOK {
	return &SplitLoadModifyCollectionOK{}
}

/*
SplitLoadModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SplitLoadModifyCollectionOK struct {
}

// IsSuccess returns true when this split load modify collection o k response has a 2xx status code
func (o *SplitLoadModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this split load modify collection o k response has a 3xx status code
func (o *SplitLoadModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this split load modify collection o k response has a 4xx status code
func (o *SplitLoadModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this split load modify collection o k response has a 5xx status code
func (o *SplitLoadModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this split load modify collection o k response a status code equal to that given
func (o *SplitLoadModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the split load modify collection o k response
func (o *SplitLoadModifyCollectionOK) Code() int {
	return 200
}

func (o *SplitLoadModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/split-loads][%d] splitLoadModifyCollectionOK", 200)
}

func (o *SplitLoadModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/file/clone/split-loads][%d] splitLoadModifyCollectionOK", 200)
}

func (o *SplitLoadModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSplitLoadModifyCollectionDefault creates a SplitLoadModifyCollectionDefault with default headers values
func NewSplitLoadModifyCollectionDefault(code int) *SplitLoadModifyCollectionDefault {
	return &SplitLoadModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SplitLoadModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13565966 | Failed to modify the maximum split load on the node due to an invalid field value. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SplitLoadModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this split load modify collection default response has a 2xx status code
func (o *SplitLoadModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this split load modify collection default response has a 3xx status code
func (o *SplitLoadModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this split load modify collection default response has a 4xx status code
func (o *SplitLoadModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this split load modify collection default response has a 5xx status code
func (o *SplitLoadModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this split load modify collection default response a status code equal to that given
func (o *SplitLoadModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the split load modify collection default response
func (o *SplitLoadModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SplitLoadModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/split-loads][%d] split_load_modify_collection default %s", o._statusCode, payload)
}

func (o *SplitLoadModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/file/clone/split-loads][%d] split_load_modify_collection default %s", o._statusCode, payload)
}

func (o *SplitLoadModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SplitLoadModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SplitLoadModifyCollectionBody split load modify collection body
swagger:model SplitLoadModifyCollectionBody
*/
type SplitLoadModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// load
	Load *models.SplitLoadInlineLoad `json:"load,omitempty"`

	// node
	Node *models.SplitLoadInlineNode `json:"node,omitempty"`

	// split load response inline records
	SplitLoadResponseInlineRecords []*models.SplitLoad `json:"records,omitempty"`
}

// Validate validates this split load modify collection body
func (o *SplitLoadModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLoad(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSplitLoadResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) validateLoad(formats strfmt.Registry) error {
	if swag.IsZero(o.Load) { // not required
		return nil
	}

	if o.Load != nil {
		if err := o.Load.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "load")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) validateSplitLoadResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SplitLoadResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SplitLoadResponseInlineRecords); i++ {
		if swag.IsZero(o.SplitLoadResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SplitLoadResponseInlineRecords[i] != nil {
			if err := o.SplitLoadResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this split load modify collection body based on the context it is used
func (o *SplitLoadModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLoad(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSplitLoadResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) contextValidateLoad(ctx context.Context, formats strfmt.Registry) error {

	if o.Load != nil {
		if err := o.Load.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "load")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *SplitLoadModifyCollectionBody) contextValidateSplitLoadResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SplitLoadResponseInlineRecords); i++ {

		if o.SplitLoadResponseInlineRecords[i] != nil {
			if err := o.SplitLoadResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SplitLoadModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SplitLoadModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SplitLoadModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SplitLoadInlineLoad split load inline load
swagger:model split_load_inline_load
*/
type SplitLoadInlineLoad struct {

	// Specifies the available file clone split load on the node.
	// Example: 4KB
	// Read Only: true
	Allowable *int64 `json:"allowable,omitempty"`

	// Specifies the current on-going file clone split load on the node.
	// Read Only: true
	Current *int64 `json:"current,omitempty"`

	// Specifies the maximum allowable file clone split load on the node at any point in time. The least allowable file clone split load is 4KB and the maximum is 675TB. The default value is 4KB for the maximum split load when unit is not specified. The default file clone split load is set based on the system configuration.
	// Example: 4KB
	Maximum *int64 `json:"maximum,omitempty"`

	// Specifies the file clone split load on the node reserved for tokens.
	// Read Only: true
	TokenReserved *int64 `json:"token_reserved,omitempty"`
}

// Validate validates this split load inline load
func (o *SplitLoadInlineLoad) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this split load inline load based on the context it is used
func (o *SplitLoadInlineLoad) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAllowable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTokenReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadInlineLoad) contextValidateAllowable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"load"+"."+"allowable", "body", o.Allowable); err != nil {
		return err
	}

	return nil
}

func (o *SplitLoadInlineLoad) contextValidateCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"load"+"."+"current", "body", o.Current); err != nil {
		return err
	}

	return nil
}

func (o *SplitLoadInlineLoad) contextValidateTokenReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"load"+"."+"token_reserved", "body", o.TokenReserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SplitLoadInlineLoad) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SplitLoadInlineLoad) UnmarshalBinary(b []byte) error {
	var res SplitLoadInlineLoad
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SplitLoadInlineNode split load inline node
swagger:model split_load_inline_node
*/
type SplitLoadInlineNode struct {

	// links
	Links *models.SplitLoadInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this split load inline node
func (o *SplitLoadInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this split load inline node based on the context it is used
func (o *SplitLoadInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SplitLoadInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SplitLoadInlineNode) UnmarshalBinary(b []byte) error {
	var res SplitLoadInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SplitLoadInlineNodeInlineLinks split load inline node inline links
swagger:model split_load_inline_node_inline__links
*/
type SplitLoadInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this split load inline node inline links
func (o *SplitLoadInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this split load inline node inline links based on the context it is used
func (o *SplitLoadInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SplitLoadInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SplitLoadInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SplitLoadInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SplitLoadInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
