// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSplitLoadModifyParams creates a new SplitLoadModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSplitLoadModifyParams() *SplitLoadModifyParams {
	return &SplitLoadModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSplitLoadModifyParamsWithTimeout creates a new SplitLoadModifyParams object
// with the ability to set a timeout on a request.
func NewSplitLoadModifyParamsWithTimeout(timeout time.Duration) *SplitLoadModifyParams {
	return &SplitLoadModifyParams{
		timeout: timeout,
	}
}

// NewSplitLoadModifyParamsWithContext creates a new SplitLoadModifyParams object
// with the ability to set a context for a request.
func NewSplitLoadModifyParamsWithContext(ctx context.Context) *SplitLoadModifyParams {
	return &SplitLoadModifyParams{
		Context: ctx,
	}
}

// NewSplitLoadModifyParamsWithHTTPClient creates a new SplitLoadModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewSplitLoadModifyParamsWithHTTPClient(client *http.Client) *SplitLoadModifyParams {
	return &SplitLoadModifyParams{
		HTTPClient: client,
	}
}

/*
SplitLoadModifyParams contains all the parameters to send to the API endpoint

	for the split load modify operation.

	Typically these are written to a http.Request.
*/
type SplitLoadModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SplitLoad

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the split load modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitLoadModifyParams) WithDefaults() *SplitLoadModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the split load modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitLoadModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the split load modify params
func (o *SplitLoadModifyParams) WithTimeout(timeout time.Duration) *SplitLoadModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the split load modify params
func (o *SplitLoadModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the split load modify params
func (o *SplitLoadModifyParams) WithContext(ctx context.Context) *SplitLoadModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the split load modify params
func (o *SplitLoadModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the split load modify params
func (o *SplitLoadModifyParams) WithHTTPClient(client *http.Client) *SplitLoadModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the split load modify params
func (o *SplitLoadModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the split load modify params
func (o *SplitLoadModifyParams) WithInfo(info *models.SplitLoad) *SplitLoadModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the split load modify params
func (o *SplitLoadModifyParams) SetInfo(info *models.SplitLoad) {
	o.Info = info
}

// WithNodeUUID adds the nodeUUID to the split load modify params
func (o *SplitLoadModifyParams) WithNodeUUID(nodeUUID string) *SplitLoadModifyParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the split load modify params
func (o *SplitLoadModifyParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SplitLoadModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
