// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSplitStatusCollectionGetParams creates a new SplitStatusCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSplitStatusCollectionGetParams() *SplitStatusCollectionGetParams {
	return &SplitStatusCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSplitStatusCollectionGetParamsWithTimeout creates a new SplitStatusCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSplitStatusCollectionGetParamsWithTimeout(timeout time.Duration) *SplitStatusCollectionGetParams {
	return &SplitStatusCollectionGetParams{
		timeout: timeout,
	}
}

// NewSplitStatusCollectionGetParamsWithContext creates a new SplitStatusCollectionGetParams object
// with the ability to set a context for a request.
func NewSplitStatusCollectionGetParamsWithContext(ctx context.Context) *SplitStatusCollectionGetParams {
	return &SplitStatusCollectionGetParams{
		Context: ctx,
	}
}

// NewSplitStatusCollectionGetParamsWithHTTPClient creates a new SplitStatusCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSplitStatusCollectionGetParamsWithHTTPClient(client *http.Client) *SplitStatusCollectionGetParams {
	return &SplitStatusCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SplitStatusCollectionGetParams contains all the parameters to send to the API endpoint

	for the split status collection get operation.

	Typically these are written to a http.Request.
*/
type SplitStatusCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PendingSplits.

	   Filter by pending_splits
	*/
	PendingSplits *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UnsplitSize.

	   Filter by unsplit_size
	*/
	UnsplitSize *int64

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the split status collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitStatusCollectionGetParams) WithDefaults() *SplitStatusCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the split status collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitStatusCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SplitStatusCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithTimeout(timeout time.Duration) *SplitStatusCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithContext(ctx context.Context) *SplitStatusCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithHTTPClient(client *http.Client) *SplitStatusCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithFields(fields []string) *SplitStatusCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithMaxRecords(maxRecords *int64) *SplitStatusCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithOrderBy(orderBy []string) *SplitStatusCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPendingSplits adds the pendingSplits to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithPendingSplits(pendingSplits *int64) *SplitStatusCollectionGetParams {
	o.SetPendingSplits(pendingSplits)
	return o
}

// SetPendingSplits adds the pendingSplits to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetPendingSplits(pendingSplits *int64) {
	o.PendingSplits = pendingSplits
}

// WithReturnRecords adds the returnRecords to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithReturnRecords(returnRecords *bool) *SplitStatusCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SplitStatusCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithSvmName(svmName *string) *SplitStatusCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithSvmUUID(svmUUID *string) *SplitStatusCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUnsplitSize adds the unsplitSize to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithUnsplitSize(unsplitSize *int64) *SplitStatusCollectionGetParams {
	o.SetUnsplitSize(unsplitSize)
	return o
}

// SetUnsplitSize adds the unsplitSize to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetUnsplitSize(unsplitSize *int64) {
	o.UnsplitSize = unsplitSize
}

// WithVolumeName adds the volumeName to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithVolumeName(volumeName *string) *SplitStatusCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the split status collection get params
func (o *SplitStatusCollectionGetParams) WithVolumeUUID(volumeUUID *string) *SplitStatusCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the split status collection get params
func (o *SplitStatusCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SplitStatusCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PendingSplits != nil {

		// query param pending_splits
		var qrPendingSplits int64

		if o.PendingSplits != nil {
			qrPendingSplits = *o.PendingSplits
		}
		qPendingSplits := swag.FormatInt64(qrPendingSplits)
		if qPendingSplits != "" {

			if err := r.SetQueryParam("pending_splits", qPendingSplits); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UnsplitSize != nil {

		// query param unsplit_size
		var qrUnsplitSize int64

		if o.UnsplitSize != nil {
			qrUnsplitSize = *o.UnsplitSize
		}
		qUnsplitSize := swag.FormatInt64(qrUnsplitSize)
		if qUnsplitSize != "" {

			if err := r.SetQueryParam("unsplit_size", qUnsplitSize); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSplitStatusCollectionGet binds the parameter fields
func (o *SplitStatusCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSplitStatusCollectionGet binds the parameter order_by
func (o *SplitStatusCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
