// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSplitStatusGetParams creates a new SplitStatusGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSplitStatusGetParams() *SplitStatusGetParams {
	return &SplitStatusGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSplitStatusGetParamsWithTimeout creates a new SplitStatusGetParams object
// with the ability to set a timeout on a request.
func NewSplitStatusGetParamsWithTimeout(timeout time.Duration) *SplitStatusGetParams {
	return &SplitStatusGetParams{
		timeout: timeout,
	}
}

// NewSplitStatusGetParamsWithContext creates a new SplitStatusGetParams object
// with the ability to set a context for a request.
func NewSplitStatusGetParamsWithContext(ctx context.Context) *SplitStatusGetParams {
	return &SplitStatusGetParams{
		Context: ctx,
	}
}

// NewSplitStatusGetParamsWithHTTPClient creates a new SplitStatusGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSplitStatusGetParamsWithHTTPClient(client *http.Client) *SplitStatusGetParams {
	return &SplitStatusGetParams{
		HTTPClient: client,
	}
}

/*
SplitStatusGetParams contains all the parameters to send to the API endpoint

	for the split status get operation.

	Typically these are written to a http.Request.
*/
type SplitStatusGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* VolumeUUID.

	   Volume Instance UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the split status get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitStatusGetParams) WithDefaults() *SplitStatusGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the split status get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SplitStatusGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the split status get params
func (o *SplitStatusGetParams) WithTimeout(timeout time.Duration) *SplitStatusGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the split status get params
func (o *SplitStatusGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the split status get params
func (o *SplitStatusGetParams) WithContext(ctx context.Context) *SplitStatusGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the split status get params
func (o *SplitStatusGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the split status get params
func (o *SplitStatusGetParams) WithHTTPClient(client *http.Client) *SplitStatusGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the split status get params
func (o *SplitStatusGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the split status get params
func (o *SplitStatusGetParams) WithFields(fields []string) *SplitStatusGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the split status get params
func (o *SplitStatusGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithVolumeUUID adds the volumeUUID to the split status get params
func (o *SplitStatusGetParams) WithVolumeUUID(volumeUUID string) *SplitStatusGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the split status get params
func (o *SplitStatusGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SplitStatusGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSplitStatusGet binds the parameter fields
func (o *SplitStatusGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
