// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StartDirectoryRestoreReader is a Reader for the StartDirectoryRestore structure.
type StartDirectoryRestoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StartDirectoryRestoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewStartDirectoryRestoreCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStartDirectoryRestoreAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStartDirectoryRestoreDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStartDirectoryRestoreCreated creates a StartDirectoryRestoreCreated with default headers values
func NewStartDirectoryRestoreCreated() *StartDirectoryRestoreCreated {
	return &StartDirectoryRestoreCreated{}
}

/*
StartDirectoryRestoreCreated describes a response with status code 201, with default header values.

Created
*/
type StartDirectoryRestoreCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DirectoryRestore
}

// IsSuccess returns true when this start directory restore created response has a 2xx status code
func (o *StartDirectoryRestoreCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this start directory restore created response has a 3xx status code
func (o *StartDirectoryRestoreCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this start directory restore created response has a 4xx status code
func (o *StartDirectoryRestoreCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this start directory restore created response has a 5xx status code
func (o *StartDirectoryRestoreCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this start directory restore created response a status code equal to that given
func (o *StartDirectoryRestoreCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the start directory restore created response
func (o *StartDirectoryRestoreCreated) Code() int {
	return 201
}

func (o *StartDirectoryRestoreCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] startDirectoryRestoreCreated %s", 201, payload)
}

func (o *StartDirectoryRestoreCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] startDirectoryRestoreCreated %s", 201, payload)
}

func (o *StartDirectoryRestoreCreated) GetPayload() *models.DirectoryRestore {
	return o.Payload
}

func (o *StartDirectoryRestoreCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DirectoryRestore)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStartDirectoryRestoreAccepted creates a StartDirectoryRestoreAccepted with default headers values
func NewStartDirectoryRestoreAccepted() *StartDirectoryRestoreAccepted {
	return &StartDirectoryRestoreAccepted{}
}

/*
StartDirectoryRestoreAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StartDirectoryRestoreAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DirectoryRestore
}

// IsSuccess returns true when this start directory restore accepted response has a 2xx status code
func (o *StartDirectoryRestoreAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this start directory restore accepted response has a 3xx status code
func (o *StartDirectoryRestoreAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this start directory restore accepted response has a 4xx status code
func (o *StartDirectoryRestoreAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this start directory restore accepted response has a 5xx status code
func (o *StartDirectoryRestoreAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this start directory restore accepted response a status code equal to that given
func (o *StartDirectoryRestoreAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the start directory restore accepted response
func (o *StartDirectoryRestoreAccepted) Code() int {
	return 202
}

func (o *StartDirectoryRestoreAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] startDirectoryRestoreAccepted %s", 202, payload)
}

func (o *StartDirectoryRestoreAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] startDirectoryRestoreAccepted %s", 202, payload)
}

func (o *StartDirectoryRestoreAccepted) GetPayload() *models.DirectoryRestore {
	return o.Payload
}

func (o *StartDirectoryRestoreAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DirectoryRestore)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStartDirectoryRestoreDefault creates a StartDirectoryRestoreDefault with default headers values
func NewStartDirectoryRestoreDefault(code int) *StartDirectoryRestoreDefault {
	return &StartDirectoryRestoreDefault{
		_statusCode: code,
	}
}

/*
	StartDirectoryRestoreDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 6488112 | Directory restore can only be started on a directory. |
| 6488113 | Directory restore requires an effective cluster version of 9.15.1 or later. |
| 6488114 | Directory restore is not supported on FlexGroup constituent volumes. |
| 6488115 | Internal error. Failed to get node information for the volume with DSID "volume.dsid". |
| 6488116 | Directory restore is not supported on root directory. Use the "volume snapshot restore" command instead. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StartDirectoryRestoreDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this start directory restore default response has a 2xx status code
func (o *StartDirectoryRestoreDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this start directory restore default response has a 3xx status code
func (o *StartDirectoryRestoreDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this start directory restore default response has a 4xx status code
func (o *StartDirectoryRestoreDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this start directory restore default response has a 5xx status code
func (o *StartDirectoryRestoreDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this start directory restore default response a status code equal to that given
func (o *StartDirectoryRestoreDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the start directory restore default response
func (o *StartDirectoryRestoreDefault) Code() int {
	return o._statusCode
}

func (o *StartDirectoryRestoreDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] start_directory_restore default %s", o._statusCode, payload)
}

func (o *StartDirectoryRestoreDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/directory-restore][%d] start_directory_restore default %s", o._statusCode, payload)
}

func (o *StartDirectoryRestoreDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StartDirectoryRestoreDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
