// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageAvailabilityZoneCollectionGetReader is a Reader for the StorageAvailabilityZoneCollectionGet structure.
type StorageAvailabilityZoneCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageAvailabilityZoneCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageAvailabilityZoneCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageAvailabilityZoneCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageAvailabilityZoneCollectionGetOK creates a StorageAvailabilityZoneCollectionGetOK with default headers values
func NewStorageAvailabilityZoneCollectionGetOK() *StorageAvailabilityZoneCollectionGetOK {
	return &StorageAvailabilityZoneCollectionGetOK{}
}

/*
StorageAvailabilityZoneCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageAvailabilityZoneCollectionGetOK struct {
	Payload *models.StorageAvailabilityZoneResponse
}

// IsSuccess returns true when this storage availability zone collection get o k response has a 2xx status code
func (o *StorageAvailabilityZoneCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage availability zone collection get o k response has a 3xx status code
func (o *StorageAvailabilityZoneCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage availability zone collection get o k response has a 4xx status code
func (o *StorageAvailabilityZoneCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage availability zone collection get o k response has a 5xx status code
func (o *StorageAvailabilityZoneCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage availability zone collection get o k response a status code equal to that given
func (o *StorageAvailabilityZoneCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage availability zone collection get o k response
func (o *StorageAvailabilityZoneCollectionGetOK) Code() int {
	return 200
}

func (o *StorageAvailabilityZoneCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones][%d] storageAvailabilityZoneCollectionGetOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones][%d] storageAvailabilityZoneCollectionGetOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneCollectionGetOK) GetPayload() *models.StorageAvailabilityZoneResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageAvailabilityZoneResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageAvailabilityZoneCollectionGetDefault creates a StorageAvailabilityZoneCollectionGetDefault with default headers values
func NewStorageAvailabilityZoneCollectionGetDefault(code int) *StorageAvailabilityZoneCollectionGetDefault {
	return &StorageAvailabilityZoneCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	StorageAvailabilityZoneCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262144015 | Failed to retrieve storage availability zone information for provided storage availability zone UUID. |
| 262144016 | Failed to retrieve the node information for provided storage availability zone UUID. |
| 262144017 | This operation is not supported on this platform or has been disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageAvailabilityZoneCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage availability zone collection get default response has a 2xx status code
func (o *StorageAvailabilityZoneCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage availability zone collection get default response has a 3xx status code
func (o *StorageAvailabilityZoneCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage availability zone collection get default response has a 4xx status code
func (o *StorageAvailabilityZoneCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage availability zone collection get default response has a 5xx status code
func (o *StorageAvailabilityZoneCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage availability zone collection get default response a status code equal to that given
func (o *StorageAvailabilityZoneCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage availability zone collection get default response
func (o *StorageAvailabilityZoneCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageAvailabilityZoneCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones][%d] storage_availability_zone_collection_get default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones][%d] storage_availability_zone_collection_get default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
