// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageAvailabilityZoneGetReader is a Reader for the StorageAvailabilityZoneGet structure.
type StorageAvailabilityZoneGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageAvailabilityZoneGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageAvailabilityZoneGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageAvailabilityZoneGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageAvailabilityZoneGetOK creates a StorageAvailabilityZoneGetOK with default headers values
func NewStorageAvailabilityZoneGetOK() *StorageAvailabilityZoneGetOK {
	return &StorageAvailabilityZoneGetOK{}
}

/*
StorageAvailabilityZoneGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageAvailabilityZoneGetOK struct {
	Payload *models.StorageAvailabilityZone
}

// IsSuccess returns true when this storage availability zone get o k response has a 2xx status code
func (o *StorageAvailabilityZoneGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage availability zone get o k response has a 3xx status code
func (o *StorageAvailabilityZoneGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage availability zone get o k response has a 4xx status code
func (o *StorageAvailabilityZoneGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage availability zone get o k response has a 5xx status code
func (o *StorageAvailabilityZoneGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage availability zone get o k response a status code equal to that given
func (o *StorageAvailabilityZoneGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage availability zone get o k response
func (o *StorageAvailabilityZoneGetOK) Code() int {
	return 200
}

func (o *StorageAvailabilityZoneGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones/{uuid}][%d] storageAvailabilityZoneGetOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones/{uuid}][%d] storageAvailabilityZoneGetOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneGetOK) GetPayload() *models.StorageAvailabilityZone {
	return o.Payload
}

func (o *StorageAvailabilityZoneGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageAvailabilityZone)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageAvailabilityZoneGetDefault creates a StorageAvailabilityZoneGetDefault with default headers values
func NewStorageAvailabilityZoneGetDefault(code int) *StorageAvailabilityZoneGetDefault {
	return &StorageAvailabilityZoneGetDefault{
		_statusCode: code,
	}
}

/*
	StorageAvailabilityZoneGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262144015 | Failed to retrieve storage availability zone information for provided storage availability zone UUID. |
| 262144016 | Failed to retrieve the node information for provided storage availability zone UUID. |
| 262144017 | This operation is not supported on this platform or has been disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageAvailabilityZoneGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage availability zone get default response has a 2xx status code
func (o *StorageAvailabilityZoneGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage availability zone get default response has a 3xx status code
func (o *StorageAvailabilityZoneGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage availability zone get default response has a 4xx status code
func (o *StorageAvailabilityZoneGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage availability zone get default response has a 5xx status code
func (o *StorageAvailabilityZoneGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage availability zone get default response a status code equal to that given
func (o *StorageAvailabilityZoneGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage availability zone get default response
func (o *StorageAvailabilityZoneGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageAvailabilityZoneGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones/{uuid}][%d] storage_availability_zone_get default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/availability-zones/{uuid}][%d] storage_availability_zone_get default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
