// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageAvailabilityZoneModifyCollectionReader is a Reader for the StorageAvailabilityZoneModifyCollection structure.
type StorageAvailabilityZoneModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageAvailabilityZoneModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageAvailabilityZoneModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageAvailabilityZoneModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageAvailabilityZoneModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageAvailabilityZoneModifyCollectionOK creates a StorageAvailabilityZoneModifyCollectionOK with default headers values
func NewStorageAvailabilityZoneModifyCollectionOK() *StorageAvailabilityZoneModifyCollectionOK {
	return &StorageAvailabilityZoneModifyCollectionOK{}
}

/*
StorageAvailabilityZoneModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StorageAvailabilityZoneModifyCollectionOK struct {
	Payload *models.StorageAvailabilityZoneJobLinkResponse
}

// IsSuccess returns true when this storage availability zone modify collection o k response has a 2xx status code
func (o *StorageAvailabilityZoneModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage availability zone modify collection o k response has a 3xx status code
func (o *StorageAvailabilityZoneModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage availability zone modify collection o k response has a 4xx status code
func (o *StorageAvailabilityZoneModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage availability zone modify collection o k response has a 5xx status code
func (o *StorageAvailabilityZoneModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage availability zone modify collection o k response a status code equal to that given
func (o *StorageAvailabilityZoneModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage availability zone modify collection o k response
func (o *StorageAvailabilityZoneModifyCollectionOK) Code() int {
	return 200
}

func (o *StorageAvailabilityZoneModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storageAvailabilityZoneModifyCollectionOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storageAvailabilityZoneModifyCollectionOK %s", 200, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionOK) GetPayload() *models.StorageAvailabilityZoneJobLinkResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageAvailabilityZoneJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageAvailabilityZoneModifyCollectionAccepted creates a StorageAvailabilityZoneModifyCollectionAccepted with default headers values
func NewStorageAvailabilityZoneModifyCollectionAccepted() *StorageAvailabilityZoneModifyCollectionAccepted {
	return &StorageAvailabilityZoneModifyCollectionAccepted{}
}

/*
StorageAvailabilityZoneModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageAvailabilityZoneModifyCollectionAccepted struct {
	Payload *models.StorageAvailabilityZoneJobLinkResponse
}

// IsSuccess returns true when this storage availability zone modify collection accepted response has a 2xx status code
func (o *StorageAvailabilityZoneModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage availability zone modify collection accepted response has a 3xx status code
func (o *StorageAvailabilityZoneModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage availability zone modify collection accepted response has a 4xx status code
func (o *StorageAvailabilityZoneModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage availability zone modify collection accepted response has a 5xx status code
func (o *StorageAvailabilityZoneModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage availability zone modify collection accepted response a status code equal to that given
func (o *StorageAvailabilityZoneModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage availability zone modify collection accepted response
func (o *StorageAvailabilityZoneModifyCollectionAccepted) Code() int {
	return 202
}

func (o *StorageAvailabilityZoneModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storageAvailabilityZoneModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storageAvailabilityZoneModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionAccepted) GetPayload() *models.StorageAvailabilityZoneJobLinkResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageAvailabilityZoneJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageAvailabilityZoneModifyCollectionDefault creates a StorageAvailabilityZoneModifyCollectionDefault with default headers values
func NewStorageAvailabilityZoneModifyCollectionDefault(code int) *StorageAvailabilityZoneModifyCollectionDefault {
	return &StorageAvailabilityZoneModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	StorageAvailabilityZoneModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9240632 | The provided nearly full threshold percent cannot be greater than full threshold percent. |
| 9240633 | The provided full threshold percent cannot be smaller than nearly full threshold percent. |
| 9240634 | The provided storage availability zone UUID is not valid. |
| 262144015 | Failed to retrieve storage availability zone information for provided storage availability zone UUID. |
| 262144016 | Failed to retrieve the node information for provided storage availability zone UUID. |
| 262144017 | This operation is not supported on this platform or has been disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageAvailabilityZoneModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage availability zone modify collection default response has a 2xx status code
func (o *StorageAvailabilityZoneModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage availability zone modify collection default response has a 3xx status code
func (o *StorageAvailabilityZoneModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage availability zone modify collection default response has a 4xx status code
func (o *StorageAvailabilityZoneModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage availability zone modify collection default response has a 5xx status code
func (o *StorageAvailabilityZoneModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage availability zone modify collection default response a status code equal to that given
func (o *StorageAvailabilityZoneModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage availability zone modify collection default response
func (o *StorageAvailabilityZoneModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StorageAvailabilityZoneModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storage_availability_zone_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/availability-zones][%d] storage_availability_zone_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageAvailabilityZoneModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageAvailabilityZoneModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StorageAvailabilityZoneModifyCollectionBody storage availability zone modify collection body
swagger:model StorageAvailabilityZoneModifyCollectionBody
*/
type StorageAvailabilityZoneModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Availability zone name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// space
	Space *models.StorageAvailabilityZoneInlineSpace `json:"space,omitempty"`

	// Nodes in the availability zone.
	// Read Only: true
	StorageAvailabilityZoneInlineNodes []*models.StorageAvailabilityZoneInlineNodesInlineArrayItem `json:"nodes,omitempty"`

	// storage availability zone response inline records
	StorageAvailabilityZoneResponseInlineRecords []*models.StorageAvailabilityZone `json:"records,omitempty"`

	// Availability zone UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage availability zone modify collection body
func (o *StorageAvailabilityZoneModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageAvailabilityZoneInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageAvailabilityZoneResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) validateStorageAvailabilityZoneInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZoneInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageAvailabilityZoneInlineNodes); i++ {
		if swag.IsZero(o.StorageAvailabilityZoneInlineNodes[i]) { // not required
			continue
		}

		if o.StorageAvailabilityZoneInlineNodes[i] != nil {
			if err := o.StorageAvailabilityZoneInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) validateStorageAvailabilityZoneResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZoneResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageAvailabilityZoneResponseInlineRecords); i++ {
		if swag.IsZero(o.StorageAvailabilityZoneResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StorageAvailabilityZoneResponseInlineRecords[i] != nil {
			if err := o.StorageAvailabilityZoneResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage availability zone modify collection body based on the context it is used
func (o *StorageAvailabilityZoneModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageAvailabilityZoneInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageAvailabilityZoneResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateStorageAvailabilityZoneInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"nodes", "body", []*models.StorageAvailabilityZoneInlineNodesInlineArrayItem(o.StorageAvailabilityZoneInlineNodes)); err != nil {
		return err
	}

	for i := 0; i < len(o.StorageAvailabilityZoneInlineNodes); i++ {

		if o.StorageAvailabilityZoneInlineNodes[i] != nil {
			if err := o.StorageAvailabilityZoneInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateStorageAvailabilityZoneResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StorageAvailabilityZoneResponseInlineRecords); i++ {

		if o.StorageAvailabilityZoneResponseInlineRecords[i] != nil {
			if err := o.StorageAvailabilityZoneResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageAvailabilityZoneModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageAvailabilityZoneModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageAvailabilityZoneModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageAvailabilityZoneInlineNodesInlineArrayItem storage availability zone inline nodes inline array item
swagger:model storage_availability_zone_inline_nodes_inline_array_item
*/
type StorageAvailabilityZoneInlineNodesInlineArrayItem struct {

	// links
	Links *models.StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage availability zone inline nodes inline array item
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline nodes inline array item based on the context it is used
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks storage availability zone inline nodes inline array item inline links
swagger:model storage_availability_zone_inline_nodes_inline_array_item_inline__links
*/
type StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage availability zone inline nodes inline array item inline links
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline nodes inline array item inline links based on the context it is used
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageAvailabilityZoneInlineSpace storage availability zone inline space
swagger:model storage_availability_zone_inline_space
*/
type StorageAvailabilityZoneInlineSpace struct {

	// Available space in the availability zone.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total space used by the delayed frees in the availability zone.
	// Read Only: true
	DelayedFrees *int64 `json:"delayed_frees,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *models.StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// The availability zone full threshold percentage that triggers an EMS error.
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// Inactive data in the availability zone.
	// Read Only: true
	InactiveData *int64 `json:"inactive_data,omitempty"`

	// The total space consumed by system logs and cores in the availability zone.
	// Read Only: true
	LogAndRecoveryMetadata *int64 `json:"log_and_recovery_metadata,omitempty"`

	// The logical space used by user data excluding snapshots in the availability zone.
	// Read Only: true
	LogicalUserDataWithoutSnapshots *int64 `json:"logical_user_data_without_snapshots,omitempty"`

	// The availability zone nearly full threshold percentage that triggers an EMS warning.
	NearlyFullThresholdPercent *int64 `json:"nearly_full_threshold_percent,omitempty"`

	// Total physical used space in the availability zone.
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The physical space used percentage in the availability zone.
	// Read Only: true
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// The physical space used by user data excluding snapshots in the availability zone.
	// Read Only: true
	PhysicalUserDataWithoutSnapshots *int64 `json:"physical_user_data_without_snapshots,omitempty"`

	// Total space in the availability zone.
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// The total space consumed by metadata in the availability zone, which includes log and recovery metadata, delayed frees along with filesystem metadata and performance metadata.
	// Read Only: true
	TotalMetadataUsed *int64 `json:"total_metadata_used,omitempty"`

	// Total unusable space in the availability zone due to an aggregate being unavailable.
	// Read Only: true
	Unusable *int64 `json:"unusable,omitempty"`
}

// Validate validates this storage availability zone inline space
func (o *StorageAvailabilityZoneInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(o.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if o.EfficiencyWithoutSnapshots != nil {
		if err := o.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline space based on the context it is used
func (o *StorageAvailabilityZoneInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDelayedFrees(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInactiveData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogAndRecoveryMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUserDataWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUserDataWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalMetadataUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnusable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateDelayedFrees(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"delayed_frees", "body", o.DelayedFrees); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if o.EfficiencyWithoutSnapshots != nil {
		if err := o.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateInactiveData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"inactive_data", "body", o.InactiveData); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateLogAndRecoveryMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"log_and_recovery_metadata", "body", o.LogAndRecoveryMetadata); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateLogicalUserDataWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"logical_user_data_without_snapshots", "body", o.LogicalUserDataWithoutSnapshots); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used", "body", o.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used_percent", "body", o.PhysicalUsedPercent); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUserDataWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_user_data_without_snapshots", "body", o.PhysicalUserDataWithoutSnapshots); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateTotalMetadataUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total_metadata_used", "body", o.TotalMetadataUsed); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpace) contextValidateUnusable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"unusable", "body", o.Unusable); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineSpace) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots for the availability zone.
swagger:model storage_availability_zone_inline_space_inline_efficiency_without_snapshots
*/
type StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots struct {

	// Data reduction ratio (logical_used_without_snapshot / physical_used_without_snapshot)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used_without_snapshot - physical_used_without_snapshot)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this storage availability zone inline space inline efficiency without snapshots
func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage availability zone inline space inline efficiency without snapshots based on the context it is used
func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots"+"."+"ratio", "body", o.Ratio); err != nil {
		return err
	}

	return nil
}

func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
