// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStorageBridgeCollectionGetParams creates a new StorageBridgeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageBridgeCollectionGetParams() *StorageBridgeCollectionGetParams {
	return &StorageBridgeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageBridgeCollectionGetParamsWithTimeout creates a new StorageBridgeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewStorageBridgeCollectionGetParamsWithTimeout(timeout time.Duration) *StorageBridgeCollectionGetParams {
	return &StorageBridgeCollectionGetParams{
		timeout: timeout,
	}
}

// NewStorageBridgeCollectionGetParamsWithContext creates a new StorageBridgeCollectionGetParams object
// with the ability to set a context for a request.
func NewStorageBridgeCollectionGetParamsWithContext(ctx context.Context) *StorageBridgeCollectionGetParams {
	return &StorageBridgeCollectionGetParams{
		Context: ctx,
	}
}

// NewStorageBridgeCollectionGetParamsWithHTTPClient creates a new StorageBridgeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageBridgeCollectionGetParamsWithHTTPClient(client *http.Client) *StorageBridgeCollectionGetParams {
	return &StorageBridgeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
StorageBridgeCollectionGetParams contains all the parameters to send to the API endpoint

	for the storage bridge collection get operation.

	Typically these are written to a http.Request.
*/
type StorageBridgeCollectionGetParams struct {

	/* ChassisThroughputState.

	   Filter by chassis_throughput_state
	*/
	ChassisThroughputState *string

	/* DramSingleBitErrorCount.

	   Filter by dram_single_bit_error_count
	*/
	DramSingleBitErrorCount *int64

	/* ErrorsComponentID.

	   Filter by errors.component.id
	*/
	ErrorsComponentID *int64

	/* ErrorsComponentName.

	   Filter by errors.component.name
	*/
	ErrorsComponentName *string

	/* ErrorsComponentUniqueID.

	   Filter by errors.component.unique_id
	*/
	ErrorsComponentUniqueID *string

	/* ErrorsReasonArgumentsCode.

	   Filter by errors.reason.arguments.code
	*/
	ErrorsReasonArgumentsCode *string

	/* ErrorsReasonArgumentsMessage.

	   Filter by errors.reason.arguments.message
	*/
	ErrorsReasonArgumentsMessage *string

	/* ErrorsReasonCode.

	   Filter by errors.reason.code
	*/
	ErrorsReasonCode *string

	/* ErrorsReasonMessage.

	   Filter by errors.reason.message
	*/
	ErrorsReasonMessage *string

	/* ErrorsSeverity.

	   Filter by errors.severity
	*/
	ErrorsSeverity *string

	/* ErrorsType.

	   Filter by errors.type
	*/
	ErrorsType *string

	/* FcPortsConfiguredDataRate.

	   Filter by fc_ports.configured_data_rate
	*/
	FcPortsConfiguredDataRate *float64

	/* FcPortsConnectionMode.

	   Filter by fc_ports.connection_mode
	*/
	FcPortsConnectionMode *string

	/* FcPortsDataRateCapability.

	   Filter by fc_ports.data_rate_capability
	*/
	FcPortsDataRateCapability *float64

	/* FcPortsEnabled.

	   Filter by fc_ports.enabled
	*/
	FcPortsEnabled *bool

	/* FcPortsID.

	   Filter by fc_ports.id
	*/
	FcPortsID *int64

	/* FcPortsNegotiatedDataRate.

	   Filter by fc_ports.negotiated_data_rate
	*/
	FcPortsNegotiatedDataRate *float64

	/* FcPortsPeerWwn.

	   Filter by fc_ports.peer_wwn
	*/
	FcPortsPeerWwn *string

	/* FcPortsSfpDataRateCapability.

	   Filter by fc_ports.sfp.data_rate_capability
	*/
	FcPortsSfpDataRateCapability *float64

	/* FcPortsSfpPartNumber.

	   Filter by fc_ports.sfp.part_number
	*/
	FcPortsSfpPartNumber *string

	/* FcPortsSfpSerialNumber.

	   Filter by fc_ports.sfp.serial_number
	*/
	FcPortsSfpSerialNumber *string

	/* FcPortsSfpVendor.

	   Filter by fc_ports.sfp.vendor
	*/
	FcPortsSfpVendor *string

	/* FcPortsState.

	   Filter by fc_ports.state
	*/
	FcPortsState *string

	/* FcPortsWwn.

	   Filter by fc_ports.wwn
	*/
	FcPortsWwn *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FirmwareVersion.

	   Filter by firmware_version
	*/
	FirmwareVersion *string

	/* IPAddress.

	   Filter by ip_address
	*/
	IPAddress *string

	/* LastRebootReasonArgumentsCode.

	   Filter by last_reboot.reason.arguments.code
	*/
	LastRebootReasonArgumentsCode *string

	/* LastRebootReasonArgumentsMessage.

	   Filter by last_reboot.reason.arguments.message
	*/
	LastRebootReasonArgumentsMessage *string

	/* LastRebootReasonCode.

	   Filter by last_reboot.reason.code
	*/
	LastRebootReasonCode *string

	/* LastRebootReasonMessage.

	   Filter by last_reboot.reason.message
	*/
	LastRebootReasonMessage *string

	/* LastRebootTime.

	   Filter by last_reboot.time
	*/
	LastRebootTime *string

	/* ManagedBy.

	   Filter by managed_by
	*/
	ManagedBy *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Model.

	   Filter by model
	*/
	Model *string

	/* MonitoringEnabled.

	   Filter by monitoring_enabled
	*/
	MonitoringEnabled *bool

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PathsName.

	   Filter by paths.name
	*/
	PathsName *string

	/* PathsNodeName.

	   Filter by paths.node.name
	*/
	PathsNodeName *string

	/* PathsNodeUUID.

	   Filter by paths.node.uuid
	*/
	PathsNodeUUID *string

	/* PathsSourcePortID.

	   Filter by paths.source_port.id
	*/
	PathsSourcePortID *string

	/* PathsSourcePortName.

	   Filter by paths.source_port.name
	*/
	PathsSourcePortName *string

	/* PathsTargetPortID.

	   Filter by paths.target_port.id
	*/
	PathsTargetPortID *string

	/* PathsTargetPortName.

	   Filter by paths.target_port.name
	*/
	PathsTargetPortName *string

	/* PathsTargetPortWwn.

	   Filter by paths.target_port.wwn
	*/
	PathsTargetPortWwn *string

	/* PowerSupplyUnitsName.

	   Filter by power_supply_units.name
	*/
	PowerSupplyUnitsName *string

	/* PowerSupplyUnitsState.

	   Filter by power_supply_units.state
	*/
	PowerSupplyUnitsState *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SasPortsCablePartNumber.

	   Filter by sas_ports.cable.part_number
	*/
	SasPortsCablePartNumber *string

	/* SasPortsCableSerialNumber.

	   Filter by sas_ports.cable.serial_number
	*/
	SasPortsCableSerialNumber *string

	/* SasPortsCableTechnology.

	   Filter by sas_ports.cable.technology
	*/
	SasPortsCableTechnology *string

	/* SasPortsCableVendor.

	   Filter by sas_ports.cable.vendor
	*/
	SasPortsCableVendor *string

	/* SasPortsDataRateCapability.

	   Filter by sas_ports.data_rate_capability
	*/
	SasPortsDataRateCapability *float64

	/* SasPortsEnabled.

	   Filter by sas_ports.enabled
	*/
	SasPortsEnabled *bool

	/* SasPortsID.

	   Filter by sas_ports.id
	*/
	SasPortsID *int64

	/* SasPortsNegotiatedDataRate.

	   Filter by sas_ports.negotiated_data_rate
	*/
	SasPortsNegotiatedDataRate *float64

	/* SasPortsPhy1State.

	   Filter by sas_ports.phy_1.state
	*/
	SasPortsPhy1State *string

	/* SasPortsPhy2State.

	   Filter by sas_ports.phy_2.state
	*/
	SasPortsPhy2State *string

	/* SasPortsPhy3State.

	   Filter by sas_ports.phy_3.state
	*/
	SasPortsPhy3State *string

	/* SasPortsPhy4State.

	   Filter by sas_ports.phy_4.state
	*/
	SasPortsPhy4State *string

	/* SasPortsState.

	   Filter by sas_ports.state
	*/
	SasPortsState *string

	/* SasPortsWwn.

	   Filter by sas_ports.wwn
	*/
	SasPortsWwn *string

	/* SecurityEnabled.

	   Filter by security_enabled
	*/
	SecurityEnabled *bool

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SymbolicName.

	   Filter by symbolic_name
	*/
	SymbolicName *string

	/* TemperatureSensorMaximum.

	   Filter by temperature_sensor.maximum
	*/
	TemperatureSensorMaximum *int64

	/* TemperatureSensorMinimum.

	   Filter by temperature_sensor.minimum
	*/
	TemperatureSensorMinimum *int64

	/* TemperatureSensorName.

	   Filter by temperature_sensor.name
	*/
	TemperatureSensorName *string

	/* TemperatureSensorReading.

	   Filter by temperature_sensor.reading
	*/
	TemperatureSensorReading *int64

	/* TemperatureSensorState.

	   Filter by temperature_sensor.state
	*/
	TemperatureSensorState *string

	/* Vendor.

	   Filter by vendor
	*/
	Vendor *string

	/* Wwn.

	   Filter by wwn
	*/
	Wwn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage bridge collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageBridgeCollectionGetParams) WithDefaults() *StorageBridgeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage bridge collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageBridgeCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := StorageBridgeCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTimeout(timeout time.Duration) *StorageBridgeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithContext(ctx context.Context) *StorageBridgeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithHTTPClient(client *http.Client) *StorageBridgeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithChassisThroughputState adds the chassisThroughputState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithChassisThroughputState(chassisThroughputState *string) *StorageBridgeCollectionGetParams {
	o.SetChassisThroughputState(chassisThroughputState)
	return o
}

// SetChassisThroughputState adds the chassisThroughputState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetChassisThroughputState(chassisThroughputState *string) {
	o.ChassisThroughputState = chassisThroughputState
}

// WithDramSingleBitErrorCount adds the dramSingleBitErrorCount to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithDramSingleBitErrorCount(dramSingleBitErrorCount *int64) *StorageBridgeCollectionGetParams {
	o.SetDramSingleBitErrorCount(dramSingleBitErrorCount)
	return o
}

// SetDramSingleBitErrorCount adds the dramSingleBitErrorCount to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetDramSingleBitErrorCount(dramSingleBitErrorCount *int64) {
	o.DramSingleBitErrorCount = dramSingleBitErrorCount
}

// WithErrorsComponentID adds the errorsComponentID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsComponentID(errorsComponentID *int64) *StorageBridgeCollectionGetParams {
	o.SetErrorsComponentID(errorsComponentID)
	return o
}

// SetErrorsComponentID adds the errorsComponentId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsComponentID(errorsComponentID *int64) {
	o.ErrorsComponentID = errorsComponentID
}

// WithErrorsComponentName adds the errorsComponentName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsComponentName(errorsComponentName *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsComponentName(errorsComponentName)
	return o
}

// SetErrorsComponentName adds the errorsComponentName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsComponentName(errorsComponentName *string) {
	o.ErrorsComponentName = errorsComponentName
}

// WithErrorsComponentUniqueID adds the errorsComponentUniqueID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsComponentUniqueID(errorsComponentUniqueID *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsComponentUniqueID(errorsComponentUniqueID)
	return o
}

// SetErrorsComponentUniqueID adds the errorsComponentUniqueId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsComponentUniqueID(errorsComponentUniqueID *string) {
	o.ErrorsComponentUniqueID = errorsComponentUniqueID
}

// WithErrorsReasonArgumentsCode adds the errorsReasonArgumentsCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsReasonArgumentsCode(errorsReasonArgumentsCode *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsReasonArgumentsCode(errorsReasonArgumentsCode)
	return o
}

// SetErrorsReasonArgumentsCode adds the errorsReasonArgumentsCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsReasonArgumentsCode(errorsReasonArgumentsCode *string) {
	o.ErrorsReasonArgumentsCode = errorsReasonArgumentsCode
}

// WithErrorsReasonArgumentsMessage adds the errorsReasonArgumentsMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage)
	return o
}

// SetErrorsReasonArgumentsMessage adds the errorsReasonArgumentsMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsReasonArgumentsMessage(errorsReasonArgumentsMessage *string) {
	o.ErrorsReasonArgumentsMessage = errorsReasonArgumentsMessage
}

// WithErrorsReasonCode adds the errorsReasonCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsReasonCode(errorsReasonCode *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsReasonCode(errorsReasonCode)
	return o
}

// SetErrorsReasonCode adds the errorsReasonCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsReasonCode(errorsReasonCode *string) {
	o.ErrorsReasonCode = errorsReasonCode
}

// WithErrorsReasonMessage adds the errorsReasonMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsReasonMessage(errorsReasonMessage *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsReasonMessage(errorsReasonMessage)
	return o
}

// SetErrorsReasonMessage adds the errorsReasonMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsReasonMessage(errorsReasonMessage *string) {
	o.ErrorsReasonMessage = errorsReasonMessage
}

// WithErrorsSeverity adds the errorsSeverity to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsSeverity(errorsSeverity *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsSeverity(errorsSeverity)
	return o
}

// SetErrorsSeverity adds the errorsSeverity to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsSeverity(errorsSeverity *string) {
	o.ErrorsSeverity = errorsSeverity
}

// WithErrorsType adds the errorsType to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithErrorsType(errorsType *string) *StorageBridgeCollectionGetParams {
	o.SetErrorsType(errorsType)
	return o
}

// SetErrorsType adds the errorsType to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetErrorsType(errorsType *string) {
	o.ErrorsType = errorsType
}

// WithFcPortsConfiguredDataRate adds the fcPortsConfiguredDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsConfiguredDataRate(fcPortsConfiguredDataRate *float64) *StorageBridgeCollectionGetParams {
	o.SetFcPortsConfiguredDataRate(fcPortsConfiguredDataRate)
	return o
}

// SetFcPortsConfiguredDataRate adds the fcPortsConfiguredDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsConfiguredDataRate(fcPortsConfiguredDataRate *float64) {
	o.FcPortsConfiguredDataRate = fcPortsConfiguredDataRate
}

// WithFcPortsConnectionMode adds the fcPortsConnectionMode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsConnectionMode(fcPortsConnectionMode *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsConnectionMode(fcPortsConnectionMode)
	return o
}

// SetFcPortsConnectionMode adds the fcPortsConnectionMode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsConnectionMode(fcPortsConnectionMode *string) {
	o.FcPortsConnectionMode = fcPortsConnectionMode
}

// WithFcPortsDataRateCapability adds the fcPortsDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsDataRateCapability(fcPortsDataRateCapability *float64) *StorageBridgeCollectionGetParams {
	o.SetFcPortsDataRateCapability(fcPortsDataRateCapability)
	return o
}

// SetFcPortsDataRateCapability adds the fcPortsDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsDataRateCapability(fcPortsDataRateCapability *float64) {
	o.FcPortsDataRateCapability = fcPortsDataRateCapability
}

// WithFcPortsEnabled adds the fcPortsEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsEnabled(fcPortsEnabled *bool) *StorageBridgeCollectionGetParams {
	o.SetFcPortsEnabled(fcPortsEnabled)
	return o
}

// SetFcPortsEnabled adds the fcPortsEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsEnabled(fcPortsEnabled *bool) {
	o.FcPortsEnabled = fcPortsEnabled
}

// WithFcPortsID adds the fcPortsID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsID(fcPortsID *int64) *StorageBridgeCollectionGetParams {
	o.SetFcPortsID(fcPortsID)
	return o
}

// SetFcPortsID adds the fcPortsId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsID(fcPortsID *int64) {
	o.FcPortsID = fcPortsID
}

// WithFcPortsNegotiatedDataRate adds the fcPortsNegotiatedDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsNegotiatedDataRate(fcPortsNegotiatedDataRate *float64) *StorageBridgeCollectionGetParams {
	o.SetFcPortsNegotiatedDataRate(fcPortsNegotiatedDataRate)
	return o
}

// SetFcPortsNegotiatedDataRate adds the fcPortsNegotiatedDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsNegotiatedDataRate(fcPortsNegotiatedDataRate *float64) {
	o.FcPortsNegotiatedDataRate = fcPortsNegotiatedDataRate
}

// WithFcPortsPeerWwn adds the fcPortsPeerWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsPeerWwn(fcPortsPeerWwn *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsPeerWwn(fcPortsPeerWwn)
	return o
}

// SetFcPortsPeerWwn adds the fcPortsPeerWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsPeerWwn(fcPortsPeerWwn *string) {
	o.FcPortsPeerWwn = fcPortsPeerWwn
}

// WithFcPortsSfpDataRateCapability adds the fcPortsSfpDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsSfpDataRateCapability(fcPortsSfpDataRateCapability *float64) *StorageBridgeCollectionGetParams {
	o.SetFcPortsSfpDataRateCapability(fcPortsSfpDataRateCapability)
	return o
}

// SetFcPortsSfpDataRateCapability adds the fcPortsSfpDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsSfpDataRateCapability(fcPortsSfpDataRateCapability *float64) {
	o.FcPortsSfpDataRateCapability = fcPortsSfpDataRateCapability
}

// WithFcPortsSfpPartNumber adds the fcPortsSfpPartNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsSfpPartNumber(fcPortsSfpPartNumber *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsSfpPartNumber(fcPortsSfpPartNumber)
	return o
}

// SetFcPortsSfpPartNumber adds the fcPortsSfpPartNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsSfpPartNumber(fcPortsSfpPartNumber *string) {
	o.FcPortsSfpPartNumber = fcPortsSfpPartNumber
}

// WithFcPortsSfpSerialNumber adds the fcPortsSfpSerialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsSfpSerialNumber(fcPortsSfpSerialNumber *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsSfpSerialNumber(fcPortsSfpSerialNumber)
	return o
}

// SetFcPortsSfpSerialNumber adds the fcPortsSfpSerialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsSfpSerialNumber(fcPortsSfpSerialNumber *string) {
	o.FcPortsSfpSerialNumber = fcPortsSfpSerialNumber
}

// WithFcPortsSfpVendor adds the fcPortsSfpVendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsSfpVendor(fcPortsSfpVendor *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsSfpVendor(fcPortsSfpVendor)
	return o
}

// SetFcPortsSfpVendor adds the fcPortsSfpVendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsSfpVendor(fcPortsSfpVendor *string) {
	o.FcPortsSfpVendor = fcPortsSfpVendor
}

// WithFcPortsState adds the fcPortsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsState(fcPortsState *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsState(fcPortsState)
	return o
}

// SetFcPortsState adds the fcPortsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsState(fcPortsState *string) {
	o.FcPortsState = fcPortsState
}

// WithFcPortsWwn adds the fcPortsWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFcPortsWwn(fcPortsWwn *string) *StorageBridgeCollectionGetParams {
	o.SetFcPortsWwn(fcPortsWwn)
	return o
}

// SetFcPortsWwn adds the fcPortsWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFcPortsWwn(fcPortsWwn *string) {
	o.FcPortsWwn = fcPortsWwn
}

// WithFields adds the fields to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFields(fields []string) *StorageBridgeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFirmwareVersion adds the firmwareVersion to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithFirmwareVersion(firmwareVersion *string) *StorageBridgeCollectionGetParams {
	o.SetFirmwareVersion(firmwareVersion)
	return o
}

// SetFirmwareVersion adds the firmwareVersion to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetFirmwareVersion(firmwareVersion *string) {
	o.FirmwareVersion = firmwareVersion
}

// WithIPAddress adds the iPAddress to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithIPAddress(iPAddress *string) *StorageBridgeCollectionGetParams {
	o.SetIPAddress(iPAddress)
	return o
}

// SetIPAddress adds the ipAddress to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetIPAddress(iPAddress *string) {
	o.IPAddress = iPAddress
}

// WithLastRebootReasonArgumentsCode adds the lastRebootReasonArgumentsCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithLastRebootReasonArgumentsCode(lastRebootReasonArgumentsCode *string) *StorageBridgeCollectionGetParams {
	o.SetLastRebootReasonArgumentsCode(lastRebootReasonArgumentsCode)
	return o
}

// SetLastRebootReasonArgumentsCode adds the lastRebootReasonArgumentsCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetLastRebootReasonArgumentsCode(lastRebootReasonArgumentsCode *string) {
	o.LastRebootReasonArgumentsCode = lastRebootReasonArgumentsCode
}

// WithLastRebootReasonArgumentsMessage adds the lastRebootReasonArgumentsMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithLastRebootReasonArgumentsMessage(lastRebootReasonArgumentsMessage *string) *StorageBridgeCollectionGetParams {
	o.SetLastRebootReasonArgumentsMessage(lastRebootReasonArgumentsMessage)
	return o
}

// SetLastRebootReasonArgumentsMessage adds the lastRebootReasonArgumentsMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetLastRebootReasonArgumentsMessage(lastRebootReasonArgumentsMessage *string) {
	o.LastRebootReasonArgumentsMessage = lastRebootReasonArgumentsMessage
}

// WithLastRebootReasonCode adds the lastRebootReasonCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithLastRebootReasonCode(lastRebootReasonCode *string) *StorageBridgeCollectionGetParams {
	o.SetLastRebootReasonCode(lastRebootReasonCode)
	return o
}

// SetLastRebootReasonCode adds the lastRebootReasonCode to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetLastRebootReasonCode(lastRebootReasonCode *string) {
	o.LastRebootReasonCode = lastRebootReasonCode
}

// WithLastRebootReasonMessage adds the lastRebootReasonMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithLastRebootReasonMessage(lastRebootReasonMessage *string) *StorageBridgeCollectionGetParams {
	o.SetLastRebootReasonMessage(lastRebootReasonMessage)
	return o
}

// SetLastRebootReasonMessage adds the lastRebootReasonMessage to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetLastRebootReasonMessage(lastRebootReasonMessage *string) {
	o.LastRebootReasonMessage = lastRebootReasonMessage
}

// WithLastRebootTime adds the lastRebootTime to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithLastRebootTime(lastRebootTime *string) *StorageBridgeCollectionGetParams {
	o.SetLastRebootTime(lastRebootTime)
	return o
}

// SetLastRebootTime adds the lastRebootTime to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetLastRebootTime(lastRebootTime *string) {
	o.LastRebootTime = lastRebootTime
}

// WithManagedBy adds the managedBy to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithManagedBy(managedBy *string) *StorageBridgeCollectionGetParams {
	o.SetManagedBy(managedBy)
	return o
}

// SetManagedBy adds the managedBy to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetManagedBy(managedBy *string) {
	o.ManagedBy = managedBy
}

// WithMaxRecords adds the maxRecords to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithMaxRecords(maxRecords *int64) *StorageBridgeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithModel adds the model to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithModel(model *string) *StorageBridgeCollectionGetParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetModel(model *string) {
	o.Model = model
}

// WithMonitoringEnabled adds the monitoringEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithMonitoringEnabled(monitoringEnabled *bool) *StorageBridgeCollectionGetParams {
	o.SetMonitoringEnabled(monitoringEnabled)
	return o
}

// SetMonitoringEnabled adds the monitoringEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetMonitoringEnabled(monitoringEnabled *bool) {
	o.MonitoringEnabled = monitoringEnabled
}

// WithName adds the name to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithName(name *string) *StorageBridgeCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithOrderBy(orderBy []string) *StorageBridgeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPathsName adds the pathsName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsName(pathsName *string) *StorageBridgeCollectionGetParams {
	o.SetPathsName(pathsName)
	return o
}

// SetPathsName adds the pathsName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsName(pathsName *string) {
	o.PathsName = pathsName
}

// WithPathsNodeName adds the pathsNodeName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsNodeName(pathsNodeName *string) *StorageBridgeCollectionGetParams {
	o.SetPathsNodeName(pathsNodeName)
	return o
}

// SetPathsNodeName adds the pathsNodeName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsNodeName(pathsNodeName *string) {
	o.PathsNodeName = pathsNodeName
}

// WithPathsNodeUUID adds the pathsNodeUUID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsNodeUUID(pathsNodeUUID *string) *StorageBridgeCollectionGetParams {
	o.SetPathsNodeUUID(pathsNodeUUID)
	return o
}

// SetPathsNodeUUID adds the pathsNodeUuid to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsNodeUUID(pathsNodeUUID *string) {
	o.PathsNodeUUID = pathsNodeUUID
}

// WithPathsSourcePortID adds the pathsSourcePortID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsSourcePortID(pathsSourcePortID *string) *StorageBridgeCollectionGetParams {
	o.SetPathsSourcePortID(pathsSourcePortID)
	return o
}

// SetPathsSourcePortID adds the pathsSourcePortId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsSourcePortID(pathsSourcePortID *string) {
	o.PathsSourcePortID = pathsSourcePortID
}

// WithPathsSourcePortName adds the pathsSourcePortName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsSourcePortName(pathsSourcePortName *string) *StorageBridgeCollectionGetParams {
	o.SetPathsSourcePortName(pathsSourcePortName)
	return o
}

// SetPathsSourcePortName adds the pathsSourcePortName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsSourcePortName(pathsSourcePortName *string) {
	o.PathsSourcePortName = pathsSourcePortName
}

// WithPathsTargetPortID adds the pathsTargetPortID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsTargetPortID(pathsTargetPortID *string) *StorageBridgeCollectionGetParams {
	o.SetPathsTargetPortID(pathsTargetPortID)
	return o
}

// SetPathsTargetPortID adds the pathsTargetPortId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsTargetPortID(pathsTargetPortID *string) {
	o.PathsTargetPortID = pathsTargetPortID
}

// WithPathsTargetPortName adds the pathsTargetPortName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsTargetPortName(pathsTargetPortName *string) *StorageBridgeCollectionGetParams {
	o.SetPathsTargetPortName(pathsTargetPortName)
	return o
}

// SetPathsTargetPortName adds the pathsTargetPortName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsTargetPortName(pathsTargetPortName *string) {
	o.PathsTargetPortName = pathsTargetPortName
}

// WithPathsTargetPortWwn adds the pathsTargetPortWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPathsTargetPortWwn(pathsTargetPortWwn *string) *StorageBridgeCollectionGetParams {
	o.SetPathsTargetPortWwn(pathsTargetPortWwn)
	return o
}

// SetPathsTargetPortWwn adds the pathsTargetPortWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPathsTargetPortWwn(pathsTargetPortWwn *string) {
	o.PathsTargetPortWwn = pathsTargetPortWwn
}

// WithPowerSupplyUnitsName adds the powerSupplyUnitsName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPowerSupplyUnitsName(powerSupplyUnitsName *string) *StorageBridgeCollectionGetParams {
	o.SetPowerSupplyUnitsName(powerSupplyUnitsName)
	return o
}

// SetPowerSupplyUnitsName adds the powerSupplyUnitsName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPowerSupplyUnitsName(powerSupplyUnitsName *string) {
	o.PowerSupplyUnitsName = powerSupplyUnitsName
}

// WithPowerSupplyUnitsState adds the powerSupplyUnitsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithPowerSupplyUnitsState(powerSupplyUnitsState *string) *StorageBridgeCollectionGetParams {
	o.SetPowerSupplyUnitsState(powerSupplyUnitsState)
	return o
}

// SetPowerSupplyUnitsState adds the powerSupplyUnitsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetPowerSupplyUnitsState(powerSupplyUnitsState *string) {
	o.PowerSupplyUnitsState = powerSupplyUnitsState
}

// WithReturnRecords adds the returnRecords to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithReturnRecords(returnRecords *bool) *StorageBridgeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *StorageBridgeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSasPortsCablePartNumber adds the sasPortsCablePartNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsCablePartNumber(sasPortsCablePartNumber *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsCablePartNumber(sasPortsCablePartNumber)
	return o
}

// SetSasPortsCablePartNumber adds the sasPortsCablePartNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsCablePartNumber(sasPortsCablePartNumber *string) {
	o.SasPortsCablePartNumber = sasPortsCablePartNumber
}

// WithSasPortsCableSerialNumber adds the sasPortsCableSerialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsCableSerialNumber(sasPortsCableSerialNumber *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsCableSerialNumber(sasPortsCableSerialNumber)
	return o
}

// SetSasPortsCableSerialNumber adds the sasPortsCableSerialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsCableSerialNumber(sasPortsCableSerialNumber *string) {
	o.SasPortsCableSerialNumber = sasPortsCableSerialNumber
}

// WithSasPortsCableTechnology adds the sasPortsCableTechnology to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsCableTechnology(sasPortsCableTechnology *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsCableTechnology(sasPortsCableTechnology)
	return o
}

// SetSasPortsCableTechnology adds the sasPortsCableTechnology to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsCableTechnology(sasPortsCableTechnology *string) {
	o.SasPortsCableTechnology = sasPortsCableTechnology
}

// WithSasPortsCableVendor adds the sasPortsCableVendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsCableVendor(sasPortsCableVendor *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsCableVendor(sasPortsCableVendor)
	return o
}

// SetSasPortsCableVendor adds the sasPortsCableVendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsCableVendor(sasPortsCableVendor *string) {
	o.SasPortsCableVendor = sasPortsCableVendor
}

// WithSasPortsDataRateCapability adds the sasPortsDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsDataRateCapability(sasPortsDataRateCapability *float64) *StorageBridgeCollectionGetParams {
	o.SetSasPortsDataRateCapability(sasPortsDataRateCapability)
	return o
}

// SetSasPortsDataRateCapability adds the sasPortsDataRateCapability to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsDataRateCapability(sasPortsDataRateCapability *float64) {
	o.SasPortsDataRateCapability = sasPortsDataRateCapability
}

// WithSasPortsEnabled adds the sasPortsEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsEnabled(sasPortsEnabled *bool) *StorageBridgeCollectionGetParams {
	o.SetSasPortsEnabled(sasPortsEnabled)
	return o
}

// SetSasPortsEnabled adds the sasPortsEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsEnabled(sasPortsEnabled *bool) {
	o.SasPortsEnabled = sasPortsEnabled
}

// WithSasPortsID adds the sasPortsID to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsID(sasPortsID *int64) *StorageBridgeCollectionGetParams {
	o.SetSasPortsID(sasPortsID)
	return o
}

// SetSasPortsID adds the sasPortsId to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsID(sasPortsID *int64) {
	o.SasPortsID = sasPortsID
}

// WithSasPortsNegotiatedDataRate adds the sasPortsNegotiatedDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsNegotiatedDataRate(sasPortsNegotiatedDataRate *float64) *StorageBridgeCollectionGetParams {
	o.SetSasPortsNegotiatedDataRate(sasPortsNegotiatedDataRate)
	return o
}

// SetSasPortsNegotiatedDataRate adds the sasPortsNegotiatedDataRate to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsNegotiatedDataRate(sasPortsNegotiatedDataRate *float64) {
	o.SasPortsNegotiatedDataRate = sasPortsNegotiatedDataRate
}

// WithSasPortsPhy1State adds the sasPortsPhy1State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsPhy1State(sasPortsPhy1State *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsPhy1State(sasPortsPhy1State)
	return o
}

// SetSasPortsPhy1State adds the sasPortsPhy1State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsPhy1State(sasPortsPhy1State *string) {
	o.SasPortsPhy1State = sasPortsPhy1State
}

// WithSasPortsPhy2State adds the sasPortsPhy2State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsPhy2State(sasPortsPhy2State *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsPhy2State(sasPortsPhy2State)
	return o
}

// SetSasPortsPhy2State adds the sasPortsPhy2State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsPhy2State(sasPortsPhy2State *string) {
	o.SasPortsPhy2State = sasPortsPhy2State
}

// WithSasPortsPhy3State adds the sasPortsPhy3State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsPhy3State(sasPortsPhy3State *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsPhy3State(sasPortsPhy3State)
	return o
}

// SetSasPortsPhy3State adds the sasPortsPhy3State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsPhy3State(sasPortsPhy3State *string) {
	o.SasPortsPhy3State = sasPortsPhy3State
}

// WithSasPortsPhy4State adds the sasPortsPhy4State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsPhy4State(sasPortsPhy4State *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsPhy4State(sasPortsPhy4State)
	return o
}

// SetSasPortsPhy4State adds the sasPortsPhy4State to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsPhy4State(sasPortsPhy4State *string) {
	o.SasPortsPhy4State = sasPortsPhy4State
}

// WithSasPortsState adds the sasPortsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsState(sasPortsState *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsState(sasPortsState)
	return o
}

// SetSasPortsState adds the sasPortsState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsState(sasPortsState *string) {
	o.SasPortsState = sasPortsState
}

// WithSasPortsWwn adds the sasPortsWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSasPortsWwn(sasPortsWwn *string) *StorageBridgeCollectionGetParams {
	o.SetSasPortsWwn(sasPortsWwn)
	return o
}

// SetSasPortsWwn adds the sasPortsWwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSasPortsWwn(sasPortsWwn *string) {
	o.SasPortsWwn = sasPortsWwn
}

// WithSecurityEnabled adds the securityEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSecurityEnabled(securityEnabled *bool) *StorageBridgeCollectionGetParams {
	o.SetSecurityEnabled(securityEnabled)
	return o
}

// SetSecurityEnabled adds the securityEnabled to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSecurityEnabled(securityEnabled *bool) {
	o.SecurityEnabled = securityEnabled
}

// WithSerialNumber adds the serialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSerialNumber(serialNumber *string) *StorageBridgeCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithState adds the state to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithState(state *string) *StorageBridgeCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSymbolicName adds the symbolicName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithSymbolicName(symbolicName *string) *StorageBridgeCollectionGetParams {
	o.SetSymbolicName(symbolicName)
	return o
}

// SetSymbolicName adds the symbolicName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetSymbolicName(symbolicName *string) {
	o.SymbolicName = symbolicName
}

// WithTemperatureSensorMaximum adds the temperatureSensorMaximum to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTemperatureSensorMaximum(temperatureSensorMaximum *int64) *StorageBridgeCollectionGetParams {
	o.SetTemperatureSensorMaximum(temperatureSensorMaximum)
	return o
}

// SetTemperatureSensorMaximum adds the temperatureSensorMaximum to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTemperatureSensorMaximum(temperatureSensorMaximum *int64) {
	o.TemperatureSensorMaximum = temperatureSensorMaximum
}

// WithTemperatureSensorMinimum adds the temperatureSensorMinimum to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTemperatureSensorMinimum(temperatureSensorMinimum *int64) *StorageBridgeCollectionGetParams {
	o.SetTemperatureSensorMinimum(temperatureSensorMinimum)
	return o
}

// SetTemperatureSensorMinimum adds the temperatureSensorMinimum to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTemperatureSensorMinimum(temperatureSensorMinimum *int64) {
	o.TemperatureSensorMinimum = temperatureSensorMinimum
}

// WithTemperatureSensorName adds the temperatureSensorName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTemperatureSensorName(temperatureSensorName *string) *StorageBridgeCollectionGetParams {
	o.SetTemperatureSensorName(temperatureSensorName)
	return o
}

// SetTemperatureSensorName adds the temperatureSensorName to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTemperatureSensorName(temperatureSensorName *string) {
	o.TemperatureSensorName = temperatureSensorName
}

// WithTemperatureSensorReading adds the temperatureSensorReading to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTemperatureSensorReading(temperatureSensorReading *int64) *StorageBridgeCollectionGetParams {
	o.SetTemperatureSensorReading(temperatureSensorReading)
	return o
}

// SetTemperatureSensorReading adds the temperatureSensorReading to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTemperatureSensorReading(temperatureSensorReading *int64) {
	o.TemperatureSensorReading = temperatureSensorReading
}

// WithTemperatureSensorState adds the temperatureSensorState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithTemperatureSensorState(temperatureSensorState *string) *StorageBridgeCollectionGetParams {
	o.SetTemperatureSensorState(temperatureSensorState)
	return o
}

// SetTemperatureSensorState adds the temperatureSensorState to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetTemperatureSensorState(temperatureSensorState *string) {
	o.TemperatureSensorState = temperatureSensorState
}

// WithVendor adds the vendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithVendor(vendor *string) *StorageBridgeCollectionGetParams {
	o.SetVendor(vendor)
	return o
}

// SetVendor adds the vendor to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetVendor(vendor *string) {
	o.Vendor = vendor
}

// WithWwn adds the wwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) WithWwn(wwn *string) *StorageBridgeCollectionGetParams {
	o.SetWwn(wwn)
	return o
}

// SetWwn adds the wwn to the storage bridge collection get params
func (o *StorageBridgeCollectionGetParams) SetWwn(wwn *string) {
	o.Wwn = wwn
}

// WriteToRequest writes these params to a swagger request
func (o *StorageBridgeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ChassisThroughputState != nil {

		// query param chassis_throughput_state
		var qrChassisThroughputState string

		if o.ChassisThroughputState != nil {
			qrChassisThroughputState = *o.ChassisThroughputState
		}
		qChassisThroughputState := qrChassisThroughputState
		if qChassisThroughputState != "" {

			if err := r.SetQueryParam("chassis_throughput_state", qChassisThroughputState); err != nil {
				return err
			}
		}
	}

	if o.DramSingleBitErrorCount != nil {

		// query param dram_single_bit_error_count
		var qrDramSingleBitErrorCount int64

		if o.DramSingleBitErrorCount != nil {
			qrDramSingleBitErrorCount = *o.DramSingleBitErrorCount
		}
		qDramSingleBitErrorCount := swag.FormatInt64(qrDramSingleBitErrorCount)
		if qDramSingleBitErrorCount != "" {

			if err := r.SetQueryParam("dram_single_bit_error_count", qDramSingleBitErrorCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorsComponentID != nil {

		// query param errors.component.id
		var qrErrorsComponentID int64

		if o.ErrorsComponentID != nil {
			qrErrorsComponentID = *o.ErrorsComponentID
		}
		qErrorsComponentID := swag.FormatInt64(qrErrorsComponentID)
		if qErrorsComponentID != "" {

			if err := r.SetQueryParam("errors.component.id", qErrorsComponentID); err != nil {
				return err
			}
		}
	}

	if o.ErrorsComponentName != nil {

		// query param errors.component.name
		var qrErrorsComponentName string

		if o.ErrorsComponentName != nil {
			qrErrorsComponentName = *o.ErrorsComponentName
		}
		qErrorsComponentName := qrErrorsComponentName
		if qErrorsComponentName != "" {

			if err := r.SetQueryParam("errors.component.name", qErrorsComponentName); err != nil {
				return err
			}
		}
	}

	if o.ErrorsComponentUniqueID != nil {

		// query param errors.component.unique_id
		var qrErrorsComponentUniqueID string

		if o.ErrorsComponentUniqueID != nil {
			qrErrorsComponentUniqueID = *o.ErrorsComponentUniqueID
		}
		qErrorsComponentUniqueID := qrErrorsComponentUniqueID
		if qErrorsComponentUniqueID != "" {

			if err := r.SetQueryParam("errors.component.unique_id", qErrorsComponentUniqueID); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonArgumentsCode != nil {

		// query param errors.reason.arguments.code
		var qrErrorsReasonArgumentsCode string

		if o.ErrorsReasonArgumentsCode != nil {
			qrErrorsReasonArgumentsCode = *o.ErrorsReasonArgumentsCode
		}
		qErrorsReasonArgumentsCode := qrErrorsReasonArgumentsCode
		if qErrorsReasonArgumentsCode != "" {

			if err := r.SetQueryParam("errors.reason.arguments.code", qErrorsReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonArgumentsMessage != nil {

		// query param errors.reason.arguments.message
		var qrErrorsReasonArgumentsMessage string

		if o.ErrorsReasonArgumentsMessage != nil {
			qrErrorsReasonArgumentsMessage = *o.ErrorsReasonArgumentsMessage
		}
		qErrorsReasonArgumentsMessage := qrErrorsReasonArgumentsMessage
		if qErrorsReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("errors.reason.arguments.message", qErrorsReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonCode != nil {

		// query param errors.reason.code
		var qrErrorsReasonCode string

		if o.ErrorsReasonCode != nil {
			qrErrorsReasonCode = *o.ErrorsReasonCode
		}
		qErrorsReasonCode := qrErrorsReasonCode
		if qErrorsReasonCode != "" {

			if err := r.SetQueryParam("errors.reason.code", qErrorsReasonCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsReasonMessage != nil {

		// query param errors.reason.message
		var qrErrorsReasonMessage string

		if o.ErrorsReasonMessage != nil {
			qrErrorsReasonMessage = *o.ErrorsReasonMessage
		}
		qErrorsReasonMessage := qrErrorsReasonMessage
		if qErrorsReasonMessage != "" {

			if err := r.SetQueryParam("errors.reason.message", qErrorsReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsSeverity != nil {

		// query param errors.severity
		var qrErrorsSeverity string

		if o.ErrorsSeverity != nil {
			qrErrorsSeverity = *o.ErrorsSeverity
		}
		qErrorsSeverity := qrErrorsSeverity
		if qErrorsSeverity != "" {

			if err := r.SetQueryParam("errors.severity", qErrorsSeverity); err != nil {
				return err
			}
		}
	}

	if o.ErrorsType != nil {

		// query param errors.type
		var qrErrorsType string

		if o.ErrorsType != nil {
			qrErrorsType = *o.ErrorsType
		}
		qErrorsType := qrErrorsType
		if qErrorsType != "" {

			if err := r.SetQueryParam("errors.type", qErrorsType); err != nil {
				return err
			}
		}
	}

	if o.FcPortsConfiguredDataRate != nil {

		// query param fc_ports.configured_data_rate
		var qrFcPortsConfiguredDataRate float64

		if o.FcPortsConfiguredDataRate != nil {
			qrFcPortsConfiguredDataRate = *o.FcPortsConfiguredDataRate
		}
		qFcPortsConfiguredDataRate := swag.FormatFloat64(qrFcPortsConfiguredDataRate)
		if qFcPortsConfiguredDataRate != "" {

			if err := r.SetQueryParam("fc_ports.configured_data_rate", qFcPortsConfiguredDataRate); err != nil {
				return err
			}
		}
	}

	if o.FcPortsConnectionMode != nil {

		// query param fc_ports.connection_mode
		var qrFcPortsConnectionMode string

		if o.FcPortsConnectionMode != nil {
			qrFcPortsConnectionMode = *o.FcPortsConnectionMode
		}
		qFcPortsConnectionMode := qrFcPortsConnectionMode
		if qFcPortsConnectionMode != "" {

			if err := r.SetQueryParam("fc_ports.connection_mode", qFcPortsConnectionMode); err != nil {
				return err
			}
		}
	}

	if o.FcPortsDataRateCapability != nil {

		// query param fc_ports.data_rate_capability
		var qrFcPortsDataRateCapability float64

		if o.FcPortsDataRateCapability != nil {
			qrFcPortsDataRateCapability = *o.FcPortsDataRateCapability
		}
		qFcPortsDataRateCapability := swag.FormatFloat64(qrFcPortsDataRateCapability)
		if qFcPortsDataRateCapability != "" {

			if err := r.SetQueryParam("fc_ports.data_rate_capability", qFcPortsDataRateCapability); err != nil {
				return err
			}
		}
	}

	if o.FcPortsEnabled != nil {

		// query param fc_ports.enabled
		var qrFcPortsEnabled bool

		if o.FcPortsEnabled != nil {
			qrFcPortsEnabled = *o.FcPortsEnabled
		}
		qFcPortsEnabled := swag.FormatBool(qrFcPortsEnabled)
		if qFcPortsEnabled != "" {

			if err := r.SetQueryParam("fc_ports.enabled", qFcPortsEnabled); err != nil {
				return err
			}
		}
	}

	if o.FcPortsID != nil {

		// query param fc_ports.id
		var qrFcPortsID int64

		if o.FcPortsID != nil {
			qrFcPortsID = *o.FcPortsID
		}
		qFcPortsID := swag.FormatInt64(qrFcPortsID)
		if qFcPortsID != "" {

			if err := r.SetQueryParam("fc_ports.id", qFcPortsID); err != nil {
				return err
			}
		}
	}

	if o.FcPortsNegotiatedDataRate != nil {

		// query param fc_ports.negotiated_data_rate
		var qrFcPortsNegotiatedDataRate float64

		if o.FcPortsNegotiatedDataRate != nil {
			qrFcPortsNegotiatedDataRate = *o.FcPortsNegotiatedDataRate
		}
		qFcPortsNegotiatedDataRate := swag.FormatFloat64(qrFcPortsNegotiatedDataRate)
		if qFcPortsNegotiatedDataRate != "" {

			if err := r.SetQueryParam("fc_ports.negotiated_data_rate", qFcPortsNegotiatedDataRate); err != nil {
				return err
			}
		}
	}

	if o.FcPortsPeerWwn != nil {

		// query param fc_ports.peer_wwn
		var qrFcPortsPeerWwn string

		if o.FcPortsPeerWwn != nil {
			qrFcPortsPeerWwn = *o.FcPortsPeerWwn
		}
		qFcPortsPeerWwn := qrFcPortsPeerWwn
		if qFcPortsPeerWwn != "" {

			if err := r.SetQueryParam("fc_ports.peer_wwn", qFcPortsPeerWwn); err != nil {
				return err
			}
		}
	}

	if o.FcPortsSfpDataRateCapability != nil {

		// query param fc_ports.sfp.data_rate_capability
		var qrFcPortsSfpDataRateCapability float64

		if o.FcPortsSfpDataRateCapability != nil {
			qrFcPortsSfpDataRateCapability = *o.FcPortsSfpDataRateCapability
		}
		qFcPortsSfpDataRateCapability := swag.FormatFloat64(qrFcPortsSfpDataRateCapability)
		if qFcPortsSfpDataRateCapability != "" {

			if err := r.SetQueryParam("fc_ports.sfp.data_rate_capability", qFcPortsSfpDataRateCapability); err != nil {
				return err
			}
		}
	}

	if o.FcPortsSfpPartNumber != nil {

		// query param fc_ports.sfp.part_number
		var qrFcPortsSfpPartNumber string

		if o.FcPortsSfpPartNumber != nil {
			qrFcPortsSfpPartNumber = *o.FcPortsSfpPartNumber
		}
		qFcPortsSfpPartNumber := qrFcPortsSfpPartNumber
		if qFcPortsSfpPartNumber != "" {

			if err := r.SetQueryParam("fc_ports.sfp.part_number", qFcPortsSfpPartNumber); err != nil {
				return err
			}
		}
	}

	if o.FcPortsSfpSerialNumber != nil {

		// query param fc_ports.sfp.serial_number
		var qrFcPortsSfpSerialNumber string

		if o.FcPortsSfpSerialNumber != nil {
			qrFcPortsSfpSerialNumber = *o.FcPortsSfpSerialNumber
		}
		qFcPortsSfpSerialNumber := qrFcPortsSfpSerialNumber
		if qFcPortsSfpSerialNumber != "" {

			if err := r.SetQueryParam("fc_ports.sfp.serial_number", qFcPortsSfpSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.FcPortsSfpVendor != nil {

		// query param fc_ports.sfp.vendor
		var qrFcPortsSfpVendor string

		if o.FcPortsSfpVendor != nil {
			qrFcPortsSfpVendor = *o.FcPortsSfpVendor
		}
		qFcPortsSfpVendor := qrFcPortsSfpVendor
		if qFcPortsSfpVendor != "" {

			if err := r.SetQueryParam("fc_ports.sfp.vendor", qFcPortsSfpVendor); err != nil {
				return err
			}
		}
	}

	if o.FcPortsState != nil {

		// query param fc_ports.state
		var qrFcPortsState string

		if o.FcPortsState != nil {
			qrFcPortsState = *o.FcPortsState
		}
		qFcPortsState := qrFcPortsState
		if qFcPortsState != "" {

			if err := r.SetQueryParam("fc_ports.state", qFcPortsState); err != nil {
				return err
			}
		}
	}

	if o.FcPortsWwn != nil {

		// query param fc_ports.wwn
		var qrFcPortsWwn string

		if o.FcPortsWwn != nil {
			qrFcPortsWwn = *o.FcPortsWwn
		}
		qFcPortsWwn := qrFcPortsWwn
		if qFcPortsWwn != "" {

			if err := r.SetQueryParam("fc_ports.wwn", qFcPortsWwn); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FirmwareVersion != nil {

		// query param firmware_version
		var qrFirmwareVersion string

		if o.FirmwareVersion != nil {
			qrFirmwareVersion = *o.FirmwareVersion
		}
		qFirmwareVersion := qrFirmwareVersion
		if qFirmwareVersion != "" {

			if err := r.SetQueryParam("firmware_version", qFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.IPAddress != nil {

		// query param ip_address
		var qrIPAddress string

		if o.IPAddress != nil {
			qrIPAddress = *o.IPAddress
		}
		qIPAddress := qrIPAddress
		if qIPAddress != "" {

			if err := r.SetQueryParam("ip_address", qIPAddress); err != nil {
				return err
			}
		}
	}

	if o.LastRebootReasonArgumentsCode != nil {

		// query param last_reboot.reason.arguments.code
		var qrLastRebootReasonArgumentsCode string

		if o.LastRebootReasonArgumentsCode != nil {
			qrLastRebootReasonArgumentsCode = *o.LastRebootReasonArgumentsCode
		}
		qLastRebootReasonArgumentsCode := qrLastRebootReasonArgumentsCode
		if qLastRebootReasonArgumentsCode != "" {

			if err := r.SetQueryParam("last_reboot.reason.arguments.code", qLastRebootReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.LastRebootReasonArgumentsMessage != nil {

		// query param last_reboot.reason.arguments.message
		var qrLastRebootReasonArgumentsMessage string

		if o.LastRebootReasonArgumentsMessage != nil {
			qrLastRebootReasonArgumentsMessage = *o.LastRebootReasonArgumentsMessage
		}
		qLastRebootReasonArgumentsMessage := qrLastRebootReasonArgumentsMessage
		if qLastRebootReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("last_reboot.reason.arguments.message", qLastRebootReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.LastRebootReasonCode != nil {

		// query param last_reboot.reason.code
		var qrLastRebootReasonCode string

		if o.LastRebootReasonCode != nil {
			qrLastRebootReasonCode = *o.LastRebootReasonCode
		}
		qLastRebootReasonCode := qrLastRebootReasonCode
		if qLastRebootReasonCode != "" {

			if err := r.SetQueryParam("last_reboot.reason.code", qLastRebootReasonCode); err != nil {
				return err
			}
		}
	}

	if o.LastRebootReasonMessage != nil {

		// query param last_reboot.reason.message
		var qrLastRebootReasonMessage string

		if o.LastRebootReasonMessage != nil {
			qrLastRebootReasonMessage = *o.LastRebootReasonMessage
		}
		qLastRebootReasonMessage := qrLastRebootReasonMessage
		if qLastRebootReasonMessage != "" {

			if err := r.SetQueryParam("last_reboot.reason.message", qLastRebootReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.LastRebootTime != nil {

		// query param last_reboot.time
		var qrLastRebootTime string

		if o.LastRebootTime != nil {
			qrLastRebootTime = *o.LastRebootTime
		}
		qLastRebootTime := qrLastRebootTime
		if qLastRebootTime != "" {

			if err := r.SetQueryParam("last_reboot.time", qLastRebootTime); err != nil {
				return err
			}
		}
	}

	if o.ManagedBy != nil {

		// query param managed_by
		var qrManagedBy string

		if o.ManagedBy != nil {
			qrManagedBy = *o.ManagedBy
		}
		qManagedBy := qrManagedBy
		if qManagedBy != "" {

			if err := r.SetQueryParam("managed_by", qManagedBy); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.MonitoringEnabled != nil {

		// query param monitoring_enabled
		var qrMonitoringEnabled bool

		if o.MonitoringEnabled != nil {
			qrMonitoringEnabled = *o.MonitoringEnabled
		}
		qMonitoringEnabled := swag.FormatBool(qrMonitoringEnabled)
		if qMonitoringEnabled != "" {

			if err := r.SetQueryParam("monitoring_enabled", qMonitoringEnabled); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PathsName != nil {

		// query param paths.name
		var qrPathsName string

		if o.PathsName != nil {
			qrPathsName = *o.PathsName
		}
		qPathsName := qrPathsName
		if qPathsName != "" {

			if err := r.SetQueryParam("paths.name", qPathsName); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeName != nil {

		// query param paths.node.name
		var qrPathsNodeName string

		if o.PathsNodeName != nil {
			qrPathsNodeName = *o.PathsNodeName
		}
		qPathsNodeName := qrPathsNodeName
		if qPathsNodeName != "" {

			if err := r.SetQueryParam("paths.node.name", qPathsNodeName); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeUUID != nil {

		// query param paths.node.uuid
		var qrPathsNodeUUID string

		if o.PathsNodeUUID != nil {
			qrPathsNodeUUID = *o.PathsNodeUUID
		}
		qPathsNodeUUID := qrPathsNodeUUID
		if qPathsNodeUUID != "" {

			if err := r.SetQueryParam("paths.node.uuid", qPathsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PathsSourcePortID != nil {

		// query param paths.source_port.id
		var qrPathsSourcePortID string

		if o.PathsSourcePortID != nil {
			qrPathsSourcePortID = *o.PathsSourcePortID
		}
		qPathsSourcePortID := qrPathsSourcePortID
		if qPathsSourcePortID != "" {

			if err := r.SetQueryParam("paths.source_port.id", qPathsSourcePortID); err != nil {
				return err
			}
		}
	}

	if o.PathsSourcePortName != nil {

		// query param paths.source_port.name
		var qrPathsSourcePortName string

		if o.PathsSourcePortName != nil {
			qrPathsSourcePortName = *o.PathsSourcePortName
		}
		qPathsSourcePortName := qrPathsSourcePortName
		if qPathsSourcePortName != "" {

			if err := r.SetQueryParam("paths.source_port.name", qPathsSourcePortName); err != nil {
				return err
			}
		}
	}

	if o.PathsTargetPortID != nil {

		// query param paths.target_port.id
		var qrPathsTargetPortID string

		if o.PathsTargetPortID != nil {
			qrPathsTargetPortID = *o.PathsTargetPortID
		}
		qPathsTargetPortID := qrPathsTargetPortID
		if qPathsTargetPortID != "" {

			if err := r.SetQueryParam("paths.target_port.id", qPathsTargetPortID); err != nil {
				return err
			}
		}
	}

	if o.PathsTargetPortName != nil {

		// query param paths.target_port.name
		var qrPathsTargetPortName string

		if o.PathsTargetPortName != nil {
			qrPathsTargetPortName = *o.PathsTargetPortName
		}
		qPathsTargetPortName := qrPathsTargetPortName
		if qPathsTargetPortName != "" {

			if err := r.SetQueryParam("paths.target_port.name", qPathsTargetPortName); err != nil {
				return err
			}
		}
	}

	if o.PathsTargetPortWwn != nil {

		// query param paths.target_port.wwn
		var qrPathsTargetPortWwn string

		if o.PathsTargetPortWwn != nil {
			qrPathsTargetPortWwn = *o.PathsTargetPortWwn
		}
		qPathsTargetPortWwn := qrPathsTargetPortWwn
		if qPathsTargetPortWwn != "" {

			if err := r.SetQueryParam("paths.target_port.wwn", qPathsTargetPortWwn); err != nil {
				return err
			}
		}
	}

	if o.PowerSupplyUnitsName != nil {

		// query param power_supply_units.name
		var qrPowerSupplyUnitsName string

		if o.PowerSupplyUnitsName != nil {
			qrPowerSupplyUnitsName = *o.PowerSupplyUnitsName
		}
		qPowerSupplyUnitsName := qrPowerSupplyUnitsName
		if qPowerSupplyUnitsName != "" {

			if err := r.SetQueryParam("power_supply_units.name", qPowerSupplyUnitsName); err != nil {
				return err
			}
		}
	}

	if o.PowerSupplyUnitsState != nil {

		// query param power_supply_units.state
		var qrPowerSupplyUnitsState string

		if o.PowerSupplyUnitsState != nil {
			qrPowerSupplyUnitsState = *o.PowerSupplyUnitsState
		}
		qPowerSupplyUnitsState := qrPowerSupplyUnitsState
		if qPowerSupplyUnitsState != "" {

			if err := r.SetQueryParam("power_supply_units.state", qPowerSupplyUnitsState); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SasPortsCablePartNumber != nil {

		// query param sas_ports.cable.part_number
		var qrSasPortsCablePartNumber string

		if o.SasPortsCablePartNumber != nil {
			qrSasPortsCablePartNumber = *o.SasPortsCablePartNumber
		}
		qSasPortsCablePartNumber := qrSasPortsCablePartNumber
		if qSasPortsCablePartNumber != "" {

			if err := r.SetQueryParam("sas_ports.cable.part_number", qSasPortsCablePartNumber); err != nil {
				return err
			}
		}
	}

	if o.SasPortsCableSerialNumber != nil {

		// query param sas_ports.cable.serial_number
		var qrSasPortsCableSerialNumber string

		if o.SasPortsCableSerialNumber != nil {
			qrSasPortsCableSerialNumber = *o.SasPortsCableSerialNumber
		}
		qSasPortsCableSerialNumber := qrSasPortsCableSerialNumber
		if qSasPortsCableSerialNumber != "" {

			if err := r.SetQueryParam("sas_ports.cable.serial_number", qSasPortsCableSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SasPortsCableTechnology != nil {

		// query param sas_ports.cable.technology
		var qrSasPortsCableTechnology string

		if o.SasPortsCableTechnology != nil {
			qrSasPortsCableTechnology = *o.SasPortsCableTechnology
		}
		qSasPortsCableTechnology := qrSasPortsCableTechnology
		if qSasPortsCableTechnology != "" {

			if err := r.SetQueryParam("sas_ports.cable.technology", qSasPortsCableTechnology); err != nil {
				return err
			}
		}
	}

	if o.SasPortsCableVendor != nil {

		// query param sas_ports.cable.vendor
		var qrSasPortsCableVendor string

		if o.SasPortsCableVendor != nil {
			qrSasPortsCableVendor = *o.SasPortsCableVendor
		}
		qSasPortsCableVendor := qrSasPortsCableVendor
		if qSasPortsCableVendor != "" {

			if err := r.SetQueryParam("sas_ports.cable.vendor", qSasPortsCableVendor); err != nil {
				return err
			}
		}
	}

	if o.SasPortsDataRateCapability != nil {

		// query param sas_ports.data_rate_capability
		var qrSasPortsDataRateCapability float64

		if o.SasPortsDataRateCapability != nil {
			qrSasPortsDataRateCapability = *o.SasPortsDataRateCapability
		}
		qSasPortsDataRateCapability := swag.FormatFloat64(qrSasPortsDataRateCapability)
		if qSasPortsDataRateCapability != "" {

			if err := r.SetQueryParam("sas_ports.data_rate_capability", qSasPortsDataRateCapability); err != nil {
				return err
			}
		}
	}

	if o.SasPortsEnabled != nil {

		// query param sas_ports.enabled
		var qrSasPortsEnabled bool

		if o.SasPortsEnabled != nil {
			qrSasPortsEnabled = *o.SasPortsEnabled
		}
		qSasPortsEnabled := swag.FormatBool(qrSasPortsEnabled)
		if qSasPortsEnabled != "" {

			if err := r.SetQueryParam("sas_ports.enabled", qSasPortsEnabled); err != nil {
				return err
			}
		}
	}

	if o.SasPortsID != nil {

		// query param sas_ports.id
		var qrSasPortsID int64

		if o.SasPortsID != nil {
			qrSasPortsID = *o.SasPortsID
		}
		qSasPortsID := swag.FormatInt64(qrSasPortsID)
		if qSasPortsID != "" {

			if err := r.SetQueryParam("sas_ports.id", qSasPortsID); err != nil {
				return err
			}
		}
	}

	if o.SasPortsNegotiatedDataRate != nil {

		// query param sas_ports.negotiated_data_rate
		var qrSasPortsNegotiatedDataRate float64

		if o.SasPortsNegotiatedDataRate != nil {
			qrSasPortsNegotiatedDataRate = *o.SasPortsNegotiatedDataRate
		}
		qSasPortsNegotiatedDataRate := swag.FormatFloat64(qrSasPortsNegotiatedDataRate)
		if qSasPortsNegotiatedDataRate != "" {

			if err := r.SetQueryParam("sas_ports.negotiated_data_rate", qSasPortsNegotiatedDataRate); err != nil {
				return err
			}
		}
	}

	if o.SasPortsPhy1State != nil {

		// query param sas_ports.phy_1.state
		var qrSasPortsPhy1State string

		if o.SasPortsPhy1State != nil {
			qrSasPortsPhy1State = *o.SasPortsPhy1State
		}
		qSasPortsPhy1State := qrSasPortsPhy1State
		if qSasPortsPhy1State != "" {

			if err := r.SetQueryParam("sas_ports.phy_1.state", qSasPortsPhy1State); err != nil {
				return err
			}
		}
	}

	if o.SasPortsPhy2State != nil {

		// query param sas_ports.phy_2.state
		var qrSasPortsPhy2State string

		if o.SasPortsPhy2State != nil {
			qrSasPortsPhy2State = *o.SasPortsPhy2State
		}
		qSasPortsPhy2State := qrSasPortsPhy2State
		if qSasPortsPhy2State != "" {

			if err := r.SetQueryParam("sas_ports.phy_2.state", qSasPortsPhy2State); err != nil {
				return err
			}
		}
	}

	if o.SasPortsPhy3State != nil {

		// query param sas_ports.phy_3.state
		var qrSasPortsPhy3State string

		if o.SasPortsPhy3State != nil {
			qrSasPortsPhy3State = *o.SasPortsPhy3State
		}
		qSasPortsPhy3State := qrSasPortsPhy3State
		if qSasPortsPhy3State != "" {

			if err := r.SetQueryParam("sas_ports.phy_3.state", qSasPortsPhy3State); err != nil {
				return err
			}
		}
	}

	if o.SasPortsPhy4State != nil {

		// query param sas_ports.phy_4.state
		var qrSasPortsPhy4State string

		if o.SasPortsPhy4State != nil {
			qrSasPortsPhy4State = *o.SasPortsPhy4State
		}
		qSasPortsPhy4State := qrSasPortsPhy4State
		if qSasPortsPhy4State != "" {

			if err := r.SetQueryParam("sas_ports.phy_4.state", qSasPortsPhy4State); err != nil {
				return err
			}
		}
	}

	if o.SasPortsState != nil {

		// query param sas_ports.state
		var qrSasPortsState string

		if o.SasPortsState != nil {
			qrSasPortsState = *o.SasPortsState
		}
		qSasPortsState := qrSasPortsState
		if qSasPortsState != "" {

			if err := r.SetQueryParam("sas_ports.state", qSasPortsState); err != nil {
				return err
			}
		}
	}

	if o.SasPortsWwn != nil {

		// query param sas_ports.wwn
		var qrSasPortsWwn string

		if o.SasPortsWwn != nil {
			qrSasPortsWwn = *o.SasPortsWwn
		}
		qSasPortsWwn := qrSasPortsWwn
		if qSasPortsWwn != "" {

			if err := r.SetQueryParam("sas_ports.wwn", qSasPortsWwn); err != nil {
				return err
			}
		}
	}

	if o.SecurityEnabled != nil {

		// query param security_enabled
		var qrSecurityEnabled bool

		if o.SecurityEnabled != nil {
			qrSecurityEnabled = *o.SecurityEnabled
		}
		qSecurityEnabled := swag.FormatBool(qrSecurityEnabled)
		if qSecurityEnabled != "" {

			if err := r.SetQueryParam("security_enabled", qSecurityEnabled); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SymbolicName != nil {

		// query param symbolic_name
		var qrSymbolicName string

		if o.SymbolicName != nil {
			qrSymbolicName = *o.SymbolicName
		}
		qSymbolicName := qrSymbolicName
		if qSymbolicName != "" {

			if err := r.SetQueryParam("symbolic_name", qSymbolicName); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorMaximum != nil {

		// query param temperature_sensor.maximum
		var qrTemperatureSensorMaximum int64

		if o.TemperatureSensorMaximum != nil {
			qrTemperatureSensorMaximum = *o.TemperatureSensorMaximum
		}
		qTemperatureSensorMaximum := swag.FormatInt64(qrTemperatureSensorMaximum)
		if qTemperatureSensorMaximum != "" {

			if err := r.SetQueryParam("temperature_sensor.maximum", qTemperatureSensorMaximum); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorMinimum != nil {

		// query param temperature_sensor.minimum
		var qrTemperatureSensorMinimum int64

		if o.TemperatureSensorMinimum != nil {
			qrTemperatureSensorMinimum = *o.TemperatureSensorMinimum
		}
		qTemperatureSensorMinimum := swag.FormatInt64(qrTemperatureSensorMinimum)
		if qTemperatureSensorMinimum != "" {

			if err := r.SetQueryParam("temperature_sensor.minimum", qTemperatureSensorMinimum); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorName != nil {

		// query param temperature_sensor.name
		var qrTemperatureSensorName string

		if o.TemperatureSensorName != nil {
			qrTemperatureSensorName = *o.TemperatureSensorName
		}
		qTemperatureSensorName := qrTemperatureSensorName
		if qTemperatureSensorName != "" {

			if err := r.SetQueryParam("temperature_sensor.name", qTemperatureSensorName); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorReading != nil {

		// query param temperature_sensor.reading
		var qrTemperatureSensorReading int64

		if o.TemperatureSensorReading != nil {
			qrTemperatureSensorReading = *o.TemperatureSensorReading
		}
		qTemperatureSensorReading := swag.FormatInt64(qrTemperatureSensorReading)
		if qTemperatureSensorReading != "" {

			if err := r.SetQueryParam("temperature_sensor.reading", qTemperatureSensorReading); err != nil {
				return err
			}
		}
	}

	if o.TemperatureSensorState != nil {

		// query param temperature_sensor.state
		var qrTemperatureSensorState string

		if o.TemperatureSensorState != nil {
			qrTemperatureSensorState = *o.TemperatureSensorState
		}
		qTemperatureSensorState := qrTemperatureSensorState
		if qTemperatureSensorState != "" {

			if err := r.SetQueryParam("temperature_sensor.state", qTemperatureSensorState); err != nil {
				return err
			}
		}
	}

	if o.Vendor != nil {

		// query param vendor
		var qrVendor string

		if o.Vendor != nil {
			qrVendor = *o.Vendor
		}
		qVendor := qrVendor
		if qVendor != "" {

			if err := r.SetQueryParam("vendor", qVendor); err != nil {
				return err
			}
		}
	}

	if o.Wwn != nil {

		// query param wwn
		var qrWwn string

		if o.Wwn != nil {
			qrWwn = *o.Wwn
		}
		qWwn := qrWwn
		if qWwn != "" {

			if err := r.SetQueryParam("wwn", qWwn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamStorageBridgeCollectionGet binds the parameter fields
func (o *StorageBridgeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamStorageBridgeCollectionGet binds the parameter order_by
func (o *StorageBridgeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
