// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageBridgeCollectionGetReader is a Reader for the StorageBridgeCollectionGet structure.
type StorageBridgeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageBridgeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageBridgeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageBridgeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageBridgeCollectionGetOK creates a StorageBridgeCollectionGetOK with default headers values
func NewStorageBridgeCollectionGetOK() *StorageBridgeCollectionGetOK {
	return &StorageBridgeCollectionGetOK{}
}

/*
StorageBridgeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageBridgeCollectionGetOK struct {
	Payload *models.StorageBridgeResponse
}

// IsSuccess returns true when this storage bridge collection get o k response has a 2xx status code
func (o *StorageBridgeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage bridge collection get o k response has a 3xx status code
func (o *StorageBridgeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage bridge collection get o k response has a 4xx status code
func (o *StorageBridgeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage bridge collection get o k response has a 5xx status code
func (o *StorageBridgeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage bridge collection get o k response a status code equal to that given
func (o *StorageBridgeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage bridge collection get o k response
func (o *StorageBridgeCollectionGetOK) Code() int {
	return 200
}

func (o *StorageBridgeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/bridges][%d] storageBridgeCollectionGetOK %s", 200, payload)
}

func (o *StorageBridgeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/bridges][%d] storageBridgeCollectionGetOK %s", 200, payload)
}

func (o *StorageBridgeCollectionGetOK) GetPayload() *models.StorageBridgeResponse {
	return o.Payload
}

func (o *StorageBridgeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageBridgeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageBridgeCollectionGetDefault creates a StorageBridgeCollectionGetDefault with default headers values
func NewStorageBridgeCollectionGetDefault(code int) *StorageBridgeCollectionGetDefault {
	return &StorageBridgeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
StorageBridgeCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageBridgeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage bridge collection get default response has a 2xx status code
func (o *StorageBridgeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage bridge collection get default response has a 3xx status code
func (o *StorageBridgeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage bridge collection get default response has a 4xx status code
func (o *StorageBridgeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage bridge collection get default response has a 5xx status code
func (o *StorageBridgeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage bridge collection get default response a status code equal to that given
func (o *StorageBridgeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage bridge collection get default response
func (o *StorageBridgeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageBridgeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/bridges][%d] storage_bridge_collection_get default %s", o._statusCode, payload)
}

func (o *StorageBridgeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/bridges][%d] storage_bridge_collection_get default %s", o._statusCode, payload)
}

func (o *StorageBridgeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageBridgeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
