// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new storage API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for storage API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregateCollectionGet(params *AggregateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateCollectionGetOK, error)

	AggregateCreate(params *AggregateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateCreateCreated, *AggregateCreateAccepted, error)

	AggregateDelete(params *AggregateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateDeleteOK, *AggregateDeleteAccepted, error)

	AggregateDeleteCollection(params *AggregateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateDeleteCollectionOK, *AggregateDeleteCollectionAccepted, error)

	AggregateGet(params *AggregateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateGetOK, error)

	AggregateModify(params *AggregateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateModifyOK, *AggregateModifyAccepted, error)

	AggregateModifyCollection(params *AggregateModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateModifyCollectionOK, *AggregateModifyCollectionAccepted, error)

	AggregatePerformanceMetricsCollectionGet(params *AggregatePerformanceMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregatePerformanceMetricsCollectionGetOK, error)

	CloudStoreCollectionGet(params *CloudStoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreCollectionGetOK, error)

	CloudStoreCreate(params *CloudStoreCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreCreateCreated, *CloudStoreCreateAccepted, error)

	CloudStoreDelete(params *CloudStoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreDeleteOK, *CloudStoreDeleteAccepted, error)

	CloudStoreDeleteCollection(params *CloudStoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreDeleteCollectionOK, *CloudStoreDeleteCollectionAccepted, error)

	CloudStoreGet(params *CloudStoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreGetOK, error)

	CloudStoreModify(params *CloudStoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreModifyOK, *CloudStoreModifyAccepted, error)

	CloudStoreModifyCollection(params *CloudStoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreModifyCollectionOK, *CloudStoreModifyCollectionAccepted, error)

	ClusterSpaceModify(params *ClusterSpaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterSpaceModifyOK, *ClusterSpaceModifyAccepted, error)

	ConnectionStatusCollectionGet(params *ConnectionStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectionStatusCollectionGetOK, error)

	ConnectionStatusGet(params *ConnectionStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectionStatusGetOK, error)

	DiskCollectionGet(params *DiskCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskCollectionGetOK, error)

	DiskGet(params *DiskGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskGetOK, error)

	DiskModify(params *DiskModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskModifyOK, error)

	FileCloneCreate(params *FileCloneCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileCloneCreateCreated, *FileCloneCreateAccepted, error)

	FileCopyCreate(params *FileCopyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileCopyCreateCreated, *FileCopyCreateAccepted, error)

	FileDelete(params *FileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDeleteOK, *FileDeleteAccepted, error)

	FileFormDataDelete(params *FileFormDataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileFormDataDeleteOK, *FileFormDataDeleteAccepted, error)

	FileInfoCollectionFormDataGet(params *FileInfoCollectionFormDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCollectionFormDataGetOK, error)

	FileInfoCollectionGet(params *FileInfoCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCollectionGetOK, error)

	FileInfoCreate(params *FileInfoCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCreateCreated, error)

	FileInfoFormDataCreate(params *FileInfoFormDataCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoFormDataCreateCreated, error)

	FileInfoFormDataModify(params *FileInfoFormDataModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoFormDataModifyOK, error)

	FileInfoModify(params *FileInfoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoModifyOK, error)

	FileMoveCollectionGet(params *FileMoveCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveCollectionGetOK, error)

	FileMoveCreate(params *FileMoveCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveCreateCreated, error)

	FileMoveGet(params *FileMoveGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveGetOK, error)

	FlexcacheCollectionGet(params *FlexcacheCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheCollectionGetOK, error)

	FlexcacheCreate(params *FlexcacheCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheCreateCreated, *FlexcacheCreateAccepted, error)

	FlexcacheDelete(params *FlexcacheDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheDeleteOK, *FlexcacheDeleteAccepted, error)

	FlexcacheDeleteCollection(params *FlexcacheDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheDeleteCollectionOK, *FlexcacheDeleteCollectionAccepted, error)

	FlexcacheGet(params *FlexcacheGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheGetOK, error)

	FlexcacheModify(params *FlexcacheModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheModifyOK, *FlexcacheModifyAccepted, error)

	FlexcacheModifyCollection(params *FlexcacheModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheModifyCollectionOK, *FlexcacheModifyCollectionAccepted, error)

	FlexcacheOriginCollectionGet(params *FlexcacheOriginCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginCollectionGetOK, error)

	FlexcacheOriginGet(params *FlexcacheOriginGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginGetOK, error)

	FlexcacheOriginModify(params *FlexcacheOriginModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginModifyOK, *FlexcacheOriginModifyAccepted, error)

	FlexcacheOriginModifyCollection(params *FlexcacheOriginModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginModifyCollectionOK, *FlexcacheOriginModifyCollectionAccepted, error)

	PerformanceQtreeMetricCollectionGet(params *PerformanceQtreeMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceQtreeMetricCollectionGetOK, error)

	PlexCollectionGet(params *PlexCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PlexCollectionGetOK, error)

	PlexGet(params *PlexGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PlexGetOK, error)

	PortCollectionGet(params *PortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortCollectionGetOK, error)

	PortGet(params *PortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortGetOK, error)

	QosOptionGet(params *QosOptionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosOptionGetOK, error)

	QosOptionModify(params *QosOptionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosOptionModifyOK, error)

	QosPolicyCollectionGet(params *QosPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyCollectionGetOK, error)

	QosPolicyCreate(params *QosPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyCreateCreated, *QosPolicyCreateAccepted, error)

	QosPolicyDelete(params *QosPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyDeleteOK, error)

	QosPolicyDeleteCollection(params *QosPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyDeleteCollectionOK, error)

	QosPolicyGet(params *QosPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyGetOK, error)

	QosPolicyModify(params *QosPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyModifyOK, *QosPolicyModifyAccepted, error)

	QosPolicyModifyCollection(params *QosPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyModifyCollectionOK, *QosPolicyModifyCollectionAccepted, error)

	QosWorkloadCollectionGet(params *QosWorkloadCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosWorkloadCollectionGetOK, error)

	QosWorkloadGet(params *QosWorkloadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosWorkloadGetOK, error)

	QtreeCollectionGet(params *QtreeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeCollectionGetOK, error)

	QtreeCreate(params *QtreeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeCreateCreated, *QtreeCreateAccepted, error)

	QtreeDelete(params *QtreeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeDeleteOK, *QtreeDeleteAccepted, error)

	QtreeDeleteCollection(params *QtreeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeDeleteCollectionOK, *QtreeDeleteCollectionAccepted, error)

	QtreeGet(params *QtreeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeGetOK, error)

	QtreeModify(params *QtreeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeModifyOK, *QtreeModifyAccepted, error)

	QtreeModifyCollection(params *QtreeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeModifyCollectionOK, *QtreeModifyCollectionAccepted, error)

	QuotaReportCollectionGet(params *QuotaReportCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaReportCollectionGetOK, error)

	QuotaReportGet(params *QuotaReportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaReportGetOK, error)

	QuotaRuleCollectionGet(params *QuotaRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleCollectionGetOK, error)

	QuotaRuleCreate(params *QuotaRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleCreateCreated, *QuotaRuleCreateAccepted, error)

	QuotaRuleDelete(params *QuotaRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleDeleteOK, *QuotaRuleDeleteAccepted, error)

	QuotaRuleDeleteCollection(params *QuotaRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleDeleteCollectionOK, *QuotaRuleDeleteCollectionAccepted, error)

	QuotaRuleGet(params *QuotaRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleGetOK, error)

	QuotaRuleModify(params *QuotaRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleModifyOK, *QuotaRuleModifyAccepted, error)

	QuotaRuleModifyCollection(params *QuotaRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleModifyCollectionOK, *QuotaRuleModifyCollectionAccepted, error)

	ShelfCollectionGet(params *ShelfCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfCollectionGetOK, error)

	ShelfGet(params *ShelfGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfGetOK, error)

	ShelfModify(params *ShelfModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfModifyOK, error)

	ShelfModifyCollection(params *ShelfModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfModifyCollectionOK, error)

	SnapshotCollectionGet(params *SnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotCollectionGetOK, error)

	SnapshotCreate(params *SnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotCreateCreated, *SnapshotCreateAccepted, error)

	SnapshotDelete(params *SnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotDeleteOK, *SnapshotDeleteAccepted, error)

	SnapshotDeleteCollection(params *SnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotDeleteCollectionOK, *SnapshotDeleteCollectionAccepted, error)

	SnapshotGet(params *SnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotGetOK, error)

	SnapshotModify(params *SnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotModifyOK, *SnapshotModifyAccepted, error)

	SnapshotModifyCollection(params *SnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotModifyCollectionOK, *SnapshotModifyCollectionAccepted, error)

	SnapshotPolicyCollectionGet(params *SnapshotPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyCollectionGetOK, error)

	SnapshotPolicyCreate(params *SnapshotPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyCreateCreated, error)

	SnapshotPolicyDelete(params *SnapshotPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyDeleteOK, error)

	SnapshotPolicyDeleteCollection(params *SnapshotPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyDeleteCollectionOK, error)

	SnapshotPolicyGet(params *SnapshotPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyGetOK, error)

	SnapshotPolicyModify(params *SnapshotPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyModifyOK, error)

	SnapshotPolicyModifyCollection(params *SnapshotPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyModifyCollectionOK, error)

	SnapshotPolicyScheduleCollectionGet(params *SnapshotPolicyScheduleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleCollectionGetOK, error)

	SnapshotPolicyScheduleCreate(params *SnapshotPolicyScheduleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleCreateCreated, error)

	SnapshotPolicyScheduleDelete(params *SnapshotPolicyScheduleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleDeleteOK, error)

	SnapshotPolicyScheduleDeleteCollection(params *SnapshotPolicyScheduleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleDeleteCollectionOK, error)

	SnapshotPolicyScheduleGet(params *SnapshotPolicyScheduleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleGetOK, error)

	SnapshotPolicyScheduleModify(params *SnapshotPolicyScheduleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleModifyOK, error)

	SnapshotPolicyScheduleModifyCollection(params *SnapshotPolicyScheduleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleModifyCollectionOK, error)

	SplitLoadCollectionGet(params *SplitLoadCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadCollectionGetOK, error)

	SplitLoadGet(params *SplitLoadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadGetOK, error)

	SplitLoadModify(params *SplitLoadModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadModifyOK, error)

	SplitLoadModifyCollection(params *SplitLoadModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadModifyCollectionOK, error)

	SplitStatusCollectionGet(params *SplitStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitStatusCollectionGetOK, error)

	SplitStatusGet(params *SplitStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitStatusGetOK, error)

	StorageAvailabilityZoneCollectionGet(params *StorageAvailabilityZoneCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneCollectionGetOK, error)

	StorageAvailabilityZoneGet(params *StorageAvailabilityZoneGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneGetOK, error)

	StorageAvailabilityZoneModify(params *StorageAvailabilityZoneModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneModifyOK, *StorageAvailabilityZoneModifyAccepted, error)

	StorageAvailabilityZoneModifyCollection(params *StorageAvailabilityZoneModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneModifyCollectionOK, *StorageAvailabilityZoneModifyCollectionAccepted, error)

	StorageBridgeCollectionGet(params *StorageBridgeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageBridgeCollectionGetOK, error)

	StorageBridgeGet(params *StorageBridgeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageBridgeGetOK, error)

	StorageClusterGet(params *StorageClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageClusterGetOK, error)

	StoragePoolCollectionGet(params *StoragePoolCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolCollectionGetOK, error)

	StoragePoolCreate(params *StoragePoolCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolCreateCreated, *StoragePoolCreateAccepted, error)

	StoragePoolDelete(params *StoragePoolDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolDeleteOK, *StoragePoolDeleteAccepted, error)

	StoragePoolDeleteCollection(params *StoragePoolDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolDeleteCollectionOK, *StoragePoolDeleteCollectionAccepted, error)

	StoragePoolGet(params *StoragePoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolGetOK, error)

	StoragePoolModify(params *StoragePoolModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolModifyOK, *StoragePoolModifyAccepted, error)

	StoragePoolModifyCollection(params *StoragePoolModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolModifyCollectionOK, *StoragePoolModifyCollectionAccepted, error)

	StoragePortModify(params *StoragePortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePortModifyOK, error)

	StoragePortModifyCollection(params *StoragePortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePortModifyCollectionOK, error)

	StorageSwitchCollectionGet(params *StorageSwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageSwitchCollectionGetOK, error)

	StorageSwitchGet(params *StorageSwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageSwitchGetOK, error)

	TapeDeviceCollectionGet(params *TapeDeviceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceCollectionGetOK, error)

	TapeDeviceGet(params *TapeDeviceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceGetOK, error)

	TapeDeviceModify(params *TapeDeviceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceModifyOK, *TapeDeviceModifyAccepted, error)

	TapeDeviceModifyCollection(params *TapeDeviceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceModifyCollectionOK, *TapeDeviceModifyCollectionAccepted, error)

	TokenCollectionGet(params *TokenCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenCollectionGetOK, error)

	TokenCreate(params *TokenCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenCreateCreated, error)

	TokenDelete(params *TokenDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenDeleteOK, error)

	TokenDeleteCollection(params *TokenDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenDeleteCollectionOK, error)

	TokenGet(params *TokenGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenGetOK, error)

	TokenModify(params *TokenModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenModifyOK, error)

	TokenModifyCollection(params *TokenModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenModifyCollectionOK, error)

	TopMetricsClientCollectionGet(params *TopMetricsClientCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsClientCollectionGetOK, error)

	TopMetricsDirectoryCollectionGet(params *TopMetricsDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsDirectoryCollectionGetOK, error)

	TopMetricsFileCollectionGet(params *TopMetricsFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsFileCollectionGetOK, error)

	TopMetricsUserCollectionGet(params *TopMetricsUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsUserCollectionGetOK, error)

	VolumeCollectionGet(params *VolumeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeCollectionGetOK, error)

	VolumeCreate(params *VolumeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeCreateCreated, *VolumeCreateAccepted, error)

	VolumeDelete(params *VolumeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeDeleteOK, *VolumeDeleteAccepted, error)

	VolumeDeleteCollection(params *VolumeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeDeleteCollectionOK, *VolumeDeleteCollectionAccepted, error)

	VolumeEfficiencyPolicyCollectionGet(params *VolumeEfficiencyPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyCollectionGetOK, error)

	VolumeEfficiencyPolicyCreate(params *VolumeEfficiencyPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyCreateCreated, error)

	VolumeEfficiencyPolicyDelete(params *VolumeEfficiencyPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyDeleteOK, error)

	VolumeEfficiencyPolicyDeleteCollection(params *VolumeEfficiencyPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyDeleteCollectionOK, error)

	VolumeEfficiencyPolicyGet(params *VolumeEfficiencyPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyGetOK, error)

	VolumeEfficiencyPolicyModify(params *VolumeEfficiencyPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyModifyOK, error)

	VolumeEfficiencyPolicyModifyCollection(params *VolumeEfficiencyPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyModifyCollectionOK, error)

	VolumeGet(params *VolumeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeGetOK, error)

	VolumeMetricsCollectionGet(params *VolumeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeMetricsCollectionGetOK, error)

	VolumeModify(params *VolumeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeModifyOK, *VolumeModifyAccepted, error)

	VolumeModifyCollection(params *VolumeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeModifyCollectionOK, *VolumeModifyCollectionAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	AggregateCollectionGet Retrieves the collection of aggregates for the entire cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `metric.*`
* `space.block_storage.inactive_user_data`
* `space.block_storage.inactive_user_data_percent`
* `space.footprint`
* `is_spare_low`
* `statistics.*`
### Related ONTAP commands
* `storage aggregate show`
*/
func (a *Client) AggregateCollectionGet(params *AggregateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AggregateCreate Automatically creates aggregates based on an optimal layout recommended by the system. Alternatively, properties can be provided to create an aggregate according to the requested specification. This request starts a job and returns a link to that job.

POST operations will be blocked while one or more nodes in the cluster are simulating or implementing automatic aggregate creation.
### Required properties
Properties are not required for this API. The following properties are only required if you want to specify properties for aggregate creation:
* `name` - Name of the aggregate.
* `node.name` or `node.uuid` - Node on which the aggregate will be created.
* `block_storage.primary.disk_count` - Number of disks to be used to create the aggregate.
### Default values
If not specified in POST, the following default values are assigned. The remaining unspecified properties will receive system dependent default values.
* `block_storage.mirror.enabled` - _false_
* `snaplock_type` - _non_snaplock_
### Related ONTAP commands
* `storage aggregate auto-provision`
* `storage aggregate create`
### Example:
```
POST /api/storage/aggregates {"node": {"name": "node1"}, "name": "test", "block_storage": {"primary": {"disk_count": "10"}}}
```
*/
func (a *Client) AggregateCreate(params *AggregateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateCreateCreated, *AggregateCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_create",
		Method:             "POST",
		PathPattern:        "/storage/aggregates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AggregateCreateCreated:
		return value, nil, nil
	case *AggregateCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AggregateDelete Deletes the aggregate specified by the UUID. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage aggregate delete`
*/
func (a *Client) AggregateDelete(params *AggregateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateDeleteOK, *AggregateDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/aggregates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AggregateDeleteOK:
		return value, nil, nil
	case *AggregateDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AggregateDeleteCollection aggregate delete collection API
*/
func (a *Client) AggregateDeleteCollection(params *AggregateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateDeleteCollectionOK, *AggregateDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/aggregates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AggregateDeleteCollectionOK:
		return value, nil, nil
	case *AggregateDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AggregateGet Retrieves the aggregate specified by the UUID. The recommend query cannot be used for this operation.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `metric.*`
* `space.block_storage.inactive_user_data`
* `space.block_storage.inactive_user_data_percent`
* `space.footprint`
* `is_spare_low`
* `statistics.*`
### Related ONTAP commands
* `storage aggregate show`
*/
func (a *Client) AggregateGet(params *AggregateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AggregateModify Updates the aggregate specified by the UUID with the properties in the body. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage aggregate add-disks`
* `storage aggregate mirror`
* `storage aggregate modify`
* `storage aggregate relocation start`
* `storage aggregate rename`
*/
func (a *Client) AggregateModify(params *AggregateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateModifyOK, *AggregateModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/aggregates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AggregateModifyOK:
		return value, nil, nil
	case *AggregateModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AggregateModifyCollection aggregate modify collection API
*/
func (a *Client) AggregateModifyCollection(params *AggregateModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregateModifyCollectionOK, *AggregateModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/aggregates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AggregateModifyCollectionOK:
		return value, nil, nil
	case *AggregateModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregateModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AggregatePerformanceMetricsCollectionGet Retrieves historical performance metrics for an aggregate.
*/
func (a *Client) AggregatePerformanceMetricsCollectionGet(params *AggregatePerformanceMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AggregatePerformanceMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatePerformanceMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate_performance_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatePerformanceMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatePerformanceMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AggregatePerformanceMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CloudStoreCollectionGet Retrieves the collection of cloud stores used by an aggregate.

### Related ONTAP commands
* `storage aggregate object-store show`
*/
func (a *Client) CloudStoreCollectionGet(params *CloudStoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CloudStoreCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CloudStoreCreate Attaches an object store to an aggregate, or adds a second object store as a mirror.

### Required properties
* `target.uuid` or `target.name` - UUID or name of the cloud target.
### Recommended optional properties
* `primary` - _true_ if the object store is primary or _false_ if it is a mirror.
* `allow_flexgroups` - Allow attaching object store to an aggregate containing FlexGroup constituents.
* `check_only` - Validate only and do not add the cloud store.
### Default property values
* `primary` - _true_
* `allow_flexgroups` - _false_
* `check_only` - _false_
### Related ONTAP commands
* `storage aggregate object-store attach`
* `storage aggregate object-store mirror`
*/
func (a *Client) CloudStoreCreate(params *CloudStoreCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreCreateCreated, *CloudStoreCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_create",
		Method:             "POST",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CloudStoreCreateCreated:
		return value, nil, nil
	case *CloudStoreCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CloudStoreDelete Removes the specified cloud target from the aggregate. Only removal of a mirror is allowed. The primary cannot be removed. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage aggregate object-store unmirror`
*/
func (a *Client) CloudStoreDelete(params *CloudStoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreDeleteOK, *CloudStoreDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CloudStoreDeleteOK:
		return value, nil, nil
	case *CloudStoreDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CloudStoreDeleteCollection cloud store delete collection API
*/
func (a *Client) CloudStoreDeleteCollection(params *CloudStoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreDeleteCollectionOK, *CloudStoreDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CloudStoreDeleteCollectionOK:
		return value, nil, nil
	case *CloudStoreDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CloudStoreGet Retrieves the cloud store for the aggregate using the specified cloud target UUID.

### Related ONTAP commands
* `storage aggregate object-store show`
*/
func (a *Client) CloudStoreGet(params *CloudStoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CloudStoreGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CloudStoreModify Updates the cloud store specified by the UUID with the fields in the body. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage aggregate object-store modify`
*/
func (a *Client) CloudStoreModify(params *CloudStoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreModifyOK, *CloudStoreModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CloudStoreModifyOK:
		return value, nil, nil
	case *CloudStoreModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CloudStoreModifyCollection cloud store modify collection API
*/
func (a *Client) CloudStoreModifyCollection(params *CloudStoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CloudStoreModifyCollectionOK, *CloudStoreModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCloudStoreModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cloud_store_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/cloud-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CloudStoreModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CloudStoreModifyCollectionOK:
		return value, nil, nil
	case *CloudStoreModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CloudStoreModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterSpaceModify Updates full_threshold_percent and nearly_full_threshold_percent for the complete cluster.
*/
func (a *Client) ClusterSpaceModify(params *ClusterSpaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterSpaceModifyOK, *ClusterSpaceModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterSpaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_space_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterSpaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterSpaceModifyOK:
		return value, nil, nil
	case *ClusterSpaceModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterSpaceModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConnectionStatusCollectionGet Retrieves attributes of the connection status between cache and origin volumes.

### Related ONTAP commands
* `volume flexcache connection-status show`
### Learn more
* [`DOC /storage/flexcache/connection-status`](#docs-storage-storage_flexcache_connection-status)
Retrieves origin of FlexCache in the cluster.
*/
func (a *Client) ConnectionStatusCollectionGet(params *ConnectionStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectionStatusCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConnectionStatusCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "connection_status_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/connection-status",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConnectionStatusCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConnectionStatusCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConnectionStatusCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConnectionStatusGet Retrieves connection status between a cache and origin volume.

### Related ONTAP commands
* `volume flexcache connection-status show`
### Learn more
* [`DOC /storage/flexcache/connection-status`](#docs-storage-storage_flexcache_connection-status)
*/
func (a *Client) ConnectionStatusGet(params *ConnectionStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectionStatusGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConnectionStatusGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "connection_status_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/connection-status/{node}/{svm}/{local_fg_msid}/{remote_svm_uuid}/{remote_vol_const_msid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConnectionStatusGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConnectionStatusGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConnectionStatusGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DiskCollectionGet Retrieves a collection of disks.

### Related ONTAP commands
* `storage disk show`
### Learn more
* [`DOC /storage/disks`](#docs-storage-storage_disks)
*/
func (a *Client) DiskCollectionGet(params *DiskCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDiskCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "disk_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/disks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DiskCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DiskCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DiskCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DiskGet Retrieves a specific disk.

### Related ONTAP commands
* `storage disk show`
* `storage encryption disk show`
### Learn more
* [`DOC /storage/disks`](#docs-storage-storage_disks)
*/
func (a *Client) DiskGet(params *DiskGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDiskGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "disk_get",
		Method:             "GET",
		PathPattern:        "/storage/disks/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DiskGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DiskGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DiskGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DiskModify Updates disk ownership, changes authentication keys, sanitizes encrypting disks, or sanitizes non-encrypting spare disks.

### Related ONTAP commands
* `storage disk assign`
* `storage disk removeowner`
* `storage encryption disk modify -data-key-id`
* `storage encryption disk sanitize`
* `security key-manager key query -key-type NSE-AK`
* `storage disk unfail`
* `storage disk sanitize-spare`
### Learn more
* [`DOC /storage/disks`](#docs-storage-storage_disks)
*/
func (a *Client) DiskModify(params *DiskModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DiskModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDiskModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "disk_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/disks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DiskModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DiskModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DiskModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileCloneCreate Creates a clone of the file.

### Required Properties
* `source_path`
* `destination_path`
* `volume.uuid` - Instance UUID of the volume in which to create clone.
### Optional Properties
* `range` -  Required only in the case of a sub file clone.
* `autodelete` - Marks a cloned file for auto deletion.
* `is_backup` - Cloned file is used as a backup.
* `volume.name` - Name of the volume in which to create the clone.
* `token_uuid` - UUID of existing clone token.
### Related Ontap commands
* `volume file clone create`
### Creating file clones
The POST operation is used to create file clones with the specified attributes in the body. Set the `volume.uuid` to identify the volume.
Set `source_path` and `destination_path` to identify the file path of the original and copied file. For a full file clone, the new file is created using `destination_path`.
For a sub file clone, set `range` in the format source-file-block-number:destination-file-block-number:block-count. The API returns an error for the following overlapping conditions: (a) if the source and destination files are the same and if any of the source ranges  overlap with any of the destination ranges. (b) if any of the source ranges overlap amongst themselves. (c) if any of the destination ranges overlap amongst themselves. If not provided, full file cloning is assumed.<br/>
If set to `autodelete`, the cloned file is deleted when the volumes are full.<br\>
```
# The API:
curl -X POST "https://<mgmt_ip>/api/storage/file/clone" -H "accept: application/hal+json" -d '{"volume": {"name": "vol1",  "uuid": "40e0fdc5-c28f-11eb-8270-005056bbeb0b"}, "source_path": "f1", "destination_path": "f2_c1"}'
# The response:

	{
	  "job": {
	    "uuid": "0d025fd9-c4dc-11eb-adb5-005056bbeb0b",
	    "_links": {
	       "self": {
	         "href": "/api/cluster/jobs/0d025fd9-c4dc-11eb-adb5-005056bbeb0b"
	       }
	    }
	  }
	}

```
### Learn More
* [`DOC /storage/file/clone`]
*/
func (a *Client) FileCloneCreate(params *FileCloneCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileCloneCreateCreated, *FileCloneCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileCloneCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_clone_create",
		Method:             "POST",
		PathPattern:        "/storage/file/clone",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileCloneCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileCloneCreateCreated:
		return value, nil, nil
	case *FileCloneCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileCloneCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileCopyCreate Starts a file copy operation. Only supported on flexible volumes.

## Required properties
* `files_to_copy` - List of files with the destination they are to be copied to.
## Default property values
* `cutover_time` - _10_
* `hold_quiescence` - _false_
* `max_throughput` - _0_
* `reference_cutover_time` - _10_
## Related ONTAP commands
* `volume file copy start`
## Examples
### Copying two files
The POST request is used to copy file(s).
```
# The API:
/api/storage/file/copy
# The call:
curl -X POST  "https://<mgmt-ip>/api/storage/file/copy" -H "accept: application/hal+json" -d '{"files_to_copy":[{"source":{"volume":{"name":"vol_a"},"svm":{"name":"vs0"},"path":"d1/src_f1"},"destination":{"volume":{"name":"vol_a"},"svm":{"name":"vs0"},"path":"d1/dst_f1"}}, {"source":{"volume":{"name":"vol_a"},"svm":{"name":"vs0"},"path":"d1/src_f2"},"destination":{"volume":{"name":"vol_a"},"svm":{"name":"vs0"},"path":"d1/dst_f2"}}]}'
# The response:

	{
	  "job": {
	    "uuid": "b89bc5dd-94a3-11e8-a7a3-0050568edf84",
	    "_links": {
	       "self": {
	         "href": "/api/cluster/jobs/b89bc5dd-94a3-11e8-a7a3-0050568edf84"
	       }
	     }
	   }
	}

```
*/
func (a *Client) FileCopyCreate(params *FileCopyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileCopyCreateCreated, *FileCopyCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileCopyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_copy_create",
		Method:             "POST",
		PathPattern:        "/storage/file/copy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileCopyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileCopyCreateCreated:
		return value, nil, nil
	case *FileCopyCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileCopyCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileDelete Deletes an existing file or directory. Query-based DELETE operations are not supported.
*/
func (a *Client) FileDelete(params *FileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDeleteOK, *FileDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDeleteOK:
		return value, nil, nil
	case *FileDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileFormDataDelete Deletes an existing file or directory. Query-based DELETE operations are not supported.
*/
func (a *Client) FileFormDataDelete(params *FileFormDataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileFormDataDeleteOK, *FileFormDataDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileFormDataDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_form_data_delete",
		Method:             "DELETE",
		PathPattern:        "//storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileFormDataDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileFormDataDeleteOK:
		return value, nil, nil
	case *FileFormDataDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileFormDataDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileInfoCollectionFormDataGet Retrieves a list of files and directories for a given directory or returns only the properties of a single given directory or file of a volume.

### Expensive properties
There is an added computational cost to retrieving values for these properties.  They are not included by default in GET results and must be explicitly requested using the `fields` query property. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
  - `analytics`
  - `qos_policy.name`
  - `qos_policy.uuid`
*/
func (a *Client) FileInfoCollectionFormDataGet(params *FileInfoCollectionFormDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCollectionFormDataGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoCollectionFormDataGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_collection_form_data_get",
		Method:             "GET",
		PathPattern:        "//storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"multipart/form-data"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoCollectionFormDataGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoCollectionFormDataGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoCollectionFormDataGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileInfoCollectionGet Retrieves a list of files and directories for a given directory or returns only the properties of a single given directory or file of a volume.

### Expensive properties
There is an added computational cost to retrieving values for these properties.  They are not included by default in GET results and must be explicitly requested using the `fields` query property. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
  - `analytics`
  - `qos_policy.name`
  - `qos_policy.uuid`
*/
func (a *Client) FileInfoCollectionGet(params *FileInfoCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileInfoCreate Creates a new file with the supplied data, a new directory or a new symlink.
*/
func (a *Client) FileInfoCreate(params *FileInfoCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_create",
		Method:             "POST",
		PathPattern:        "/storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileInfoFormDataCreate Creates a new file with the supplied data, a new directory or a new symlink.
*/
func (a *Client) FileInfoFormDataCreate(params *FileInfoFormDataCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoFormDataCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoFormDataCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_form_data_create",
		Method:             "POST",
		PathPattern:        "//storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoFormDataCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoFormDataCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoFormDataCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileInfoFormDataModify Writes to an existing file with the supplied data or modifies the size, name, space reservation information, QoS policy, or hole range information of a file. Query-based PATCH operations are not supported.
*/
func (a *Client) FileInfoFormDataModify(params *FileInfoFormDataModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoFormDataModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoFormDataModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_form_data_modify",
		Method:             "PATCH",
		PathPattern:        "//storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoFormDataModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoFormDataModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoFormDataModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FileInfoModify Writes to an existing file with the supplied data or modifies the size, name, space reservation information, QoS policy, or hole range information of a file. Query-based PATCH operations are not supported.
*/
func (a *Client) FileInfoModify(params *FileInfoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileInfoModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileInfoModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_info_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/volumes/{volume.uuid}/files/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileInfoModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileInfoModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileInfoModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileMoveCollectionGet Retrieves all ongoing file move operations in the cluster.

### Related ONTAP commands
* `volume file move show`
* `volume rebalance file-move show`
*/
func (a *Client) FileMoveCollectionGet(params *FileMoveCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileMoveCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_move_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/file/moves",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileMoveCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileMoveCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileMoveCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileMoveCreate Starts a file move operation. This API can be used to move files from one FlexVol volume to another FlexVol volume or within a FlexGroup volume for capacity rebalancing.

For a FlexGroup volume file move operation, only one source file can be specified in files_to_move. The source volume is the FlexGroup volume. The destination volume is the destination FlexGroup volume constituent to move the file to. When “automatic“ is true, destination volume is not required. The source path is the path to the file to be moved within the FlexGroup volume. If the destination path is specified, it must be the same as the source path.
## Required properties for file move operation
* `files_to_move` - List of files with the destination they are to be moved to.
## Optional properties for file move operation
* `reference` - The source reference file for moving multiple files.
## Default property values
* `max_throughput` - _0_
* `max_cutover_time` - _10_
* `reference.max_cutover_time` - _10_
## Related ONTAP commands
* `volume file move start`
* `volume rebalance file-move start`
*/
func (a *Client) FileMoveCreate(params *FileMoveCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileMoveCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_move_create",
		Method:             "POST",
		PathPattern:        "/storage/file/moves",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileMoveCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileMoveCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileMoveCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileMoveGet ## Overview

Retrieve the status of an on-going file move operation.
### Related ONTAP commands
* `volume file move show`
* `volume rebalance file-move show`
*/
func (a *Client) FileMoveGet(params *FileMoveGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileMoveGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileMoveGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_move_get",
		Method:             "GET",
		PathPattern:        "/storage/file/moves/{node.uuid}/{uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileMoveGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileMoveGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileMoveGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheCollectionGet Retrieves FlexCache in the cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `origins.ip_address` - IP address of origin.
* `origins.size` - Physical size of origin.
* `origins.state` - State of origin.
* `size` - Physical size of FlexCache.
* `guarantee.type` - Space guarantee style of FlexCache.
* `aggregates.name` or `aggregates.uuid` - Name or UUID of aggregate of FlexCache volume.
* `path` - Fully-qualified path of the owning SVM's namespace where the FlexCache is mounted.
### Related ONTAP commands
* `volume flexcache show`
### Learn more
* [`DOC /storage/flexcache/flexcaches`](#docs-storage-storage_flexcache_flexcaches)
*/
func (a *Client) FlexcacheCollectionGet(params *FlexcacheCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/flexcaches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FlexcacheCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheCreate Creates a FlexCache in the cluster.

### Required properties
* `name` - Name of FlexCache volume.
* `origins.volume.name` - Name of the origin volume. This volume can only be identified by its name, not by its UUID.
* `origins.svm.name` - Name of origin Vserver.
* `svm.name` or `svm.uuid` - Name or UUID of Vserver where FlexCache will be created.
### Recommended optional properties
* `path` - Path to mount the FlexCache volume
* `prepopulate.dir_paths` - List of directory-paths to be prepopulated for the FlexCache volume.
* `prepopulate.exclude_dir_paths` - List of directory-paths to be excluded from prepopulation for the FlexCache volume.
### Default property values
If not specified in POST, the following default property values are assigned:
* `size` - 10% of origin volume size or 1GB per constituent, whichever is greater.
* `guarantee.type` - none. FlexCache is thin provisioned by default.
* `constituents_per_aggregate` - 4 if aggregates.name or aggregates.uuid is used.
* `use_tiered_aggregate` - false if aggr-list is not used. This property is only used when auto-provisioning a FlexCache volume.
* `is_disconnected_mode_off_for_locks` - false. This property specifies if the origin will honor the cache side locks when doing the lock checks in the disconnected mode.
* `dr_cache` - false if FlexCache is not a DR cache. This property is used to create a DR FlexCache.
* `global_file_locking_enabled` - false. This property specifies whether global file locking is enabled on the FlexCache volume.
* `writeback.enabled` - false. This property specifies whether writeback is enabled for the FlexCache volume.
* `relative_size.enabled` - false. This property specifies whether the relative sizing is enabled for the FlexCache volume.
* `relative_size.percentage` - 10. This property specifies the percent size FlexCache volume should have relative to the total size of the origin volume.
* `override_encryption` - false. If true, this property is used to create a plaintext FlexCache volume for an encrypted origin volume.
* `atime_scrub.enabled` - false. This property specifies whether scrubbing of inactive files based on atime is enabled for the FlexCache volume.
* `atime_scrub.period` - 30. This property specifies the atime duration in days after which the file can be scrubbed from the FlexCache volume if it stays unused beyond the duration.
* `nfsv4.enabled` - false. This property specifies whether NFSv4 is enabled for the FlexCache volume.
* `cifs.enabled` - false. This property specifies whether CIFS is enabled for the FlexCache volume.
* `s3.enabled` - false. This property specifies whether S3 is enabled for the FlexCache volume.
* `cifs_change_notify.enabled` - false. This property specifies whether a CIFS change notification is enabled for the FlexCache volume. <personalities supports=aiml>
* `constituent_count` - 1. This property specifies the number of constituents in the FlexGroup volume upon Flexcache create. </personalities>
### Related ONTAP commands
* `volume flexcache create`
* `volume flexcache prepopulate start`
### Learn more
* [`DOC /storage/flexcache/flexcaches`](#docs-storage-storage_flexcache_flexcaches)
*/
func (a *Client) FlexcacheCreate(params *FlexcacheCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheCreateCreated, *FlexcacheCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_create",
		Method:             "POST",
		PathPattern:        "/storage/flexcache/flexcaches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheCreateCreated:
		return value, nil, nil
	case *FlexcacheCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheDelete Deletes a FlexCache. If a FlexCache volume is online, it is offlined before deletion.

### Related ONTAP commands
* `volume flexcache delete`
### Learn more
* [`DOC /storage/flexcache/flexcaches`](#docs-storage-storage_flexcache_flexcaches)
*/
func (a *Client) FlexcacheDelete(params *FlexcacheDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheDeleteOK, *FlexcacheDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/flexcache/flexcaches/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheDeleteOK:
		return value, nil, nil
	case *FlexcacheDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FlexcacheDeleteCollection flexcache delete collection API
*/
func (a *Client) FlexcacheDeleteCollection(params *FlexcacheDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheDeleteCollectionOK, *FlexcacheDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/flexcache/flexcaches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheDeleteCollectionOK:
		return value, nil, nil
	case *FlexcacheDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheGet Retrieves attributes of the FlexCache in the cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are included by default in GET. The recommended method to use this API is to filter and retrieve only the required fields. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `origins.ip_address` - IP address of origin.
* `origins.size` - Physical size of origin.
* `origins.state` - State of origin.
* `size` - Physical size of FlexCache.
* `guarantee.type` - Space guarantee style of FlexCache.
* `aggregates.name` or `aggregates.uuid` - Name or UUID of aggregate of FlexCache volume.
* `path` - Fully-qualified path of the owning SVM's namespace where the FlexCache is mounted.
### Related ONTAP commands
* `volume flexcache show`
### Learn more
* [`DOC /storage/flexcache/flexcaches`](#docs-storage-storage_flexcache_flexcaches)
*/
func (a *Client) FlexcacheGet(params *FlexcacheGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/flexcaches/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FlexcacheGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheModify Prepopulates a FlexCache volume in the cluster, or modifies configuration of the FlexCache volume.

### Recommended optional properties
* `uuid` - FlexCache volume UUID.
* `prepopulate.exclude_dir_paths` - List of directory-paths to be excluded from prepopulation for the FlexCache volume.
* `prepopulate.dir_paths` - List of directory-paths to be prepopulated for the FlexCache volume.
* `writeback.enabled` - false. This property specifies whether writeback is enabled for the FlexCache volume.
* `relative_size.enabled` - This property specifies whether the relative sizing is enabled for the FlexCache volume.
* `relative_size.percentage` - This property specifies the percent size FlexCache volume should have relative to the total size of the origin volume.
* `atime_scrub.enabled` - This property specifies whether the atime based scrub is enabled for the FlexCache volume.
* `atime_scrub.period` - This property specifies the duration in days after which inactive files can be scrubbed from FlexCache volume.
* `cifs_change_notify.enabled` - This property specifies whether a CIFS change notification is enabled for the FlexCache volume.
* `nfsv4.enabled` - This property specifies whether NFSv4 is enabled for the FlexCache volume.
* `cifs.enabled` - This property specifies whether CIFS is enabled for the FlexCache volume.
* `s3.enabled` - This property specifies whether S3 is enabled for the FlexCache volume.
### Default property values
If not specified in PATCH, the following default property value is assigned:
* `prepopulate.recurse` - Default value is "true".
### Related ONTAP commands
* `volume flexcache prepopulate start`
* `volume flexcache config modify`
### Learn more
* [`DOC /storage/flexcache/flexcaches`](#docs-storage-storage_flexcache_flexcaches)
*/
func (a *Client) FlexcacheModify(params *FlexcacheModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheModifyOK, *FlexcacheModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/flexcache/flexcaches/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheModifyOK:
		return value, nil, nil
	case *FlexcacheModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FlexcacheModifyCollection flexcache modify collection API
*/
func (a *Client) FlexcacheModifyCollection(params *FlexcacheModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheModifyCollectionOK, *FlexcacheModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/flexcache/flexcaches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheModifyCollectionOK:
		return value, nil, nil
	case *FlexcacheModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheOriginCollectionGet Retrieves origin of FlexCache in the cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `flexcaches.ip_address` - IP address of FlexCache.
* `flexcaches.size` - Physical size of FlexCache.
* `flexcaches.guarantee.type` - Space guarantee style of FlexCache.
* `flexcaches.state` - State of FlexCache.
### Related ONTAP commands
* `volume flexcache origin show-caches`
### Learn more
* [`DOC /storage/flexcache/origins`](#docs-storage-storage_flexcache_origins)
*/
func (a *Client) FlexcacheOriginCollectionGet(params *FlexcacheOriginCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheOriginCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_origin_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/origins",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheOriginCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FlexcacheOriginCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheOriginCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheOriginGet Retrieves attributes of the origin of a FlexCache in the cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are included by default in GET results. The recommended method to use this API is to filter and retrieve only the required fields. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `flexcaches.ip_address` - IP address of FlexCache.
* `flexcaches.size` - Physical size of FlexCache.
* `flexcaches.guarantee.type` - Space guarantee style of FlexCache.
* `flexcaches.state` - State of FlexCache.
* `flexcaches.dr_cache` - True if the cache is a DR cache.
### Related ONTAP commands
* `volume flexcache origin show-caches`
### Learn more
* [`DOC /storage/flexcache/origins`](#docs-storage-storage_flexcache_origins)
*/
func (a *Client) FlexcacheOriginGet(params *FlexcacheOriginGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheOriginGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_origin_get",
		Method:             "GET",
		PathPattern:        "/storage/flexcache/origins/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheOriginGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FlexcacheOriginGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheOriginGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FlexcacheOriginModify Modifies origin options for a origin volume in the cluster.

### Required properties
* `uuid` - Origin volume UUID.
* `block_level_invalidation` - Value for the Block Level Invalidation flag - options {true|false}.
### Related ONTAP commands
* `volume flexcache origin config modify`
### Learn more
* [`DOC /storage/flexcache/origins`](#docs-storage-storage_flexcache_origins)
*/
func (a *Client) FlexcacheOriginModify(params *FlexcacheOriginModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginModifyOK, *FlexcacheOriginModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheOriginModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_origin_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/flexcache/origins/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheOriginModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheOriginModifyOK:
		return value, nil, nil
	case *FlexcacheOriginModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheOriginModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FlexcacheOriginModifyCollection flexcache origin modify collection API
*/
func (a *Client) FlexcacheOriginModifyCollection(params *FlexcacheOriginModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FlexcacheOriginModifyCollectionOK, *FlexcacheOriginModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFlexcacheOriginModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "flexcache_origin_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/flexcache/origins",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FlexcacheOriginModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FlexcacheOriginModifyCollectionOK:
		return value, nil, nil
	case *FlexcacheOriginModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FlexcacheOriginModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceQtreeMetricCollectionGet Retrieves historical performance metrics for a qtree which has extended performance monitoring enabled.
*/
func (a *Client) PerformanceQtreeMetricCollectionGet(params *PerformanceQtreeMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceQtreeMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceQtreeMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_qtree_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/qtrees/{volume.uuid}/{qtree.id}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceQtreeMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceQtreeMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceQtreeMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PlexCollectionGet Retrieves the collection of plexes for the specified aggregate.

### Related ONTAP commands
* `storage aggregate plex show`
*/
func (a *Client) PlexCollectionGet(params *PlexCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PlexCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPlexCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "plex_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/plexes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PlexCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PlexCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PlexCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PlexGet Retrieves the plex specified by the aggregate UUID and plex name.

### Related ONTAP commands
* `storage aggregate plex show`
*/
func (a *Client) PlexGet(params *PlexGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PlexGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPlexGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "plex_get",
		Method:             "GET",
		PathPattern:        "/storage/aggregates/{aggregate.uuid}/plexes/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PlexGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PlexGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PlexGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortCollectionGet Retrieves a collection of storage ports.

### Related ONTAP commands
* `storage port show`
### Learn more
* [`DOC /storage/ports`](#docs-storage-storage_ports)
*/
func (a *Client) PortCollectionGet(params *PortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "port_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortGet Retrieves a specific storage port.

### Related ONTAP commands
* `storage port show`
### Learn more
* [`DOC /storage/ports`](#docs-storage-storage_ports)
*/
func (a *Client) PortGet(params *PortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "port_get",
		Method:             "GET",
		PathPattern:        "/storage/ports/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosOptionGet Retrieves QoS options.

This option is available only at diagnostic privilege level and above.
### Related ONTAP commands
* `qos settings cluster-options show`
*/
func (a *Client) QosOptionGet(params *QosOptionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosOptionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosOptionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_option_get",
		Method:             "GET",
		PathPattern:        "/storage/qos/qos-options",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosOptionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosOptionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosOptionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosOptionModify Update a specific QoS option.

This option is available only at diagnostic privilege level and above.
### Related ONTAP commands
* `qos settings cluster-options modify`
*/
func (a *Client) QosOptionModify(params *QosOptionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosOptionModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosOptionModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_option_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/qos/qos-options",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosOptionModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosOptionModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosOptionModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QosPolicyCollectionGet Retrieves a collection of QoS policies.
*/
func (a *Client) QosPolicyCollectionGet(params *QosPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/qos/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosPolicyCreate Creates a QoS policy.

### Required properties
* `svm.uuid` or `svm.name` - The existing SVM owning the QoS policy.
* `name` - The name of the QoS policy.
* `fixed.*` or `adaptive.*` - Either of the fixed or adaptive parameters.
### Default property values
* If `fixed.*` parameters are specified, then capacity.shared is set to false by default.
### Related ONTAP commands
* `qos policy-group create`
* `qos adaptive-policy-group create`
*/
func (a *Client) QosPolicyCreate(params *QosPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyCreateCreated, *QosPolicyCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_create",
		Method:             "POST",
		PathPattern:        "/storage/qos/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QosPolicyCreateCreated:
		return value, nil, nil
	case *QosPolicyCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosPolicyDelete Deletes a QoS policy. All QoS workloads associated with the policy are removed.

### Related ONTAP commands
* `qos policy-group delete`
* `qos adaptive-policy-group delete`
*/
func (a *Client) QosPolicyDelete(params *QosPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/qos/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QosPolicyDeleteCollection qos policy delete collection API
*/
func (a *Client) QosPolicyDeleteCollection(params *QosPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/qos/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosPolicyGet Retrieves a specific QoS policy.

### Related ONTAP commands
* `qos policy-group show`
* `qos adaptive-policy-group show`
*/
func (a *Client) QosPolicyGet(params *QosPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_get",
		Method:             "GET",
		PathPattern:        "/storage/qos/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosPolicyModify Update a specific QoS policy.

### Related ONTAP commands
* `qos policy-group modify`
* `qos adaptive-policy-group modify`
*/
func (a *Client) QosPolicyModify(params *QosPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyModifyOK, *QosPolicyModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/qos/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QosPolicyModifyOK:
		return value, nil, nil
	case *QosPolicyModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QosPolicyModifyCollection qos policy modify collection API
*/
func (a *Client) QosPolicyModifyCollection(params *QosPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosPolicyModifyCollectionOK, *QosPolicyModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/qos/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QosPolicyModifyCollectionOK:
		return value, nil, nil
	case *QosPolicyModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosPolicyModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QosWorkloadCollectionGet Retrieves a collection of QoS workloads.
*/
func (a *Client) QosWorkloadCollectionGet(params *QosWorkloadCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosWorkloadCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosWorkloadCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_workload_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/qos/workloads",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosWorkloadCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosWorkloadCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosWorkloadCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QosWorkloadGet Retrieves a specific QoS workload.

### Related ONTAP command
* `qos workload show`
*/
func (a *Client) QosWorkloadGet(params *QosWorkloadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QosWorkloadGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQosWorkloadGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qos_workload_get",
		Method:             "GET",
		PathPattern:        "/storage/qos/workloads/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QosWorkloadGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QosWorkloadGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QosWorkloadGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QtreeCollectionGet Retrieves qtrees configured for all FlexVol volumes or FlexGroup volumes. <br/>

Use the `fields` query parameter to retrieve all properties of the qtree. If the `fields` query parameter is not used, then GET returns the qtree `name` and qtree `id` only.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `ext_performance_monitoring.enabled`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `qtree show`
*/
func (a *Client) QtreeCollectionGet(params *QtreeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/qtrees",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QtreeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QtreeCreate Creates a qtree in a FlexVol volume or a FlexGroup volume. <br/>

After a qtree is created, the new qtree is assigned an identifier. This identifier is obtained using a qtree GET request. This identifier is used in the API path for the qtree PATCH and DELETE operations.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the qtree.
* `volume.uuid` or `volume.name` - Existing volume in which to create the qtree.
* `name` - Name for the qtree.
### Recommended optional properties
If not specified in POST, the values are inherited from the volume.
* `security_style` - Security style for the qtree.
* `unix_permissions` - UNIX permissions for the qtree.
* `export_policy.name or export_policy.id` - Export policy of the SVM for the qtree.
### Related ONTAP commands
* `qtree create`
*/
func (a *Client) QtreeCreate(params *QtreeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeCreateCreated, *QtreeCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_create",
		Method:             "POST",
		PathPattern:        "/storage/qtrees",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QtreeCreateCreated:
		return value, nil, nil
	case *QtreeCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QtreeDelete Deletes a qtree.

### Related ONTAP commands
* `qtree delete`
*/
func (a *Client) QtreeDelete(params *QtreeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeDeleteOK, *QtreeDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/qtrees/{volume.uuid}/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QtreeDeleteOK:
		return value, nil, nil
	case *QtreeDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QtreeDeleteCollection qtree delete collection API
*/
func (a *Client) QtreeDeleteCollection(params *QtreeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeDeleteCollectionOK, *QtreeDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/qtrees",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QtreeDeleteCollectionOK:
		return value, nil, nil
	case *QtreeDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QtreeGet Retrieves properties for a specific qtree identified by the `volume.uuid` and the `id` in the API path.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `ext_performance_monitoring.enabled`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `qtree show`
*/
func (a *Client) QtreeGet(params *QtreeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_get",
		Method:             "GET",
		PathPattern:        "/storage/qtrees/{volume.uuid}/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QtreeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QtreeModify Updates properties for a specific qtree.

### Related ONTAP commands
* `qtree modify`
* `qtree rename`
*/
func (a *Client) QtreeModify(params *QtreeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeModifyOK, *QtreeModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/qtrees/{volume.uuid}/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QtreeModifyOK:
		return value, nil, nil
	case *QtreeModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QtreeModifyCollection qtree modify collection API
*/
func (a *Client) QtreeModifyCollection(params *QtreeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QtreeModifyCollectionOK, *QtreeModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQtreeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "qtree_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/qtrees",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QtreeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QtreeModifyCollectionOK:
		return value, nil, nil
	case *QtreeModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QtreeModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaReportCollectionGet Retrieves the quota report records for all FlexVol volumes and FlexGroup volumes.

### Related ONTAP commands
* `quota report`
*/
func (a *Client) QuotaReportCollectionGet(params *QuotaReportCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaReportCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaReportCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_report_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/quota/reports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaReportCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuotaReportCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaReportCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaReportGet Retrieves a specific quota report record.

### Related ONTAP commands
* `quota report`
*/
func (a *Client) QuotaReportGet(params *QuotaReportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaReportGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaReportGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_report_get",
		Method:             "GET",
		PathPattern:        "/storage/quota/reports/{volume.uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaReportGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuotaReportGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaReportGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaRuleCollectionGet Retrieves quota policy rules configured for all FlexVol volumes and FlexGroup volumes.

### Related ONTAP commands
* `quota policy rule show`
*/
func (a *Client) QuotaRuleCollectionGet(params *QuotaRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/quota/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuotaRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaRuleCreate Creates a quota policy rule for a FlexVol or a FlexGroup volume.<br/>

Important notes:
* Unlike CLI/ONTAPI, the `quota policy` input is not needed for POST.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the qtree.
* `volume.uuid` or `volume.name` - Existing volume in which to create the qtree.
* `type` - Quota type for the rule. This type can be `user`, `group`, or `tree`.
* `users.name` or `user.id` -  If the quota type is user, this property takes the user name or user ID. For default user quota rules, the user name must be specified as "".
* `group.name` or `group.id` - If the quota type is group, this property takes the group name or group ID. For default group quota rules, the group name must be specified as "".
* `qtree.name` - Qtree for which to create the rule. For default tree rules, the qtree name must be specified as "".
### Recommended optional properties
* `space.hard_limit` - Specifies the space hard limit, in bytes. If less than 1024 bytes, the value is rounded up to 1024 bytes.
* `space.soft_limit` - Specifies the space soft limit, in bytes. If less than 1024 bytes, the value is rounded up to 1024 bytes.
* `files.hard_limit` - Specifies the hard limit for files.
* `files.soft_limit` - Specifies the soft limit for files.
* `user_mapping` - Specifies the user_mapping. This property is valid only for quota policy rules of type `user`.
### Related ONTAP commands
* `quota policy rule create`
*/
func (a *Client) QuotaRuleCreate(params *QuotaRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleCreateCreated, *QuotaRuleCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_create",
		Method:             "POST",
		PathPattern:        "/storage/quota/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QuotaRuleCreateCreated:
		return value, nil, nil
	case *QuotaRuleCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaRuleDelete Deletes a quota policy rule.

### Related ONTAP commands
* `quota policy rule delete`
*/
func (a *Client) QuotaRuleDelete(params *QuotaRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleDeleteOK, *QuotaRuleDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/quota/rules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QuotaRuleDeleteOK:
		return value, nil, nil
	case *QuotaRuleDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QuotaRuleDeleteCollection quota rule delete collection API
*/
func (a *Client) QuotaRuleDeleteCollection(params *QuotaRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleDeleteCollectionOK, *QuotaRuleDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/quota/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QuotaRuleDeleteCollectionOK:
		return value, nil, nil
	case *QuotaRuleDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaRuleGet Retrieves properties for a specific quota policy rule.

### Related ONTAP commands
* `quota policy rule show`
*/
func (a *Client) QuotaRuleGet(params *QuotaRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_get",
		Method:             "GET",
		PathPattern:        "/storage/quota/rules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuotaRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	QuotaRuleModify Updates properties of a specific quota policy rule. <br>

Important notes:
* The quota resize functionality is supported with the PATCH operation.
* Quota resize allows you to modify the quota limits, directly in the filesystem.
* The quota must be enabled on a FlexVol or a FlexGroup volume for `quota resize` to take effect.
* If the quota is disabled on the volume, the quota policy rule PATCH API modifies the rule, but this does not affect the limits in the filesystem.
### Related ONTAP commands
* `quota policy rule modify`
* `quota resize`
*/
func (a *Client) QuotaRuleModify(params *QuotaRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleModifyOK, *QuotaRuleModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/quota/rules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QuotaRuleModifyOK:
		return value, nil, nil
	case *QuotaRuleModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
QuotaRuleModifyCollection quota rule modify collection API
*/
func (a *Client) QuotaRuleModifyCollection(params *QuotaRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*QuotaRuleModifyCollectionOK, *QuotaRuleModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuotaRuleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "quota_rule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/quota/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuotaRuleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *QuotaRuleModifyCollectionOK:
		return value, nil, nil
	case *QuotaRuleModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*QuotaRuleModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShelfCollectionGet Retrieves a collection of shelves.

### Related ONTAP commands
* `storage shelf show`
* `storage shelf port show`
* `storage shelf drawer show`
* `storage shelf drawer show-slot`
* `storage shelf acp show`
### Learn more
* [`DOC /storage/shelves`](#docs-storage-storage_shelves)
*/
func (a *Client) ShelfCollectionGet(params *ShelfCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShelfCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shelf_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/shelves",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShelfCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShelfCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShelfCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShelfGet Retrieves a specific shelf.

### Related ONTAP commands
* `storage shelf show`
* `storage shelf port show`
* `storage shelf drawer show`
* `storage shelf drawer show-slot`
* `storage shelf acp show`
### Learn more
* [`DOC /storage/shelves`](#docs-storage-storage_shelves)
*/
func (a *Client) ShelfGet(params *ShelfGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShelfGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shelf_get",
		Method:             "GET",
		PathPattern:        "/storage/shelves/{uid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShelfGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShelfGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShelfGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShelfModify Updates a shelf location LED.

### Related ONTAP commands
* `storage shelf location-led modify`
### Learn more
* [`DOC /storage/shelves`](#docs-storage-storage_shelves)
*/
func (a *Client) ShelfModify(params *ShelfModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShelfModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shelf_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/shelves/{uid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShelfModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShelfModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShelfModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ShelfModifyCollection shelf modify collection API
*/
func (a *Client) ShelfModifyCollection(params *ShelfModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShelfModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShelfModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shelf_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/shelves",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShelfModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShelfModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShelfModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotCollectionGet Retrieves a collection of volume snapshots.

### Expensive properties
There is an added computational cost to retrieving the amount of reclaimable space for snapshots, as the calculation is done on demand based on the list of snapshots provided.
* `reclaimable_space`
* `delta`
### Related ONTAP commands
* `snapshot show`
* `snapshot compute-reclaimable`
* `snapshot show-delta`
### Learn more
* [`DOC /storage/volumes/{volume.uuid}/snapshots`](#docs-storage-storage_volumes_{volume.uuid}_snapshots)
*/
func (a *Client) SnapshotCollectionGet(params *SnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotCreate Creates a volume snapshot.

### Required properties
* `name` - Name of the snapshot to be created.
### Recommended optional properties
* `comment` - Comment associated with the snapshot.
* `expiry_time` - snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
* `snapmirror_label` - Label for SnapMirror operations.
* `snaplock_expiry_time` - Expiry time for snapshot locking enabled volumes.
### Related ONTAP commands
* `snapshot create`
### Learn more
* [`DOC /storage/volumes/{volume.uuid}/snapshots`](#docs-storage-storage_volumes_{volume.uuid}_snapshots)
*/
func (a *Client) SnapshotCreate(params *SnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotCreateCreated, *SnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_create",
		Method:             "POST",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapshotCreateCreated:
		return value, nil, nil
	case *SnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotDelete Deletes a Volume snapshot.

### Related ONTAP commands
* `snapshot delete`
### Learn more
* [`DOC /storage/volumes/{volume.uuid}/snapshots`](#docs-storage-storage_volumes_{volume.uuid}_snapshots)
*/
func (a *Client) SnapshotDelete(params *SnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotDeleteOK, *SnapshotDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapshotDeleteOK:
		return value, nil, nil
	case *SnapshotDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotDeleteCollection snapshot delete collection API
*/
func (a *Client) SnapshotDeleteCollection(params *SnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotDeleteCollectionOK, *SnapshotDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapshotDeleteCollectionOK:
		return value, nil, nil
	case *SnapshotDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotGet Retrieves details of a specific volume snapshot.

### Related ONTAP commands
* `snapshot show`
### Learn more
* [`DOC /storage/volumes/{volume.uuid}/snapshots`](#docs-storage-storage_volumes_{volume.uuid}_snapshots)
*/
func (a *Client) SnapshotGet(params *SnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotModify Updates a Volume snapshot.

### Related ONTAP commands
* `snapshot modify`
* `snapshot rename`
### Learn more
* [`DOC /storage/volumes/{volume.uuid}/snapshots`](#docs-storage-storage_volumes_{volume.uuid}_snapshots)
*/
func (a *Client) SnapshotModify(params *SnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotModifyOK, *SnapshotModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapshotModifyOK:
		return value, nil, nil
	case *SnapshotModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotModifyCollection snapshot modify collection API
*/
func (a *Client) SnapshotModifyCollection(params *SnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotModifyCollectionOK, *SnapshotModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/volumes/{volume.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapshotModifyCollectionOK:
		return value, nil, nil
	case *SnapshotModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyCollectionGet Retrieves a collection of snapshot policies.

### Related ONTAP commands
* `snapshot policy show`
### Learn more
* [`DOC /storage/snapshot-policies`](#docs-storage-storage_snapshot-policies)
*/
func (a *Client) SnapshotPolicyCollectionGet(params *SnapshotPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snapshot-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyCreate Creates a snapshot policy.

### Required properties
* `svm.uuid` or `svm.name` - Specifies an SVM for policy creation. If not specified, the snapshot policy will be created on the cluster admin SVM.
* `name` - Name for the snapshot policy.
* `copies.schedule` - Schedule name at which snapshots are captured on the volume.
* `copies.count` - Number of snapshots to maintain for this schedule.
### Recommended optional properties
* `copies.prefix` - Prefix to use when creating snapshots at regular intervals.
* `copies.snapmirror_label` - Label for SnapMirror operations.
* `copies.retention_period` - Retention period for snapshot locking enabled volumes.The duration must be specified in ISO format or \"infinite\".
### Default property values
If not specified in POST, the following default property values are assigned:
* `svm.uuid` or `svm.name` - If not specified, the snapshot policy will be created on the cluster admin SVM.
* `enabled` - _true_
* `copies.prefix` - Value of `schedule.name`
### Related ONTAP commands
* `snapshot policy create`
### Learn more
* [`DOC /storage/snapshot-policies`](#docs-storage-storage_snapshot-policies)
*/
func (a *Client) SnapshotPolicyCreate(params *SnapshotPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_create",
		Method:             "POST",
		PathPattern:        "/storage/snapshot-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyDelete Deletes a snapshot policy

### Related ONTAP commands
* `snapshot policy delete`
### Learn more
* [`DOC /storage/snapshot-policies`](#docs-storage-storage_snapshot-policies)
*/
func (a *Client) SnapshotPolicyDelete(params *SnapshotPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snapshot-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotPolicyDeleteCollection snapshot policy delete collection API
*/
func (a *Client) SnapshotPolicyDeleteCollection(params *SnapshotPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snapshot-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyGet Retrieves details of a specific snapshot policy.

### Related ONTAP commands
* `snapshot policy show`
### Learn more
* [`DOC /storage/snapshot-policies`](#docs-storage-storage_snapshot-policies)
*/
func (a *Client) SnapshotPolicyGet(params *SnapshotPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_get",
		Method:             "GET",
		PathPattern:        "/storage/snapshot-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyModify Updates a snapshot policy

### Related ONTAP commands
* `snapshot policy modify`
* `snapshot policy modify-schedule`
* `snapshot policy add-schedule`
### Learn more
* [`DOC /storage/snapshot-policies`](#docs-storage-storage_snapshot-policies)
*/
func (a *Client) SnapshotPolicyModify(params *SnapshotPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/snapshot-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotPolicyModifyCollection snapshot policy modify collection API
*/
func (a *Client) SnapshotPolicyModifyCollection(params *SnapshotPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/snapshot-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyScheduleCollectionGet Retrieves a collection of snapshot policy schedules.

### Related ONTAP commands
* `snapshot policy show`
### Learn more
* [`DOC /storage/snapshot-policies/{snapshot_policy.uuid}/schedules`](#docs-storage-storage_snapshot-policies_{snapshot_policy.uuid}_schedules)
*/
func (a *Client) SnapshotPolicyScheduleCollectionGet(params *SnapshotPolicyScheduleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyScheduleCreate Adds a schedule to a snapshot policy.

### Required properties
* `schedule.uuid` or `schedule.name` - Schedule at which snapshots are captured on the volume.
* `count` - Number of snapshots to maintain for this schedule.
### Recommended optional properties
* `prefix` - Prefix to use when creating snapshots at regular intervals.
### Default property values
If not specified in POST, the following default property values are assigned:
* `prefix` - Value of `schedule.name`
### Related ONTAP commands
* `snapshot policy add-schedule`
### Learn more
* [`DOC /storage/snapshot-policies/{snapshot_policy.uuid}/schedules`](#docs-storage-storage_snapshot-policies_{snapshot_policy.uuid}_schedules)
*/
func (a *Client) SnapshotPolicyScheduleCreate(params *SnapshotPolicyScheduleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_create",
		Method:             "POST",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyScheduleDelete Deletes a schedule from a snapshot policy

### Related ONTAP commands
* `snapshot policy remove-schedule`
### Learn more
* [`DOC /storage/snapshot-policies/{snapshot_policy.uuid}/schedules`](#docs-storage-storage_snapshot-policies_{snapshot_policy.uuid}_schedules)
*/
func (a *Client) SnapshotPolicyScheduleDelete(params *SnapshotPolicyScheduleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotPolicyScheduleDeleteCollection snapshot policy schedule delete collection API
*/
func (a *Client) SnapshotPolicyScheduleDeleteCollection(params *SnapshotPolicyScheduleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyScheduleGet Retrieves details of a specific snapshot policy schedule.

### Related ONTAP commands
* `snapshot policy show`
### Learn more
* [`DOC /storage/snapshot-policies/{snapshot_policy.uuid}/schedules`](#docs-storage-storage_snapshot-policies_{snapshot_policy.uuid}_schedules)
*/
func (a *Client) SnapshotPolicyScheduleGet(params *SnapshotPolicyScheduleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_get",
		Method:             "GET",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapshotPolicyScheduleModify Updates a snapshot policy schedule

### Related ONTAP commands
* `snapshot policy modify-schedule`
### Learn more
* [`DOC /storage/snapshot-policies/{snapshot_policy.uuid}/schedules`](#docs-storage-storage_snapshot-policies_{snapshot_policy.uuid}_schedules)
*/
func (a *Client) SnapshotPolicyScheduleModify(params *SnapshotPolicyScheduleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules/{schedule.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapshotPolicyScheduleModifyCollection snapshot policy schedule modify collection API
*/
func (a *Client) SnapshotPolicyScheduleModifyCollection(params *SnapshotPolicyScheduleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapshotPolicyScheduleModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapshotPolicyScheduleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapshot_policy_schedule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/snapshot-policies/{snapshot_policy.uuid}/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapshotPolicyScheduleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapshotPolicyScheduleModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapshotPolicyScheduleModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SplitLoadCollectionGet Retrieves the clone split load of a node.

### Related Ontap Commands
* `volume file clone split load show`
### Retrieving file clone split load related information
The GET operation can be used to retrieve information about clone split load data. Split load data is the data currently undergoing the split. There is a limit on split load data. This API communicates how much data is undergoing split and how much can still be processed.
```
# The API:
/api/storage/file/clone/split-loads
# The call:
curl -X GET "https://<mgmt_ip>/api/storage/file/clone/split-loads" -H "accept: application/hal+json"
# The response:

	{
	  "records": [
	    {
	      "node": {
	        "uuid": "158d592f-a829-11eb-a47b-005056bb46d7",
	        "name": "node1",
	        "_links": {
	          "self": {
	            "href": "/api/cluster/nodes/158d592f-a829-11eb-a47b-005056bb46d7"
	          }
	        }
	      },
	      "load": {
	        "maximum": 35184372088832,
	        "current": 0,
	        "token_reserved": 0,
	        "allowable": 35184372088832
	      },
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/split-loads/158d592f-a829-11eb-a47b-005056bb46d7"
	        }
	      }
	    },
	    {
	      "node": {
	        "uuid": "9686b8d1-a828-11eb-80d8-005056bbe7b6",
	        "name": "node2",
	        "_links": {
	          "self": {
	            "href": "/api/cluster/nodes/9686b8d1-a828-11eb-80d8-005056bbe7b6"
	          }
	        }
	      },
	      "load": {
	        "maximum": 35184372088832,
	        "current": 0,
	        "token_reserved": 0,
	        "allowable": 35184372088832
	      },
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/split-loads/9686b8d1-a828-11eb-80d8-005056bbe7b6"
	        }
	      }
	    }
	  ],
	  "num_records": 2,
	  "_links":
	    "self": {
	      "href": "/api/storage/file/clone/split-loads"
	    }
	  }
	}

```
### Learn More
* [`DOC /storage/file/clone`]
*/
func (a *Client) SplitLoadCollectionGet(params *SplitLoadCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitLoadCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_load_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/split-loads",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitLoadCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitLoadCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitLoadCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SplitLoadGet Retrieve the volume file clone split load.

### Related ONTAP command
* `volume file clone split load show`
*/
func (a *Client) SplitLoadGet(params *SplitLoadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitLoadGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_load_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/split-loads/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitLoadGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitLoadGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitLoadGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SplitLoadModify Updates the maximum split load.

### Related Ontap command
* `volume file clone split load modify`
### Learn More
* [`DOC /storage/file/clone`]
```
# The call:
curl -X PATCH "https://<mgmt_IP>/api/storage/file/clone/split-loads/9686b8d1-a828-11eb-80d8-005056bbe7b6" -d '{"load": {"maximum": "16TB" } }'
# The response to successful patch is empty body
```
*/
func (a *Client) SplitLoadModify(params *SplitLoadModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitLoadModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_load_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/file/clone/split-loads/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitLoadModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitLoadModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitLoadModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SplitLoadModifyCollection split load modify collection API
*/
func (a *Client) SplitLoadModifyCollection(params *SplitLoadModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitLoadModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitLoadModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_load_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/file/clone/split-loads",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitLoadModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitLoadModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitLoadModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SplitStatusCollectionGet Retrieves file clone split status of all volumes in the node.

### Learn More
* [`DOC /storage/file/clone`]
```
# The API:
/api/storage/file/clone/split-status
# The call:
curl -X GET "https://<mgmt_ip>/api/storage/file/clone/split-status" -H "accept: application/hal+json"
# The response:

	{
	  "records": [
	    {
	      "volume": {
	        "uuid": "ac559964-57a3-40cf-b5cb-f3cb99151a7d",
	        "name": "vol1",
	        "_links": {
	          "self": {
	            "href": "/api/storage/volumes/ac559964-57a3-40cf-b5cb-f3cb99151a7d"
	          }
	        }
	      },
	      "svm": {
	        "uuid": "9fcb44bf-4305-11e8-b8d5-00a09887594b",
	        "name": "vs1"
	        "_links": {
	          "self": {
	            "href": "/api/svm/svms/9fcb44bf-4305-11e8-b8d5-00a09887594b"
	          }
	        }
	      },
	      "pending_splits": 0,
	      "unsplit_size": 0,
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/split-status/ac559964-57a3-40cf-b5cb-f3cb99151a7d"
	        }
	      }
	    },
	    {
	      "volume": {
	        "uuid": "32d95d48-d8b7-11eb-a41d-005056bb3837",
	        "name": "vs1_root",
	        "_links": {
	          "self": {
	            "href": "/api/storage/volumes/32d95d48-d8b7-11eb-a41d-005056bb3837"
	          }
	        }
	      },
	      "svm": {
	        "name": "vs1"
	        "_links": {
	          "self": {
	            "href": "/api/svm/svms/9fcb44bf-4305-11e8-b8d5-00a09887594b"
	          }
	        }
	      },
	      "pending_splits": 0,
	      "unsplit_size": 0,
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/split-status/32d95d48-d8b7-11eb-a41d-005056bb3837"
	        }
	      }
	    }
	  ],
	  "num_records": 2,
	  "_links": {
	    "self": {
	      "href": "/api/storage/file/clone/split-status"
	    }
	  }
	}

```
*/
func (a *Client) SplitStatusCollectionGet(params *SplitStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitStatusCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitStatusCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_status_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/split-status",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitStatusCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitStatusCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitStatusCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SplitStatusGet Retrieves file clone split status of all volumes in the node.

### Related Ontap commands
* `volume file clone split status`
### Learn More
* [`DOC /storage/file/clone`]
### Retrieves the information of split status.
The GET operation retrieves information about split processes in the volume.
`pending-clone-splits` is the number of files for which file clone split is not yet completed.
`unsplit-size` is the sum of all sizes in the volume that is not split, in bytes.
```
# The API:
/api/storage/file/clone/split-status/{volume.uuid}
# The call:
curl -X GET "https://<mgmt_ip>/api/storage/file/clone/split-status/ac559964-57a3-40cf-b5cb-f3cb99151a7d" -H "accept: application/hal+json"
# The response:

	{
	  "volume": {
	    "uuid": "ac559964-57a3-40cf-b5cb-f3cb99151a7d",
	    "name": "vol1",
	    "_links": {
	      "self": {
	        "href": "/api/storage/volumes/ac559964-57a3-40cf-b5cb-f3cb99151a7d"
	      }
	    }
	  },
	  "svm": {
	    "name": "vs1"
	  },
	  "pending_splits": 0,
	  "unsplit_size": 0,
	  "_links": {
	    "self": {
	      "href": "/api/storage/file/clone/split-status/ac559964-57a3-40cf-b5cb-f3cb99151a7d"
	    }
	  }
	}

```
*/
func (a *Client) SplitStatusGet(params *SplitStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SplitStatusGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSplitStatusGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "split_status_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/split-status/{volume.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SplitStatusGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SplitStatusGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SplitStatusGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageAvailabilityZoneCollectionGet Retrieves storage details for all availability zones of the cluster. By default, the availability zone UUID is retrieved. Other Storage details can

be retrieved using fields parameter. Storage details include storage efficiency and other storage related information.
*/
func (a *Client) StorageAvailabilityZoneCollectionGet(params *StorageAvailabilityZoneCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageAvailabilityZoneCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_availability_zone_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/availability-zones",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageAvailabilityZoneCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageAvailabilityZoneCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageAvailabilityZoneCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageAvailabilityZoneGet Retrieves storage details for an individual availability zone of the cluster. By default, this endpoint returns all fields.

Storage details include storage efficiency and other storage related information.
*/
func (a *Client) StorageAvailabilityZoneGet(params *StorageAvailabilityZoneGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageAvailabilityZoneGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_availability_zone_get",
		Method:             "GET",
		PathPattern:        "/storage/availability-zones/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageAvailabilityZoneGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageAvailabilityZoneGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageAvailabilityZoneGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageAvailabilityZoneModify Updates full_threshold_percent and nearly_full_threshold_percent for an individual availability zone of the cluster.
*/
func (a *Client) StorageAvailabilityZoneModify(params *StorageAvailabilityZoneModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneModifyOK, *StorageAvailabilityZoneModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageAvailabilityZoneModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_availability_zone_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/availability-zones/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageAvailabilityZoneModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageAvailabilityZoneModifyOK:
		return value, nil, nil
	case *StorageAvailabilityZoneModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageAvailabilityZoneModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageAvailabilityZoneModifyCollection storage availability zone modify collection API
*/
func (a *Client) StorageAvailabilityZoneModifyCollection(params *StorageAvailabilityZoneModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageAvailabilityZoneModifyCollectionOK, *StorageAvailabilityZoneModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageAvailabilityZoneModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_availability_zone_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/availability-zones",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageAvailabilityZoneModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageAvailabilityZoneModifyCollectionOK:
		return value, nil, nil
	case *StorageAvailabilityZoneModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageAvailabilityZoneModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageBridgeCollectionGet Retrieves a collection of bridges.

### Related ONTAP commands
* `storage bridge show`
### Learn more
* [`DOC /storage/bridges`](#docs-storage-storage_bridges)
*/
func (a *Client) StorageBridgeCollectionGet(params *StorageBridgeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageBridgeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageBridgeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_bridge_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/bridges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageBridgeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageBridgeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageBridgeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageBridgeGet Retrieves a specific bridge

### Related ONTAP commands
* `storage bridge show`
### Learn more
* [`DOC /storage/bridges`](#docs-storage-storage_bridges)
*/
func (a *Client) StorageBridgeGet(params *StorageBridgeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageBridgeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageBridgeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_bridge_get",
		Method:             "GET",
		PathPattern:        "/storage/bridges/{wwn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageBridgeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageBridgeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageBridgeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageClusterGet Retrieves cluster-wide storage details across the different tiers. By default, this endpoint returns all fields.

Storage details include storage efficiency, block storage and cloud storage information.
Supports the following roles: admin, and readonly.
*/
func (a *Client) StorageClusterGet(params *StorageClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageClusterGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageClusterGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_cluster_get",
		Method:             "GET",
		PathPattern:        "/storage/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageClusterGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageClusterGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageClusterGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePoolCollectionGet Retrieves the collection of storage pools for the entire cluster.

### Related ONTAP commands
* `storage pool show`
*/
func (a *Client) StoragePoolCollectionGet(params *StoragePoolCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StoragePoolCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePoolCreate Creates a new storage pool using available solid state capacity attached to the nodes specified.

### Required properties
The following properties are required in the POST body:
* `name` - Name of the new storage pool.
* `nodes[].name` or `nodes[].uuid` - Nodes that can use cache capacity from the new storage pool. Only nodes in the same HA pair can be specified for a given storage pool. Spare cache capacity will be distributed evenly among the specified nodes.
* `capacity.disk_count` - Number of SSDs to be used to create the storage pool.
### Related ONTAP commands
* `storage pool create`
### Example:
```
POST /api/storage/pools {"nodes": [{"name": "node1"}, {"name": "node2"}], "name": "storage_pool_1", "capacity": {"disk_count": "4"}}
```
*/
func (a *Client) StoragePoolCreate(params *StoragePoolCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolCreateCreated, *StoragePoolCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_create",
		Method:             "POST",
		PathPattern:        "/storage/pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StoragePoolCreateCreated:
		return value, nil, nil
	case *StoragePoolCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePoolDelete Deletes the storage pool specified by the UUID. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage pool delete`
*/
func (a *Client) StoragePoolDelete(params *StoragePoolDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolDeleteOK, *StoragePoolDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/pools/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StoragePoolDeleteOK:
		return value, nil, nil
	case *StoragePoolDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StoragePoolDeleteCollection storage pool delete collection API
*/
func (a *Client) StoragePoolDeleteCollection(params *StoragePoolDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolDeleteCollectionOK, *StoragePoolDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StoragePoolDeleteCollectionOK:
		return value, nil, nil
	case *StoragePoolDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePoolGet Retrieves the storage pool specified by the UUID.

### Related ONTAP commands
* `storage pool show -storage-pool-uuid`
*/
func (a *Client) StoragePoolGet(params *StoragePoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_get",
		Method:             "GET",
		PathPattern:        "/storage/pools/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StoragePoolGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePoolModify Updates the storage pool specified by the UUID with the properties in the body. This request starts a job and returns a link to that job.

### Related ONTAP commands
* `storage pool rename`
* `storage pool reassign`
* `storage pool add`
*/
func (a *Client) StoragePoolModify(params *StoragePoolModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolModifyOK, *StoragePoolModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/pools/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StoragePoolModifyOK:
		return value, nil, nil
	case *StoragePoolModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StoragePoolModifyCollection storage pool modify collection API
*/
func (a *Client) StoragePoolModifyCollection(params *StoragePoolModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePoolModifyCollectionOK, *StoragePoolModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePoolModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_pool_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePoolModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StoragePoolModifyCollectionOK:
		return value, nil, nil
	case *StoragePoolModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePoolModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StoragePortModify Updates a storage port.

### Related ONTAP commands
* `storage port modify`
* `storage port enable`
* `storage port disable`
### Learn more
* [`DOC /storage/ports`](#docs-storage-storage_ports)
*/
func (a *Client) StoragePortModify(params *StoragePortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePortModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePortModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_port_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/ports/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePortModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StoragePortModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePortModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StoragePortModifyCollection storage port modify collection API
*/
func (a *Client) StoragePortModifyCollection(params *StoragePortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StoragePortModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStoragePortModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_port_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StoragePortModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StoragePortModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StoragePortModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageSwitchCollectionGet Retrieves a collection of storage switches.

### Related ONTAP commands
* `storage switch show`
### Learn more
* [`DOC /storage/switches`](#docs-storage-storage_switches)
*/
func (a *Client) StorageSwitchCollectionGet(params *StorageSwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageSwitchCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageSwitchCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_switch_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageSwitchCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageSwitchCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageSwitchCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageSwitchGet Retrieves a specific storage switch.

### Related ONTAP commands
* `storage switch show`
### Learn more
* [`DOC /storage/switches`](#docs-storage-storage_switches)
*/
func (a *Client) StorageSwitchGet(params *StorageSwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageSwitchGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageSwitchGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_switch_get",
		Method:             "GET",
		PathPattern:        "/storage/switches/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageSwitchGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageSwitchGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageSwitchGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TapeDeviceCollectionGet Retrieves a collection of tape devices.

### Related ONTAP commands
* `storage tape show`
### Learn more
* [`DOC /storage/tape-devices`](#docs-storage-storage_tape-devices)
*/
func (a *Client) TapeDeviceCollectionGet(params *TapeDeviceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTapeDeviceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tape_device_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/tape-devices",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TapeDeviceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TapeDeviceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TapeDeviceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TapeDeviceGet Retrieves a specific tape device.

### Related ONTAP commands
* `storage tape show`
### Learn more
* [`DOC /storage/tape-devices`](#docs-storage-storage_tape-devices)
*/
func (a *Client) TapeDeviceGet(params *TapeDeviceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTapeDeviceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tape_device_get",
		Method:             "GET",
		PathPattern:        "/storage/tape-devices/{node.uuid}/{device_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TapeDeviceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TapeDeviceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TapeDeviceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TapeDeviceModify Updates a specific tape device.

### Related ONTAP commands
* `storage tape alias-set`
* `storage tape alias-clear`
* `storage tape online`
* `storage tape offline`
* `storage tape position`
### Learn more
* [`DOC /storage/tape-devices`](#docs-storage-storage_tape-devices)
*/
func (a *Client) TapeDeviceModify(params *TapeDeviceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceModifyOK, *TapeDeviceModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTapeDeviceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tape_device_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/tape-devices/{node.uuid}/{device_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TapeDeviceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *TapeDeviceModifyOK:
		return value, nil, nil
	case *TapeDeviceModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TapeDeviceModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TapeDeviceModifyCollection tape device modify collection API
*/
func (a *Client) TapeDeviceModifyCollection(params *TapeDeviceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TapeDeviceModifyCollectionOK, *TapeDeviceModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTapeDeviceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tape_device_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/tape-devices",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TapeDeviceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *TapeDeviceModifyCollectionOK:
		return value, nil, nil
	case *TapeDeviceModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TapeDeviceModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TokenCollectionGet Retrieves information for the specified token.

### Related Ontap command
* `volume file clone token show`
### Learn More
* [`DOC /storage/file/clone`]
### Retrieving information on clone tokens
```
# The API:
/api/storage/file/clone/tokens
# The call:
curl -X GET "https://<mgmt_ip>/api/storage/file/clone/tokens" -H "accept: application/hal+json"
# The response:

	{
	  "records": [
	    {
	      "node": {
	        "uuid": "97255711-a1ad-11eb-92b2-0050568eb2ca",
	        "name": "node1",
	        "_links": {
	          "self": {
	            "href": "/api/cluster/nodes/97255711-a1ad-11eb-92b2-0050568eb2ca"
	          }
	        }
	      },
	      "uuid": "905c42ce-a74b-11eb-bd86-0050568ec7ae",
	      "reserve_size": 10240,
	      "expiry_time": {
	        "limit": "PT1H10M",
	      },
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca/905c42ce-a74b-11eb-bd86-0050568ec7ae"
	        }
	      }
	    }
	  ],
	  "num_records": 1,
	  "_links": {
	    "self": {
	      "href": "/api/storage/file/clone/tokens"
	    }
	  }
	}

```
*/
func (a *Client) TokenCollectionGet(params *TokenCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/tokens",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TokenCreate Creates a new token to reserve the split load.

### Required Properties
* `node.uuid`
* `reserve-size`
### Optional Properties
* `expiry_time.limit`
### Default values
* `expiry_time.limit` - "60"
### Related ONTAP Commands
* `volume file clone token create`
### Learn More
* [`DOC /storage/file/clone`]
### Creating clone tokens to reserve space for clone creation on the node
There is a limit on the amount of clone data that can undergo a split at a point of time on the node (clone split load). Clone tokens are used to reserve space from clone split load for clone creation. The POST operation is used to create clone tokens with `reserve-size` and `expiry-time.limit` in the body.<br\>
```
# The API
/api/storage/file/clone/tokens
# The call
curl -X POST "https://<mgmt_ip>/api/storage/file/clone/tokens" -H "accept: application/hal+json" -d '{"node": {"uuid": "97255711-a1ad-11eb-92b2-0050568eb2ca"}, "reserve_size": "40M", "expiry_time": { "limit": "4200"} }'
# The response

	{
	  "num_records": 1,
	  "records": [
	    {
	      "node": {
	        "uuid": "97255711-a1ad-11eb-92b2-0050568eb2ca",
	        "name": "node1"
	      },
	      "uuid": "286f6ae4-c94d-11eb-adb5-005056bbeb0b",
	      "reserve_size": 41943040,
	      "expiry_time": {
	        "limit": "PT1H10M"
	      },
	      "_links": {
	        "self": {
	          "href": "/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca"
	        }
	      }
	    }
	  ]
	}

```
*/
func (a *Client) TokenCreate(params *TokenCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_create",
		Method:             "POST",
		PathPattern:        "/storage/file/clone/tokens",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TokenDelete Deletes a specific file clone token.

### Related Ontap command
* `volume file clone token delete`
### Delete specific clone token.
```
# The API:
/api/storage/file/clone/tokens/{node.uuid}/{token.uuid}
# The call:
curl -X DELETE "https://<mgmt_ip>/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca/909c42ce-a74b-11eb-bd86-0050568ec7ae"
# The successful response is empty body.
```
### Learn More
* [`DOC /storage/file/clone`]
*/
func (a *Client) TokenDelete(params *TokenDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/file/clone/tokens/{node.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TokenDeleteCollection token delete collection API
*/
func (a *Client) TokenDeleteCollection(params *TokenDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/file/clone/tokens",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TokenGet Retrieves a file clone token

### Related Ontap command
* `volume file clone token show`
### Retrieve information for single token.
```
# The call:
curl -X GET "https://<mgmt_ip>/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca/905c42ce-a74b-11eb-bd86-0050568ec7ae"
# The response:

	{
	  "node": {
	    "uuid": "97255711-a1ad-11eb-92b2-0050568eb2ca",
	    "name": "node1",
	    "_links": {
	      "self": {
	        "href": "/api/cluster/nodes/97255711-a1ad-11eb-92b2-0050568eb2ca"
	      }
	    }
	  },
	  "uuid": "905c42ce-a74b-11eb-bd86-0050568ec7ae",
	  "reserve_size": 41943040,
	  "expiry_time": {
	    "limit": "PT1H10M",
	  },
	  "_links": {
	    "self": {
	      "href": "/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca/905c42ce-a74b-11eb-bd86-0050568ec7ae"
	    }
	  }
	}

```
### Learn More
* [`DOC /storage/file/clone`]
*/
func (a *Client) TokenGet(params *TokenGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_get",
		Method:             "GET",
		PathPattern:        "/storage/file/clone/tokens/{node.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TokenModify Updates a file clone token.

### Related Ontap commands
* `volume file clone token modify`
### Modify clone token
Use the PATCH API to update the expiry time associated with the clone token.<br\>
```
# The call:
curl -X PATCH "https://<mgmt_ip>/api/storage/file/clone/tokens/97255711-a1ad-11eb-92b2-0050568eb2ca/905c42ce-a74b-11eb-bd86-0050568ec7ae" -d '{"expiry_time": {"limit": "5400"} }'
# The response for successful PATCH is empty.
```
### Learn More
* [`DOC /storage/file/clone`]
*/
func (a *Client) TokenModify(params *TokenModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/file/clone/tokens/{node.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TokenModifyCollection token modify collection API
*/
func (a *Client) TokenModifyCollection(params *TokenModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TokenModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokenModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "token_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/file/clone/tokens",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokenModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokenModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TokenModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsClientCollectionGet Retrieves a list of clients with the most I/O activity.
*/
func (a *Client) TopMetricsClientCollectionGet(params *TopMetricsClientCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsClientCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsClientCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_client_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/top-metrics/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsClientCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsClientCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsClientCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsDirectoryCollectionGet Retrieves a list of directories with the greatest value performance metric or capacity metric.
*/
func (a *Client) TopMetricsDirectoryCollectionGet(params *TopMetricsDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsDirectoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsDirectoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_directory_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/top-metrics/directories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsDirectoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsDirectoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsDirectoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsFileCollectionGet Retrieves a list of files with the most I/O activity.
*/
func (a *Client) TopMetricsFileCollectionGet(params *TopMetricsFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsFileCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsFileCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_file_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/top-metrics/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsFileCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsFileCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsFileCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsUserCollectionGet Retrieves a list of users with the most I/O activity.
*/
func (a *Client) TopMetricsUserCollectionGet(params *TopMetricsUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsUserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsUserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_user_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/top-metrics/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsUserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsUserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsUserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeCollectionGet Retrieves volumes.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `is_svm_root`
* `aggressive_readahead_mode`
* `analytics.by_accessed_time.bytes_used`
* `analytics.by_modified_time.bytes_used`
* `analytics.bytes_used`
* `analytics.file_count`
* `analytics.histogram_by_time_labels`
* `analytics.incomplete_data`
* `analytics.report_time`
* `analytics.subdir_count`
* `analytics.supported`
* `analytics.unsupported_reason`
* `anti_ransomware.*`
* `application.*`
* `encryption.*`
* `queue_for_encryption`
* `convert_unicode`
* `clone.parent_snapshot.name`
* `clone.parent_snapshot.uuid`
* `clone.parent_svm.name`
* `clone.parent_svm.uuid`
* `clone.parent_volume.name`
* `clone.parent_volume.uuid`
* `clone.split_complete_percent`
* `clone.split_estimate`
* `clone.split_initiated`
* `efficiency.*`
* `error_state.*`
* `files.*`
* `max_dir_size`
* `nas.export_policy.id`
* `nas.gid`
* `nas.path`
* `nas.security_style`
* `nas.uid`
* `nas.unix_permissions`
* `nas.junction_parent.name`
* `nas.junction_parent.uuid`
* `snaplock.*`
* `restore_to.*`
* `quota.*`
* `qos.*`
* `flexcache_endpoint_type`
* `space.block_storage_inactive_user_data`
* `space.capacity_tier_footprint`
* `space.performance_tier_footprint`
* `space.local_tier_footprint`
* `space.footprint`
* `space.over_provisioned`
* `space.metadata`
* `space.total_footprint`
* `space.dedupe_metafiles_footprint`
* `space.dedupe_metafiles_temporary_footprint`
* `space.delayed_free_footprint`
* `space.file_operation_metadata`
* `space.snapmirror_destination_footprint`
* `space.volume_guarantee_footprint`
* `space.cross_volume_dedupe_metafiles_footprint`
* `space.cross_volume_dedupe_metafiles_temporary_footprint`
* `space.snapshot_reserve_unusable`
* `space.snapshot_spill`
* `space.user_data`
* `space.logical_space.*`
* `space.snapshot.*`
* `space.used_by_afs`
* `space.afs_total`
* `space.available_percent`
* `space.full_threshold_percent`
* `space.nearly_full_threshold_percent`
* `space.overwrite_reserve`
* `space.overwrite_reserve_used`
* `space.size_available_for_snapshots`
* `space.percent_used`
* `space.fractional_reserve`
* `space.block_storage_inactive_user_data_percent`
* `space.physical_used`
* `space.physical_used_percent`
* `space.expected_available`
* `space.filesystem_size`
* `space.filesystem_size_fixed`
* `guarantee.*`
* `autosize.*`
<personalities supports=unified>
* `movement.*`
</personalities>
* `statistics.*`
* `constituents.name`
* `constituents.node.name`
* `constituents.node.uuid`
* `constituents.space.size`
* `constituents.space.available`
* `constituents.space.used`
* `constituents.space.available_percent`
* `constituents.space.used_percent`
* `constituents.space.block_storage_inactive_user_data`
* `constituents.space.capacity_tier_footprint`
* `constituents.space.performance_tier_footprint`
* `constituents.space.local_tier_footprint`
* `constituents.space.footprint`
* `constituents.space.over_provisioned`
* `constituents.space.metadata`
* `constituents.space.total_footprint`
* `constituents.space.logical_space.reporting`
* `constituents.space.logical_space.enforcement`
* `constituents.space.logical_space.used_by_afs`
* `constituents.space.logical_space.available`
* `constituents.space.snapshot.used`
* `constituents.space.snapshot.reserve_percent`
* `constituents.space.snapshot.autodelete_enabled`
* `constituents.space.large_size_enabled`
* `constituents.space.max_size`
* `constituents.space.total_metadata`
* `constituents.space.total_metadata_footprint`
* `constituents.aggregates.name`
* `constituents.aggregates.uuid`
<personalities supports=unified>
* `constituents.movement.destination_aggregate.name`
* `constituents.movement.destination_aggregate.uuid`
* `constituents.movement.state`
* `constituents.movement.percent_complete`
* `constituents.movement.cutover_window`
* `constituents.movement.tiering_policy`
</personalities>
* `asynchronous_directory_delete.*`
* `rebalancing.*`
* `metric.*`
* `cloud_write_enabled`
### Related ONTAP commands
* `volume show`
* `volume clone show`
* `volume efficiency show`
* `volume encryption show`
* `volume flexcache show`
* `volume flexgroup show`
<personalities supports=unified,aiml>
* `volume move show`
</personalities>
* `volume quota show`
* `volume show-space`
* `volume snaplock show`
* `volume rebalance show`
* `security anti-ransomware volume show`
* `security anti-ransomware volume space show`
* `volume file async-delete client show`
*/
func (a *Client) VolumeCollectionGet(params *VolumeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeCreate Creates a volume on a specified SVM and storage aggregates.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the volume.
* `name` - Name of the volume.
* `aggregates.name` or `aggregates.uuid` - Existing aggregates in which to create the volume.
### Default property values
* `state` -  _online_
* `size` - _20MB_
* `style` - _flexvol_
* `type` - _rw_
* `encryption.enabled` - _false_
* `snapshot_policy.name` - _default_
* `guarantee.type` - _volume_
* `anti_ransomware.state` - _default_
### Related ONTAP commands
* `volume create`
* `volume clone create`
*/
func (a *Client) VolumeCreate(params *VolumeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeCreateCreated, *VolumeCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_create",
		Method:             "POST",
		PathPattern:        "/storage/volumes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *VolumeCreateCreated:
		return value, nil, nil
	case *VolumeCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeDelete Deletes a volume. If the UUID belongs to a volume, all of its blocks are freed and returned to its containing aggregate. If a volume is online, it is offlined before deletion. If a volume is mounted, unmount the volume by specifying the nas.path as empty before deleting it using the DELETE operation.

### Optional parameters:
* `force` - Bypasses the recovery-queue and completely removes the volume from the aggregate making it non-recoverable. By default, this flag is set to "false".
### Related ONTAP commands
* `volume delete`
* `volume clone delete`
*/
func (a *Client) VolumeDelete(params *VolumeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeDeleteOK, *VolumeDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/volumes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *VolumeDeleteOK:
		return value, nil, nil
	case *VolumeDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VolumeDeleteCollection volume delete collection API
*/
func (a *Client) VolumeDeleteCollection(params *VolumeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeDeleteCollectionOK, *VolumeDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/volumes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *VolumeDeleteCollectionOK:
		return value, nil, nil
	case *VolumeDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeEfficiencyPolicyCollectionGet Retrieves a collection of volume efficiency policies.

### Related ONTAP commands
* `volume efficiency policy show`
### Learn more
* [`DOC /storage/volume-efficiency-policies`](#docs-storage-storage_volume-efficiency-policies)
*/
func (a *Client) VolumeEfficiencyPolicyCollectionGet(params *VolumeEfficiencyPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volume-efficiency-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeEfficiencyPolicyCreate Creates a volume efficiency policy.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the volume efficiency policy.
* `name` - Name for the volume efficiency policy.
### Recommended optional properties
* `type` - Type of volume policy.
* `schedule` - Schedule the volume efficiency defined in minutes, hourly, daily and weekly.
* `duration` - Indicates the allowed duration for a session for policy type "scheduled".
* `start_threshold_percent` - Indicates the start threshold percentage for the policy type "threshold". It is mutually exclusive of the schedule.
* `qos_policy` - QoS policy for the sis operation.
* `comment` - A comment associated with the volume efficiency policy.
* `enabled` - Is the volume efficiency policy enabled?
### Default property values
If not specified in POST, the following default property values are assigned:
* `type` - scheduled
* `start_threshold_percent` - 20
* `enabled` - true
* `qos_policy` - best_effort
* `schedule` - daily
### Related ONTAP commands
* `volume efficiency policy create`
### Learn more
* [`DOC /storage/volume-efficiency-policies`](#docs-storage-storage_volume-efficiency-policies)
*/
func (a *Client) VolumeEfficiencyPolicyCreate(params *VolumeEfficiencyPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_create",
		Method:             "POST",
		PathPattern:        "/storage/volume-efficiency-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeEfficiencyPolicyDelete Deletes a volume efficiency policy.

### Related ONTAP commands
* `volume efficiency policy delete`
### Learn more
* [`DOC /storage/volume-efficiency-policies`](#docs-storage-storage_volume-efficiency-policies)
*/
func (a *Client) VolumeEfficiencyPolicyDelete(params *VolumeEfficiencyPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/volume-efficiency-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VolumeEfficiencyPolicyDeleteCollection volume efficiency policy delete collection API
*/
func (a *Client) VolumeEfficiencyPolicyDeleteCollection(params *VolumeEfficiencyPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/volume-efficiency-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeEfficiencyPolicyGet Retrieves the details of the specified volume efficiency policy.

### Related ONTAP commands
* `volume efficiency policy show`
### Learn more
* [`DOC /storage/volume-efficiency-policies`](#docs-storage-storage_volume-efficiency-policies)
*/
func (a *Client) VolumeEfficiencyPolicyGet(params *VolumeEfficiencyPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_get",
		Method:             "GET",
		PathPattern:        "/storage/volume-efficiency-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeEfficiencyPolicyModify Updates a volume efficiency policy.

### Related ONTAP commands
* `volume efficiency policy modify`
### Learn more
* [`DOC /storage/volume-efficiency-policies`](#docs-storage-storage_volume-efficiency-policies)
*/
func (a *Client) VolumeEfficiencyPolicyModify(params *VolumeEfficiencyPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/volume-efficiency-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VolumeEfficiencyPolicyModifyCollection volume efficiency policy modify collection API
*/
func (a *Client) VolumeEfficiencyPolicyModifyCollection(params *VolumeEfficiencyPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeEfficiencyPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeEfficiencyPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_efficiency_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/volume-efficiency-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeEfficiencyPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeEfficiencyPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeEfficiencyPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeGet Retrieves a volume. The GET API can be used to retrieve the quota state for a FlexVol or a FlexGroup volume.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `is_svm_root`
* `analytics.*`
* `anti_ransomware.*`
* `application.*`
* `encryption.*`
* `convert_unicode`
* `clone.parent_snapshot.name`
* `clone.parent_snapshot.uuid`
* `clone.parent_svm.name`
* `clone.parent_svm.uuid`
* `clone.parent_volume.name`
* `clone.parent_volume.uuid`
* `clone.split_complete_percent`
* `clone.split_estimate`
* `clone.split_initiated`
* `efficiency.*`
* `error_state.*`
* `files.*`
* `max_dir_size`
* `nas.export_policy.id`
* `nas.gid`
* `nas.path`
* `nas.security_style`
* `nas.uid`
* `nas.unix_permissions`
* `nas.junction_parent.name`
* `nas.junction_parent.uuid`
* `snaplock.*`
* `restore_to.*`
* `quota.*`
* `qos.*`
* `flexcache_endpoint_type`
* `space.block_storage_inactive_user_data`
* `space.capacity_tier_footprint`
* `space.performance_tier_footprint`
* `space.local_tier_footprint`
* `space.footprint`
* `space.over_provisioned`
* `space.metadata`
* `space.total_footprint`
* `space.dedupe_metafiles_footprint`
* `space.dedupe_metafiles_temporary_footprint`
* `space.delayed_free_footprint`
* `space.file_operation_metadata`
* `space.snapmirror_destination_footprint`
* `space.volume_guarantee_footprint`
* `space.cross_volume_dedupe_metafiles_footprint`
* `space.cross_volume_dedupe_metafiles_temporary_footprint`
* `space.auto_adaptive_compression_footprint_data_reduction`
* `space.capacity_tier_footprint_data_reduction`
* `space.compaction_footprint_data_reduction`
* `space.effective_total_footprint`
* `space.snapshot_reserve_unusable`
* `space.snapshot_spill`
* `space.user_data`
* `space.logical_space.*`
* `space.snapshot.*`
* `space.used_by_afs`
* `space.afs_total`
* `space.available_percent`
* `space.full_threshold_percent`
* `space.nearly_full_threshold_percent`
* `space.overwrite_reserve`
* `space.overwrite_reserve_used`
* `space.size_available_for_snapshots`
* `space.percent_used`
* `space.fractional_reserve`
* `space.block_storage_inactive_user_data_percent`
* `space.physical_used`
* `space.physical_used_percent`
* `space.expected_available`
* `space.filesystem_size`
* `space.filesystem_size_fixed`
* `guarantee.*`
* `autosize.*`
<personalities supports=unified>
* `movement.*`
</personalities>
* `statistics.*`
* `asynchronous_directory_delete.*`
* `rebalancing.*`
* `metric.*`
* `cloud_write_enabled`
### Related ONTAP commands
* `volume show`
* `volume clone show`
* `volume efficiency show`
* `volume encryption show`
* `volume flexcache show`
* `volume flexgroup show`
<personalities supports=unified,aiml>
* `volume move show`
</personalities>
* `volume quota show`
* `volume show-space`
* `volume snaplock show`
* `volume rebalance show`
* `security anti-ransomware volume show`
* `security anti-ransomware volume attack generate-report`
* `security anti-ransomware volume space show`
* `volume file async-delete client show`
*/
func (a *Client) VolumeGet(params *VolumeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VolumeMetricsCollectionGet Retrieves historical performance metrics for a volume.
*/
func (a *Client) VolumeMetricsCollectionGet(params *VolumeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/volumes/{volume.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VolumeMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VolumeModify Updates the attributes of a volume. <personalities supports=unified>For movement, use the "validate_only" field on the request to validate but not perform the operation. </personalities>The PATCH API can be used to enable or disable quotas for a FlexVol or a FlexGroup volume. The PATCH API can also be used to start or stop non-disruptive volume capacity rebalancing for FlexGroup volumes in addition to modifying capacity rebalancing properties. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline removes its junction path.

<br>A PATCH request for volume encryption performs conversion/rekey operations asynchronously. You can retrieve the conversion/rekey progress details by calling a GET request on the corresponding volume endpoint.
<personalities supports=asar2>
PATCH is not supported for the following immutable properties:
* `autosize.maximum`
* `autosize.minimum`
* `autosize.grow_threshold`
* `autosize.shrink_threshold`
* `autosize.mode`
* `size`
* `space.size`
* `space.large_size_enabled`
* `space.max_size`
* `qos.policy.min-throughput-iops`
* `qos.policy.max-throughput-iops`
* `qos.policy.max-throughput-mbps`
* `qos.policy.min-throughput-mbps`
* `qos.policy.uuid`
* `qos.policy.name`
* `tiering.policy`
* `tiering.min_cooling_days`
* `tiering.object_tags`
* `tiering.storage_class`
* `anti_ransomware`
* `nas.uid`
* `nas.gid`
* `nas.unix_permissions`
* `state`
* `space.snapshot.autodelete_enabled`
* `snapshot_policy.name`
* `snapshot_policy.uuid`
* `guarantee.type`
* `clone.split_initiated`
* `clone.match_parent_storage_tier`
* `efficiency.application_io_size`
* `efficiency.compression_type`
* `efficiency.compression`
* `efficiency.storage_efficiency_mode`
* `efficiency.dedupe`
* `efficiency.cross_volume_dedupe`
* `efficiency.compaction`
* `efficiency.policy.name`
* `efficiency.enable_all`
* `efficiency.disable_all`
* `efficiency.state`
* `efficiency.scanner.state`
* `efficiency.scanner.scan_old_data`
* `efficiency.scanner.compression`
* `efficiency.scanner.dedupe`
* `efficiency.idcs_scanner.operation_state`
* `efficiency.idcs_scanner.inactive_days`
* `efficiency.idcs_scanner.mode`
* `encryption.enabled`
* `encryption.rekey`
* `encryption.action`
* `queue_for_encryption`
* `movement.destination_aggregate`
* `movement.state`
* `movement.percent_complete`
* `movement.cutover_window`
* `movement.tiering_policy`
* `movement.capacity_tier_optimized`
* `movement.copy_free`
</personalities>
### Optional properties
* `queue_for_encryption` - Queue volumes for encryption when `encryption.enabled=true`.  If this option is not provided or is false, conversion of volumes starts immediately. When there are volumes in the queue and less than four encryptions are running, volumes are encrypted in the order in which they are queued.
* `encryption.action` - You can pause an ongoing rekey/conversion operation or resume a paused rekey/conversion operation using this field.  The following actions are supported for this field: &dash; conversion_pause - Pause an encryption conversion operation currently in progress &dash; conversion_resume - Resume a paused encryption conversion operation &dash; rekey_pause - Pause an encryption rekey operation currently in progress &dash; rekey_resume - Resume a paused encryption rekey operation
### Related ONTAP commands
* `volume unmount`
* `volume mount`
* `volume online`
* `volume offline`
* `volume modify`
* `volume clone modify`
* `volume efficiency modify`
* `volume quota on`
* `volume quota off`
* `volume snaplock modify`
* `volume encryption conversion start`
* `volume encryption conversion pause`
* `volume encryption conversion resume`
* `volume encryption rekey start`
* `volume encryption rekey pause`
* `volume encryption rekey resume`
* `volume rebalance start`
* `volume rebalance stop`
* `volume rebalance modify`
* `security anti-ransomware volume enable`
* `security anti-ransomware volume disable`
* `security anti-ransomware volume dry-run`
* `security anti-ransomware volume pause`
* `security anti-ransomware volume resume`
* `volume file async-delete client disable`
* `volume file async-delete client enable`
* `volume move`
*/
func (a *Client) VolumeModify(params *VolumeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeModifyOK, *VolumeModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/volumes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *VolumeModifyOK:
		return value, nil, nil
	case *VolumeModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VolumeModifyCollection volume modify collection API
*/
func (a *Client) VolumeModifyCollection(params *VolumeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VolumeModifyCollectionOK, *VolumeModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVolumeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "volume_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/volumes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VolumeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *VolumeModifyCollectionOK:
		return value, nil, nil
	case *VolumeModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VolumeModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
