// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewStoragePoolCreateParams creates a new StoragePoolCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStoragePoolCreateParams() *StoragePoolCreateParams {
	return &StoragePoolCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStoragePoolCreateParamsWithTimeout creates a new StoragePoolCreateParams object
// with the ability to set a timeout on a request.
func NewStoragePoolCreateParamsWithTimeout(timeout time.Duration) *StoragePoolCreateParams {
	return &StoragePoolCreateParams{
		timeout: timeout,
	}
}

// NewStoragePoolCreateParamsWithContext creates a new StoragePoolCreateParams object
// with the ability to set a context for a request.
func NewStoragePoolCreateParamsWithContext(ctx context.Context) *StoragePoolCreateParams {
	return &StoragePoolCreateParams{
		Context: ctx,
	}
}

// NewStoragePoolCreateParamsWithHTTPClient creates a new StoragePoolCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewStoragePoolCreateParamsWithHTTPClient(client *http.Client) *StoragePoolCreateParams {
	return &StoragePoolCreateParams{
		HTTPClient: client,
	}
}

/*
StoragePoolCreateParams contains all the parameters to send to the API endpoint

	for the storage pool create operation.

	Typically these are written to a http.Request.
*/
type StoragePoolCreateParams struct {

	/* DiskSize.

	   If set, POST only selects SSDs within five percent of the specified size.
	*/
	DiskSize *int64

	/* Info.

	   Info specification
	*/
	Info *models.StoragePool

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* Simulate.

	   When set to "true", the end point returns a simulated layout of the proposed new storage pool, without changing system state.
	*/
	Simulate *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage pool create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePoolCreateParams) WithDefaults() *StoragePoolCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage pool create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePoolCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := StoragePoolCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage pool create params
func (o *StoragePoolCreateParams) WithTimeout(timeout time.Duration) *StoragePoolCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage pool create params
func (o *StoragePoolCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage pool create params
func (o *StoragePoolCreateParams) WithContext(ctx context.Context) *StoragePoolCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage pool create params
func (o *StoragePoolCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage pool create params
func (o *StoragePoolCreateParams) WithHTTPClient(client *http.Client) *StoragePoolCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage pool create params
func (o *StoragePoolCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDiskSize adds the diskSize to the storage pool create params
func (o *StoragePoolCreateParams) WithDiskSize(diskSize *int64) *StoragePoolCreateParams {
	o.SetDiskSize(diskSize)
	return o
}

// SetDiskSize adds the diskSize to the storage pool create params
func (o *StoragePoolCreateParams) SetDiskSize(diskSize *int64) {
	o.DiskSize = diskSize
}

// WithInfo adds the info to the storage pool create params
func (o *StoragePoolCreateParams) WithInfo(info *models.StoragePool) *StoragePoolCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage pool create params
func (o *StoragePoolCreateParams) SetInfo(info *models.StoragePool) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the storage pool create params
func (o *StoragePoolCreateParams) WithReturnRecords(returnRecords *bool) *StoragePoolCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage pool create params
func (o *StoragePoolCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage pool create params
func (o *StoragePoolCreateParams) WithReturnTimeout(returnTimeout *int64) *StoragePoolCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage pool create params
func (o *StoragePoolCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSimulate adds the simulate to the storage pool create params
func (o *StoragePoolCreateParams) WithSimulate(simulate *bool) *StoragePoolCreateParams {
	o.SetSimulate(simulate)
	return o
}

// SetSimulate adds the simulate to the storage pool create params
func (o *StoragePoolCreateParams) SetSimulate(simulate *bool) {
	o.Simulate = simulate
}

// WriteToRequest writes these params to a swagger request
func (o *StoragePoolCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DiskSize != nil {

		// query param disk_size
		var qrDiskSize int64

		if o.DiskSize != nil {
			qrDiskSize = *o.DiskSize
		}
		qDiskSize := swag.FormatInt64(qrDiskSize)
		if qDiskSize != "" {

			if err := r.SetQueryParam("disk_size", qDiskSize); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Simulate != nil {

		// query param simulate
		var qrSimulate bool

		if o.Simulate != nil {
			qrSimulate = *o.Simulate
		}
		qSimulate := swag.FormatBool(qrSimulate)
		if qSimulate != "" {

			if err := r.SetQueryParam("simulate", qSimulate); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
