// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StoragePoolCreateReader is a Reader for the StoragePoolCreate structure.
type StoragePoolCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StoragePoolCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewStoragePoolCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStoragePoolCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStoragePoolCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStoragePoolCreateCreated creates a StoragePoolCreateCreated with default headers values
func NewStoragePoolCreateCreated() *StoragePoolCreateCreated {
	return &StoragePoolCreateCreated{}
}

/*
StoragePoolCreateCreated describes a response with status code 201, with default header values.

Created
*/
type StoragePoolCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StoragePoolResponse
}

// IsSuccess returns true when this storage pool create created response has a 2xx status code
func (o *StoragePoolCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool create created response has a 3xx status code
func (o *StoragePoolCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool create created response has a 4xx status code
func (o *StoragePoolCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool create created response has a 5xx status code
func (o *StoragePoolCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool create created response a status code equal to that given
func (o *StoragePoolCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the storage pool create created response
func (o *StoragePoolCreateCreated) Code() int {
	return 201
}

func (o *StoragePoolCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storagePoolCreateCreated %s", 201, payload)
}

func (o *StoragePoolCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storagePoolCreateCreated %s", 201, payload)
}

func (o *StoragePoolCreateCreated) GetPayload() *models.StoragePoolResponse {
	return o.Payload
}

func (o *StoragePoolCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StoragePoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolCreateAccepted creates a StoragePoolCreateAccepted with default headers values
func NewStoragePoolCreateAccepted() *StoragePoolCreateAccepted {
	return &StoragePoolCreateAccepted{}
}

/*
StoragePoolCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StoragePoolCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StoragePoolJobLinkResponse
}

// IsSuccess returns true when this storage pool create accepted response has a 2xx status code
func (o *StoragePoolCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool create accepted response has a 3xx status code
func (o *StoragePoolCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool create accepted response has a 4xx status code
func (o *StoragePoolCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool create accepted response has a 5xx status code
func (o *StoragePoolCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool create accepted response a status code equal to that given
func (o *StoragePoolCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage pool create accepted response
func (o *StoragePoolCreateAccepted) Code() int {
	return 202
}

func (o *StoragePoolCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storagePoolCreateAccepted %s", 202, payload)
}

func (o *StoragePoolCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storagePoolCreateAccepted %s", 202, payload)
}

func (o *StoragePoolCreateAccepted) GetPayload() *models.StoragePoolJobLinkResponse {
	return o.Payload
}

func (o *StoragePoolCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StoragePoolJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolCreateDefault creates a StoragePoolCreateDefault with default headers values
func NewStoragePoolCreateDefault(code int) *StoragePoolCreateDefault {
	return &StoragePoolCreateDefault{
		_statusCode: code,
	}
}

/*
	StoragePoolCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 11206666 | Storage pool is unhealthy. |
| 11208658 | A storage pool already uses the specified name. |
| 11208660 | Disk does not exist. |
| 11208661 | Disk is not a spare disk. |
| 11208662 | Disk is not an SSD. |
| 11208663 | Disk is reserved for core dump. |
| 11208664 | Could not determine checksum type of disk. |
| 11208666 | Could not determine usable size of disk. |
| 11208668 | Could not determine connectivity between controller and disk. |
| 11208670 | Could not determine original owner of disk. |
| 11208671 | Could not determine SyncMirror pool of disk. |
| 11208673 | Could not determine HA mode of node. |
| 11208674 | Could not determine HA partner of node. |
| 11208675 | Disks specified in the disk list are not visible to node. |
| 11208678 | The disk list contains disks from nodes which are not in HA pair. |
| 11208679 | Storage pools are not supported on nodes. |
| 11208680 | Internal error. Cannot determine configuration for node. |
| 11208681 | Node is not online. |
| 11208682 | Internal error. Sharing configuration mismatch. |
| 11208684 | Unable to share disk. |
| 11208686 | Disk cannot be shared. |
| 11208687 | Unable to retrieve expected sharing configuration. |
| 11208688 | Storage pool create job failed. |
| 11208690 | Not all nodes sharing the storage pool view disk as a shared disk. |
| 11208691 | Not enough matching spares available. |
| 11208692 | A disk list or count is a required parameter for storage pool creation. |
| 11208693 | Invalid number of disks specified. |
| 11208698 | Internal error. Missing node name. |
| 11208699 | Internal error. Missing partner name for node configured for HA. |
| 11208701 | Node is a standalone node. Do not specify other nodes with a standalone node. |
| 11208703 | Incorrect number of nodes specified. Specify one node or both nodes in an HA pair. |
| 11208704 | Specified nodes are not part of HA relationship. Specify one node or both nodes in an HA pair. |
| 11208705 | Disk is a data center SSD, which cannot be used in storage pools. |
| 11208706 | Disk is a SSD-ZNS, which cannot be used in storage pools. |
| 11215756 | Missing a required field for POST request. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StoragePoolCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage pool create default response has a 2xx status code
func (o *StoragePoolCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage pool create default response has a 3xx status code
func (o *StoragePoolCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage pool create default response has a 4xx status code
func (o *StoragePoolCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage pool create default response has a 5xx status code
func (o *StoragePoolCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage pool create default response a status code equal to that given
func (o *StoragePoolCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage pool create default response
func (o *StoragePoolCreateDefault) Code() int {
	return o._statusCode
}

func (o *StoragePoolCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storage_pool_create default %s", o._statusCode, payload)
}

func (o *StoragePoolCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/pools][%d] storage_pool_create default %s", o._statusCode, payload)
}

func (o *StoragePoolCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StoragePoolCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
