// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStoragePoolDeleteCollectionParams creates a new StoragePoolDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStoragePoolDeleteCollectionParams() *StoragePoolDeleteCollectionParams {
	return &StoragePoolDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStoragePoolDeleteCollectionParamsWithTimeout creates a new StoragePoolDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewStoragePoolDeleteCollectionParamsWithTimeout(timeout time.Duration) *StoragePoolDeleteCollectionParams {
	return &StoragePoolDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewStoragePoolDeleteCollectionParamsWithContext creates a new StoragePoolDeleteCollectionParams object
// with the ability to set a context for a request.
func NewStoragePoolDeleteCollectionParamsWithContext(ctx context.Context) *StoragePoolDeleteCollectionParams {
	return &StoragePoolDeleteCollectionParams{
		Context: ctx,
	}
}

// NewStoragePoolDeleteCollectionParamsWithHTTPClient creates a new StoragePoolDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewStoragePoolDeleteCollectionParamsWithHTTPClient(client *http.Client) *StoragePoolDeleteCollectionParams {
	return &StoragePoolDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
StoragePoolDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the storage pool delete collection operation.

	Typically these are written to a http.Request.
*/
type StoragePoolDeleteCollectionParams struct {

	/* CapacityDiskCount.

	   Filter by capacity.disk_count
	*/
	CapacityDiskCount *int64

	/* CapacityDisksDiskName.

	   Filter by capacity.disks.disk.name
	*/
	CapacityDisksDiskName *string

	/* CapacityDisksTotalSize.

	   Filter by capacity.disks.total_size
	*/
	CapacityDisksTotalSize *int64

	/* CapacityDisksUsableSize.

	   Filter by capacity.disks.usable_size
	*/
	CapacityDisksUsableSize *int64

	/* CapacityRemaining.

	   Filter by capacity.remaining
	*/
	CapacityRemaining *int64

	/* CapacitySpareAllocationUnitsAvailableSize.

	   Filter by capacity.spare_allocation_units.available_size
	*/
	CapacitySpareAllocationUnitsAvailableSize *int64

	/* CapacitySpareAllocationUnitsCount.

	   Filter by capacity.spare_allocation_units.count
	*/
	CapacitySpareAllocationUnitsCount *int64

	/* CapacitySpareAllocationUnitsNodeName.

	   Filter by capacity.spare_allocation_units.node.name
	*/
	CapacitySpareAllocationUnitsNodeName *string

	/* CapacitySpareAllocationUnitsNodeUUID.

	   Filter by capacity.spare_allocation_units.node.uuid
	*/
	CapacitySpareAllocationUnitsNodeUUID *string

	/* CapacitySpareAllocationUnitsSize.

	   Filter by capacity.spare_allocation_units.size
	*/
	CapacitySpareAllocationUnitsSize *int64

	/* CapacitySpareAllocationUnitsSyncmirrorPool.

	   Filter by capacity.spare_allocation_units.syncmirror_pool
	*/
	CapacitySpareAllocationUnitsSyncmirrorPool *string

	/* CapacityTotal.

	   Filter by capacity.total
	*/
	CapacityTotal *int64

	/* CapacityUsedAllocationUnitsAggregateName.

	   Filter by capacity.used_allocation_units.aggregate.name
	*/
	CapacityUsedAllocationUnitsAggregateName *string

	/* CapacityUsedAllocationUnitsAggregateUUID.

	   Filter by capacity.used_allocation_units.aggregate.uuid
	*/
	CapacityUsedAllocationUnitsAggregateUUID *string

	/* CapacityUsedAllocationUnitsCount.

	   Filter by capacity.used_allocation_units.count
	*/
	CapacityUsedAllocationUnitsCount *int64

	/* CapacityUsedAllocationUnitsCurrentUsage.

	   Filter by capacity.used_allocation_units.current_usage
	*/
	CapacityUsedAllocationUnitsCurrentUsage *int64

	/* CapacityUsedAllocationUnitsNodeName.

	   Filter by capacity.used_allocation_units.node.name
	*/
	CapacityUsedAllocationUnitsNodeName *string

	/* CapacityUsedAllocationUnitsNodeUUID.

	   Filter by capacity.used_allocation_units.node.uuid
	*/
	CapacityUsedAllocationUnitsNodeUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* HealthIsHealthy.

	   Filter by health.is_healthy
	*/
	HealthIsHealthy *bool

	/* HealthState.

	   Filter by health.state
	*/
	HealthState *string

	/* HealthUnhealthyReasonArgumentsCode.

	   Filter by health.unhealthy_reason.arguments.code
	*/
	HealthUnhealthyReasonArgumentsCode *string

	/* HealthUnhealthyReasonArgumentsMessage.

	   Filter by health.unhealthy_reason.arguments.message
	*/
	HealthUnhealthyReasonArgumentsMessage *string

	/* HealthUnhealthyReasonCode.

	   Filter by health.unhealthy_reason.code
	*/
	HealthUnhealthyReasonCode *string

	/* HealthUnhealthyReasonMessage.

	   Filter by health.unhealthy_reason.message
	*/
	HealthUnhealthyReasonMessage *string

	/* Info.

	   Info specification
	*/
	Info StoragePoolDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodesName.

	   Filter by nodes.name
	*/
	NodesName *string

	/* NodesUUID.

	   Filter by nodes.uuid
	*/
	NodesUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StorageType.

	   Filter by storage_type
	*/
	StorageType *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage pool delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePoolDeleteCollectionParams) WithDefaults() *StoragePoolDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage pool delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePoolDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := StoragePoolDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithTimeout(timeout time.Duration) *StoragePoolDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithContext(ctx context.Context) *StoragePoolDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHTTPClient(client *http.Client) *StoragePoolDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCapacityDiskCount adds the capacityDiskCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityDiskCount(capacityDiskCount *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityDiskCount(capacityDiskCount)
	return o
}

// SetCapacityDiskCount adds the capacityDiskCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityDiskCount(capacityDiskCount *int64) {
	o.CapacityDiskCount = capacityDiskCount
}

// WithCapacityDisksDiskName adds the capacityDisksDiskName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityDisksDiskName(capacityDisksDiskName *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacityDisksDiskName(capacityDisksDiskName)
	return o
}

// SetCapacityDisksDiskName adds the capacityDisksDiskName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityDisksDiskName(capacityDisksDiskName *string) {
	o.CapacityDisksDiskName = capacityDisksDiskName
}

// WithCapacityDisksTotalSize adds the capacityDisksTotalSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityDisksTotalSize(capacityDisksTotalSize *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityDisksTotalSize(capacityDisksTotalSize)
	return o
}

// SetCapacityDisksTotalSize adds the capacityDisksTotalSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityDisksTotalSize(capacityDisksTotalSize *int64) {
	o.CapacityDisksTotalSize = capacityDisksTotalSize
}

// WithCapacityDisksUsableSize adds the capacityDisksUsableSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityDisksUsableSize(capacityDisksUsableSize *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityDisksUsableSize(capacityDisksUsableSize)
	return o
}

// SetCapacityDisksUsableSize adds the capacityDisksUsableSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityDisksUsableSize(capacityDisksUsableSize *int64) {
	o.CapacityDisksUsableSize = capacityDisksUsableSize
}

// WithCapacityRemaining adds the capacityRemaining to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityRemaining(capacityRemaining *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityRemaining(capacityRemaining)
	return o
}

// SetCapacityRemaining adds the capacityRemaining to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityRemaining(capacityRemaining *int64) {
	o.CapacityRemaining = capacityRemaining
}

// WithCapacitySpareAllocationUnitsAvailableSize adds the capacitySpareAllocationUnitsAvailableSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsAvailableSize(capacitySpareAllocationUnitsAvailableSize *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsAvailableSize(capacitySpareAllocationUnitsAvailableSize)
	return o
}

// SetCapacitySpareAllocationUnitsAvailableSize adds the capacitySpareAllocationUnitsAvailableSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsAvailableSize(capacitySpareAllocationUnitsAvailableSize *int64) {
	o.CapacitySpareAllocationUnitsAvailableSize = capacitySpareAllocationUnitsAvailableSize
}

// WithCapacitySpareAllocationUnitsCount adds the capacitySpareAllocationUnitsCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsCount(capacitySpareAllocationUnitsCount *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsCount(capacitySpareAllocationUnitsCount)
	return o
}

// SetCapacitySpareAllocationUnitsCount adds the capacitySpareAllocationUnitsCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsCount(capacitySpareAllocationUnitsCount *int64) {
	o.CapacitySpareAllocationUnitsCount = capacitySpareAllocationUnitsCount
}

// WithCapacitySpareAllocationUnitsNodeName adds the capacitySpareAllocationUnitsNodeName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsNodeName(capacitySpareAllocationUnitsNodeName *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsNodeName(capacitySpareAllocationUnitsNodeName)
	return o
}

// SetCapacitySpareAllocationUnitsNodeName adds the capacitySpareAllocationUnitsNodeName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsNodeName(capacitySpareAllocationUnitsNodeName *string) {
	o.CapacitySpareAllocationUnitsNodeName = capacitySpareAllocationUnitsNodeName
}

// WithCapacitySpareAllocationUnitsNodeUUID adds the capacitySpareAllocationUnitsNodeUUID to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsNodeUUID(capacitySpareAllocationUnitsNodeUUID *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsNodeUUID(capacitySpareAllocationUnitsNodeUUID)
	return o
}

// SetCapacitySpareAllocationUnitsNodeUUID adds the capacitySpareAllocationUnitsNodeUuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsNodeUUID(capacitySpareAllocationUnitsNodeUUID *string) {
	o.CapacitySpareAllocationUnitsNodeUUID = capacitySpareAllocationUnitsNodeUUID
}

// WithCapacitySpareAllocationUnitsSize adds the capacitySpareAllocationUnitsSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsSize(capacitySpareAllocationUnitsSize *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsSize(capacitySpareAllocationUnitsSize)
	return o
}

// SetCapacitySpareAllocationUnitsSize adds the capacitySpareAllocationUnitsSize to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsSize(capacitySpareAllocationUnitsSize *int64) {
	o.CapacitySpareAllocationUnitsSize = capacitySpareAllocationUnitsSize
}

// WithCapacitySpareAllocationUnitsSyncmirrorPool adds the capacitySpareAllocationUnitsSyncmirrorPool to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacitySpareAllocationUnitsSyncmirrorPool(capacitySpareAllocationUnitsSyncmirrorPool *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacitySpareAllocationUnitsSyncmirrorPool(capacitySpareAllocationUnitsSyncmirrorPool)
	return o
}

// SetCapacitySpareAllocationUnitsSyncmirrorPool adds the capacitySpareAllocationUnitsSyncmirrorPool to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacitySpareAllocationUnitsSyncmirrorPool(capacitySpareAllocationUnitsSyncmirrorPool *string) {
	o.CapacitySpareAllocationUnitsSyncmirrorPool = capacitySpareAllocationUnitsSyncmirrorPool
}

// WithCapacityTotal adds the capacityTotal to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityTotal(capacityTotal *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityTotal(capacityTotal)
	return o
}

// SetCapacityTotal adds the capacityTotal to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityTotal(capacityTotal *int64) {
	o.CapacityTotal = capacityTotal
}

// WithCapacityUsedAllocationUnitsAggregateName adds the capacityUsedAllocationUnitsAggregateName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsAggregateName(capacityUsedAllocationUnitsAggregateName *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsAggregateName(capacityUsedAllocationUnitsAggregateName)
	return o
}

// SetCapacityUsedAllocationUnitsAggregateName adds the capacityUsedAllocationUnitsAggregateName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsAggregateName(capacityUsedAllocationUnitsAggregateName *string) {
	o.CapacityUsedAllocationUnitsAggregateName = capacityUsedAllocationUnitsAggregateName
}

// WithCapacityUsedAllocationUnitsAggregateUUID adds the capacityUsedAllocationUnitsAggregateUUID to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsAggregateUUID(capacityUsedAllocationUnitsAggregateUUID *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsAggregateUUID(capacityUsedAllocationUnitsAggregateUUID)
	return o
}

// SetCapacityUsedAllocationUnitsAggregateUUID adds the capacityUsedAllocationUnitsAggregateUuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsAggregateUUID(capacityUsedAllocationUnitsAggregateUUID *string) {
	o.CapacityUsedAllocationUnitsAggregateUUID = capacityUsedAllocationUnitsAggregateUUID
}

// WithCapacityUsedAllocationUnitsCount adds the capacityUsedAllocationUnitsCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsCount(capacityUsedAllocationUnitsCount *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsCount(capacityUsedAllocationUnitsCount)
	return o
}

// SetCapacityUsedAllocationUnitsCount adds the capacityUsedAllocationUnitsCount to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsCount(capacityUsedAllocationUnitsCount *int64) {
	o.CapacityUsedAllocationUnitsCount = capacityUsedAllocationUnitsCount
}

// WithCapacityUsedAllocationUnitsCurrentUsage adds the capacityUsedAllocationUnitsCurrentUsage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsCurrentUsage(capacityUsedAllocationUnitsCurrentUsage *int64) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsCurrentUsage(capacityUsedAllocationUnitsCurrentUsage)
	return o
}

// SetCapacityUsedAllocationUnitsCurrentUsage adds the capacityUsedAllocationUnitsCurrentUsage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsCurrentUsage(capacityUsedAllocationUnitsCurrentUsage *int64) {
	o.CapacityUsedAllocationUnitsCurrentUsage = capacityUsedAllocationUnitsCurrentUsage
}

// WithCapacityUsedAllocationUnitsNodeName adds the capacityUsedAllocationUnitsNodeName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsNodeName(capacityUsedAllocationUnitsNodeName *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsNodeName(capacityUsedAllocationUnitsNodeName)
	return o
}

// SetCapacityUsedAllocationUnitsNodeName adds the capacityUsedAllocationUnitsNodeName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsNodeName(capacityUsedAllocationUnitsNodeName *string) {
	o.CapacityUsedAllocationUnitsNodeName = capacityUsedAllocationUnitsNodeName
}

// WithCapacityUsedAllocationUnitsNodeUUID adds the capacityUsedAllocationUnitsNodeUUID to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithCapacityUsedAllocationUnitsNodeUUID(capacityUsedAllocationUnitsNodeUUID *string) *StoragePoolDeleteCollectionParams {
	o.SetCapacityUsedAllocationUnitsNodeUUID(capacityUsedAllocationUnitsNodeUUID)
	return o
}

// SetCapacityUsedAllocationUnitsNodeUUID adds the capacityUsedAllocationUnitsNodeUuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetCapacityUsedAllocationUnitsNodeUUID(capacityUsedAllocationUnitsNodeUUID *string) {
	o.CapacityUsedAllocationUnitsNodeUUID = capacityUsedAllocationUnitsNodeUUID
}

// WithContinueOnFailure adds the continueOnFailure to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *StoragePoolDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithHealthIsHealthy adds the healthIsHealthy to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthIsHealthy(healthIsHealthy *bool) *StoragePoolDeleteCollectionParams {
	o.SetHealthIsHealthy(healthIsHealthy)
	return o
}

// SetHealthIsHealthy adds the healthIsHealthy to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthIsHealthy(healthIsHealthy *bool) {
	o.HealthIsHealthy = healthIsHealthy
}

// WithHealthState adds the healthState to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthState(healthState *string) *StoragePoolDeleteCollectionParams {
	o.SetHealthState(healthState)
	return o
}

// SetHealthState adds the healthState to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthState(healthState *string) {
	o.HealthState = healthState
}

// WithHealthUnhealthyReasonArgumentsCode adds the healthUnhealthyReasonArgumentsCode to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthUnhealthyReasonArgumentsCode(healthUnhealthyReasonArgumentsCode *string) *StoragePoolDeleteCollectionParams {
	o.SetHealthUnhealthyReasonArgumentsCode(healthUnhealthyReasonArgumentsCode)
	return o
}

// SetHealthUnhealthyReasonArgumentsCode adds the healthUnhealthyReasonArgumentsCode to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthUnhealthyReasonArgumentsCode(healthUnhealthyReasonArgumentsCode *string) {
	o.HealthUnhealthyReasonArgumentsCode = healthUnhealthyReasonArgumentsCode
}

// WithHealthUnhealthyReasonArgumentsMessage adds the healthUnhealthyReasonArgumentsMessage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthUnhealthyReasonArgumentsMessage(healthUnhealthyReasonArgumentsMessage *string) *StoragePoolDeleteCollectionParams {
	o.SetHealthUnhealthyReasonArgumentsMessage(healthUnhealthyReasonArgumentsMessage)
	return o
}

// SetHealthUnhealthyReasonArgumentsMessage adds the healthUnhealthyReasonArgumentsMessage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthUnhealthyReasonArgumentsMessage(healthUnhealthyReasonArgumentsMessage *string) {
	o.HealthUnhealthyReasonArgumentsMessage = healthUnhealthyReasonArgumentsMessage
}

// WithHealthUnhealthyReasonCode adds the healthUnhealthyReasonCode to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthUnhealthyReasonCode(healthUnhealthyReasonCode *string) *StoragePoolDeleteCollectionParams {
	o.SetHealthUnhealthyReasonCode(healthUnhealthyReasonCode)
	return o
}

// SetHealthUnhealthyReasonCode adds the healthUnhealthyReasonCode to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthUnhealthyReasonCode(healthUnhealthyReasonCode *string) {
	o.HealthUnhealthyReasonCode = healthUnhealthyReasonCode
}

// WithHealthUnhealthyReasonMessage adds the healthUnhealthyReasonMessage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithHealthUnhealthyReasonMessage(healthUnhealthyReasonMessage *string) *StoragePoolDeleteCollectionParams {
	o.SetHealthUnhealthyReasonMessage(healthUnhealthyReasonMessage)
	return o
}

// SetHealthUnhealthyReasonMessage adds the healthUnhealthyReasonMessage to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetHealthUnhealthyReasonMessage(healthUnhealthyReasonMessage *string) {
	o.HealthUnhealthyReasonMessage = healthUnhealthyReasonMessage
}

// WithInfo adds the info to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithInfo(info StoragePoolDeleteCollectionBody) *StoragePoolDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetInfo(info StoragePoolDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithName(name *string) *StoragePoolDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodesName adds the nodesName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithNodesName(nodesName *string) *StoragePoolDeleteCollectionParams {
	o.SetNodesName(nodesName)
	return o
}

// SetNodesName adds the nodesName to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetNodesName(nodesName *string) {
	o.NodesName = nodesName
}

// WithNodesUUID adds the nodesUUID to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithNodesUUID(nodesUUID *string) *StoragePoolDeleteCollectionParams {
	o.SetNodesUUID(nodesUUID)
	return o
}

// SetNodesUUID adds the nodesUuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetNodesUUID(nodesUUID *string) {
	o.NodesUUID = nodesUUID
}

// WithReturnRecords adds the returnRecords to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *StoragePoolDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *StoragePoolDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *StoragePoolDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStorageType adds the storageType to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithStorageType(storageType *string) *StoragePoolDeleteCollectionParams {
	o.SetStorageType(storageType)
	return o
}

// SetStorageType adds the storageType to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetStorageType(storageType *string) {
	o.StorageType = storageType
}

// WithUUID adds the uuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) WithUUID(uuid *string) *StoragePoolDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the storage pool delete collection params
func (o *StoragePoolDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *StoragePoolDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CapacityDiskCount != nil {

		// query param capacity.disk_count
		var qrCapacityDiskCount int64

		if o.CapacityDiskCount != nil {
			qrCapacityDiskCount = *o.CapacityDiskCount
		}
		qCapacityDiskCount := swag.FormatInt64(qrCapacityDiskCount)
		if qCapacityDiskCount != "" {

			if err := r.SetQueryParam("capacity.disk_count", qCapacityDiskCount); err != nil {
				return err
			}
		}
	}

	if o.CapacityDisksDiskName != nil {

		// query param capacity.disks.disk.name
		var qrCapacityDisksDiskName string

		if o.CapacityDisksDiskName != nil {
			qrCapacityDisksDiskName = *o.CapacityDisksDiskName
		}
		qCapacityDisksDiskName := qrCapacityDisksDiskName
		if qCapacityDisksDiskName != "" {

			if err := r.SetQueryParam("capacity.disks.disk.name", qCapacityDisksDiskName); err != nil {
				return err
			}
		}
	}

	if o.CapacityDisksTotalSize != nil {

		// query param capacity.disks.total_size
		var qrCapacityDisksTotalSize int64

		if o.CapacityDisksTotalSize != nil {
			qrCapacityDisksTotalSize = *o.CapacityDisksTotalSize
		}
		qCapacityDisksTotalSize := swag.FormatInt64(qrCapacityDisksTotalSize)
		if qCapacityDisksTotalSize != "" {

			if err := r.SetQueryParam("capacity.disks.total_size", qCapacityDisksTotalSize); err != nil {
				return err
			}
		}
	}

	if o.CapacityDisksUsableSize != nil {

		// query param capacity.disks.usable_size
		var qrCapacityDisksUsableSize int64

		if o.CapacityDisksUsableSize != nil {
			qrCapacityDisksUsableSize = *o.CapacityDisksUsableSize
		}
		qCapacityDisksUsableSize := swag.FormatInt64(qrCapacityDisksUsableSize)
		if qCapacityDisksUsableSize != "" {

			if err := r.SetQueryParam("capacity.disks.usable_size", qCapacityDisksUsableSize); err != nil {
				return err
			}
		}
	}

	if o.CapacityRemaining != nil {

		// query param capacity.remaining
		var qrCapacityRemaining int64

		if o.CapacityRemaining != nil {
			qrCapacityRemaining = *o.CapacityRemaining
		}
		qCapacityRemaining := swag.FormatInt64(qrCapacityRemaining)
		if qCapacityRemaining != "" {

			if err := r.SetQueryParam("capacity.remaining", qCapacityRemaining); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsAvailableSize != nil {

		// query param capacity.spare_allocation_units.available_size
		var qrCapacitySpareAllocationUnitsAvailableSize int64

		if o.CapacitySpareAllocationUnitsAvailableSize != nil {
			qrCapacitySpareAllocationUnitsAvailableSize = *o.CapacitySpareAllocationUnitsAvailableSize
		}
		qCapacitySpareAllocationUnitsAvailableSize := swag.FormatInt64(qrCapacitySpareAllocationUnitsAvailableSize)
		if qCapacitySpareAllocationUnitsAvailableSize != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.available_size", qCapacitySpareAllocationUnitsAvailableSize); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsCount != nil {

		// query param capacity.spare_allocation_units.count
		var qrCapacitySpareAllocationUnitsCount int64

		if o.CapacitySpareAllocationUnitsCount != nil {
			qrCapacitySpareAllocationUnitsCount = *o.CapacitySpareAllocationUnitsCount
		}
		qCapacitySpareAllocationUnitsCount := swag.FormatInt64(qrCapacitySpareAllocationUnitsCount)
		if qCapacitySpareAllocationUnitsCount != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.count", qCapacitySpareAllocationUnitsCount); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsNodeName != nil {

		// query param capacity.spare_allocation_units.node.name
		var qrCapacitySpareAllocationUnitsNodeName string

		if o.CapacitySpareAllocationUnitsNodeName != nil {
			qrCapacitySpareAllocationUnitsNodeName = *o.CapacitySpareAllocationUnitsNodeName
		}
		qCapacitySpareAllocationUnitsNodeName := qrCapacitySpareAllocationUnitsNodeName
		if qCapacitySpareAllocationUnitsNodeName != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.node.name", qCapacitySpareAllocationUnitsNodeName); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsNodeUUID != nil {

		// query param capacity.spare_allocation_units.node.uuid
		var qrCapacitySpareAllocationUnitsNodeUUID string

		if o.CapacitySpareAllocationUnitsNodeUUID != nil {
			qrCapacitySpareAllocationUnitsNodeUUID = *o.CapacitySpareAllocationUnitsNodeUUID
		}
		qCapacitySpareAllocationUnitsNodeUUID := qrCapacitySpareAllocationUnitsNodeUUID
		if qCapacitySpareAllocationUnitsNodeUUID != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.node.uuid", qCapacitySpareAllocationUnitsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsSize != nil {

		// query param capacity.spare_allocation_units.size
		var qrCapacitySpareAllocationUnitsSize int64

		if o.CapacitySpareAllocationUnitsSize != nil {
			qrCapacitySpareAllocationUnitsSize = *o.CapacitySpareAllocationUnitsSize
		}
		qCapacitySpareAllocationUnitsSize := swag.FormatInt64(qrCapacitySpareAllocationUnitsSize)
		if qCapacitySpareAllocationUnitsSize != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.size", qCapacitySpareAllocationUnitsSize); err != nil {
				return err
			}
		}
	}

	if o.CapacitySpareAllocationUnitsSyncmirrorPool != nil {

		// query param capacity.spare_allocation_units.syncmirror_pool
		var qrCapacitySpareAllocationUnitsSyncmirrorPool string

		if o.CapacitySpareAllocationUnitsSyncmirrorPool != nil {
			qrCapacitySpareAllocationUnitsSyncmirrorPool = *o.CapacitySpareAllocationUnitsSyncmirrorPool
		}
		qCapacitySpareAllocationUnitsSyncmirrorPool := qrCapacitySpareAllocationUnitsSyncmirrorPool
		if qCapacitySpareAllocationUnitsSyncmirrorPool != "" {

			if err := r.SetQueryParam("capacity.spare_allocation_units.syncmirror_pool", qCapacitySpareAllocationUnitsSyncmirrorPool); err != nil {
				return err
			}
		}
	}

	if o.CapacityTotal != nil {

		// query param capacity.total
		var qrCapacityTotal int64

		if o.CapacityTotal != nil {
			qrCapacityTotal = *o.CapacityTotal
		}
		qCapacityTotal := swag.FormatInt64(qrCapacityTotal)
		if qCapacityTotal != "" {

			if err := r.SetQueryParam("capacity.total", qCapacityTotal); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsAggregateName != nil {

		// query param capacity.used_allocation_units.aggregate.name
		var qrCapacityUsedAllocationUnitsAggregateName string

		if o.CapacityUsedAllocationUnitsAggregateName != nil {
			qrCapacityUsedAllocationUnitsAggregateName = *o.CapacityUsedAllocationUnitsAggregateName
		}
		qCapacityUsedAllocationUnitsAggregateName := qrCapacityUsedAllocationUnitsAggregateName
		if qCapacityUsedAllocationUnitsAggregateName != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.aggregate.name", qCapacityUsedAllocationUnitsAggregateName); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsAggregateUUID != nil {

		// query param capacity.used_allocation_units.aggregate.uuid
		var qrCapacityUsedAllocationUnitsAggregateUUID string

		if o.CapacityUsedAllocationUnitsAggregateUUID != nil {
			qrCapacityUsedAllocationUnitsAggregateUUID = *o.CapacityUsedAllocationUnitsAggregateUUID
		}
		qCapacityUsedAllocationUnitsAggregateUUID := qrCapacityUsedAllocationUnitsAggregateUUID
		if qCapacityUsedAllocationUnitsAggregateUUID != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.aggregate.uuid", qCapacityUsedAllocationUnitsAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsCount != nil {

		// query param capacity.used_allocation_units.count
		var qrCapacityUsedAllocationUnitsCount int64

		if o.CapacityUsedAllocationUnitsCount != nil {
			qrCapacityUsedAllocationUnitsCount = *o.CapacityUsedAllocationUnitsCount
		}
		qCapacityUsedAllocationUnitsCount := swag.FormatInt64(qrCapacityUsedAllocationUnitsCount)
		if qCapacityUsedAllocationUnitsCount != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.count", qCapacityUsedAllocationUnitsCount); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsCurrentUsage != nil {

		// query param capacity.used_allocation_units.current_usage
		var qrCapacityUsedAllocationUnitsCurrentUsage int64

		if o.CapacityUsedAllocationUnitsCurrentUsage != nil {
			qrCapacityUsedAllocationUnitsCurrentUsage = *o.CapacityUsedAllocationUnitsCurrentUsage
		}
		qCapacityUsedAllocationUnitsCurrentUsage := swag.FormatInt64(qrCapacityUsedAllocationUnitsCurrentUsage)
		if qCapacityUsedAllocationUnitsCurrentUsage != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.current_usage", qCapacityUsedAllocationUnitsCurrentUsage); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsNodeName != nil {

		// query param capacity.used_allocation_units.node.name
		var qrCapacityUsedAllocationUnitsNodeName string

		if o.CapacityUsedAllocationUnitsNodeName != nil {
			qrCapacityUsedAllocationUnitsNodeName = *o.CapacityUsedAllocationUnitsNodeName
		}
		qCapacityUsedAllocationUnitsNodeName := qrCapacityUsedAllocationUnitsNodeName
		if qCapacityUsedAllocationUnitsNodeName != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.node.name", qCapacityUsedAllocationUnitsNodeName); err != nil {
				return err
			}
		}
	}

	if o.CapacityUsedAllocationUnitsNodeUUID != nil {

		// query param capacity.used_allocation_units.node.uuid
		var qrCapacityUsedAllocationUnitsNodeUUID string

		if o.CapacityUsedAllocationUnitsNodeUUID != nil {
			qrCapacityUsedAllocationUnitsNodeUUID = *o.CapacityUsedAllocationUnitsNodeUUID
		}
		qCapacityUsedAllocationUnitsNodeUUID := qrCapacityUsedAllocationUnitsNodeUUID
		if qCapacityUsedAllocationUnitsNodeUUID != "" {

			if err := r.SetQueryParam("capacity.used_allocation_units.node.uuid", qCapacityUsedAllocationUnitsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.HealthIsHealthy != nil {

		// query param health.is_healthy
		var qrHealthIsHealthy bool

		if o.HealthIsHealthy != nil {
			qrHealthIsHealthy = *o.HealthIsHealthy
		}
		qHealthIsHealthy := swag.FormatBool(qrHealthIsHealthy)
		if qHealthIsHealthy != "" {

			if err := r.SetQueryParam("health.is_healthy", qHealthIsHealthy); err != nil {
				return err
			}
		}
	}

	if o.HealthState != nil {

		// query param health.state
		var qrHealthState string

		if o.HealthState != nil {
			qrHealthState = *o.HealthState
		}
		qHealthState := qrHealthState
		if qHealthState != "" {

			if err := r.SetQueryParam("health.state", qHealthState); err != nil {
				return err
			}
		}
	}

	if o.HealthUnhealthyReasonArgumentsCode != nil {

		// query param health.unhealthy_reason.arguments.code
		var qrHealthUnhealthyReasonArgumentsCode string

		if o.HealthUnhealthyReasonArgumentsCode != nil {
			qrHealthUnhealthyReasonArgumentsCode = *o.HealthUnhealthyReasonArgumentsCode
		}
		qHealthUnhealthyReasonArgumentsCode := qrHealthUnhealthyReasonArgumentsCode
		if qHealthUnhealthyReasonArgumentsCode != "" {

			if err := r.SetQueryParam("health.unhealthy_reason.arguments.code", qHealthUnhealthyReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.HealthUnhealthyReasonArgumentsMessage != nil {

		// query param health.unhealthy_reason.arguments.message
		var qrHealthUnhealthyReasonArgumentsMessage string

		if o.HealthUnhealthyReasonArgumentsMessage != nil {
			qrHealthUnhealthyReasonArgumentsMessage = *o.HealthUnhealthyReasonArgumentsMessage
		}
		qHealthUnhealthyReasonArgumentsMessage := qrHealthUnhealthyReasonArgumentsMessage
		if qHealthUnhealthyReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("health.unhealthy_reason.arguments.message", qHealthUnhealthyReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.HealthUnhealthyReasonCode != nil {

		// query param health.unhealthy_reason.code
		var qrHealthUnhealthyReasonCode string

		if o.HealthUnhealthyReasonCode != nil {
			qrHealthUnhealthyReasonCode = *o.HealthUnhealthyReasonCode
		}
		qHealthUnhealthyReasonCode := qrHealthUnhealthyReasonCode
		if qHealthUnhealthyReasonCode != "" {

			if err := r.SetQueryParam("health.unhealthy_reason.code", qHealthUnhealthyReasonCode); err != nil {
				return err
			}
		}
	}

	if o.HealthUnhealthyReasonMessage != nil {

		// query param health.unhealthy_reason.message
		var qrHealthUnhealthyReasonMessage string

		if o.HealthUnhealthyReasonMessage != nil {
			qrHealthUnhealthyReasonMessage = *o.HealthUnhealthyReasonMessage
		}
		qHealthUnhealthyReasonMessage := qrHealthUnhealthyReasonMessage
		if qHealthUnhealthyReasonMessage != "" {

			if err := r.SetQueryParam("health.unhealthy_reason.message", qHealthUnhealthyReasonMessage); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodesName != nil {

		// query param nodes.name
		var qrNodesName string

		if o.NodesName != nil {
			qrNodesName = *o.NodesName
		}
		qNodesName := qrNodesName
		if qNodesName != "" {

			if err := r.SetQueryParam("nodes.name", qNodesName); err != nil {
				return err
			}
		}
	}

	if o.NodesUUID != nil {

		// query param nodes.uuid
		var qrNodesUUID string

		if o.NodesUUID != nil {
			qrNodesUUID = *o.NodesUUID
		}
		qNodesUUID := qrNodesUUID
		if qNodesUUID != "" {

			if err := r.SetQueryParam("nodes.uuid", qNodesUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StorageType != nil {

		// query param storage_type
		var qrStorageType string

		if o.StorageType != nil {
			qrStorageType = *o.StorageType
		}
		qStorageType := qrStorageType
		if qStorageType != "" {

			if err := r.SetQueryParam("storage_type", qStorageType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
