// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StoragePoolDeleteCollectionReader is a Reader for the StoragePoolDeleteCollection structure.
type StoragePoolDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StoragePoolDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStoragePoolDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStoragePoolDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStoragePoolDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStoragePoolDeleteCollectionOK creates a StoragePoolDeleteCollectionOK with default headers values
func NewStoragePoolDeleteCollectionOK() *StoragePoolDeleteCollectionOK {
	return &StoragePoolDeleteCollectionOK{}
}

/*
StoragePoolDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StoragePoolDeleteCollectionOK struct {
	Payload *models.StoragePoolJobLinkResponse
}

// IsSuccess returns true when this storage pool delete collection o k response has a 2xx status code
func (o *StoragePoolDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool delete collection o k response has a 3xx status code
func (o *StoragePoolDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool delete collection o k response has a 4xx status code
func (o *StoragePoolDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool delete collection o k response has a 5xx status code
func (o *StoragePoolDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool delete collection o k response a status code equal to that given
func (o *StoragePoolDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage pool delete collection o k response
func (o *StoragePoolDeleteCollectionOK) Code() int {
	return 200
}

func (o *StoragePoolDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storagePoolDeleteCollectionOK %s", 200, payload)
}

func (o *StoragePoolDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storagePoolDeleteCollectionOK %s", 200, payload)
}

func (o *StoragePoolDeleteCollectionOK) GetPayload() *models.StoragePoolJobLinkResponse {
	return o.Payload
}

func (o *StoragePoolDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StoragePoolJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolDeleteCollectionAccepted creates a StoragePoolDeleteCollectionAccepted with default headers values
func NewStoragePoolDeleteCollectionAccepted() *StoragePoolDeleteCollectionAccepted {
	return &StoragePoolDeleteCollectionAccepted{}
}

/*
StoragePoolDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StoragePoolDeleteCollectionAccepted struct {
	Payload *models.StoragePoolJobLinkResponse
}

// IsSuccess returns true when this storage pool delete collection accepted response has a 2xx status code
func (o *StoragePoolDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool delete collection accepted response has a 3xx status code
func (o *StoragePoolDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool delete collection accepted response has a 4xx status code
func (o *StoragePoolDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool delete collection accepted response has a 5xx status code
func (o *StoragePoolDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool delete collection accepted response a status code equal to that given
func (o *StoragePoolDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage pool delete collection accepted response
func (o *StoragePoolDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *StoragePoolDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storagePoolDeleteCollectionAccepted %s", 202, payload)
}

func (o *StoragePoolDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storagePoolDeleteCollectionAccepted %s", 202, payload)
}

func (o *StoragePoolDeleteCollectionAccepted) GetPayload() *models.StoragePoolJobLinkResponse {
	return o.Payload
}

func (o *StoragePoolDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StoragePoolJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolDeleteCollectionDefault creates a StoragePoolDeleteCollectionDefault with default headers values
func NewStoragePoolDeleteCollectionDefault(code int) *StoragePoolDeleteCollectionDefault {
	return &StoragePoolDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	StoragePoolDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 11209668 | Capacity from pool is being used by one or more aggregates. |
| 11209670 | Unable to stop sharing a constituent disk of the storage pool. |
| 11209671 | Cannot find a node sharing this storage pool. |
| 11209672 | Disk is not shared. |
| 11209673 | Unable to assign shared capacity from a constituent disk. |
| 11209675 | A constituent disk of the storage pool has non-spare capacity. |
| 11209676 | A constituent disk of the storage pool is reserved for coredump. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StoragePoolDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage pool delete collection default response has a 2xx status code
func (o *StoragePoolDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage pool delete collection default response has a 3xx status code
func (o *StoragePoolDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage pool delete collection default response has a 4xx status code
func (o *StoragePoolDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage pool delete collection default response has a 5xx status code
func (o *StoragePoolDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage pool delete collection default response a status code equal to that given
func (o *StoragePoolDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage pool delete collection default response
func (o *StoragePoolDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StoragePoolDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storage_pool_delete_collection default %s", o._statusCode, payload)
}

func (o *StoragePoolDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/pools][%d] storage_pool_delete_collection default %s", o._statusCode, payload)
}

func (o *StoragePoolDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StoragePoolDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StoragePoolDeleteCollectionBody storage pool delete collection body
swagger:model StoragePoolDeleteCollectionBody
*/
type StoragePoolDeleteCollectionBody struct {

	// error
	Error *models.Error `json:"error,omitempty"`

	// storage pool response inline records
	StoragePoolResponseInlineRecords []*models.StoragePool `json:"records,omitempty"`

	// storage pool response inline spares
	StoragePoolResponseInlineSpares []*models.StoragePoolShowSpares `json:"spares,omitempty"`
}

// Validate validates this storage pool delete collection body
func (o *StoragePoolDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePoolResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePoolResponseInlineSpares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolDeleteCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolDeleteCollectionBody) validateStoragePoolResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePoolResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePoolResponseInlineRecords); i++ {
		if swag.IsZero(o.StoragePoolResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StoragePoolResponseInlineRecords[i] != nil {
			if err := o.StoragePoolResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolDeleteCollectionBody) validateStoragePoolResponseInlineSpares(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePoolResponseInlineSpares) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePoolResponseInlineSpares); i++ {
		if swag.IsZero(o.StoragePoolResponseInlineSpares[i]) { // not required
			continue
		}

		if o.StoragePoolResponseInlineSpares[i] != nil {
			if err := o.StoragePoolResponseInlineSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage pool delete collection body based on the context it is used
func (o *StoragePoolDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePoolResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePoolResponseInlineSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolDeleteCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolDeleteCollectionBody) contextValidateStoragePoolResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePoolResponseInlineRecords); i++ {

		if o.StoragePoolResponseInlineRecords[i] != nil {
			if err := o.StoragePoolResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolDeleteCollectionBody) contextValidateStoragePoolResponseInlineSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePoolResponseInlineSpares); i++ {

		if o.StoragePoolResponseInlineSpares[i] != nil {
			if err := o.StoragePoolResponseInlineSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePoolDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePoolDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res StoragePoolDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
