// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StoragePoolModifyCollectionReader is a Reader for the StoragePoolModifyCollection structure.
type StoragePoolModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StoragePoolModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStoragePoolModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStoragePoolModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStoragePoolModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStoragePoolModifyCollectionOK creates a StoragePoolModifyCollectionOK with default headers values
func NewStoragePoolModifyCollectionOK() *StoragePoolModifyCollectionOK {
	return &StoragePoolModifyCollectionOK{}
}

/*
StoragePoolModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StoragePoolModifyCollectionOK struct {
	Payload *models.StoragePoolPatch
}

// IsSuccess returns true when this storage pool modify collection o k response has a 2xx status code
func (o *StoragePoolModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool modify collection o k response has a 3xx status code
func (o *StoragePoolModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool modify collection o k response has a 4xx status code
func (o *StoragePoolModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool modify collection o k response has a 5xx status code
func (o *StoragePoolModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool modify collection o k response a status code equal to that given
func (o *StoragePoolModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage pool modify collection o k response
func (o *StoragePoolModifyCollectionOK) Code() int {
	return 200
}

func (o *StoragePoolModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storagePoolModifyCollectionOK %s", 200, payload)
}

func (o *StoragePoolModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storagePoolModifyCollectionOK %s", 200, payload)
}

func (o *StoragePoolModifyCollectionOK) GetPayload() *models.StoragePoolPatch {
	return o.Payload
}

func (o *StoragePoolModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StoragePoolPatch)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolModifyCollectionAccepted creates a StoragePoolModifyCollectionAccepted with default headers values
func NewStoragePoolModifyCollectionAccepted() *StoragePoolModifyCollectionAccepted {
	return &StoragePoolModifyCollectionAccepted{}
}

/*
StoragePoolModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StoragePoolModifyCollectionAccepted struct {
	Payload *models.StoragePoolPatch
}

// IsSuccess returns true when this storage pool modify collection accepted response has a 2xx status code
func (o *StoragePoolModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage pool modify collection accepted response has a 3xx status code
func (o *StoragePoolModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage pool modify collection accepted response has a 4xx status code
func (o *StoragePoolModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage pool modify collection accepted response has a 5xx status code
func (o *StoragePoolModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage pool modify collection accepted response a status code equal to that given
func (o *StoragePoolModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage pool modify collection accepted response
func (o *StoragePoolModifyCollectionAccepted) Code() int {
	return 202
}

func (o *StoragePoolModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storagePoolModifyCollectionAccepted %s", 202, payload)
}

func (o *StoragePoolModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storagePoolModifyCollectionAccepted %s", 202, payload)
}

func (o *StoragePoolModifyCollectionAccepted) GetPayload() *models.StoragePoolPatch {
	return o.Payload
}

func (o *StoragePoolModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StoragePoolPatch)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStoragePoolModifyCollectionDefault creates a StoragePoolModifyCollectionDefault with default headers values
func NewStoragePoolModifyCollectionDefault(code int) *StoragePoolModifyCollectionDefault {
	return &StoragePoolModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	StoragePoolModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 11211658 | Node does not have enough spare capacity. |
| 11211659 | Valid allocation unit input is required. |
| 11211662 | Specified node is not part of the storage pool. |
| 11211663 | Failed to reassign available capacity in the storage pool. |
| 11211664 | Could not fix the broken allocation unit for the storage pool. |
| 11212673 | Could not grow one or more aggregates. |
| 11212679 | Adding specified number of disks will expand storage pool beyond maximum supported disk limit. |
| 11212680 | Incorrect node specified. |
| 11212681 | 0 is an invalid value for disk_count. |
| 11212682 | Adding the specified number of disks will result in the storage pool reaching the maximum disk limit reserved for RAID-TEC use only. At this limit, the storage pool can only allocate capacity to aggregates containing RAID-TEC RAID groups. Existing aggregates containing RAID groups other than RAID-TEC will not automatically grow to the new capacity. |
| 11212683 | Renaming storage pool to new name failed. |
| 11212763 | Storage pool add job failed. |
| 11215657 | Storage pool PATCH request have missing parameters. |
| 11215658 | Storage pool PATCH request for reassign is invalid. |
| 11215659 | Storage pool PATCH request for reassign have invalid allocation unit count. |
| 11215660 | Storage pool PATCH request for reassign have invalid node name. |
| 11215662 | Storage pool PATCH request have invalid disk count. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StoragePoolModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage pool modify collection default response has a 2xx status code
func (o *StoragePoolModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage pool modify collection default response has a 3xx status code
func (o *StoragePoolModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage pool modify collection default response has a 4xx status code
func (o *StoragePoolModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage pool modify collection default response has a 5xx status code
func (o *StoragePoolModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage pool modify collection default response a status code equal to that given
func (o *StoragePoolModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage pool modify collection default response
func (o *StoragePoolModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StoragePoolModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storage_pool_modify_collection default %s", o._statusCode, payload)
}

func (o *StoragePoolModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/pools][%d] storage_pool_modify_collection default %s", o._statusCode, payload)
}

func (o *StoragePoolModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StoragePoolModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StoragePoolModifyCollectionBody storage pool modify collection body
swagger:model StoragePoolModifyCollectionBody
*/
type StoragePoolModifyCollectionBody struct {

	// links
	Links *models.StoragePoolInlineLinks `json:"_links,omitempty"`

	// capacity
	Capacity *models.StoragePoolInlineCapacity `json:"capacity,omitempty"`

	// error
	Error *models.Error `json:"error,omitempty"`

	// health
	Health *models.StoragePoolInlineHealth `json:"health,omitempty"`

	// Storage pool name.
	Name *string `json:"name,omitempty"`

	// Nodes that can use this storage pool for their aggregates.
	StoragePoolInlineNodes []*models.NodeReference `json:"nodes,omitempty"`

	// storage pool response inline records
	StoragePoolResponseInlineRecords []*models.StoragePool `json:"records,omitempty"`

	// storage pool response inline spares
	StoragePoolResponseInlineSpares []*models.StoragePoolShowSpares `json:"spares,omitempty"`

	// Storage type for the disks used to create the storage pool.
	// Read Only: true
	// Enum: ["SSD"]
	StorageType *string `json:"storage_type,omitempty"`

	// Storage pool UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage pool modify collection body
func (o *StoragePoolModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePoolInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePoolResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePoolResponseInlineSpares(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateCapacity(formats strfmt.Registry) error {
	if swag.IsZero(o.Capacity) { // not required
		return nil
	}

	if o.Capacity != nil {
		if err := o.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "capacity")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateHealth(formats strfmt.Registry) error {
	if swag.IsZero(o.Health) { // not required
		return nil
	}

	if o.Health != nil {
		if err := o.Health.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "health")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateStoragePoolInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePoolInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePoolInlineNodes); i++ {
		if swag.IsZero(o.StoragePoolInlineNodes[i]) { // not required
			continue
		}

		if o.StoragePoolInlineNodes[i] != nil {
			if err := o.StoragePoolInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateStoragePoolResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePoolResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePoolResponseInlineRecords); i++ {
		if swag.IsZero(o.StoragePoolResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StoragePoolResponseInlineRecords[i] != nil {
			if err := o.StoragePoolResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) validateStoragePoolResponseInlineSpares(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePoolResponseInlineSpares) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePoolResponseInlineSpares); i++ {
		if swag.IsZero(o.StoragePoolResponseInlineSpares[i]) { // not required
			continue
		}

		if o.StoragePoolResponseInlineSpares[i] != nil {
			if err := o.StoragePoolResponseInlineSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storagePoolModifyCollectionBodyTypeStorageTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSD"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolModifyCollectionBodyTypeStorageTypePropEnum = append(storagePoolModifyCollectionBodyTypeStorageTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StoragePoolModifyCollectionBody
	// StoragePoolModifyCollectionBody
	// storage_type
	// StorageType
	// SSD
	// END DEBUGGING
	// StoragePoolModifyCollectionBodyStorageTypeSSD captures enum value "SSD"
	StoragePoolModifyCollectionBodyStorageTypeSSD string = "SSD"
)

// prop value enum
func (o *StoragePoolModifyCollectionBody) validateStorageTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolModifyCollectionBodyTypeStorageTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePoolModifyCollectionBody) validateStorageType(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageType) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageTypeEnum("info"+"."+"storage_type", "body", *o.StorageType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage pool modify collection body based on the context it is used
func (o *StoragePoolModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePoolInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePoolResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePoolResponseInlineSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if o.Capacity != nil {
		if err := o.Capacity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "capacity")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateHealth(ctx context.Context, formats strfmt.Registry) error {

	if o.Health != nil {
		if err := o.Health.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "health")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateStoragePoolInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePoolInlineNodes); i++ {

		if o.StoragePoolInlineNodes[i] != nil {
			if err := o.StoragePoolInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateStoragePoolResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePoolResponseInlineRecords); i++ {

		if o.StoragePoolResponseInlineRecords[i] != nil {
			if err := o.StoragePoolResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateStoragePoolResponseInlineSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePoolResponseInlineSpares); i++ {

		if o.StoragePoolResponseInlineSpares[i] != nil {
			if err := o.StoragePoolResponseInlineSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateStorageType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage_type", "body", o.StorageType); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePoolModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePoolModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res StoragePoolModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePoolInlineLinks storage pool inline links
swagger:model storage_pool_inline__links
*/
type StoragePoolInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage pool inline links
func (o *StoragePoolInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool inline links based on the context it is used
func (o *StoragePoolInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePoolInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePoolInlineLinks) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePoolInlineCapacity storage pool inline capacity
swagger:model storage_pool_inline_capacity
*/
type StoragePoolInlineCapacity struct {

	// The number of disks in the storage pool.
	DiskCount *int64 `json:"disk_count,omitempty"`

	// Properties of each disk used in the shared storage pool.
	Disks []*models.StoragePoolDisk `json:"disks,omitempty"`

	// Remaining usable capacity in the flash pool, in bytes.
	// Read Only: true
	Remaining *int64 `json:"remaining,omitempty"`

	// Properties of spare allocation units.
	SpareAllocationUnits []*models.StoragePoolSpareAllocationUnit `json:"spare_allocation_units,omitempty"`

	// Total size of the flash pool, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Information about the storage pool allocation units participating in the cache tier of an aggregate.
	UsedAllocationUnits []*models.StoragePoolUsedAllocationUnit `json:"used_allocation_units,omitempty"`
}

// Validate validates this storage pool inline capacity
func (o *StoragePoolInlineCapacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDisks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpareAllocationUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUsedAllocationUnits(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolInlineCapacity) validateDisks(formats strfmt.Registry) error {
	if swag.IsZero(o.Disks) { // not required
		return nil
	}

	for i := 0; i < len(o.Disks); i++ {
		if swag.IsZero(o.Disks[i]) { // not required
			continue
		}

		if o.Disks[i] != nil {
			if err := o.Disks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolInlineCapacity) validateSpareAllocationUnits(formats strfmt.Registry) error {
	if swag.IsZero(o.SpareAllocationUnits) { // not required
		return nil
	}

	for i := 0; i < len(o.SpareAllocationUnits); i++ {
		if swag.IsZero(o.SpareAllocationUnits[i]) { // not required
			continue
		}

		if o.SpareAllocationUnits[i] != nil {
			if err := o.SpareAllocationUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "spare_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolInlineCapacity) validateUsedAllocationUnits(formats strfmt.Registry) error {
	if swag.IsZero(o.UsedAllocationUnits) { // not required
		return nil
	}

	for i := 0; i < len(o.UsedAllocationUnits); i++ {
		if swag.IsZero(o.UsedAllocationUnits[i]) { // not required
			continue
		}

		if o.UsedAllocationUnits[i] != nil {
			if err := o.UsedAllocationUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "used_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage pool inline capacity based on the context it is used
func (o *StoragePoolInlineCapacity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDisks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemaining(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpareAllocationUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedAllocationUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolInlineCapacity) contextValidateDisks(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Disks); i++ {

		if o.Disks[i] != nil {
			if err := o.Disks[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolInlineCapacity) contextValidateRemaining(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"capacity"+"."+"remaining", "body", o.Remaining); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolInlineCapacity) contextValidateSpareAllocationUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SpareAllocationUnits); i++ {

		if o.SpareAllocationUnits[i] != nil {
			if err := o.SpareAllocationUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "spare_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePoolInlineCapacity) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"capacity"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolInlineCapacity) contextValidateUsedAllocationUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.UsedAllocationUnits); i++ {

		if o.UsedAllocationUnits[i] != nil {
			if err := o.UsedAllocationUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "capacity" + "." + "used_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePoolInlineCapacity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePoolInlineCapacity) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineCapacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePoolInlineHealth Properties that outline shared storage pool health.
swagger:model storage_pool_inline_health
*/
type StoragePoolInlineHealth struct {

	// Indicates whether the storage pool is able to participate in provisioning operations.
	// Read Only: true
	IsHealthy *bool `json:"is_healthy,omitempty"`

	// The state of the shared storage pool.
	// Read Only: true
	// Enum: ["normal","degraded","creating","deleting","reassigning","growing"]
	State *string `json:"state,omitempty"`

	// Indicates why the storage pool is unhealthy. This property is not returned for healthy storage pools.
	// Read Only: true
	UnhealthyReason *models.Error `json:"unhealthy_reason,omitempty"`
}

// Validate validates this storage pool inline health
func (o *StoragePoolInlineHealth) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnhealthyReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storagePoolInlineHealthTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","degraded","creating","deleting","reassigning","growing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolInlineHealthTypeStatePropEnum = append(storagePoolInlineHealthTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// normal
	// END DEBUGGING
	// StoragePoolInlineHealthStateNormal captures enum value "normal"
	StoragePoolInlineHealthStateNormal string = "normal"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// degraded
	// END DEBUGGING
	// StoragePoolInlineHealthStateDegraded captures enum value "degraded"
	StoragePoolInlineHealthStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// creating
	// END DEBUGGING
	// StoragePoolInlineHealthStateCreating captures enum value "creating"
	StoragePoolInlineHealthStateCreating string = "creating"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// deleting
	// END DEBUGGING
	// StoragePoolInlineHealthStateDeleting captures enum value "deleting"
	StoragePoolInlineHealthStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// reassigning
	// END DEBUGGING
	// StoragePoolInlineHealthStateReassigning captures enum value "reassigning"
	StoragePoolInlineHealthStateReassigning string = "reassigning"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// growing
	// END DEBUGGING
	// StoragePoolInlineHealthStateGrowing captures enum value "growing"
	StoragePoolInlineHealthStateGrowing string = "growing"
)

// prop value enum
func (o *StoragePoolInlineHealth) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolInlineHealthTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePoolInlineHealth) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"health"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolInlineHealth) validateUnhealthyReason(formats strfmt.Registry) error {
	if swag.IsZero(o.UnhealthyReason) { // not required
		return nil
	}

	if o.UnhealthyReason != nil {
		if err := o.UnhealthyReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "health" + "." + "unhealthy_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool inline health based on the context it is used
func (o *StoragePoolInlineHealth) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIsHealthy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnhealthyReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePoolInlineHealth) contextValidateIsHealthy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"health"+"."+"is_healthy", "body", o.IsHealthy); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolInlineHealth) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"health"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *StoragePoolInlineHealth) contextValidateUnhealthyReason(ctx context.Context, formats strfmt.Registry) error {

	if o.UnhealthyReason != nil {
		if err := o.UnhealthyReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "health" + "." + "unhealthy_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePoolInlineHealth) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePoolInlineHealth) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineHealth
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
