// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStoragePortModifyCollectionParams creates a new StoragePortModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStoragePortModifyCollectionParams() *StoragePortModifyCollectionParams {
	return &StoragePortModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStoragePortModifyCollectionParamsWithTimeout creates a new StoragePortModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewStoragePortModifyCollectionParamsWithTimeout(timeout time.Duration) *StoragePortModifyCollectionParams {
	return &StoragePortModifyCollectionParams{
		timeout: timeout,
	}
}

// NewStoragePortModifyCollectionParamsWithContext creates a new StoragePortModifyCollectionParams object
// with the ability to set a context for a request.
func NewStoragePortModifyCollectionParamsWithContext(ctx context.Context) *StoragePortModifyCollectionParams {
	return &StoragePortModifyCollectionParams{
		Context: ctx,
	}
}

// NewStoragePortModifyCollectionParamsWithHTTPClient creates a new StoragePortModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewStoragePortModifyCollectionParamsWithHTTPClient(client *http.Client) *StoragePortModifyCollectionParams {
	return &StoragePortModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
StoragePortModifyCollectionParams contains all the parameters to send to the API endpoint

	for the storage port modify collection operation.

	Typically these are written to a http.Request.
*/
type StoragePortModifyCollectionParams struct {

	/* BoardName.

	   Filter by board_name
	*/
	BoardName *string

	/* CableIdentifier.

	   Filter by cable.identifier
	*/
	CableIdentifier *string

	/* CableLength.

	   Filter by cable.length
	*/
	CableLength *string

	/* CablePartNumber.

	   Filter by cable.part_number
	*/
	CablePartNumber *string

	/* CableSerialNumber.

	   Filter by cable.serial_number
	*/
	CableSerialNumber *string

	/* CableTransceiver.

	   Filter by cable.transceiver
	*/
	CableTransceiver *string

	/* CableVendor.

	   Filter by cable.vendor
	*/
	CableVendor *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* ErrorCorrectiveAction.

	   Filter by error.corrective_action
	*/
	ErrorCorrectiveAction *string

	/* ErrorMessage.

	   Filter by error.message
	*/
	ErrorMessage *string

	/* FirmwareVersion.

	   Filter by firmware_version
	*/
	FirmwareVersion *string

	/* InUse.

	   Filter by in_use
	*/
	InUse *bool

	/* Info.

	   Info specification
	*/
	Info StoragePortModifyCollectionBody

	/* MacAddress.

	   Filter by mac_address
	*/
	MacAddress *string

	/* Mode.

	   Filter by mode
	*/
	Mode *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* PartNumber.

	   Filter by part_number
	*/
	PartNumber *string

	/* Redundant.

	   Filter by redundant
	*/
	Redundant *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Speed.

	   Filter by speed
	*/
	Speed *float64

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* Wwn.

	   Filter by wwn
	*/
	Wwn *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePortModifyCollectionParams) WithDefaults() *StoragePortModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StoragePortModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := StoragePortModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithTimeout(timeout time.Duration) *StoragePortModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithContext(ctx context.Context) *StoragePortModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithHTTPClient(client *http.Client) *StoragePortModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBoardName adds the boardName to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithBoardName(boardName *string) *StoragePortModifyCollectionParams {
	o.SetBoardName(boardName)
	return o
}

// SetBoardName adds the boardName to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetBoardName(boardName *string) {
	o.BoardName = boardName
}

// WithCableIdentifier adds the cableIdentifier to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCableIdentifier(cableIdentifier *string) *StoragePortModifyCollectionParams {
	o.SetCableIdentifier(cableIdentifier)
	return o
}

// SetCableIdentifier adds the cableIdentifier to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCableIdentifier(cableIdentifier *string) {
	o.CableIdentifier = cableIdentifier
}

// WithCableLength adds the cableLength to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCableLength(cableLength *string) *StoragePortModifyCollectionParams {
	o.SetCableLength(cableLength)
	return o
}

// SetCableLength adds the cableLength to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCableLength(cableLength *string) {
	o.CableLength = cableLength
}

// WithCablePartNumber adds the cablePartNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCablePartNumber(cablePartNumber *string) *StoragePortModifyCollectionParams {
	o.SetCablePartNumber(cablePartNumber)
	return o
}

// SetCablePartNumber adds the cablePartNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCablePartNumber(cablePartNumber *string) {
	o.CablePartNumber = cablePartNumber
}

// WithCableSerialNumber adds the cableSerialNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCableSerialNumber(cableSerialNumber *string) *StoragePortModifyCollectionParams {
	o.SetCableSerialNumber(cableSerialNumber)
	return o
}

// SetCableSerialNumber adds the cableSerialNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCableSerialNumber(cableSerialNumber *string) {
	o.CableSerialNumber = cableSerialNumber
}

// WithCableTransceiver adds the cableTransceiver to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCableTransceiver(cableTransceiver *string) *StoragePortModifyCollectionParams {
	o.SetCableTransceiver(cableTransceiver)
	return o
}

// SetCableTransceiver adds the cableTransceiver to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCableTransceiver(cableTransceiver *string) {
	o.CableTransceiver = cableTransceiver
}

// WithCableVendor adds the cableVendor to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithCableVendor(cableVendor *string) *StoragePortModifyCollectionParams {
	o.SetCableVendor(cableVendor)
	return o
}

// SetCableVendor adds the cableVendor to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetCableVendor(cableVendor *string) {
	o.CableVendor = cableVendor
}

// WithContinueOnFailure adds the continueOnFailure to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *StoragePortModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDescription adds the description to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithDescription(description *string) *StoragePortModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEnabled adds the enabled to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithEnabled(enabled *bool) *StoragePortModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithErrorCorrectiveAction adds the errorCorrectiveAction to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithErrorCorrectiveAction(errorCorrectiveAction *string) *StoragePortModifyCollectionParams {
	o.SetErrorCorrectiveAction(errorCorrectiveAction)
	return o
}

// SetErrorCorrectiveAction adds the errorCorrectiveAction to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetErrorCorrectiveAction(errorCorrectiveAction *string) {
	o.ErrorCorrectiveAction = errorCorrectiveAction
}

// WithErrorMessage adds the errorMessage to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithErrorMessage(errorMessage *string) *StoragePortModifyCollectionParams {
	o.SetErrorMessage(errorMessage)
	return o
}

// SetErrorMessage adds the errorMessage to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetErrorMessage(errorMessage *string) {
	o.ErrorMessage = errorMessage
}

// WithFirmwareVersion adds the firmwareVersion to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithFirmwareVersion(firmwareVersion *string) *StoragePortModifyCollectionParams {
	o.SetFirmwareVersion(firmwareVersion)
	return o
}

// SetFirmwareVersion adds the firmwareVersion to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetFirmwareVersion(firmwareVersion *string) {
	o.FirmwareVersion = firmwareVersion
}

// WithInUse adds the inUse to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithInUse(inUse *bool) *StoragePortModifyCollectionParams {
	o.SetInUse(inUse)
	return o
}

// SetInUse adds the inUse to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetInUse(inUse *bool) {
	o.InUse = inUse
}

// WithInfo adds the info to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithInfo(info StoragePortModifyCollectionBody) *StoragePortModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetInfo(info StoragePortModifyCollectionBody) {
	o.Info = info
}

// WithMacAddress adds the macAddress to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithMacAddress(macAddress *string) *StoragePortModifyCollectionParams {
	o.SetMacAddress(macAddress)
	return o
}

// SetMacAddress adds the macAddress to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetMacAddress(macAddress *string) {
	o.MacAddress = macAddress
}

// WithMode adds the mode to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithMode(mode *string) *StoragePortModifyCollectionParams {
	o.SetMode(mode)
	return o
}

// SetMode adds the mode to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetMode(mode *string) {
	o.Mode = mode
}

// WithName adds the name to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithName(name *string) *StoragePortModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithNodeName(nodeName *string) *StoragePortModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithNodeUUID(nodeUUID *string) *StoragePortModifyCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithPartNumber adds the partNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithPartNumber(partNumber *string) *StoragePortModifyCollectionParams {
	o.SetPartNumber(partNumber)
	return o
}

// SetPartNumber adds the partNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetPartNumber(partNumber *string) {
	o.PartNumber = partNumber
}

// WithRedundant adds the redundant to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithRedundant(redundant *bool) *StoragePortModifyCollectionParams {
	o.SetRedundant(redundant)
	return o
}

// SetRedundant adds the redundant to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetRedundant(redundant *bool) {
	o.Redundant = redundant
}

// WithReturnRecords adds the returnRecords to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithReturnRecords(returnRecords *bool) *StoragePortModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *StoragePortModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithSerialNumber(serialNumber *string) *StoragePortModifyCollectionParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSerialRecords adds the serialRecords to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithSerialRecords(serialRecords *bool) *StoragePortModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpeed adds the speed to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithSpeed(speed *float64) *StoragePortModifyCollectionParams {
	o.SetSpeed(speed)
	return o
}

// SetSpeed adds the speed to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetSpeed(speed *float64) {
	o.Speed = speed
}

// WithState adds the state to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithState(state *string) *StoragePortModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithType(typeVar *string) *StoragePortModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithWwn adds the wwn to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithWwn(wwn *string) *StoragePortModifyCollectionParams {
	o.SetWwn(wwn)
	return o
}

// SetWwn adds the wwn to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetWwn(wwn *string) {
	o.Wwn = wwn
}

// WithWwpn adds the wwpn to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) WithWwpn(wwpn *string) *StoragePortModifyCollectionParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the storage port modify collection params
func (o *StoragePortModifyCollectionParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *StoragePortModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BoardName != nil {

		// query param board_name
		var qrBoardName string

		if o.BoardName != nil {
			qrBoardName = *o.BoardName
		}
		qBoardName := qrBoardName
		if qBoardName != "" {

			if err := r.SetQueryParam("board_name", qBoardName); err != nil {
				return err
			}
		}
	}

	if o.CableIdentifier != nil {

		// query param cable.identifier
		var qrCableIdentifier string

		if o.CableIdentifier != nil {
			qrCableIdentifier = *o.CableIdentifier
		}
		qCableIdentifier := qrCableIdentifier
		if qCableIdentifier != "" {

			if err := r.SetQueryParam("cable.identifier", qCableIdentifier); err != nil {
				return err
			}
		}
	}

	if o.CableLength != nil {

		// query param cable.length
		var qrCableLength string

		if o.CableLength != nil {
			qrCableLength = *o.CableLength
		}
		qCableLength := qrCableLength
		if qCableLength != "" {

			if err := r.SetQueryParam("cable.length", qCableLength); err != nil {
				return err
			}
		}
	}

	if o.CablePartNumber != nil {

		// query param cable.part_number
		var qrCablePartNumber string

		if o.CablePartNumber != nil {
			qrCablePartNumber = *o.CablePartNumber
		}
		qCablePartNumber := qrCablePartNumber
		if qCablePartNumber != "" {

			if err := r.SetQueryParam("cable.part_number", qCablePartNumber); err != nil {
				return err
			}
		}
	}

	if o.CableSerialNumber != nil {

		// query param cable.serial_number
		var qrCableSerialNumber string

		if o.CableSerialNumber != nil {
			qrCableSerialNumber = *o.CableSerialNumber
		}
		qCableSerialNumber := qrCableSerialNumber
		if qCableSerialNumber != "" {

			if err := r.SetQueryParam("cable.serial_number", qCableSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.CableTransceiver != nil {

		// query param cable.transceiver
		var qrCableTransceiver string

		if o.CableTransceiver != nil {
			qrCableTransceiver = *o.CableTransceiver
		}
		qCableTransceiver := qrCableTransceiver
		if qCableTransceiver != "" {

			if err := r.SetQueryParam("cable.transceiver", qCableTransceiver); err != nil {
				return err
			}
		}
	}

	if o.CableVendor != nil {

		// query param cable.vendor
		var qrCableVendor string

		if o.CableVendor != nil {
			qrCableVendor = *o.CableVendor
		}
		qCableVendor := qrCableVendor
		if qCableVendor != "" {

			if err := r.SetQueryParam("cable.vendor", qCableVendor); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.ErrorCorrectiveAction != nil {

		// query param error.corrective_action
		var qrErrorCorrectiveAction string

		if o.ErrorCorrectiveAction != nil {
			qrErrorCorrectiveAction = *o.ErrorCorrectiveAction
		}
		qErrorCorrectiveAction := qrErrorCorrectiveAction
		if qErrorCorrectiveAction != "" {

			if err := r.SetQueryParam("error.corrective_action", qErrorCorrectiveAction); err != nil {
				return err
			}
		}
	}

	if o.ErrorMessage != nil {

		// query param error.message
		var qrErrorMessage string

		if o.ErrorMessage != nil {
			qrErrorMessage = *o.ErrorMessage
		}
		qErrorMessage := qrErrorMessage
		if qErrorMessage != "" {

			if err := r.SetQueryParam("error.message", qErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.FirmwareVersion != nil {

		// query param firmware_version
		var qrFirmwareVersion string

		if o.FirmwareVersion != nil {
			qrFirmwareVersion = *o.FirmwareVersion
		}
		qFirmwareVersion := qrFirmwareVersion
		if qFirmwareVersion != "" {

			if err := r.SetQueryParam("firmware_version", qFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.InUse != nil {

		// query param in_use
		var qrInUse bool

		if o.InUse != nil {
			qrInUse = *o.InUse
		}
		qInUse := swag.FormatBool(qrInUse)
		if qInUse != "" {

			if err := r.SetQueryParam("in_use", qInUse); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.MacAddress != nil {

		// query param mac_address
		var qrMacAddress string

		if o.MacAddress != nil {
			qrMacAddress = *o.MacAddress
		}
		qMacAddress := qrMacAddress
		if qMacAddress != "" {

			if err := r.SetQueryParam("mac_address", qMacAddress); err != nil {
				return err
			}
		}
	}

	if o.Mode != nil {

		// query param mode
		var qrMode string

		if o.Mode != nil {
			qrMode = *o.Mode
		}
		qMode := qrMode
		if qMode != "" {

			if err := r.SetQueryParam("mode", qMode); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PartNumber != nil {

		// query param part_number
		var qrPartNumber string

		if o.PartNumber != nil {
			qrPartNumber = *o.PartNumber
		}
		qPartNumber := qrPartNumber
		if qPartNumber != "" {

			if err := r.SetQueryParam("part_number", qPartNumber); err != nil {
				return err
			}
		}
	}

	if o.Redundant != nil {

		// query param redundant
		var qrRedundant bool

		if o.Redundant != nil {
			qrRedundant = *o.Redundant
		}
		qRedundant := swag.FormatBool(qrRedundant)
		if qRedundant != "" {

			if err := r.SetQueryParam("redundant", qRedundant); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Speed != nil {

		// query param speed
		var qrSpeed float64

		if o.Speed != nil {
			qrSpeed = *o.Speed
		}
		qSpeed := swag.FormatFloat64(qrSpeed)
		if qSpeed != "" {

			if err := r.SetQueryParam("speed", qSpeed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.Wwn != nil {

		// query param wwn
		var qrWwn string

		if o.Wwn != nil {
			qrWwn = *o.Wwn
		}
		qWwn := qrWwn
		if qWwn != "" {

			if err := r.SetQueryParam("wwn", qWwn); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
