// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StoragePortModifyCollectionReader is a Reader for the StoragePortModifyCollection structure.
type StoragePortModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StoragePortModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStoragePortModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStoragePortModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStoragePortModifyCollectionOK creates a StoragePortModifyCollectionOK with default headers values
func NewStoragePortModifyCollectionOK() *StoragePortModifyCollectionOK {
	return &StoragePortModifyCollectionOK{}
}

/*
StoragePortModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StoragePortModifyCollectionOK struct {
}

// IsSuccess returns true when this storage port modify collection o k response has a 2xx status code
func (o *StoragePortModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage port modify collection o k response has a 3xx status code
func (o *StoragePortModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage port modify collection o k response has a 4xx status code
func (o *StoragePortModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage port modify collection o k response has a 5xx status code
func (o *StoragePortModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage port modify collection o k response a status code equal to that given
func (o *StoragePortModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage port modify collection o k response
func (o *StoragePortModifyCollectionOK) Code() int {
	return 200
}

func (o *StoragePortModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/ports][%d] storagePortModifyCollectionOK", 200)
}

func (o *StoragePortModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/ports][%d] storagePortModifyCollectionOK", 200)
}

func (o *StoragePortModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewStoragePortModifyCollectionDefault creates a StoragePortModifyCollectionDefault with default headers values
func NewStoragePortModifyCollectionDefault(code int) *StoragePortModifyCollectionDefault {
	return &StoragePortModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	StoragePortModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 17891328 | Port operation \"<operation>\" failed on port \"<name>\". This might indicate a hardware error, an illegal request, or an aborted command. |
| 17891329 | Port \"<name>\" is invalid. |
| 17891330 | Port operation \"<operation>\" failed on port \"<port>\" because it is not supported on this port type. |
| 17891331 | Cannot complete operation on port \"<port>\". The status of the port is not available. |
| 17891332 | Port operation \"<operation>\" failed on port \"<port>\". The port is not offline. |
| 17891333 | Port operation \"<operation>\" failed on port \"<port>\". The port is already offline. |
| 17891334 | Port operation \"<operation>\" failed on port \"<port>\". One or more devices on the port is currently being sanitized. |
| 17891338 | Device operation \"<operation>\" failed on port \"<name>\". Some devices can only be accessed through this port. Disabling this port might cause multiple device failures. |
| 17891339 | Device operation \"<operation>\" failed on port \"<name>\". Some devices can only be accessed through this port. Disabling this port might cause multiple device failures. Use the \"-force\" parameter to ignore checks and <operation> the port. |
| 17891344 | Device operation \"<operation>\" failed on port \"<name>\" because the port is in use. |
| 17891345 | Device operation \"<operation>\" failed on port \"<name>\" because the port is in use. Use the \"-force\" parameter to ignore checks and <operation> the port. |
| 17891346 | Port \"<name>\" is already enabled. |
| 17891347 | Port \"<name>\" is already disabled. |
| 17891350 | Port \"<name>\" is not a valid storage Ethernet port. |
| 17891350 | Port \"<port>\" is not a valid storage Ethernet port. |
| 17891352 | Port operation \"<operation>\" failed on port \"<name>\". Reboot node \"<node>\" to recover. |
| 17891353 | Unable to enable port \"<port>\" because it is in network mode. |
| 17891354 | Unable to disable port \"<port>\" because it is in network mode. |
| 17891355 | Port operation \"<operation>\" failed on port \"<name>\" because it is not supported on dedicated ports. |
| 17891356 | Unable to <operation> port \"<port>\" when setting mode to \"<mode>\". |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StoragePortModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage port modify collection default response has a 2xx status code
func (o *StoragePortModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage port modify collection default response has a 3xx status code
func (o *StoragePortModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage port modify collection default response has a 4xx status code
func (o *StoragePortModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage port modify collection default response has a 5xx status code
func (o *StoragePortModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage port modify collection default response a status code equal to that given
func (o *StoragePortModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage port modify collection default response
func (o *StoragePortModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StoragePortModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/ports][%d] storage_port_modify_collection default %s", o._statusCode, payload)
}

func (o *StoragePortModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/ports][%d] storage_port_modify_collection default %s", o._statusCode, payload)
}

func (o *StoragePortModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StoragePortModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StoragePortModifyCollectionBody storage port modify collection body
swagger:model StoragePortModifyCollectionBody
*/
type StoragePortModifyCollectionBody struct {

	// board name
	// Read Only: true
	BoardName *string `json:"board_name,omitempty"`

	// cable
	Cable *models.StoragePortInlineCable `json:"cable,omitempty"`

	// description
	// Example: SAS Host Adapter 2a (PMC-Sierra PM8072 rev. C)
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// enabled
	Enabled *bool `json:"enabled,omitempty"`

	// error
	Error *models.StoragePortInlineError `json:"error,omitempty"`

	// firmware version
	// Example: 03.08.09.00
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// force
	Force *bool `json:"force,omitempty"`

	// Specifies whether any devices are connected through this port
	// Read Only: true
	InUse *bool `json:"in_use,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// Operational mode of a non-dedicated Ethernet port
	// Example: storage
	// Enum: ["network","storage"]
	Mode *string `json:"mode,omitempty"`

	// name
	// Example: 2a
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *models.StoragePortInlineNode `json:"node,omitempty"`

	// part number
	// Example: 111-03801
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// Specifies whether all devices connected through this port have a redundant path from another port
	// Read Only: true
	Redundant *bool `json:"redundant,omitempty"`

	// serial number
	// Example: 7A2463CC45B
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// Operational port speed in Gbps
	// Example: 6
	// Read Only: true
	Speed *float64 `json:"speed,omitempty"`

	// state
	// Example: online
	// Read Only: true
	// Enum: ["online","offline","error"]
	State *string `json:"state,omitempty"`

	// storage port response inline records
	StoragePortResponseInlineRecords []*models.StoragePort `json:"records,omitempty"`

	// type
	// Example: sas
	// Read Only: true
	// Enum: ["sas","fc","enet"]
	Type *string `json:"type,omitempty"`

	// World Wide Name
	// Example: 50000d1703544b80
	// Read Only: true
	Wwn *string `json:"wwn,omitempty"`

	// World Wide Port Name
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this storage port modify collection body
func (o *StoragePortModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCable(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePortResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortModifyCollectionBody) validateCable(formats strfmt.Registry) error {
	if swag.IsZero(o.Cable) { // not required
		return nil
	}

	if o.Cable != nil {
		if err := o.Cable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cable")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

var storagePortModifyCollectionBodyTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["network","storage"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePortModifyCollectionBodyTypeModePropEnum = append(storagePortModifyCollectionBodyTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// mode
	// Mode
	// network
	// END DEBUGGING
	// StoragePortModifyCollectionBodyModeNetwork captures enum value "network"
	StoragePortModifyCollectionBodyModeNetwork string = "network"

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// mode
	// Mode
	// storage
	// END DEBUGGING
	// StoragePortModifyCollectionBodyModeStorage captures enum value "storage"
	StoragePortModifyCollectionBodyModeStorage string = "storage"
)

// prop value enum
func (o *StoragePortModifyCollectionBody) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePortModifyCollectionBodyTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePortModifyCollectionBody) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

var storagePortModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePortModifyCollectionBodyTypeStatePropEnum = append(storagePortModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// state
	// State
	// online
	// END DEBUGGING
	// StoragePortModifyCollectionBodyStateOnline captures enum value "online"
	StoragePortModifyCollectionBodyStateOnline string = "online"

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// state
	// State
	// offline
	// END DEBUGGING
	// StoragePortModifyCollectionBodyStateOffline captures enum value "offline"
	StoragePortModifyCollectionBodyStateOffline string = "offline"

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// state
	// State
	// error
	// END DEBUGGING
	// StoragePortModifyCollectionBodyStateError captures enum value "error"
	StoragePortModifyCollectionBodyStateError string = "error"
)

// prop value enum
func (o *StoragePortModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePortModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePortModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) validateStoragePortResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePortResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePortResponseInlineRecords); i++ {
		if swag.IsZero(o.StoragePortResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StoragePortResponseInlineRecords[i] != nil {
			if err := o.StoragePortResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storagePortModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sas","fc","enet"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePortModifyCollectionBodyTypeTypePropEnum = append(storagePortModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// type
	// Type
	// sas
	// END DEBUGGING
	// StoragePortModifyCollectionBodyTypeSas captures enum value "sas"
	StoragePortModifyCollectionBodyTypeSas string = "sas"

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// type
	// Type
	// fc
	// END DEBUGGING
	// StoragePortModifyCollectionBodyTypeFc captures enum value "fc"
	StoragePortModifyCollectionBodyTypeFc string = "fc"

	// BEGIN DEBUGGING
	// StoragePortModifyCollectionBody
	// StoragePortModifyCollectionBody
	// type
	// Type
	// enet
	// END DEBUGGING
	// StoragePortModifyCollectionBodyTypeEnet captures enum value "enet"
	StoragePortModifyCollectionBodyTypeEnet string = "enet"
)

// prop value enum
func (o *StoragePortModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePortModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePortModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage port modify collection body based on the context it is used
func (o *StoragePortModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBoardName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInUse(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRedundant(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePortResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateBoardName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"board_name", "body", o.BoardName); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateCable(ctx context.Context, formats strfmt.Registry) error {

	if o.Cable != nil {
		if err := o.Cable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cable")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"firmware_version", "body", o.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateInUse(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"in_use", "body", o.InUse); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"mac_address", "body", o.MacAddress); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"part_number", "body", o.PartNumber); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateRedundant(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"redundant", "body", o.Redundant); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"speed", "body", o.Speed); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateStoragePortResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePortResponseInlineRecords); i++ {

		if o.StoragePortResponseInlineRecords[i] != nil {
			if err := o.StoragePortResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateWwn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwn", "body", o.Wwn); err != nil {
		return err
	}

	return nil
}

func (o *StoragePortModifyCollectionBody) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwpn", "body", o.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePortModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePortModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res StoragePortModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePortInlineCable storage port inline cable
swagger:model storage_port_inline_cable
*/
type StoragePortInlineCable struct {

	// identifier
	// Example: 500a0980000b6c3f-50000d1703544b80
	Identifier *string `json:"identifier,omitempty"`

	// length
	// Example: 2m
	Length *string `json:"length,omitempty"`

	// part number
	// Example: 112-00431+A0
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: 616930439
	SerialNumber *string `json:"serial_number,omitempty"`

	// transceiver
	// Example: mini_sas_hd
	// Enum: ["qsfp","qsfp_plus","qsfp28","mini_sas_hd","sfp"]
	Transceiver *string `json:"transceiver,omitempty"`

	// vendor
	// Example: Molex Inc.
	Vendor *string `json:"vendor,omitempty"`
}

// Validate validates this storage port inline cable
func (o *StoragePortInlineCable) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateTransceiver(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storagePortInlineCableTypeTransceiverPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["qsfp","qsfp_plus","qsfp28","mini_sas_hd","sfp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePortInlineCableTypeTransceiverPropEnum = append(storagePortInlineCableTypeTransceiverPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_port_inline_cable
	// StoragePortInlineCable
	// transceiver
	// Transceiver
	// qsfp
	// END DEBUGGING
	// StoragePortInlineCableTransceiverQsfp captures enum value "qsfp"
	StoragePortInlineCableTransceiverQsfp string = "qsfp"

	// BEGIN DEBUGGING
	// storage_port_inline_cable
	// StoragePortInlineCable
	// transceiver
	// Transceiver
	// qsfp_plus
	// END DEBUGGING
	// StoragePortInlineCableTransceiverQsfpPlus captures enum value "qsfp_plus"
	StoragePortInlineCableTransceiverQsfpPlus string = "qsfp_plus"

	// BEGIN DEBUGGING
	// storage_port_inline_cable
	// StoragePortInlineCable
	// transceiver
	// Transceiver
	// qsfp28
	// END DEBUGGING
	// StoragePortInlineCableTransceiverQsfp28 captures enum value "qsfp28"
	StoragePortInlineCableTransceiverQsfp28 string = "qsfp28"

	// BEGIN DEBUGGING
	// storage_port_inline_cable
	// StoragePortInlineCable
	// transceiver
	// Transceiver
	// mini_sas_hd
	// END DEBUGGING
	// StoragePortInlineCableTransceiverMiniSasHd captures enum value "mini_sas_hd"
	StoragePortInlineCableTransceiverMiniSasHd string = "mini_sas_hd"

	// BEGIN DEBUGGING
	// storage_port_inline_cable
	// StoragePortInlineCable
	// transceiver
	// Transceiver
	// sfp
	// END DEBUGGING
	// StoragePortInlineCableTransceiverSfp captures enum value "sfp"
	StoragePortInlineCableTransceiverSfp string = "sfp"
)

// prop value enum
func (o *StoragePortInlineCable) validateTransceiverEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePortInlineCableTypeTransceiverPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StoragePortInlineCable) validateTransceiver(formats strfmt.Registry) error {
	if swag.IsZero(o.Transceiver) { // not required
		return nil
	}

	// value enum
	if err := o.validateTransceiverEnum("info"+"."+"cable"+"."+"transceiver", "body", *o.Transceiver); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage port inline cable based on the context it is used
func (o *StoragePortInlineCable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StoragePortInlineCable) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePortInlineCable) UnmarshalBinary(b []byte) error {
	var res StoragePortInlineCable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePortInlineError storage port inline error
swagger:model storage_port_inline_error
*/
type StoragePortInlineError struct {

	// Error corrective action
	CorrectiveAction *string `json:"corrective_action,omitempty"`

	// Error message
	Message *string `json:"message,omitempty"`
}

// Validate validates this storage port inline error
func (o *StoragePortInlineError) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage port inline error based on the context it is used
func (o *StoragePortInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StoragePortInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePortInlineError) UnmarshalBinary(b []byte) error {
	var res StoragePortInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePortInlineNode storage port inline node
swagger:model storage_port_inline_node
*/
type StoragePortInlineNode struct {

	// links
	Links *models.StoragePortInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage port inline node
func (o *StoragePortInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage port inline node based on the context it is used
func (o *StoragePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePortInlineNode) UnmarshalBinary(b []byte) error {
	var res StoragePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StoragePortInlineNodeInlineLinks storage port inline node inline links
swagger:model storage_port_inline_node_inline__links
*/
type StoragePortInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage port inline node inline links
func (o *StoragePortInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage port inline node inline links based on the context it is used
func (o *StoragePortInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StoragePortInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StoragePortInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StoragePortInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StoragePortInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
