// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StoragePortModifyReader is a Reader for the StoragePortModify structure.
type StoragePortModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StoragePortModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStoragePortModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStoragePortModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStoragePortModifyOK creates a StoragePortModifyOK with default headers values
func NewStoragePortModifyOK() *StoragePortModifyOK {
	return &StoragePortModifyOK{}
}

/*
StoragePortModifyOK describes a response with status code 200, with default header values.

OK
*/
type StoragePortModifyOK struct {
}

// IsSuccess returns true when this storage port modify o k response has a 2xx status code
func (o *StoragePortModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage port modify o k response has a 3xx status code
func (o *StoragePortModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage port modify o k response has a 4xx status code
func (o *StoragePortModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage port modify o k response has a 5xx status code
func (o *StoragePortModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage port modify o k response a status code equal to that given
func (o *StoragePortModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage port modify o k response
func (o *StoragePortModifyOK) Code() int {
	return 200
}

func (o *StoragePortModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/ports/{node.uuid}/{name}][%d] storagePortModifyOK", 200)
}

func (o *StoragePortModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/ports/{node.uuid}/{name}][%d] storagePortModifyOK", 200)
}

func (o *StoragePortModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewStoragePortModifyDefault creates a StoragePortModifyDefault with default headers values
func NewStoragePortModifyDefault(code int) *StoragePortModifyDefault {
	return &StoragePortModifyDefault{
		_statusCode: code,
	}
}

/*
	StoragePortModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 17891328 | Port operation \"<operation>\" failed on port \"<name>\". This might indicate a hardware error, an illegal request, or an aborted command. |
| 17891329 | Port \"<name>\" is invalid. |
| 17891330 | Port operation \"<operation>\" failed on port \"<port>\" because it is not supported on this port type. |
| 17891331 | Cannot complete operation on port \"<port>\". The status of the port is not available. |
| 17891332 | Port operation \"<operation>\" failed on port \"<port>\". The port is not offline. |
| 17891333 | Port operation \"<operation>\" failed on port \"<port>\". The port is already offline. |
| 17891334 | Port operation \"<operation>\" failed on port \"<port>\". One or more devices on the port is currently being sanitized. |
| 17891338 | Device operation \"<operation>\" failed on port \"<name>\". Some devices can only be accessed through this port. Disabling this port might cause multiple device failures. |
| 17891339 | Device operation \"<operation>\" failed on port \"<name>\". Some devices can only be accessed through this port. Disabling this port might cause multiple device failures. Use the \"-force\" parameter to ignore checks and <operation> the port. |
| 17891344 | Device operation \"<operation>\" failed on port \"<name>\" because the port is in use. |
| 17891345 | Device operation \"<operation>\" failed on port \"<name>\" because the port is in use. Use the \"-force\" parameter to ignore checks and <operation> the port. |
| 17891346 | Port \"<name>\" is already enabled. |
| 17891347 | Port \"<name>\" is already disabled. |
| 17891350 | Port \"<name>\" is not a valid storage Ethernet port. |
| 17891350 | Port \"<port>\" is not a valid storage Ethernet port. |
| 17891352 | Port operation \"<operation>\" failed on port \"<name>\". Reboot node \"<node>\" to recover. |
| 17891353 | Unable to enable port \"<port>\" because it is in network mode. |
| 17891354 | Unable to disable port \"<port>\" because it is in network mode. |
| 17891355 | Port operation \"<operation>\" failed on port \"<name>\" because it is not supported on dedicated ports. |
| 17891356 | Unable to <operation> port \"<port>\" when setting mode to \"<mode>\". |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StoragePortModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage port modify default response has a 2xx status code
func (o *StoragePortModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage port modify default response has a 3xx status code
func (o *StoragePortModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage port modify default response has a 4xx status code
func (o *StoragePortModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage port modify default response has a 5xx status code
func (o *StoragePortModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage port modify default response a status code equal to that given
func (o *StoragePortModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage port modify default response
func (o *StoragePortModifyDefault) Code() int {
	return o._statusCode
}

func (o *StoragePortModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/ports/{node.uuid}/{name}][%d] storage_port_modify default %s", o._statusCode, payload)
}

func (o *StoragePortModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/ports/{node.uuid}/{name}][%d] storage_port_modify default %s", o._statusCode, payload)
}

func (o *StoragePortModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StoragePortModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
